/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.fix.request;

import com.fxcm.GenericException;
import com.fxcm.fix.TradingSecurity;
import com.fxcm.fix.pretrade.SecurityStatus;
import com.fxcm.fix.pretrade.SecurityStatusRequest;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.util.fix.ISessionStrategy;
import com.fxcm.messaging.util.fix.request.ARequestProcessor;

public class SecurityStatusProcessor
extends ARequestProcessor {
    public SecurityStatusProcessor(ISessionStrategy aSession) {
        super(aSession);
    }

    private void fill(SecurityStatus aSecurityStatus, SecurityStatusRequest aSecurityStatusRequest) {
        aSecurityStatus.setTradingSessionID(this.mSession.getTradingSessionID());
        aSecurityStatus.setTradingSessionSubID(this.mSession.getTradingSessionSubID());
        aSecurityStatus.setSecurityStatusReqID(aSecurityStatusRequest.getRequestID());
    }

    @Override
    public void process(ITransportable aTransportable) throws GenericException {
        SecurityStatusRequest ssr = (SecurityStatusRequest)aTransportable;
        TradingSecurity ts = this.mSession.getTradingSessionStatus().getSecurity(ssr.getInstrument().getSymbol());
        if (ts == null) {
            SecurityStatus ss = new SecurityStatus(new TradingSecurity("[N/A]", 0, 0, 0.0, 0, "999", 1.0));
            this.fill(ss, ssr);
            this.mSession.sendBackToUser(ss);
        } else {
            SecurityStatus ss = new SecurityStatus(ts);
            this.fill(ss, ssr);
            this.mSession.sendBackToUser(ss);
        }
    }
}

