/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.fix.request;

import com.fxcm.GenericException;
import com.fxcm.fix.TradingSecurity;
import com.fxcm.fix.pretrade.SecurityList;
import com.fxcm.fix.pretrade.SecurityListRequest;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.util.fix.ISessionStrategy;
import com.fxcm.messaging.util.fix.TradingSessionStatusAdj;
import com.fxcm.messaging.util.fix.request.ARequestProcessor;
import java.util.Enumeration;

public class SecurityListProcessor
extends ARequestProcessor {
    public SecurityListProcessor(ISessionStrategy aSession) {
        super(aSession);
    }

    @Override
    public void process(ITransportable aTransportable) throws GenericException {
        SecurityListRequest request = (SecurityListRequest)aTransportable;
        SecurityList list = new SecurityList();
        list.setSecurityReqID(request.getRequestID());
        list.setSecurityResponseID(request.getRequestID());
        list.setTradingSessionID(this.mSession.getTradingSessionID());
        list.setTradingSessionSubID(this.mSession.getTradingSessionSubID());
        TradingSessionStatusAdj tss = this.mSession.getTradingSessionStatus();
        if (0 == request.getSecurityListRequestType()) {
            TradingSecurity ts = tss.getSecurity(request.getInstrument().getSymbol());
            if (ts == null) {
                list.setSecurityRequestResult(2);
            } else {
                list.setSecurityRequestResult(0);
                list.setSecurity(ts);
            }
            this.mSession.sendBackToUser(list);
        } else if (4 == request.getSecurityListRequestType()) {
            Enumeration enumeration = tss.getSecurities();
            list.setSecurityRequestResult(0);
            while (enumeration.hasMoreElements()) {
                TradingSecurity ts = (TradingSecurity)enumeration.nextElement();
                list.setSecurity(ts);
            }
            this.mSession.sendBackToUser(list);
        } else {
            list.setSecurityRequestResult(1);
            this.mSession.sendBackToUser(list);
        }
    }
}

