/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.fix.request;

import com.fxcm.GenericException;
import com.fxcm.fix.PosReqTypeFactory;
import com.fxcm.fix.posttrade.RequestForPositions;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.util.fix.FXCMCommandType;
import com.fxcm.messaging.util.fix.ISessionStrategy;
import com.fxcm.messaging.util.fix.request.ARequestProcessor;
import java.util.Calendar;
import java.util.HashMap;

public class RequestForPositionsProcessor
extends ARequestProcessor {
    public RequestForPositionsProcessor(ISessionStrategy aSession) {
        super(aSession);
    }

    @Override
    public void process(ITransportable aObj) throws GenericException {
        FXCMCommandType cmd;
        RequestForPositions rfp = (RequestForPositions)aObj;
        HashMap<String, String> params = new HashMap<String, String>();
        if (rfp.getAccount() != null) {
            params.put("AcctReportID", rfp.getAccount());
        }
        if (rfp.getPosReqType() == PosReqTypeFactory.TRADES) {
            cmd = FXCMCommandType.GET_TRADER_CLOSEDPOSITIONS;
            if (this.mSession.getUserKind() == 24) {
                cmd = FXCMCommandType.GET_DEALER_CLOSEDPOSITIONS;
            }
            if (rfp.getFXCMStartDate() != null) {
                int second;
                int minute;
                int hour;
                int day;
                int month;
                Calendar cal;
                params.put("BatchSize", String.valueOf(rfp.getFXCMMaxNoResults()));
                StringBuffer dateFrom = new StringBuffer();
                StringBuffer dateTo = new StringBuffer();
                if (rfp.getFXCMStartDate() != null) {
                    cal = this.mSession.getTradingSessionStatus().getServerCalendar();
                    cal.setTime(rfp.getFXCMStartDate().toDate());
                    month = cal.get(2) + 1;
                    if (month < 10) {
                        dateFrom.append("0");
                    }
                    dateFrom.append(month);
                    day = cal.get(5);
                    if (day < 10) {
                        dateFrom.append("0");
                    }
                    dateFrom.append(day);
                    dateFrom.append(cal.get(1));
                    if (rfp.getFXCMStartTime() != null) {
                        cal.clear();
                        cal.setTime(rfp.getFXCMStartTime().toDate());
                        hour = cal.get(11);
                        if (hour < 10) {
                            dateFrom.append("0");
                        }
                        dateFrom.append(hour);
                        minute = cal.get(12);
                        if (minute < 10) {
                            dateFrom.append("0");
                        }
                        dateFrom.append(minute);
                        second = cal.get(13);
                        if (second < 10) {
                            dateFrom.append("0");
                        }
                        dateFrom.append(second);
                    }
                }
                if (rfp.getFXCMEndDate() != null) {
                    cal = this.mSession.getTradingSessionStatus().getServerCalendar();
                    cal.setTime(rfp.getFXCMEndDate().toDate());
                    month = cal.get(2) + 1;
                    if (month < 10) {
                        dateTo.append("0");
                    }
                    dateTo.append(month);
                    day = cal.get(5);
                    if (day < 10) {
                        dateTo.append("0");
                    }
                    dateTo.append(day);
                    dateTo.append(cal.get(1));
                    if (rfp.getFXCMEndTime() != null) {
                        cal.clear();
                        cal.setTime(rfp.getFXCMEndTime().toDate());
                        hour = cal.get(11);
                        if (hour < 10) {
                            dateTo.append("0");
                        }
                        dateTo.append(hour);
                        minute = cal.get(12);
                        if (minute < 10) {
                            dateTo.append("0");
                        }
                        dateTo.append(minute);
                        second = cal.get(13);
                        if (second < 10) {
                            dateTo.append("0");
                        }
                        dateTo.append(second);
                    }
                }
                if (rfp.getParties().getFXCMAcctID() != 0L) {
                    params.put("AcctID", String.valueOf(rfp.getParties().getFXCMAcctID()));
                }
                params.put("DtFrom", dateFrom.toString());
                params.put("DtTo", dateTo.toString());
                cmd = FXCMCommandType.GET_SNAPSHOT_CLOSEDPOSITIONS;
            } else if (rfp.getFXCMPosID() != null) {
                cmd = FXCMCommandType.GET_POSID_CLOSEDPOSITIONS;
                params.put("TradeID", rfp.getFXCMPosID());
            } else if (rfp.getOrderID() != null) {
                cmd = FXCMCommandType.GET_ORDERID_CLOSEDPOSITIONS;
                params.put("OrderID", rfp.getOrderID());
            } else if (rfp.getClOrdID() != null) {
                cmd = FXCMCommandType.GET_QID_CLOSEDPOSITIONS;
                params.put("OriginQID", rfp.getClOrdID());
            } else if (rfp.getSecondaryClOrdID() != null) {
                cmd = FXCMCommandType.GET_QTXT_CLOSEDPOSITIONS;
                params.put("OriginQTXT", rfp.getSecondaryClOrdID());
            } else if (rfp.getParties().getFXCMAcctID() != 0L) {
                cmd = FXCMCommandType.GET_ACCT_CLOSEDPOSITIONS;
                params.put("AcctID", String.valueOf(rfp.getParties().getFXCMAcctID()));
            } else if (rfp.getParties().getFXCMTraderLoginId() != null) {
                cmd = FXCMCommandType.GET_LOGIN_CLOSEDPOSITIONS;
                params.put("LoginID", rfp.getParties().getFXCMTraderLoginId());
            }
        } else {
            cmd = FXCMCommandType.GET_TRADER_OPENPOSITIONS;
            if (this.mSession.getUserKind() == 24) {
                cmd = FXCMCommandType.GET_DEALER_OPENPOSITIONS;
            }
            if (rfp.getFXCMPosID() != null) {
                cmd = FXCMCommandType.GET_POSID_OPENPOSITIONS;
                params.put("TradeID", rfp.getFXCMPosID());
            } else if (rfp.getOrderID() != null) {
                cmd = FXCMCommandType.GET_ORDERID_OPENPOSITIONS;
                params.put("OrderID", rfp.getOrderID());
            } else if (rfp.getClOrdID() != null) {
                cmd = FXCMCommandType.GET_QID_OPENPOSITIONS;
                params.put("OriginQID", rfp.getClOrdID());
            } else if (rfp.getSecondaryClOrdID() != null) {
                cmd = FXCMCommandType.GET_QTXT_OPENPOSITIONS;
                params.put("OriginQTXT", rfp.getSecondaryClOrdID());
            } else if (rfp.getParties().getFXCMAcctID() != 0L) {
                cmd = FXCMCommandType.GET_ACCT_OPENPOSITIONS;
                params.put("AcctID", String.valueOf(rfp.getParties().getFXCMAcctID()));
            } else if (rfp.getParties().getFXCMTraderLoginId() != null) {
                params.put("LoginID", rfp.getParties().getFXCMTraderLoginId());
                cmd = FXCMCommandType.GET_LOGIN_OPENPOSITIONS;
            }
        }
        this.request(cmd, params, aObj.getRequestID());
    }
}

