/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.fix.request;

import com.fxcm.GenericException;
import com.fxcm.fix.QuoteRespTypeFactory;
import com.fxcm.fix.pretrade.QuoteResponse;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.util.fix.FXCMCommandType;
import com.fxcm.messaging.util.fix.ISessionStrategy;
import com.fxcm.messaging.util.fix.request.ARequestProcessor;
import java.util.HashMap;

public class QuoteResponseProcessor
extends ARequestProcessor {
    public QuoteResponseProcessor(ISessionStrategy aSession) {
        super(aSession);
    }

    @Override
    public void process(ITransportable aObj) throws GenericException {
        QuoteResponse rfp = (QuoteResponse)aObj;
        HashMap<String, String> params = new HashMap<String, String>();
        String qid = rfp.getQuoteID();
        if (qid == null) {
            throw new GenericException("No Quote ID specifed");
        }
        if (qid.startsWith("Requote-")) {
            if (rfp.getQuoteRespType() != QuoteRespTypeFactory.PASS) {
                throw new GenericException("Unsupported Quote Response Type");
            }
            params.put("OrderID", qid.substring("Requote-".length()));
            qid = rfp.getSecondaryClOrdID();
            if (qid == null) {
                qid = "";
            }
            params.put("QTXT", qid);
            this.request(FXCMCommandType.REJECT_REQUOTE, params, aObj.getRequestID());
        } else {
            params.put("RQID", qid);
            this.request(FXCMCommandType.DELETE_QUOTE, params, aObj.getRequestID());
        }
    }
}

