/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.fix.request;

import com.fxcm.GenericException;
import com.fxcm.fix.ExecTypeFactory;
import com.fxcm.fix.FXCMOrdStatusFactory;
import com.fxcm.fix.Instrument;
import com.fxcm.fix.OrdRejReasonFactory;
import com.fxcm.fix.OrdStatusFactory;
import com.fxcm.fix.SideFactory;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.fix.trade.ExecutionReport;
import com.fxcm.fix.trade.OrderStatusRequest;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.util.fix.FXCMCommandType;
import com.fxcm.messaging.util.fix.ISessionStrategy;
import com.fxcm.messaging.util.fix.request.ARequestProcessor;
import java.util.HashMap;

public class OrderStatusRequestProcessor
extends ARequestProcessor {
    public OrderStatusRequestProcessor(ISessionStrategy aSession) {
        super(aSession);
    }

    @Override
    public void process(ITransportable aObj) throws GenericException {
        OrderStatusRequest request = (OrderStatusRequest)aObj;
        HashMap<String, String> map = new HashMap<String, String>();
        boolean ret = true;
        String error = null;
        if (request.getClOrdID() != null) {
            map.put("OrderQID", request.getClOrdID());
        } else if (request.getSecondaryClOrdID() != null) {
            map.put("OrderQTXT", request.getSecondaryClOrdID());
        } else if (request.getOrderID() != null) {
            map.put("OrderID", request.getOrderID());
        } else {
            error = "Error: Must supply OrderID, ClOrdID(RequestID) or SecondaryClOrdID.";
            ret = false;
        }
        if (ret) {
            if (request.getAccount() == null) {
                error = "Error: Must Supply Account";
                ret = false;
            } else {
                long acctID;
                map.put("AcctReportID", request.getAccount());
                if (request.getParties() != null && (acctID = request.getParties().getFXCMAcctID()) != 0L) {
                    map.put("AcctID", String.valueOf(acctID));
                }
            }
        }
        if (ret) {
            this.request(FXCMCommandType.GET_ORDER_STATUS, map, aObj.getRequestID());
        } else {
            ExecutionReport reject = new ExecutionReport();
            String s = request.getOrderID();
            if (s == null || s.length() == 0) {
                s = "NONE";
            }
            reject.setOrderID(s);
            reject.setOrdStatusReqID(request.getOrderStatusReqID());
            reject.setAccount(request.getAccount());
            reject.setClOrdID(request.getClOrdID());
            reject.setSecondaryClOrdID(request.getSecondaryClOrdID());
            Instrument instrument = request.getInstrument();
            if (instrument == null || instrument.getSymbol() == null || instrument.getSymbol().length() == 0) {
                instrument = new Instrument("[N/A]");
            }
            reject.setInstrument(instrument);
            reject.setSide(SideFactory.UNDISCLOSED);
            reject.setParties(request.getParties());
            reject.setTradingSessionID(this.mSession.getTradingSessionID());
            reject.setTradingSessionSubID(this.mSession.getTradingSessionSubID());
            reject.setTransactTime(new UTCTimestamp());
            reject.setExecID("0");
            reject.setExecType(ExecTypeFactory.ORDER_STATUS);
            reject.setOrdRejReason(OrdRejReasonFactory.UNSUPPORTED_ORDER_CHARACTERISTIC);
            reject.setFXCMOrdStatus(FXCMOrdStatusFactory.REJECTED);
            reject.setFXCMErrorDetails(error);
            reject.setFXCMRequestRejectReason(0);
            reject.setLastRptRequested(true);
            reject.setMassStatusReqID(null);
            reject.setOrdStatus(OrdStatusFactory.REJECTED);
            reject.setText(error);
            reject.setTotNumReports(0);
            this.mSession.sendBackToUser(reject);
        }
    }
}

