/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.fix.request;

import com.fxcm.GenericException;
import com.fxcm.fix.ExecTypeFactory;
import com.fxcm.fix.FXCMOrdStatusFactory;
import com.fxcm.fix.FXCMOrdTypeFactory;
import com.fxcm.fix.IFXCMOrdType;
import com.fxcm.fix.IOrdType;
import com.fxcm.fix.ISide;
import com.fxcm.fix.ITimeInForce;
import com.fxcm.fix.OrdStatusFactory;
import com.fxcm.fix.OrdTypeFactory;
import com.fxcm.fix.Party;
import com.fxcm.fix.PegInstruction;
import com.fxcm.fix.SideFactory;
import com.fxcm.fix.TimeInForceFactory;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.fix.custom.FXCMRequest;
import com.fxcm.fix.trade.ExecutionReport;
import com.fxcm.fix.trade.OrderSingle;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.util.fix.FXCMCommandType;
import com.fxcm.messaging.util.fix.ISessionStrategy;
import com.fxcm.messaging.util.fix.request.ARequestProcessor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class OrderSingleProcessor
extends ARequestProcessor {
    private final Map<IFXCMOrdType, ARequestBuilder> mBuilders = new HashMap<IFXCMOrdType, ARequestBuilder>();

    public OrderSingleProcessor(ISessionStrategy aSession) {
        super(aSession);
        this.mBuilders.put(FXCMOrdTypeFactory.OPEN, new OpenBuilder(FXCMOrdTypeFactory.OPEN));
        this.mBuilders.put(FXCMOrdTypeFactory.OPEN_MARKET, new OpenMarketBuilder(FXCMOrdTypeFactory.OPEN_MARKET));
        this.mBuilders.put(FXCMOrdTypeFactory.OPEN_LIMIT, new OpenLimitBuilder(FXCMOrdTypeFactory.OPEN_LIMIT));
        this.mBuilders.put(FXCMOrdTypeFactory.CLOSE_LIMIT, new CloseLimitBuilder(FXCMOrdTypeFactory.CLOSE_LIMIT));
        this.mBuilders.put(FXCMOrdTypeFactory.CLOSE_RANGE, new CloseRangeBuilder(FXCMOrdTypeFactory.CLOSE_RANGE));
        this.mBuilders.put(FXCMOrdTypeFactory.OPEN_RANGE, new OpenRangeBuilder(FXCMOrdTypeFactory.OPEN_RANGE));
        this.mBuilders.put(FXCMOrdTypeFactory.CLOSE, new CloseBuilder(FXCMOrdTypeFactory.CLOSE));
        this.mBuilders.put(FXCMOrdTypeFactory.CLOSE_MARKET, new CloseMarketBuilder(FXCMOrdTypeFactory.CLOSE_MARKET));
        this.mBuilders.put(FXCMOrdTypeFactory.ENTRY_LIMIT, new EntryStopLimitBuilder(FXCMOrdTypeFactory.ENTRY_LIMIT));
        this.mBuilders.put(FXCMOrdTypeFactory.ENTRY_STOP, new EntryStopLimitBuilder(FXCMOrdTypeFactory.ENTRY_STOP));
        this.mBuilders.put(FXCMOrdTypeFactory.STOP_TRAILING_ENTRY, new EntryStopLimitBuilder(FXCMOrdTypeFactory.STOP_TRAILING_ENTRY));
        this.mBuilders.put(FXCMOrdTypeFactory.LIMIT_TRAILING_ENTRY, new EntryStopLimitBuilder(FXCMOrdTypeFactory.LIMIT_TRAILING_ENTRY));
        this.mBuilders.put(FXCMOrdTypeFactory.LIMIT, new StopLimitBuilder(FXCMOrdTypeFactory.LIMIT));
        this.mBuilders.put(FXCMOrdTypeFactory.STOP, new StopLimitBuilder(FXCMOrdTypeFactory.STOP));
        this.mBuilders.put(FXCMOrdTypeFactory.RANGE_ENTRY, new OpenRangeBuilder(FXCMOrdTypeFactory.RANGE_ENTRY));
        this.mBuilders.put(FXCMOrdTypeFactory.RANGE_TRAILING_ENTRY, new OpenRangeBuilder(FXCMOrdTypeFactory.RANGE_TRAILING_ENTRY));
        this.mBuilders.put(FXCMOrdTypeFactory.OPEN_REQUOTE, new RequoteBuilder(FXCMOrdTypeFactory.OPEN_REQUOTE));
        this.mBuilders.put(FXCMOrdTypeFactory.CLOSE_REQUOTE, new RequoteBuilder(FXCMOrdTypeFactory.CLOSE_REQUOTE));
    }

    protected IFXCMOrdType calcFXCMOrderType(OrderSingle aOrder) {
        IFXCMOrdType ret = null;
        ITimeInForce timeInForce = aOrder.getTimeInForce();
        String posID = aOrder.getFXCMPosID();
        IOrdType ordType = aOrder.getOrdType();
        String quoteID = aOrder.getQuoteID();
        double price = aOrder.getPrice();
        if (ordType == OrdTypeFactory.PREVIOUSLY_QUOTED) {
            ret = quoteID != null && quoteID.startsWith("Requote-") ? (posID == null ? FXCMOrdTypeFactory.OPEN_REQUOTE : FXCMOrdTypeFactory.CLOSE_REQUOTE) : (posID == null ? FXCMOrdTypeFactory.OPEN : FXCMOrdTypeFactory.CLOSE);
        } else if (ordType == OrdTypeFactory.MARKET) {
            ret = posID == null ? FXCMOrdTypeFactory.OPEN_MARKET : FXCMOrdTypeFactory.CLOSE_MARKET;
        } else {
            PegInstruction peg = aOrder.getPegInstructions();
            if (ordType == OrdTypeFactory.LIMIT) {
                if (price > 0.0 || peg != null && peg.getPegOffsetValue() != 0.0) {
                    if (posID == null) {
                        if (OrderSingleProcessor.isWaitingOrder(timeInForce)) {
                            ret = peg != null && peg.getFXCMPegFluctuatePts() != 0 ? FXCMOrdTypeFactory.LIMIT_TRAILING_ENTRY : FXCMOrdTypeFactory.ENTRY_LIMIT;
                        } else if (timeInForce == TimeInForceFactory.FILL_OR_KILL) {
                            ret = FXCMOrdTypeFactory.OPEN_LIMIT;
                        } else if (timeInForce == TimeInForceFactory.IMMEDIATE_OR_CANCEL) {
                            ret = FXCMOrdTypeFactory.OPEN_LIMIT;
                        }
                    } else if (OrderSingleProcessor.isWaitingOrder(timeInForce)) {
                        ret = FXCMOrdTypeFactory.LIMIT;
                    } else if (timeInForce == TimeInForceFactory.FILL_OR_KILL) {
                        ret = FXCMOrdTypeFactory.CLOSE_LIMIT;
                    } else if (timeInForce == TimeInForceFactory.IMMEDIATE_OR_CANCEL) {
                        ret = FXCMOrdTypeFactory.CLOSE_LIMIT;
                    }
                } else {
                    ret = FXCMOrdTypeFactory.ENTRY_LIMIT;
                }
            } else if (ordType == OrdTypeFactory.STOP) {
                if (aOrder.getStopPx() > 0.0 || aOrder.getPrice() > 0.0 || peg != null && peg.getPegOffsetValue() != 0.0) {
                    if (posID == null) {
                        if (OrderSingleProcessor.isWaitingOrder(timeInForce)) {
                            ret = peg != null && peg.getFXCMPegFluctuatePts() != 0 ? FXCMOrdTypeFactory.STOP_TRAILING_ENTRY : FXCMOrdTypeFactory.ENTRY_STOP;
                        }
                    } else if (OrderSingleProcessor.isWaitingOrder(timeInForce)) {
                        ret = FXCMOrdTypeFactory.STOP;
                    }
                } else {
                    ret = FXCMOrdTypeFactory.ENTRY_STOP;
                }
            } else if (ordType == OrdTypeFactory.STOP_LIMIT && (aOrder.getStopPx() > 0.0 && aOrder.getPrice() > 0.0 || peg != null && peg.getPegOffsetValue() != 0.0)) {
                ret = OrderSingleProcessor.isWaitingOrder(timeInForce) ? (peg != null && peg.getFXCMPegFluctuatePts() != 0 ? FXCMOrdTypeFactory.RANGE_TRAILING_ENTRY : FXCMOrdTypeFactory.RANGE_ENTRY) : (posID == null ? FXCMOrdTypeFactory.OPEN_RANGE : FXCMOrdTypeFactory.CLOSE_RANGE);
            }
        }
        return ret;
    }

    private static boolean isWaitingOrder(ITimeInForce aTimeInForce) {
        return aTimeInForce == TimeInForceFactory.DAY || aTimeInForce == TimeInForceFactory.GOOD_TILL_DATE || aTimeInForce == TimeInForceFactory.GOOD_TILL_CANCEL;
    }

    protected FXCMRequest buildFXCMRequest(ITransportable aTransportable) throws Exception {
        OrderSingle fixOrder = (OrderSingle)aTransportable;
        StringBuilder errorTxt = new StringBuilder("Unsupported Order Type or Field Combination");
        try {
            if (fixOrder.getInstrument() != null) {
                int offerID = this.mSession.getParser().getOfferId(fixOrder.getInstrument().getSymbol());
                if (offerID == 0) {
                    errorTxt.append(", Invalid currency pair: ").append(fixOrder.getInstrument().getSymbol());
                } else {
                    fixOrder.getInstrument().setFXCMSymID(offerID);
                }
            }
            IFXCMOrdType ordType = this.calcFXCMOrderType(fixOrder);
            ARequestBuilder builder = this.mBuilders.get(ordType);
            FXCMRequest request = builder.build(fixOrder);
            request.setTransactTime(fixOrder.getTransactTime());
            return request;
        }
        catch (Exception e) {
            this.mLogger.error(e.getMessage(), e);
            errorTxt.append(", ").append(e.getMessage());
            throw new Exception(errorTxt.toString(), e);
        }
    }

    @Override
    public void process(ITransportable aTransportable) throws GenericException {
        OrderSingle fixOrder = (OrderSingle)aTransportable;
        try {
            FXCMRequest request = this.buildFXCMRequest(aTransportable);
            this.mSession.sendToServer(request);
        }
        catch (Exception e) {
            this.mLogger.error(e.getMessage(), e);
            ExecutionReport report = this.buildReject(fixOrder, e);
            this.mSession.sendBackToUser(report);
        }
    }

    protected ExecutionReport buildReject(OrderSingle aFixOrder, Exception aException) {
        ExecutionReport er = new ExecutionReport();
        String s = aFixOrder.getOrderID();
        if (s == null || s.length() == 0) {
            s = "NONE";
        }
        er.setOrderID(s);
        er.setAccount(aFixOrder.getAccount());
        er.setClOrdID(aFixOrder.getClOrdID());
        er.setSecondaryClOrdID(aFixOrder.getSecondaryClOrdID());
        er.setInstrument(aFixOrder.getInstrument());
        er.setParties(aFixOrder.getParties());
        er.setTradingSessionID(this.mSession.getTradingSessionID());
        er.setTradingSessionSubID(this.mSession.getTradingSessionSubID());
        er.setTransactTime(new UTCTimestamp());
        er.setExecID("0");
        er.setExecType(ExecTypeFactory.REJECTED);
        er.setFXCMOrdStatus(FXCMOrdStatusFactory.REJECTED);
        er.setFXCMOrdType(this.calcFXCMOrderType(aFixOrder));
        er.setFXCMPosID(aFixOrder.getFXCMPosID());
        er.setFXCMErrorDetails(aException.getMessage());
        er.setFXCMRequestRejectReason(0);
        er.setLastRptRequested(true);
        er.setMassStatusReqID(null);
        er.setOrdStatus(OrdStatusFactory.REJECTED);
        er.setOrdType(aFixOrder.getOrdType());
        er.setPrice(aFixOrder.getPrice());
        er.setSide(aFixOrder.getSide());
        er.setText(aException.getMessage());
        er.setTotNumReports(0);
        er.setTimeInForce(aFixOrder.getTimeInForce());
        er.setCurrency(aFixOrder.getCurrency());
        return er;
    }

    private class RequoteBuilder
    extends ARequestBuilder {
        RequoteBuilder(IFXCMOrdType aType) {
            super(aType);
        }

        @Override
        protected FXCMCommandType fill(OrderSingle aMsg, Map<String, String> aParams) throws GenericException {
            String qid = OrderSingleProcessor.this.toStringSafe(aMsg.getQuoteID(), "No Quote ID specified");
            aParams.put("OrderID", qid.substring("Requote-".length()));
            if (aMsg.getFXCMPosID() != null) {
                aParams.put("TradeID", aMsg.getFXCMPosID());
            }
            String s = "";
            if (aMsg.getPrice() != 0.0) {
                s = String.valueOf(aMsg.getPrice());
            }
            aParams.put("Rate", s);
            aParams.put("RateID", qid);
            return FXCMCommandType.ACCEPT_ORDER;
        }
    }

    private class StopLimitBuilder
    extends ARequestBuilder {
        StopLimitBuilder(IFXCMOrdType aType) {
            super(aType);
        }

        @Override
        protected FXCMCommandType fill(OrderSingle aMsg, Map<String, String> aParams) throws GenericException {
            aParams.put("Stage", "C");
            aParams.put("TradeID", OrderSingleProcessor.this.toStringSafe(aMsg.getFXCMPosID(), "No Ticket No specified"));
            aParams.put("SIDE", this.toSideStringSafe(this.mType, aMsg.getSide(), aMsg.getOrdType(), "No Side specified"));
            PegInstruction pegInstruction = aMsg.getPegInstructions();
            if (pegInstruction != null && pegInstruction.getFXCMPegFluctuatePts() != 0) {
                aParams.put("TrailUpdatePips", String.valueOf(pegInstruction.getFXCMPegFluctuatePts()));
            }
            if (aMsg.getStopPx() == 0.0 && aMsg.getPrice() == 0.0) {
                if (pegInstruction != null) {
                    if (pegInstruction.getPegPriceType() == 3) {
                        aParams.put("PEG_TYPE", "0");
                    } else if (pegInstruction.getPegPriceType() == 4) {
                        aParams.put("PEG_TYPE", "1");
                    }
                    aParams.put("PRICE_OFFSET_PIPS", OrderSingleProcessor.this.toStringSafe(pegInstruction.getPegOffsetValue(), "No PegOffsetValue specified"));
                }
            } else if (aMsg.getOrdType() == OrdTypeFactory.STOP) {
                double rate = 0.0;
                if (pegInstruction != null) {
                    rate = pegInstruction.getPegOffsetValue();
                }
                if (rate == 0.0) {
                    rate = aMsg.getStopPx();
                }
                if (rate == 0.0) {
                    rate = aMsg.getPrice();
                }
                aParams.put("Rate", OrderSingleProcessor.this.toStringSafe(rate, "No Price specified"));
            } else {
                aParams.put("Rate", OrderSingleProcessor.this.toStringSafe(aMsg.getPrice(), "No Price specified"));
            }
            if (TimeInForceFactory.GOOD_TILL_DATE.is(aMsg.getTimeInForce())) {
                if (aMsg.isExpireDateSet() && aMsg.isExpireTimeSet()) {
                    aParams.put("EXPIRE_DT", aMsg.getExpireTimestamp().toString());
                } else if (aMsg.isExpireDateSet()) {
                    aParams.put("EXPIRE_DT", aMsg.getExpireDate().toString() + "-21:00:00");
                } else if (aMsg.isExpireTimeSet()) {
                    aParams.put("EXPIRE_DT", aMsg.getExpireTime().toString());
                } else {
                    throw new GenericException("GTD order specified without accompanying ExpireTime or ExpireDate");
                }
            }
            if (aMsg.getTimeInForce() != null) {
                aParams.put("GTC", aMsg.getTimeInForce().getLabel());
            }
            return FXCMCommandType.CREATE_ORDER;
        }
    }

    private class EntryStopLimitBuilder
    extends ARequestBuilder {
        EntryStopLimitBuilder(IFXCMOrdType aType) {
            super(aType);
        }

        @Override
        protected FXCMCommandType fill(OrderSingle aMsg, Map<String, String> aParams) throws GenericException {
            PegInstruction pegInstruction = aMsg.getPegInstructions();
            if (pegInstruction != null) {
                if (pegInstruction.getFXCMPegFluctuatePts() > 0) {
                    aParams.put("TrailUpdatePips", String.valueOf(pegInstruction.getFXCMPegFluctuatePts()));
                } else if (pegInstruction.getFXCMPegFluctuatePts() < 0) {
                    aParams.put("TrailUpdatePips", "1");
                }
            }
            if (aMsg.getStopPx() == 0.0 && aMsg.getPrice() == 0.0) {
                if (pegInstruction != null) {
                    if (pegInstruction.getPegPriceType() == 3) {
                        aParams.put("PEG_TYPE", "0");
                    } else if (pegInstruction.getPegPriceType() == 4) {
                        aParams.put("PEG_TYPE", "1");
                    }
                    aParams.put("PRICE_OFFSET_PIPS", OrderSingleProcessor.this.toStringSafe(pegInstruction.getPegOffsetValue(), "No PegOffsetValue specified"));
                }
            } else if (aMsg.getOrdType() == OrdTypeFactory.STOP || aMsg.getOrdType() == OrdTypeFactory.STOP_LIMIT) {
                try {
                    aParams.put("Rate", OrderSingleProcessor.this.toStringSafe(aMsg.getStopPx(), "No Price specified"));
                }
                catch (GenericException e) {
                    aParams.put("Rate", OrderSingleProcessor.this.toStringSafe(aMsg.getPrice(), "No Price specified"));
                }
            } else {
                aParams.put("Rate", OrderSingleProcessor.this.toStringSafe(aMsg.getPrice(), "No Price specified"));
            }
            aParams.put("SIDE", this.toSideStringSafe(this.mType, aMsg.getSide(), aMsg.getOrdType(), "No Side specified"));
            if (TimeInForceFactory.GOOD_TILL_DATE.is(aMsg.getTimeInForce())) {
                if (aMsg.isExpireDateSet() && aMsg.isExpireTimeSet()) {
                    aParams.put("EXPIRE_DT", aMsg.getExpireTimestamp().toString());
                } else if (aMsg.isExpireDateSet()) {
                    aParams.put("EXPIRE_DT", aMsg.getExpireDate().toString() + "-21:00:00");
                } else if (aMsg.isExpireTimeSet()) {
                    aParams.put("EXPIRE_DT", aMsg.getExpireTime().toString());
                } else {
                    throw new GenericException("GTD order specified without accompanying ExpireTime or ExpireDate");
                }
                aParams.put("GTC", aMsg.getTimeInForce().getLabel());
            } else if (aMsg.getTimeInForce() != null) {
                aParams.put("GTC", aMsg.getTimeInForce().getLabel());
            } else {
                aParams.put("GTC", "Y");
            }
            return FXCMCommandType.CREATE_ORDER;
        }
    }

    private class CloseLimitBuilder
    extends ARequestBuilder {
        CloseLimitBuilder(IFXCMOrdType aType) {
            super(aType);
        }

        @Override
        protected FXCMCommandType fill(OrderSingle aMsg, Map<String, String> aParams) throws GenericException {
            aParams.put("TradeID", OrderSingleProcessor.this.toStringSafe(aMsg.getFXCMPosID(), "No Ticket No specified"));
            aParams.put("Rate", OrderSingleProcessor.this.toStringSafe(aMsg.getPrice(), "No Price specified"));
            if (aMsg.getTimeInForce() != null) {
                aParams.put("GTC", aMsg.getTimeInForce().getLabel());
            } else {
                aParams.put("GTC", "Y");
            }
            aParams.put("Stage", "C");
            return FXCMCommandType.CREATE_ORDER;
        }
    }

    private class CloseMarketBuilder
    extends ARequestBuilder {
        CloseMarketBuilder(IFXCMOrdType aType) {
            super(aType);
        }

        @Override
        protected FXCMCommandType fill(OrderSingle aMsg, Map<String, String> aParams) throws GenericException {
            aParams.put("TradeID", OrderSingleProcessor.this.toStringSafe(aMsg.getFXCMPosID(), "No Ticket No specified"));
            if (TimeInForceFactory.GOOD_TILL_DATE.is(aMsg.getTimeInForce())) {
                if (aMsg.isExpireDateSet() && aMsg.isExpireTimeSet()) {
                    aParams.put("EXPIRE_DT", aMsg.getExpireTimestamp().toString());
                } else if (aMsg.isExpireDateSet()) {
                    aParams.put("EXPIRE_DT", aMsg.getExpireDate().toString() + "-21:00:00");
                } else if (aMsg.isExpireTimeSet()) {
                    aParams.put("EXPIRE_DT", aMsg.getExpireTime().toString());
                } else {
                    throw new GenericException("GTD order specified without accompanying ExpireTime or ExpireDate");
                }
            }
            if (aMsg.getTimeInForce() != null) {
                aParams.put("GTC", aMsg.getTimeInForce().getLabel());
            }
            aParams.put("Stage", "C");
            return FXCMCommandType.CREATE_ORDER;
        }
    }

    private class CloseRangeBuilder
    extends ARequestBuilder {
        CloseRangeBuilder(IFXCMOrdType aType) {
            super(aType);
        }

        @Override
        protected FXCMCommandType fill(OrderSingle aMsg, Map<String, String> aParams) throws GenericException {
            aParams.put("TradeID", OrderSingleProcessor.this.toStringSafe(aMsg.getFXCMPosID(), "No Ticket No specified"));
            if (aMsg.getPegInstructions() != null && aMsg.getPegInstructions().getPegOffsetValue() != 0.0) {
                aParams.put("Rate", OrderSingleProcessor.this.toStringSafe(aMsg.getPrice(), "No Price specified"));
                aParams.put("AtMarket", OrderSingleProcessor.this.toStringSafe((int)aMsg.getPegInstructions().getPegOffsetValue(), "No At Market Points specified"));
            } else {
                aParams.put("Rate3", OrderSingleProcessor.this.toStringSafe(aMsg.getPrice(), "No Price specified"));
                aParams.put("Rate2", OrderSingleProcessor.this.toStringSafe(aMsg.getStopPx(), "No Stop Price specified"));
            }
            if (aMsg.getQuoteID() != null) {
                aParams.put("RateID", aMsg.getQuoteID());
            }
            if (aMsg.getTimeInForce() != null) {
                aParams.put("GTC", aMsg.getTimeInForce().getLabel());
            }
            aParams.put("Stage", "C");
            return FXCMCommandType.CREATE_ORDER;
        }
    }

    private class CloseBuilder
    extends ARequestBuilder {
        CloseBuilder(IFXCMOrdType aType) {
            super(aType);
        }

        @Override
        protected FXCMCommandType fill(OrderSingle aMsg, Map<String, String> aParams) throws GenericException {
            aParams.put("TradeID", OrderSingleProcessor.this.toStringSafe(aMsg.getFXCMPosID(), "No Ticket No specified"));
            aParams.put("Rate", OrderSingleProcessor.this.toStringSafe(aMsg.getPrice(), "No Price specified"));
            aParams.put("RateID", OrderSingleProcessor.this.toStringSafe(aMsg.getQuoteID(), "No Quote ID specified"));
            if (aMsg.getTimeInForce() != null) {
                aParams.put("GTC", aMsg.getTimeInForce().getLabel());
            }
            aParams.put("Stage", "C");
            return FXCMCommandType.CREATE_ORDER;
        }
    }

    private class OpenLimitBuilder
    extends ARequestBuilder {
        OpenLimitBuilder(IFXCMOrdType aType) {
            super(aType);
        }

        @Override
        protected FXCMCommandType fill(OrderSingle aMsg, Map<String, String> aParams) throws GenericException {
            aParams.put("Rate", OrderSingleProcessor.this.toStringSafe(aMsg.getPrice(), "No Price specified"));
            if (aMsg.getTimeInForce() != null) {
                aParams.put("GTC", aMsg.getTimeInForce().getLabel());
            } else {
                aParams.put("GTC", "Y");
            }
            return FXCMCommandType.CREATE_ORDER;
        }
    }

    private class OpenMarketBuilder
    extends ARequestBuilder {
        OpenMarketBuilder(IFXCMOrdType aType) {
            super(aType);
        }

        @Override
        protected FXCMCommandType fill(OrderSingle aMsg, Map<String, String> aParams) throws GenericException {
            if (aMsg.getPrice() != 0.0) {
                if (aMsg.getOrdType() == OrdTypeFactory.STOP || aMsg.getOrdType() == OrdTypeFactory.STOP_LIMIT) {
                    try {
                        aParams.put("Rate", OrderSingleProcessor.this.toStringSafe(aMsg.getStopPx(), "No Price specified"));
                    }
                    catch (GenericException e) {
                        aParams.put("Rate", OrderSingleProcessor.this.toStringSafe(aMsg.getPrice(), "No Price specified"));
                    }
                } else {
                    aParams.put("Rate", OrderSingleProcessor.this.toStringSafe(aMsg.getPrice(), "No Price specified"));
                }
            }
            if (aMsg.getQuoteID() != null) {
                aParams.put("RateID", aMsg.getQuoteID());
            }
            if (TimeInForceFactory.GOOD_TILL_DATE.is(aMsg.getTimeInForce())) {
                if (aMsg.isExpireDateSet() && aMsg.isExpireTimeSet()) {
                    aParams.put("EXPIRE_DT", aMsg.getExpireTimestamp().toString());
                } else if (aMsg.isExpireDateSet()) {
                    aParams.put("EXPIRE_DT", aMsg.getExpireDate().toString() + "-21:00:00");
                } else if (aMsg.isExpireTimeSet()) {
                    aParams.put("EXPIRE_DT", aMsg.getExpireTime().toString());
                } else {
                    throw new GenericException("GTD order specified without accompanying ExpireTime or ExpireDate");
                }
            }
            if (aMsg.getTimeInForce() != null) {
                aParams.put("GTC", aMsg.getTimeInForce().getLabel());
            }
            return FXCMCommandType.CREATE_ORDER;
        }
    }

    private class OpenRangeBuilder
    extends ARequestBuilder {
        OpenRangeBuilder(IFXCMOrdType aType) {
            super(aType);
        }

        @Override
        protected FXCMCommandType fill(OrderSingle aMsg, Map<String, String> aParams) throws GenericException {
            if (this.mType == FXCMOrdTypeFactory.RANGE_ENTRY || this.mType == FXCMOrdTypeFactory.RANGE_TRAILING_ENTRY) {
                aParams.put("SIDE", this.toSideStringSafe(this.mType, aMsg.getSide(), aMsg.getOrdType(), "No Side specified"));
                if (this.mType == FXCMOrdTypeFactory.RANGE_TRAILING_ENTRY) {
                    PegInstruction pegInstruction = aMsg.getPegInstructions();
                    if (pegInstruction != null && pegInstruction.getFXCMPegFluctuatePts() != 0) {
                        aParams.put("TrailUpdatePips", String.valueOf(pegInstruction.getFXCMPegFluctuatePts()));
                    }
                    if (pegInstruction != null && pegInstruction.getPegPriceType() == 4) {
                        aParams.put("PEG_TYPE", "1");
                    }
                }
            }
            if (aMsg.getPegInstructions() != null && aMsg.getPegInstructions().getPegOffsetValue() != 0.0) {
                aParams.put("Rate", OrderSingleProcessor.this.toStringSafe(aMsg.getPrice(), "No Price specified"));
                aParams.put("AtMarket", OrderSingleProcessor.this.toStringSafe((int)aMsg.getPegInstructions().getPegOffsetValue(), "No At Market Points specified"));
            } else {
                aParams.put("Rate3", OrderSingleProcessor.this.toStringSafe(aMsg.getPrice(), "No Price specified"));
                aParams.put("Rate2", OrderSingleProcessor.this.toStringSafe(aMsg.getStopPx(), "No Stop Price specified"));
            }
            if (aMsg.getQuoteID() != null) {
                aParams.put("RateID", aMsg.getQuoteID());
            }
            if (TimeInForceFactory.GOOD_TILL_DATE.is(aMsg.getTimeInForce())) {
                if (aMsg.isExpireDateSet() && aMsg.isExpireTimeSet()) {
                    aParams.put("EXPIRE_DT", aMsg.getExpireTimestamp().toString());
                } else if (aMsg.isExpireDateSet()) {
                    aParams.put("EXPIRE_DT", aMsg.getExpireDate().toString() + "-21:00:00");
                } else if (aMsg.isExpireTimeSet()) {
                    aParams.put("EXPIRE_DT", aMsg.getExpireTime().toString());
                } else {
                    throw new GenericException("GTD order specified without accompanying ExpireTime or ExpireDate");
                }
            }
            if (aMsg.getTimeInForce() != null) {
                aParams.put("GTC", aMsg.getTimeInForce().getLabel());
            }
            return FXCMCommandType.CREATE_ORDER;
        }
    }

    private class OpenBuilder
    extends ARequestBuilder {
        OpenBuilder(IFXCMOrdType aType) {
            super(aType);
        }

        @Override
        protected FXCMCommandType fill(OrderSingle aMsg, Map<String, String> aParams) throws GenericException {
            aParams.put("Rate", OrderSingleProcessor.this.toStringSafe(aMsg.getPrice(), "No Price specified"));
            aParams.put("RateID", OrderSingleProcessor.this.toStringSafe(aMsg.getQuoteID(), "No Quote ID specified"));
            if (aMsg.getTimeInForce() != null) {
                aParams.put("GTC", aMsg.getTimeInForce().getLabel());
            }
            return FXCMCommandType.CREATE_ORDER;
        }
    }

    private abstract class ARequestBuilder {
        protected IFXCMOrdType mType;

        protected ARequestBuilder(IFXCMOrdType aType) {
            this.mType = aType;
        }

        public FXCMRequest build(ITransportable aTransportable) throws GenericException {
            if (OrderSingleProcessor.this.mLogger.isDebugEnabled()) {
                OrderSingleProcessor.this.mLogger.debug("Order to send: " + aTransportable);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            FXCMCommandType cmd = this.fill((OrderSingle)aTransportable, map);
            OrderSingle os = (OrderSingle)aTransportable;
            if (cmd == null) {
                throw new GenericException("Unsupported Order Type");
            }
            if (os.getTimeInForce() == null) {
                throw new GenericException("Unsupported Time In Force");
            }
            if (os.getQuoteID() != null && os.getQuoteID().startsWith("Requote-")) {
                return OrderSingleProcessor.this.buildFXCMRequest(cmd, map, aTransportable.getRequestID());
            }
            map.put("AcctReportID", OrderSingleProcessor.this.toStringSafe(os.getAccount(), "No Account specified"));
            if (os.getParties() != null) {
                Iterator parties;
                if (os.getParties().getFXCMAcctID() != 0L) {
                    map.put("AcctID", String.valueOf(os.getParties().getFXCMAcctID()));
                }
                if ((parties = os.getParties().getParties()) != null && parties.hasNext()) {
                    StringBuilder sb = new StringBuilder();
                    while (parties.hasNext()) {
                        Party p = (Party)parties.next();
                        sb.append("[");
                        sb.append(p.getPartyId());
                        sb.append(",");
                        sb.append(p.getPartyIdSource());
                        sb.append(",");
                        sb.append(p.getPartyRole());
                        sb.append(",");
                        Iterator subParties = p.getSubParties();
                        while (subParties.hasNext()) {
                            Party.SubParty sp = (Party.SubParty)subParties.next();
                            sb.append(sp.getPartySubId());
                            sb.append(",");
                            sb.append(sp.getPartySubIdType());
                            if (!subParties.hasNext()) continue;
                            sb.append(",");
                        }
                        sb.append("]");
                    }
                    map.put("PARTIES", sb.toString());
                }
            }
            int offerID = os.getInstrument().getFXCMSymID();
            map.put("OfferID", String.valueOf(offerID));
            map.put("CCY1CCY2", os.getInstrument().getSymbol());
            if (os.getOrderPercent() == 0.0) {
                String qty = "1".equals(os.getClOrdLinkID()) ? OrderSingleProcessor.this.toQuantityStringSafe(os.getOrderQty(), offerID) : OrderSingleProcessor.this.toQuantityStringSafe(os.getOrderQty(), offerID, "No Quantity specified");
                map.put("Quantity", qty);
            } else {
                map.put("NET_QTY_FLG", "Y");
            }
            String buysell = this.toBuySellStringSafe(this.mType, os.getSide(), "No Order Side specified");
            map.put("BuySell", buysell);
            map.put("QTXT", OrderSingleProcessor.this.avoidNull(os.getSecondaryClOrdID()));
            map.put("OrderType", this.mType.getCode());
            if (os.getPrevClosePx() != 0.0) {
                map.put("CLIENTRATE", String.valueOf(os.getPrevClosePx()));
            }
            if (OrderSingleProcessor.this.isDealer() && "5".equals(os.getExecInstruction())) {
                map.put("EE", "N");
            }
            return OrderSingleProcessor.this.buildFXCMRequest(cmd, map, aTransportable.getRequestID());
        }

        protected String toBuySellStringSafe(IFXCMOrdType aOrdType, ISide aSide, String aError) throws GenericException {
            String ret = null;
            if (aOrdType == FXCMOrdTypeFactory.STOP || aOrdType == FXCMOrdTypeFactory.LIMIT) {
                if (aSide == SideFactory.SELL) {
                    ret = "B";
                } else if (aSide == SideFactory.BUY) {
                    ret = "S";
                }
            } else if (aOrdType == FXCMOrdTypeFactory.OPEN_MARKET || aOrdType == FXCMOrdTypeFactory.CLOSE_MARKET || aOrdType == FXCMOrdTypeFactory.OPEN || aOrdType == FXCMOrdTypeFactory.CLOSE || aOrdType == FXCMOrdTypeFactory.ENTRY_STOP || aOrdType == FXCMOrdTypeFactory.ENTRY_LIMIT || aOrdType == FXCMOrdTypeFactory.OPEN_LIMIT || aOrdType == FXCMOrdTypeFactory.OPEN_RANGE || aOrdType == FXCMOrdTypeFactory.CLOSE_RANGE || aOrdType == FXCMOrdTypeFactory.CLOSE_LIMIT || aOrdType == FXCMOrdTypeFactory.STOP_TRAILING_ENTRY || aOrdType == FXCMOrdTypeFactory.LIMIT_TRAILING_ENTRY || aOrdType == FXCMOrdTypeFactory.RANGE_ENTRY || aOrdType == FXCMOrdTypeFactory.RANGE_TRAILING_ENTRY) {
                if (aSide == SideFactory.SELL) {
                    ret = "S";
                } else if (aSide == SideFactory.BUY) {
                    ret = "B";
                }
            } else {
                throw new GenericException(aError);
            }
            if (ret == null) {
                throw new GenericException(aError);
            }
            return ret;
        }

        protected String toSideStringSafe(IFXCMOrdType aOrdType, ISide aSide, IOrdType aType, String aError) throws GenericException {
            String ret = null;
            if (aOrdType == FXCMOrdTypeFactory.STOP || aOrdType == FXCMOrdTypeFactory.LIMIT) {
                if (aSide == SideFactory.SELL) {
                    if (aType == OrdTypeFactory.LIMIT) {
                        ret = "-1";
                    } else if (aType == OrdTypeFactory.STOP) {
                        ret = "1";
                    }
                } else if (aSide == SideFactory.BUY) {
                    if (aType == OrdTypeFactory.LIMIT) {
                        ret = "1";
                    } else if (aType == OrdTypeFactory.STOP) {
                        ret = "-1";
                    }
                }
            } else if (aOrdType == FXCMOrdTypeFactory.ENTRY_STOP || aOrdType == FXCMOrdTypeFactory.ENTRY_LIMIT || aOrdType == FXCMOrdTypeFactory.OPEN_LIMIT || aOrdType == FXCMOrdTypeFactory.CLOSE_LIMIT || aOrdType == FXCMOrdTypeFactory.STOP_TRAILING_ENTRY || aOrdType == FXCMOrdTypeFactory.LIMIT_TRAILING_ENTRY) {
                if (aSide == SideFactory.SELL) {
                    if (aType == OrdTypeFactory.LIMIT) {
                        ret = "1";
                    } else if (aType == OrdTypeFactory.STOP) {
                        ret = "-1";
                    }
                } else if (aSide == SideFactory.BUY) {
                    if (aType == OrdTypeFactory.LIMIT) {
                        ret = "-1";
                    } else if (aType == OrdTypeFactory.STOP) {
                        ret = "1";
                    }
                }
            } else if (aOrdType == FXCMOrdTypeFactory.RANGE_ENTRY || aOrdType == FXCMOrdTypeFactory.RANGE_TRAILING_ENTRY) {
                if (aSide == SideFactory.BUY) {
                    ret = "1";
                } else if (aSide == SideFactory.SELL) {
                    ret = "-1";
                }
            }
            if (ret == null) {
                throw new GenericException(aError);
            }
            return ret;
        }

        protected abstract FXCMCommandType fill(OrderSingle var1, Map<String, String> var2) throws GenericException;
    }
}

