/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.fix.request;

import com.fxcm.GenericException;
import com.fxcm.fix.trade.OrderMassStatusRequest;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.util.fix.FXCMCommandType;
import com.fxcm.messaging.util.fix.ISessionStrategy;
import com.fxcm.messaging.util.fix.request.ARequestProcessor;
import java.util.HashMap;

public class OrderMassStatusRequestProcessor
extends ARequestProcessor {
    public OrderMassStatusRequestProcessor(ISessionStrategy aSession) {
        super(aSession);
    }

    @Override
    public void process(ITransportable aObj) throws GenericException {
        OrderMassStatusRequest omsr = (OrderMassStatusRequest)aObj;
        FXCMCommandType cmd = FXCMCommandType.GET_TRADER_ORDERS;
        if (this.mSession.getUserKind() == 24) {
            cmd = FXCMCommandType.GET_DEALER_ORDERS;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (omsr.getParties() != null) {
            if (omsr.getParties().getFXCMAcctID() != 0L) {
                cmd = FXCMCommandType.GET_ACCT_ORDERS;
                params.put("AcctID", String.valueOf(omsr.getParties().getFXCMAcctID()));
            } else if (omsr.getParties().getFXCMTraderLoginId() != null) {
                cmd = FXCMCommandType.GET_LOGIN_ORDERS;
                params.put("LoginID", omsr.getParties().getFXCMTraderLoginId());
            }
        }
        if (omsr.getAccount() != null) {
            params.put("AcctReportID", omsr.getAccount());
        }
        if (omsr.getExecID() != null) {
            params.put("CHANGE_NO", omsr.getExecID());
            cmd = FXCMCommandType.GET_ORDER_HISTORY;
        }
        if (omsr.getOrderID() != null) {
            params.put("OrderID", omsr.getOrderID());
            cmd = FXCMCommandType.GET_ORDER_HISTORY;
        }
        if (omsr.getClOrdID() != null) {
            params.put("OrderQID", omsr.getClOrdID());
            cmd = FXCMCommandType.GET_ORDER_HISTORY;
        }
        if (omsr.getSecondaryClOrdID() != null) {
            params.put("OrderQTXT", omsr.getSecondaryClOrdID());
            cmd = FXCMCommandType.GET_ORDER_HISTORY;
        }
        this.request(cmd, params, aObj.getRequestID());
    }
}

