/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.fix.request;

import com.fxcm.GenericException;
import com.fxcm.fix.ContingencyTypeFactory;
import com.fxcm.fix.ExecTypeFactory;
import com.fxcm.fix.FXCMOrdStatusFactory;
import com.fxcm.fix.Instrument;
import com.fxcm.fix.OrdStatusFactory;
import com.fxcm.fix.SideFactory;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.fix.custom.BatchRequest;
import com.fxcm.fix.custom.FXCMRequest;
import com.fxcm.fix.trade.ExecutionReport;
import com.fxcm.fix.trade.OrderList;
import com.fxcm.fix.trade.OrderSingle;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.util.fix.FXCMCommandType;
import com.fxcm.messaging.util.fix.IProcessor;
import com.fxcm.messaging.util.fix.ISessionStrategy;
import com.fxcm.messaging.util.fix.request.OrderSingleProcessor;
import java.util.ArrayList;

public class OrderListProcessor
extends OrderSingleProcessor {
    private IProcessor mELS;
    private IProcessor mNONE = new NONE();
    private IProcessor mOCO;
    private IProcessor mOTO = new OTO();
    private IProcessor mOTOCO;

    public OrderListProcessor(ISessionStrategy aSession) {
        super(aSession);
        this.mELS = new ELS();
        this.mOCO = new OCO();
        this.mOTOCO = new OTOCO();
    }

    @Override
    public void process(ITransportable aObj) throws GenericException {
        OrderList orderList = (OrderList)aObj;
        this.mLogger.debug(orderList);
        if (orderList.getFXCMContingencyID() == null && orderList.getContingencyType() == null) {
            this.mNONE.process(orderList);
        } else if (orderList.getContingencyType() == ContingencyTypeFactory.OTO) {
            this.mOTO.process(orderList);
        } else if (orderList.getContingencyType() == ContingencyTypeFactory.ELS) {
            this.mELS.process(orderList);
        } else if (orderList.getContingencyType() == ContingencyTypeFactory.OTOCO) {
            this.mOTOCO.process(orderList);
        } else {
            this.mOCO.process(orderList);
        }
    }

    private void processContingency(OrderList aOrderList, int aContingencyType) {
        BatchRequest batchRequest = new BatchRequest();
        batchRequest.setRefMsgType("U54");
        batchRequest.setFXCMCommandID(FXCMCommandType.CREATE_ORDER.getType());
        batchRequest.setMDReqID(aOrderList.getListID());
        batchRequest.setContingencyType(aContingencyType);
        batchRequest.setTransactTime(aOrderList.getTransactTime());
        OrderSingle[] orders = aOrderList.getOrders();
        ArrayList<OrderSingle> list = new ArrayList<OrderSingle>();
        String primaryQID = null;
        for (OrderSingle os : orders) {
            if ("1".equals(os.getClOrdLinkID())) {
                this.mLogger.debug("primary order = " + os);
                primaryQID = os.getRequestID();
                try {
                    FXCMRequest request = this.buildFXCMRequest(os);
                    batchRequest.addMessage(request);
                    continue;
                }
                catch (Exception e) {
                    this.mLogger.error(e.getMessage(), e);
                    ExecutionReport report = this.buildReject(os, e);
                    report.setListID(aOrderList.getListID());
                    this.mSession.sendBackToUser(report);
                    return;
                }
            }
            list.add(os);
        }
        for (OrderSingle os : list) {
            this.mLogger.debug("secondary order = " + os);
            try {
                FXCMRequest request = this.buildFXCMRequest(os);
                request.setParam("PRIMARY_QID", primaryQID);
                batchRequest.addMessage(request);
            }
            catch (Exception e) {
                this.mLogger.error(e.getMessage(), e);
                ExecutionReport report = this.buildReject(os, e);
                report.setListID(aOrderList.getListID());
                this.mSession.sendBackToUser(report);
            }
        }
        this.mLogger.debug("sending batchrequest = " + batchRequest);
        try {
            this.mSession.sendToServer(batchRequest);
        }
        catch (GenericException e) {
            this.mLogger.error(e.getMessage(), e);
            ExecutionReport report = this.buildReject(aOrderList, (Exception)e);
            this.mSession.sendBackToUser(report);
        }
    }

    protected ExecutionReport buildReject(OrderList aFixOrder, Exception aException) {
        ExecutionReport report = new ExecutionReport();
        report.setOrderID("NONE");
        report.setInstrument(new Instrument("[N/A]"));
        report.setListID(aFixOrder.getListID());
        report.setTradingSessionID(this.mSession.getTradingSessionID());
        report.setTradingSessionSubID(this.mSession.getTradingSessionSubID());
        report.setTransactTime(new UTCTimestamp());
        report.setExecID("0");
        report.setExecType(ExecTypeFactory.REJECTED);
        report.setFXCMOrdStatus(FXCMOrdStatusFactory.REJECTED);
        report.setFXCMErrorDetails(aException.getMessage());
        report.setFXCMRequestRejectReason(0);
        report.setLastRptRequested(true);
        report.setOrdStatus(OrdStatusFactory.REJECTED);
        report.setSide(SideFactory.UNDISCLOSED);
        report.setText(aException.getMessage());
        report.setTotNumReports(0);
        return report;
    }

    private final class OCO
    implements IProcessor {
        private OCO() {
        }

        @Override
        public void process(ITransportable aObj) {
            OrderSingle[] orders;
            OrderList orderList = (OrderList)aObj;
            BatchRequest batchRequest = new BatchRequest();
            batchRequest.setRefMsgType("U54");
            batchRequest.setFXCMCommandID(FXCMCommandType.CONTINGENCY_BULK.getType());
            batchRequest.setMDReqID(orderList.getListID());
            batchRequest.setTransactTime(orderList.getTransactTime());
            if (orderList.getContingencyType() != null) {
                batchRequest.setContingencyType(Integer.parseInt(ContingencyTypeFactory.OCO.getCode()));
            }
            for (OrderSingle order : orders = orderList.getOrders()) {
                try {
                    FXCMRequest request = OrderListProcessor.this.buildFXCMRequest(order);
                    if (orderList.getContingencyType() != null) {
                        request.setParam("CONTINGENCY_TYPE", orderList.getContingencyType().getCode());
                    }
                    if (orderList.getFXCMContingencyID() != null) {
                        request.setParam("CONTINGENCY_ID", orderList.getFXCMContingencyID());
                    }
                    if (order.getAccount() != null) {
                        request.setParam("AcctReportID", order.getAccount());
                    }
                    if (order.getOrderID() != null) {
                        request.setParam("OrderID", order.getOrderID());
                    }
                    if (order.getParties() != null && order.getParties().getFXCMAcctID() != 0L) {
                        request.setParam("AcctID", String.valueOf(order.getParties().getFXCMAcctID()));
                    }
                    batchRequest.addMessage(request);
                }
                catch (Exception e) {
                    OrderListProcessor.this.mLogger.error(e.getMessage(), e);
                    ExecutionReport report = OrderListProcessor.this.buildReject(order, e);
                    report.setListID(orderList.getListID());
                    OrderListProcessor.this.mSession.sendBackToUser(report);
                }
            }
            OrderListProcessor.this.mLogger.debug("sending batchrequest = " + batchRequest);
            try {
                OrderListProcessor.this.mSession.sendToServer(batchRequest);
            }
            catch (GenericException e) {
                OrderListProcessor.this.mLogger.error(e.getMessage(), e);
                ExecutionReport report = OrderListProcessor.this.buildReject(orderList, (Exception)e);
                OrderListProcessor.this.mSession.sendBackToUser(report);
            }
        }
    }

    private final class NONE
    implements IProcessor {
        private NONE() {
        }

        @Override
        public void process(ITransportable aObj) {
            OrderSingle[] orders;
            OrderList orderList = (OrderList)aObj;
            BatchRequest batchRequest = new BatchRequest();
            batchRequest.setRefMsgType("U54");
            batchRequest.setFXCMCommandID(FXCMCommandType.CREATE_ORDER.getType());
            batchRequest.setMDReqID(orderList.getListID());
            batchRequest.setTransactTime(orderList.getTransactTime());
            for (OrderSingle os : orders = orderList.getOrders()) {
                if (!(os instanceof OrderSingle)) continue;
                try {
                    FXCMRequest request = OrderListProcessor.this.buildFXCMRequest(os);
                    batchRequest.addMessage(request);
                }
                catch (Exception e) {
                    OrderListProcessor.this.mLogger.error(e.getMessage(), e);
                    ExecutionReport report = OrderListProcessor.this.buildReject(os, e);
                    report.setListID(orderList.getListID());
                    OrderListProcessor.this.mSession.sendBackToUser(report);
                }
            }
            OrderListProcessor.this.mLogger.debug("sending batchrequest = " + batchRequest);
            try {
                OrderListProcessor.this.mSession.sendToServer(batchRequest);
            }
            catch (GenericException e) {
                OrderListProcessor.this.mLogger.error(e.getMessage(), e);
                ExecutionReport report = OrderListProcessor.this.buildReject(orderList, (Exception)e);
                OrderListProcessor.this.mSession.sendBackToUser(report);
            }
        }
    }

    private final class OTOCO
    implements IProcessor {
        private OTOCO() {
        }

        @Override
        public void process(ITransportable aObj) {
            OrderListProcessor.this.processContingency((OrderList)aObj, 4);
        }
    }

    private final class ELS
    implements IProcessor {
        private ELS() {
        }

        @Override
        public void process(ITransportable aObj) {
            OrderListProcessor.this.processContingency((OrderList)aObj, 3);
        }
    }

    private final class OTO
    implements IProcessor {
        private OTO() {
        }

        @Override
        public void process(ITransportable aObj) {
            OrderListProcessor.this.processContingency((OrderList)aObj, 2);
        }
    }
}

