/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.fix.request;

import com.fxcm.GenericException;
import com.fxcm.fix.CxlRejReasonFactory;
import com.fxcm.fix.CxlRejResponseToFactory;
import com.fxcm.fix.OrdStatusFactory;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.fix.trade.OrderCancelReject;
import com.fxcm.fix.trade.OrderCancelRequest;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.util.fix.FXCMCommandType;
import com.fxcm.messaging.util.fix.ISessionStrategy;
import com.fxcm.messaging.util.fix.request.ARequestProcessor;
import com.fxcm.util.Util;
import java.util.HashMap;

public class OrderCancelRequestProcessor
extends ARequestProcessor {
    public OrderCancelRequestProcessor(ISessionStrategy aSession) {
        super(aSession);
    }

    @Override
    public void process(ITransportable aTransportable) throws GenericException {
        OrderCancelRequest request = (OrderCancelRequest)aTransportable;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("OrderCancelRequest to send: " + request);
        }
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("OrderID", this.toStringSafe(request.getOrderID(), "Error: Must Supply OrderID"));
            map.put("AcctReportID", this.toStringSafe(request.getAccount(), "Error: Must Supply Account"));
            if (request.getSecondaryClOrdID() != null) {
                map.put("QTXT", request.getSecondaryClOrdID());
            }
            if (request.getOrigClOrdID() != null) {
                map.put("OriginQID", request.getOrigClOrdID());
            }
            this.request(FXCMCommandType.DELETE_ORDER, map, request.getRequestID());
        }
        catch (GenericException e) {
            OrderCancelReject reject = new OrderCancelReject();
            reject.setOrderID(Util.avoidEmpty(request.getOrderID(), "NONE"));
            reject.setOrigClOrdID(Util.avoidEmpty(request.getOrigClOrdID(), "[N/A]"));
            reject.setAccount(request.getAccount());
            reject.setClOrdID(request.getRequestID());
            reject.setSecondaryClOrdID(request.getSecondaryClOrdID());
            reject.setTradingSessionID(this.mSession.getTradingSessionID());
            reject.setTradingSessionSubID(this.mSession.getTradingSessionSubID());
            reject.setTransactTime(new UTCTimestamp());
            reject.setCxlRejReason(CxlRejReasonFactory.OTHER);
            reject.setCxlRejResponseTo(CxlRejResponseToFactory.ORDER_CANCEL_REQUEST);
            reject.setFXCMRequestRejectReason(0);
            reject.setOrdStatus(OrdStatusFactory.REJECTED);
            reject.setFXCMErrorDetails(e.getMessage());
            reject.setText(e.getMessage());
            this.mSession.sendBackToUser(reject);
        }
    }
}

