/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.fix.request;

import com.fxcm.GenericException;
import com.fxcm.fix.CxlRejReasonFactory;
import com.fxcm.fix.CxlRejResponseToFactory;
import com.fxcm.fix.OrdStatusFactory;
import com.fxcm.fix.OrdTypeFactory;
import com.fxcm.fix.PegInstruction;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.fix.custom.BatchRequest;
import com.fxcm.fix.custom.FXCMRequest;
import com.fxcm.fix.trade.OrderCancelReject;
import com.fxcm.fix.trade.OrderCancelReplaceRequest;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.util.fix.FXCMCommandType;
import com.fxcm.messaging.util.fix.ISessionStrategy;
import com.fxcm.messaging.util.fix.request.ARequestProcessor;
import java.util.HashMap;

public class OrderCancelReplaceRequestProcessor
extends ARequestProcessor {
    public OrderCancelReplaceRequestProcessor(ISessionStrategy aSession) {
        super(aSession);
    }

    @Override
    public void process(ITransportable aTransportable) throws GenericException {
        OrderCancelReplaceRequest request = (OrderCancelReplaceRequest)aTransportable;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("OrderCancelReplaceRequest to send: " + request);
        }
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            if (request.getFXCMContingencyID() == null && request.getContingencyType() == null) {
                PegInstruction pegInstructions;
                String qty;
                int offerID;
                if (request.getSecondaryClOrdID() != null) {
                    map.put("QTXT", request.getSecondaryClOrdID());
                }
                if (request.getOrigClOrdID() != null) {
                    map.put("OriginQID", request.getOrigClOrdID());
                }
                if (request.getOrderQty() != 0.0 && request.getInstrument() != null) {
                    offerID = this.mSession.getParser().getOfferId(request.getInstrument().getSymbol());
                    if (offerID == 0) {
                        throw new GenericException("Invalid currency pair: " + request.getInstrument());
                    }
                    request.getInstrument().setFXCMSymID(offerID);
                    qty = this.toQuantityStringSafe(request.getOrderQty(), offerID, "No Quantity specified");
                    map.put("ORDR_QTY", qty);
                }
                if (request.getLeavesQty() != 0.0 && request.getInstrument() != null) {
                    offerID = this.mSession.getParser().getOfferId(request.getInstrument().getSymbol());
                    if (offerID == 0) {
                        throw new GenericException("Invalid currency pair: " + request.getInstrument());
                    }
                    request.getInstrument().setFXCMSymID(offerID);
                    qty = this.toQuantityStringSafe(request.getLeavesQty(), offerID, "No LeavesQuantity specified");
                    map.put("Quantity", qty);
                }
                if ((pegInstructions = request.getPegInstructions()) != null && pegInstructions.getFXCMPegFluctuatePts() != 0) {
                    map.put("TrailUpdatePips", String.valueOf(pegInstructions.getFXCMPegFluctuatePts()));
                }
                if (request.getStopPx() == 0.0 && request.getPrice() == 0.0) {
                    if (pegInstructions != null) {
                        if (pegInstructions.getPegPriceType() == 3) {
                            map.put("PEG_TYPE", "0");
                        } else if (pegInstructions.getPegPriceType() == 4) {
                            map.put("PEG_TYPE", "1");
                        }
                        map.put("PRICE_OFFSET_PIPS", this.toStringSafe(pegInstructions.getPegOffsetValue(), "Error: Must Supply PegOffsetValue"));
                    }
                } else if (request.getOrdType() == OrdTypeFactory.STOP || request.getOrdType() == OrdTypeFactory.STOP_LIMIT) {
                    if (OrderCancelReplaceRequestProcessor.isRangeOrder(request)) {
                        map.put("Rate2", this.toStringSafe(request.getPrice(), "Error: No Price specified"));
                        map.put("Rate3", this.toStringSafe(request.getStopPx(), "Error: No StopPx specified"));
                    } else {
                        double rate = 0.0;
                        if (pegInstructions != null) {
                            rate = pegInstructions.getPegOffsetValue();
                        }
                        if (rate == 0.0) {
                            rate = request.getStopPx();
                        }
                        if (rate == 0.0) {
                            rate = request.getPrice();
                        }
                        map.put("Rate", this.toStringSafe(rate, "Error: No Price specified"));
                    }
                } else {
                    map.put("Rate", this.toStringSafe(request.getPrice(), "Error: No Price specified"));
                }
                map.put("OrderID", this.toStringSafe(request.getOrderID(), "Error: Must Supply OrderID"));
                map.put("AcctReportID", this.toStringSafe(request.getAccount(), "Error: Must Supply Account"));
                this.request(FXCMCommandType.CHANGE_ORDER_RATE, map, request.getRequestID());
            } else {
                BatchRequest br = new BatchRequest();
                br.setRefMsgType("U54");
                br.setFXCMCommandID(FXCMCommandType.CONTINGENCY_BULK.getType());
                if (request.getContingencyType() != null) {
                    br.setContingencyType(Integer.parseInt(request.getContingencyType().getCode()));
                }
                if (request.getAccount() != null) {
                    map.put("AcctReportID", request.getAccount());
                }
                map.put("OrderID", this.toStringSafe(request.getOrderID(), "Error: Must Supply OrderID"));
                map.put("AcctReportID", this.toStringSafe(request.getAccount(), "Error: Must Supply Account"));
                if (request.getContingencyType() != null && request.getFXCMContingencyID() != null) {
                    map.put("CONTINGENCY_TYPE", request.getContingencyType().getCode());
                }
                if (request.getFXCMContingencyID() != null) {
                    map.put("CONTINGENCY_ID", request.getFXCMContingencyID());
                }
                if (request.getParties() != null && request.getParties().getFXCMAcctID() != 0L) {
                    map.put("AcctID", String.valueOf(request.getParties().getFXCMAcctID()));
                }
                FXCMRequest req = this.buildFXCMRequest(FXCMCommandType.CONTINGENCY_BULK, map, request.getRequestID());
                br.addMessage(req);
                this.mLogger.debug("br = " + br);
                this.mSession.sendToServer(br);
            }
        }
        catch (GenericException e) {
            this.sendReject(request, e.getMessage());
        }
    }

    private static boolean isRangeOrder(OrderCancelReplaceRequest aRequest) {
        return aRequest.getPrice() != 0.0 && aRequest.getStopPx() != 0.0 && aRequest.getPrice() != aRequest.getStopPx();
    }

    private void sendReject(OrderCancelReplaceRequest aRequest, String aError) {
        OrderCancelReject reject = new OrderCancelReject();
        String s = aRequest.getOrderID();
        if (s == null || s.length() == 0) {
            s = "NONE";
        }
        reject.setOrderID(s);
        s = aRequest.getOrigClOrdID();
        if (s == null || s.length() == 0) {
            s = "[N/A]";
        }
        reject.setOrigClOrdID(s);
        reject.setAccount(aRequest.getAccount());
        reject.setClOrdID(aRequest.getRequestID());
        reject.setSecondaryClOrdID(aRequest.getSecondaryClOrdID());
        reject.setTradingSessionID(this.mSession.getTradingSessionID());
        reject.setTradingSessionSubID(this.mSession.getTradingSessionSubID());
        reject.setTransactTime(new UTCTimestamp());
        reject.setCxlRejReason(CxlRejReasonFactory.OTHER);
        reject.setCxlRejResponseTo(CxlRejResponseToFactory.ORDER_CANCEL_REPLACE_REQUEST);
        reject.setFXCMRequestRejectReason(0);
        reject.setOrdStatus(OrdStatusFactory.REJECTED);
        reject.setFXCMErrorDetails(aError);
        reject.setText(aError);
        this.mSession.sendBackToUser(reject);
    }
}

