/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.fix.request;

import com.fxcm.GenericException;
import com.fxcm.fix.ISubscriptionRequestType;
import com.fxcm.fix.Instrument;
import com.fxcm.fix.SubscriptionRequestTypeFactory;
import com.fxcm.fix.TradingSecurity;
import com.fxcm.fix.pretrade.MarketDataRequest;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.util.fix.FXCMCommandType;
import com.fxcm.messaging.util.fix.ISessionStrategy;
import com.fxcm.messaging.util.fix.TradingSessionStatusAdj;
import com.fxcm.messaging.util.fix.request.ARequestProcessor;
import java.util.Enumeration;
import java.util.HashMap;

public class MarketDataRequestProcessor
extends ARequestProcessor {
    public MarketDataRequestProcessor(ISessionStrategy aSession) {
        super(aSession);
    }

    private boolean isHistoricalRequest(MarketDataRequest aMdr) {
        return aMdr.getFXCMEndDate() != null || aMdr.getFXCMEndTime() != null || aMdr.getFXCMStartDate() != null || aMdr.getFXCMStartTime() != null;
    }

    @Override
    public void process(ITransportable aObj) throws GenericException {
        MarketDataRequest mdr = (MarketDataRequest)aObj;
        HashMap<String, String> map = null;
        Enumeration enumeration = mdr.getRelatedSymbols();
        if (enumeration.hasMoreElements()) {
            StringBuffer sb = new StringBuffer();
            while (enumeration.hasMoreElements()) {
                Instrument instrument = (Instrument)enumeration.nextElement();
                if (instrument == null) continue;
                try {
                    TradingSecurity security;
                    String symbol = instrument.getSymbol();
                    sb.append(symbol);
                    if (enumeration.hasMoreElements()) {
                        sb.append(",");
                    }
                    if ((security = this.mSession.getTradingSessionStatus().getSecurity(symbol)) == null) continue;
                    this.updateSubscription(mdr.getSubscriptionRequestType(), security);
                }
                catch (Exception e) {
                    this.mLogger.error(e.getMessage(), e);
                }
            }
            if (sb.length() != 0) {
                map = new HashMap<String, String>();
                map.put("symbols", sb.toString());
            }
        } else {
            Enumeration securities = this.mSession.getTradingSessionStatus().getSecurities();
            while (securities.hasMoreElements()) {
                TradingSecurity security = (TradingSecurity)securities.nextElement();
                if (security == null) continue;
                this.updateSubscription(mdr.getSubscriptionRequestType(), security);
            }
        }
        if (mdr.getSubscriptionRequestType() == SubscriptionRequestTypeFactory.SNAPSHOT || mdr.getSubscriptionRequestType() == SubscriptionRequestTypeFactory.SUBSCRIBE) {
            if (this.isHistoricalRequest(mdr)) {
                this.mSession.sendToServer(mdr);
            } else {
                this.request(FXCMCommandType.GET_OFFERS, map, mdr.getRequestID());
            }
        }
    }

    private void updateSubscription(ISubscriptionRequestType aType, TradingSecurity aSecurity) {
        try {
            boolean notNative;
            TradingSessionStatusAdj tradingSessionStatus = this.mSession.getParser().getTradingSessionStatus();
            String supportType = tradingSessionStatus.getParameterValue("FixSupport");
            boolean bl = notNative = !"FIXONLY".equalsIgnoreCase(supportType);
            if (notNative && this.mSession.getUserKind() == 20) {
                if (aType == SubscriptionRequestTypeFactory.SUBSCRIBE) {
                    if (!"T".equals(aSecurity.getFXCMSubscriptionStatus())) {
                        HashMap<String, String> hm = new HashMap<String, String>();
                        hm.put("Status", "T");
                        hm.put("OfferID", String.valueOf(aSecurity.getFXCMSymID()));
                        this.request(FXCMCommandType.SET_INSTRUMENTS, hm, this.mSession.getNextRequestID());
                    }
                } else if (aType == SubscriptionRequestTypeFactory.UNSUBSCRIBE && !"D".equals(aSecurity.getFXCMSubscriptionStatus())) {
                    HashMap<String, String> hm = new HashMap<String, String>();
                    hm.put("Status", "D");
                    hm.put("OfferID", String.valueOf(aSecurity.getFXCMSymID()));
                    this.request(FXCMCommandType.SET_INSTRUMENTS, hm, this.mSession.getNextRequestID());
                }
            }
        }
        catch (Exception e) {
            this.mLogger.error(e.getMessage(), e);
        }
    }
}

