/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.fix.request;

import com.fxcm.GenericException;
import com.fxcm.fix.custom.FXCMRequest;
import com.fxcm.messaging.util.fix.FXCMCommandType;
import com.fxcm.messaging.util.fix.IProcessor;
import com.fxcm.messaging.util.fix.ISessionStrategy;
import com.fxcm.util.logging.Utils;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;

public abstract class ARequestProcessor
implements IProcessor {
    protected final Log mLogger = Utils.getLog(this);
    protected final ISessionStrategy mSession;

    protected ARequestProcessor(ISessionStrategy aSession) {
        this.mSession = aSession;
    }

    protected String avoidNull(String aValue) {
        String ret = "";
        if (aValue != null) {
            ret = aValue;
        }
        return ret;
    }

    protected FXCMRequest buildFXCMRequest(FXCMCommandType aFXCMCommandId, Map<String, String> aReqMap, String aRequestID) throws GenericException {
        FXCMRequest req = new FXCMRequest();
        String reqID = aRequestID != null ? aRequestID : this.mSession.getNextRequestID();
        req.setTradingSessionID(this.mSession.getTradingSessionID());
        req.setTradingSessionSubID(this.mSession.getTradingSessionSubID());
        req.setTestReqID(reqID);
        req.setFXCMCommandID(aFXCMCommandId.getType());
        Hashtable<String, String> params = new Hashtable<String, String>();
        if (aReqMap != null) {
            params.putAll(aReqMap);
        }
        params.put("SID", this.mSession.getSessionID());
        if (this.mSession.getUserKind() != 24) {
            params.put("TraderID", String.valueOf(this.mSession.getUserID()));
        }
        params.put("QID", reqID);
        req.setParams(params);
        if (this.mLogger.isDebugEnabled()) {
            String sb = "RequestID = " + reqID + "; FXCMCommand = " + aFXCMCommandId + "; Params=" + params;
            this.mLogger.debug(sb);
        }
        return req;
    }

    protected boolean isDealer() {
        return this.mSession.getUserKind() == 24;
    }

    protected void request(FXCMCommandType aFXCMCommandId, Map<String, String> aReqMap, String aRequestID) throws GenericException {
        FXCMRequest request = this.buildFXCMRequest(aFXCMCommandId, aReqMap, aRequestID);
        this.mSession.sendToServer(request);
    }

    protected String toQuantityStringSafe(double aValue, int aOfferID, String aError) throws GenericException {
        long ret = this.mSession.getParser().absoluteToLots(aValue, aOfferID);
        if (ret == 0L) {
            throw new GenericException(aError);
        }
        return String.valueOf(ret);
    }

    protected String toQuantityStringSafe(double aValue, int aOfferID) throws GenericException {
        long ret = this.mSession.getParser().absoluteToLots(aValue, aOfferID);
        return String.valueOf(ret);
    }

    protected String toStringSafe(long aValue, String aError) throws GenericException {
        if (aValue == 0L) {
            throw new GenericException(aError);
        }
        return String.valueOf(aValue);
    }

    protected String toStringSafe(double aValue, String aError) throws GenericException {
        if (aValue == 0.0) {
            throw new GenericException(aError);
        }
        return String.valueOf(aValue);
    }

    protected String toStringSafe(String aValue, String aError) throws GenericException {
        if (aValue == null) {
            throw new GenericException(aError);
        }
        return aValue;
    }
}

