/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.fix;

import com.fxcm.fix.Parameter;
import com.fxcm.fix.TradingSecurity;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.fix.pretrade.TradingSessionStatus;
import com.fxcm.messaging.util.fix.TradingSecurityAdj;
import com.fxcm.util.logging.Utils;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.logging.Log;

public class TradingSessionStatusAdj
extends com.fxcm.fix.pretrade.inner.TradingSessionStatus {
    private final Log mLogger = Utils.getLog(TradingSessionStatusAdj.class);
    private final Map mSecuritiesByID;
    private Calendar mServerTime = Calendar.getInstance();
    private String mTradeProfileID;

    public TradingSessionStatusAdj() {
        this.mSecuritiesByID = Collections.synchronizedMap(new HashMap());
    }

    public TradingSessionStatusAdj(TradingSessionStatus aTradingSessionStatus) {
        this();
        this.fill(aTradingSessionStatus);
    }

    protected void clearInstruments() {
        this.mSecurities.clear();
        this.mSecuritiesByID.clear();
    }

    public void fill(TradingSessionStatus aTradingSessionStatus) {
        Enumeration en = aTradingSessionStatus.getParameters();
        while (en.hasMoreElements()) {
            this.setParameter((Parameter)en.nextElement());
        }
        en = aTradingSessionStatus.getSecurities();
        while (en.hasMoreElements()) {
            this.setSecurity((TradingSecurity)en.nextElement());
        }
        this.setTradSesReqID(aTradingSessionStatus.getTradSesReqID());
        this.setTradingSessionID(aTradingSessionStatus.getTradingSessionID());
        this.setTradingSessionSubID(aTradingSessionStatus.getTradingSessionSubID());
        this.setTradSesStatusRejReason(aTradingSessionStatus.getTradSesStatusRejReason());
        this.setFXCMServerTimeZoneName(aTradingSessionStatus.getFXCMServerTimeZoneName());
        this.setTradSesMode(aTradingSessionStatus.getTradSesMode());
        this.setTradSesStatus(aTradingSessionStatus.getTradSesStatus());
        this.setText(aTradingSessionStatus.getText());
        this.setFXCMServerTimeZone(aTradingSessionStatus.getFXCMServerTimeZone());
        this.setUnsolicitedIndicator(aTradingSessionStatus.getUnsolicitedIndicator());
        this.setTransactTime(new UTCTimestamp());
        this.setTradSesStartTime(aTradingSessionStatus.getTradSesStartTime());
        this.setTradSesOpenTime(aTradingSessionStatus.getTradSesOpenTime());
        this.setTradSesCloseTime(aTradingSessionStatus.getTradSesCloseTime());
    }

    @Override
    public TradingSecurity getSecurity(String aCcy) {
        return super.getSecurity(aCcy);
    }

    public Calendar getServerCalendar() {
        return (Calendar)this.mServerTime.clone();
    }

    public String getTradeProfileID() {
        return this.mTradeProfileID;
    }

    public TradingSecurityAdj getTradingSecurityAdj(int aOfferID) {
        return (TradingSecurityAdj)this.mSecuritiesByID.get(String.valueOf(aOfferID));
    }

    @Override
    public void setFXCMServerTimeZoneName(String aFXCMServerTimeZoneName) {
        this.mLogger.debug("inc:" + aFXCMServerTimeZoneName);
        if (aFXCMServerTimeZoneName != null) {
            String serverTime = this.getParameterValue("SERVER_TIME_UTC");
            this.mLogger.debug("serverTime = " + serverTime);
            this.mFXCMServerTimeZoneName = "UTC".equalsIgnoreCase(serverTime) ? TimeZone.getTimeZone("UTC").getDisplayName() : aFXCMServerTimeZoneName;
            this.mServerTime.setTimeZone(TimeZone.getTimeZone(this.mFXCMServerTimeZoneName));
            int hour = 3600000;
            int difference = this.mServerTime.get(15) + this.mServerTime.get(16);
            int offset = difference / hour;
            this.mLogger.debug("offset = " + offset);
            this.setFXCMServerTimeZone(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSecurity(TradingSecurity aSecurity) {
        if (aSecurity != null) {
            try {
                TradingSecurityAdj ts = new TradingSecurityAdj();
                ts.fill(aSecurity);
                Map map = this.mSecuritiesByID;
                synchronized (map) {
                    this.mSecurities.put(ts.getSymbol(), ts);
                    this.mSecuritiesByID.put(String.valueOf(ts.getFXCMSymID()), ts);
                }
            }
            catch (Exception e) {
                this.mLogger.error(e.getMessage(), e);
            }
        }
    }

    public void setTradingProfileID(String aTradeProfileID) {
        this.mTradeProfileID = aTradeProfileID;
    }
}

