/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.fix;

import com.fxcm.fix.PriceStream;
import com.fxcm.fix.TradingSecurity;

public class TradingSecurityAdj
extends TradingSecurity {
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyz";
    protected double mAskAdjustment;
    protected double mBidAdjustment;
    private PriceStream mPriceStream;

    public TradingSecurityAdj() {
    }

    public TradingSecurityAdj(TradingSecurity aTradingSecurity) {
        this();
        this.fill(aTradingSecurity);
    }

    public void fill(TradingSecurity aTradingSecurity) {
        super.fill(aTradingSecurity);
        if (aTradingSecurity instanceof TradingSecurityAdj) {
            TradingSecurityAdj tradingSecurityAdj = (TradingSecurityAdj)aTradingSecurity;
            if (tradingSecurityAdj.getAskAdjustment() != 0.0) {
                this.mAskAdjustment = tradingSecurityAdj.getAskAdjustment();
            }
            if (tradingSecurityAdj.getBidAdjustment() != 0.0) {
                this.mBidAdjustment = tradingSecurityAdj.getBidAdjustment();
            }
            if (tradingSecurityAdj.getPriceStream() != null) {
                this.mPriceStream = tradingSecurityAdj.getPriceStream();
            }
        }
    }

    public double getAskAdjustment() {
        return this.mAskAdjustment;
    }

    public void setAskAdjustment(double aAskAdjustment) {
        this.mAskAdjustment = aAskAdjustment;
    }

    public double getBidAdjustment() {
        return this.mBidAdjustment;
    }

    public void setBidAdjustment(double aBidAdjustment) {
        this.mBidAdjustment = aBidAdjustment;
    }

    public PriceStream getPriceStream() {
        return this.mPriceStream;
    }

    public void setPriceStream(PriceStream aPriceStream) {
        this.mPriceStream = aPriceStream;
    }

    @Override
    public boolean isValid() {
        if (this.isForex() && !this.isValidSymbol(this.mSymbol)) {
            return false;
        }
        if (this.mFXCMSymPrecision == -1) {
            return false;
        }
        return this.mCurrency != null;
    }

    private boolean isValidSymbol(String aSymbol) {
        if (aSymbol == null) {
            return false;
        }
        boolean isValid = true;
        block9: for (int i = 0; i < aSymbol.length(); ++i) {
            String character = String.valueOf(aSymbol.charAt(i)).toLowerCase();
            switch (i) {
                case 0: {
                    if (ALPHABET.indexOf(character) != -1) continue block9;
                    isValid = false;
                    continue block9;
                }
                case 1: {
                    if (ALPHABET.indexOf(character) != -1) continue block9;
                    isValid = false;
                    continue block9;
                }
                case 2: {
                    if (ALPHABET.indexOf(character) != -1) continue block9;
                    isValid = false;
                    continue block9;
                }
                case 3: {
                    if ("/".indexOf(character) != -1) continue block9;
                    isValid = false;
                    continue block9;
                }
                case 4: {
                    if (ALPHABET.indexOf(character) != -1) continue block9;
                    isValid = false;
                    continue block9;
                }
                case 5: {
                    if (ALPHABET.indexOf(character) != -1) continue block9;
                    isValid = false;
                    continue block9;
                }
                case 6: {
                    if (ALPHABET.indexOf(character) != -1) continue block9;
                    isValid = false;
                }
            }
        }
        return isValid;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TradingSecurityAdj");
        sb.append(" --- begin superclass toString ");
        sb.append(super.toString());
        sb.append(" --- end superclass toString ");
        sb.append("{mAskAdjustment=").append(this.mAskAdjustment);
        sb.append(", mBidAdjustment=").append(this.mBidAdjustment);
        sb.append(", mPriceStream=").append(this.mPriceStream);
        sb.append('}');
        return sb.toString();
    }
}

