/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.fix;

import com.fxcm.entity.ACode;
import com.fxcm.fix.FixObjectFactory;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.util.IllegalRequestException;
import com.fxcm.messaging.util.fix.IProcessor;
import com.fxcm.messaging.util.fix.ISessionStrategy;
import com.fxcm.messaging.util.fix.request.CollateralInquiryProcessor;
import com.fxcm.messaging.util.fix.request.MarketDataRequestProcessor;
import com.fxcm.messaging.util.fix.request.OrderCancelReplaceRequestProcessor;
import com.fxcm.messaging.util.fix.request.OrderCancelRequestProcessor;
import com.fxcm.messaging.util.fix.request.OrderListProcessor;
import com.fxcm.messaging.util.fix.request.OrderMassStatusRequestProcessor;
import com.fxcm.messaging.util.fix.request.OrderSingleProcessor;
import com.fxcm.messaging.util.fix.request.OrderStatusRequestProcessor;
import com.fxcm.messaging.util.fix.request.PassThruReqProcessor;
import com.fxcm.messaging.util.fix.request.QuoteRequestProcessor;
import com.fxcm.messaging.util.fix.request.QuoteResponseProcessor;
import com.fxcm.messaging.util.fix.request.RequestForPositionsProcessor;
import com.fxcm.messaging.util.fix.request.SecurityListProcessor;
import com.fxcm.messaging.util.fix.request.SecurityStatusProcessor;
import com.fxcm.messaging.util.fix.request.TradingSessionStatusProcessor;
import com.fxcm.messaging.util.fix.request.UserRequestProcessor;
import com.fxcm.messaging.util.fix.response.DasMsgProcessor;
import com.fxcm.messaging.util.fix.response.MarketDataIncrementalProcessor;
import com.fxcm.messaging.util.fix.response.MarketDataSnapshotProcessor;
import com.fxcm.messaging.util.fix.response.PassThruRespProcessor;
import com.fxcm.messaging.util.fix.response.RejectProcessor;
import com.fxcm.messaging.util.fix.response.ResponseProcessor;
import com.fxcm.util.logging.Utils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;

public class RequestResponseController {
    public static final Status SUCCESS = new Status(0, "Success");
    public static final Status FAILURE = new Status(1, "Failure");
    public static final Status UNKNOWN = new Status(2, "Unknown");
    public static final Status ILLEGAL = new Status(3, "Illegal");
    private final Log mLogger = Utils.getLog(RequestResponseController.class);
    private final Map<String, IProcessor> mRequestProcessors;
    private final Map<String, IProcessor> mResponseProcessors = new HashMap<String, IProcessor>();

    public RequestResponseController(ISessionStrategy aStrategy) {
        this.addResponseProcessor("U60", new DasMsgProcessor(aStrategy));
        this.addResponseProcessor("U55", new ResponseProcessor(aStrategy));
        this.addResponseProcessor("U52", new RejectProcessor(aStrategy));
        this.addResponseProcessor("W", new MarketDataSnapshotProcessor(aStrategy));
        this.addResponseProcessor("X", new MarketDataIncrementalProcessor(aStrategy));
        this.addResponseProcessor("Y", new PassThruRespProcessor(aStrategy));
        this.mRequestProcessors = new HashMap<String, IProcessor>();
        PassThruReqProcessor passThru = new PassThruReqProcessor(aStrategy);
        this.addRequestProcessor("1", passThru);
        this.addRequestProcessor("U54", passThru);
        this.addRequestProcessor("0", passThru);
        this.addRequestProcessor("U50", passThru);
        this.addRequestProcessor("U51", passThru);
        this.addRequestProcessor("U54.Batch.Req", passThru);
        this.addRequestProcessor("BE", new UserRequestProcessor(aStrategy));
        this.addRequestProcessor("BB", new CollateralInquiryProcessor(aStrategy));
        this.addRequestProcessor("AN", new RequestForPositionsProcessor(aStrategy));
        this.addRequestProcessor("g", new TradingSessionStatusProcessor(aStrategy));
        this.addRequestProcessor("V", new MarketDataRequestProcessor(aStrategy));
        this.addRequestProcessor("R", new QuoteRequestProcessor(aStrategy));
        this.addRequestProcessor("e", new SecurityStatusProcessor(aStrategy));
        this.addRequestProcessor("x", new SecurityListProcessor(aStrategy));
        this.addRequestProcessor("AF", new OrderMassStatusRequestProcessor(aStrategy));
        this.addRequestProcessor("F", new OrderCancelRequestProcessor(aStrategy));
        this.addRequestProcessor("G", new OrderCancelReplaceRequestProcessor(aStrategy));
        this.addRequestProcessor("D", new OrderSingleProcessor(aStrategy));
        this.addRequestProcessor("E", new OrderListProcessor(aStrategy));
        this.addRequestProcessor("AJ", new QuoteResponseProcessor(aStrategy));
        this.addRequestProcessor("H", new OrderStatusRequestProcessor(aStrategy));
    }

    public void addRequestProcessor(String aMsgType, IProcessor aProcessor) {
        this.mRequestProcessors.put(aMsgType, aProcessor);
    }

    public void addResponseProcessor(String aMsgType, IProcessor aProcessor) {
        this.mResponseProcessors.put(aMsgType, aProcessor);
    }

    public Status processRequest(IMessage aMessage) {
        ITransportable transportable;
        Status processed = UNKNOWN;
        IProcessor processor = this.mRequestProcessors.get(aMessage.getMsgType());
        if (processor != null && (transportable = FixObjectFactory.toObject(aMessage)) != null) {
            try {
                processor.process(transportable);
                processed = SUCCESS;
            }
            catch (IllegalRequestException e) {
                processed = ILLEGAL;
            }
            catch (Exception e) {
                this.mLogger.error(e.getMessage(), e);
                processed = FAILURE;
            }
        }
        return processed;
    }

    public Status processResponse(IMessage aMessage) {
        ITransportable transportable;
        Status processed = UNKNOWN;
        IProcessor processor = this.mResponseProcessors.get(aMessage.getMsgType());
        if (processor != null && (transportable = FixObjectFactory.toObject(aMessage)) != null) {
            try {
                processor.process(transportable);
                processed = SUCCESS;
            }
            catch (Exception e) {
                this.mLogger.error(e.getMessage(), e);
                processed = FAILURE;
            }
        }
        return processed;
    }

    public Status processResponse(ITransportable aObject) {
        IProcessor processor;
        Status processed = UNKNOWN;
        if (aObject != null && (processor = this.mResponseProcessors.get(aObject.getType().getCode())) != null) {
            try {
                processor.process(aObject);
                processed = SUCCESS;
            }
            catch (Exception e) {
                this.mLogger.error(e.getMessage(), e);
                processed = FAILURE;
            }
        }
        return processed;
    }

    public void removeRequestProcessor(String aMsgType) {
        this.mRequestProcessors.remove(aMsgType);
    }

    public void removeResponseProcessor(String aMsgType) {
        this.mResponseProcessors.remove(aMsgType);
    }

    public static final class Status
    extends ACode {
        Status(int aCode, String aLabel) {
            super(String.valueOf(aCode), aLabel, aLabel);
        }

        @Override
        public boolean equals(Object aObj) {
            return this == aObj;
        }

        @Override
        public String toString() {
            return "RequestResponseController:" + this.getLabel() + " (" + this.getCode() + ")";
        }
    }
}

