/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.fix;

import com.fxcm.GenericException;
import com.fxcm.fix.ContingencyTypeFactory;
import com.fxcm.fix.ExecTypeFactory;
import com.fxcm.fix.FXCMOrdStatusFactory;
import com.fxcm.fix.FXCMOrdTypeFactory;
import com.fxcm.fix.IExecType;
import com.fxcm.fix.IFXCMOrdStatus;
import com.fxcm.fix.IFXCMOrdType;
import com.fxcm.fix.IOrdStatus;
import com.fxcm.fix.IOrdType;
import com.fxcm.fix.ISide;
import com.fxcm.fix.ITimeInForce;
import com.fxcm.fix.NotDefinedException;
import com.fxcm.fix.OrdStatusFactory;
import com.fxcm.fix.OrdTypeFactory;
import com.fxcm.fix.Parameter;
import com.fxcm.fix.Parties;
import com.fxcm.fix.PegInstruction;
import com.fxcm.fix.PosReqTypeFactory;
import com.fxcm.fix.PositionQty;
import com.fxcm.fix.PriceStream;
import com.fxcm.fix.QuoteTypeFactory;
import com.fxcm.fix.SideFactory;
import com.fxcm.fix.TimeInForceFactory;
import com.fxcm.fix.TradingSecurity;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.fix.posttrade.ClosedPositionReport;
import com.fxcm.fix.posttrade.CollateralReport;
import com.fxcm.fix.posttrade.PositionReport;
import com.fxcm.fix.pretrade.EMail;
import com.fxcm.fix.pretrade.Quote;
import com.fxcm.fix.pretrade.inner.MarketDataSnapshot;
import com.fxcm.messaging.util.fix.ExecutionReportEx;
import com.fxcm.messaging.util.fix.TradingSecurityAdj;
import com.fxcm.messaging.util.fix.TradingSessionStatusAdj;
import com.fxcm.util.DateTimeFormatterMs;
import com.fxcm.util.Util;
import com.fxcm.util.logging.Utils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;

public class FixFXMsgParser {
    private static final Pattern COMPILE = Pattern.compile("[^\\p{ASCII}]");
    private final Log mLogger = Utils.getLog(FixFXMsgParser.class);
    private static final Map cOrdTypes = new HashMap();
    private static final Map cOrdStatuses = new HashMap();
    protected static final ThreadLocal<Calendar> cServerCalendar;
    protected TradingSessionStatusAdj mTradingSessionStatus;
    protected String mNonChangedTag = "!=";
    protected boolean mUseOriginRate = true;

    public static IOrdType toOrdType(IFXCMOrdType aType) {
        return (IOrdType)cOrdTypes.get(aType);
    }

    public void init(TradingSessionStatusAdj aTradingSessionStatus) {
        this.mTradingSessionStatus = aTradingSessionStatus;
        String nonChangedValue = this.mTradingSessionStatus.getParameterValue("NON_CHANGED_VALUE");
        if (nonChangedValue != null && nonChangedValue.length() > 0) {
            this.mNonChangedTag = nonChangedValue;
        }
    }

    public int absoluteToLots(double aAbsolute, int aOfferId) throws GenericException {
        TradingSecurityAdj ts = this.mTradingSessionStatus.getTradingSecurityAdj(aOfferId);
        if (ts == null) {
            throw new GenericException("Incorrect security: " + aOfferId);
        }
        long contractSize = (long)ts.getRoundLot();
        if ((long)aAbsolute % contractSize != 0L) {
            throw new GenericException("Incorrect Amount: " + aAbsolute);
        }
        int lots = (int)((long)aAbsolute / contractSize);
        return lots;
    }

    public int getOfferId(String aCcy) {
        int offerId = 0;
        TradingSecurity ts = this.mTradingSessionStatus.getSecurity(aCcy);
        if (ts != null) {
            offerId = ts.getFXCMSymID();
        }
        return offerId;
    }

    public double lotsToAbsolute(int aLots, int aOfferID) {
        long contractSize = 1L;
        TradingSecurityAdj ts = this.mTradingSessionStatus.getTradingSecurityAdj(aOfferID);
        if (ts != null) {
            try {
                contractSize = (long)ts.getRoundLot();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (long)aLots * contractSize;
    }

    protected String toStringSafe(String[] aTokens, int aIndex) {
        String ret = null;
        if (aTokens.length > aIndex && aTokens[aIndex] != null && aTokens[aIndex].length() > 0 && this.mNonChangedTag.equals(ret = aTokens[aIndex])) {
            ret = null;
        }
        return ret;
    }

    protected long toLongSafe(String[] aTokens, int aIndex) {
        long ret = 0L;
        String s = this.toStringSafe(aTokens, aIndex);
        if (s != null) {
            try {
                ret = Math.abs(Long.parseLong(s));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    protected int toIntSafe(String[] aTokens, int aIndex) {
        int ret = 0;
        String s = this.toStringSafe(aTokens, aIndex);
        if (s != null) {
            try {
                ret = Math.abs(Integer.parseInt(s));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    protected double toDoubleSafe(String[] aTokens, int aIndex) {
        double ret = 0.0;
        String s = this.toStringSafe(aTokens, aIndex);
        if (s != null) {
            try {
                ret = Double.parseDouble(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    protected TradingSecurityAdj toSecuritySafe(String[] aTokens, int aIndex) {
        int offerId = this.toIntSafe(aTokens, aIndex);
        TradingSecurityAdj ret = null;
        if (offerId != 0) {
            ret = this.mTradingSessionStatus.getTradingSecurityAdj(offerId);
        }
        return ret;
    }

    protected Calendar getServerCalendar() {
        Calendar ret = cServerCalendar.get();
        if (ret == null) {
            ret = this.mTradingSessionStatus.getServerCalendar();
            cServerCalendar.set(ret);
        }
        return ret;
    }

    protected UTCTimestamp toTimeSafe(String[] aTokens, int aIndex) {
        UTCTimestamp ret = null;
        String s = this.toStringSafe(aTokens, aIndex);
        if (s != null) {
            try {
                ret = new UTCTimestamp(DateTimeFormatterMs.parseDasDateInMillis(s, this.getServerCalendar(), false));
            }
            catch (Exception e) {
                this.mLogger.error("problem parsing time: " + s, e);
            }
        }
        return ret;
    }

    protected ISide toSideSafe(String[] aTokens, int aIndex) {
        ISide ret = SideFactory.UNDISCLOSED;
        String s = this.toStringSafe(aTokens, aIndex);
        if ("B".equals(s)) {
            ret = SideFactory.BUY;
        } else if ("S".equals(s)) {
            ret = SideFactory.SELL;
        }
        return ret;
    }

    protected PositionQty toPositionQtySafe(String[] aTokens, int aSideIndex, int aQtyIndex, TradingSecurity aSecurity) {
        PositionQty ret = null;
        ISide side = this.toSideSafe(aTokens, aSideIndex);
        long qty = this.toLongSafe(aTokens, aQtyIndex);
        try {
            ret = new PositionQty(side, (double)qty * aSecurity.getRoundLot());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private double toQtySafe(String[] aTokens, int aIndex, TradingSecurity aSecurity) {
        double ret = 0.0;
        long qty = Math.abs(this.toLongSafe(aTokens, aIndex));
        try {
            ret = (double)qty * aSecurity.getRoundLot();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    protected IFXCMOrdType toFXCMOrdType(String aOrderType) {
        IFXCMOrdType ret = null;
        if (aOrderType != null && aOrderType.length() > 0) {
            ret = FXCMOrdTypeFactory.toCode(aOrderType);
        }
        if (ret == null) {
            ret = FXCMOrdTypeFactory.OPEN;
        }
        return ret;
    }

    protected IFXCMOrdStatus toFXCMOrdStatus(String aOrderStatus) {
        IFXCMOrdStatus ret = null;
        if (aOrderStatus != null && aOrderStatus.length() > 0) {
            ret = FXCMOrdStatusFactory.toCode(aOrderStatus);
        }
        if (ret == null) {
            ret = FXCMOrdStatusFactory.WAITING;
        }
        return ret;
    }

    protected String toExecText(IFXCMOrdType aType, IFXCMOrdStatus aStatus) {
        String ret = null;
        if (aType == FXCMOrdTypeFactory.MARGIN_CALL) {
            ret = "Margin Call";
        } else if (aType == FXCMOrdTypeFactory.EQUITY_STOP) {
            ret = "Equity Stop";
        } else if (aStatus.isDeleted()) {
            ret = aStatus.getDesc();
        }
        return ret;
    }

    protected ITimeInForce toTimeInForce(IFXCMOrdType aType) {
        ITimeInForce ret = aType == FXCMOrdTypeFactory.ENTRY_LIMIT || aType == FXCMOrdTypeFactory.ENTRY_STOP || aType == FXCMOrdTypeFactory.LIMIT || aType == FXCMOrdTypeFactory.STOP || aType == FXCMOrdTypeFactory.OPEN_MARKET || aType == FXCMOrdTypeFactory.CLOSE_MARKET || aType == FXCMOrdTypeFactory.TRAILING_STOP ? TimeInForceFactory.GOOD_TILL_CANCEL : TimeInForceFactory.IMMEDIATE_OR_CANCEL;
        return ret;
    }

    public CollateralReport parseAccount(String aMsg, String aTradingSessionID, String aTradingSessionSubID) {
        return this.parseAccount(aMsg, 0, aTradingSessionID, aTradingSessionSubID);
    }

    private CollateralReport parseAccount(String aMsg, int aOffset, String aTradingSessionID, String aTradingSessionSubID) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("parsing account message = " + aMsg);
        }
        String[] tokens = Util.splitToArray(aMsg, ";");
        CollateralReport cr = null;
        if (tokens.length > 1) {
            cr = new CollateralReport();
            cr.getParties().setFXCMAcctID(this.toLongSafe(tokens, 2 + aOffset));
            cr.setCollRptID(this.toStringSafe(tokens, 3 + aOffset));
            cr.setCashOutstanding(this.toDoubleSafe(tokens, 6 + aOffset));
            cr.setFXCMUsedMargin(this.toDoubleSafe(tokens, 7 + aOffset));
            cr.setFXCMMarginCall(this.toStringSafe(tokens, 8 + aOffset));
            cr.setAccount(this.toStringSafe(tokens, 9 + aOffset));
            cr.getParties().setFXCMTraderLoginId(this.toStringSafe(tokens, 10 + aOffset));
            cr.getParties().setFXCMAcctName(this.toStringSafe(tokens, 11 + aOffset));
            cr.getParties().setFXCMAcctType(this.toIntSafe(tokens, 15 + aOffset));
            cr.setFXCMUsedMargin3(this.toDoubleSafe(tokens, 17 + aOffset));
            cr.setStartCash(this.toDoubleSafe(tokens, 18 + aOffset));
            cr.setFXCMCashDaily(this.toDoubleSafe(tokens, 19 + aOffset));
            cr.getParties().setFXCMPositionMaintenance(this.toStringSafe(tokens, 36 + aOffset));
            cr.setMarginRatio(this.toDoubleSafe(tokens, 38 + aOffset));
            cr.setQuantity(this.toDoubleSafe(tokens, 41 + aOffset));
            cr.setTradingSessionID(aTradingSessionID);
            cr.setTradingSessionSubID(aTradingSessionSubID);
            cr.setEndCash(this.toDoubleSafe(tokens, 48 + aOffset));
        }
        return cr;
    }

    public ClosedPositionReport[] parseClosedTrades(String aMsg, String aTradingSessionID, String aTradingSessionSubID, int aUserKind) {
        String[] lines;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("parsing closed positions batch message = " + aMsg);
        }
        ArrayList<ClosedPositionReport> positionList = new ArrayList<ClosedPositionReport>();
        for (String line : lines = Util.splitToArray(aMsg, "\n")) {
            ClosedPositionReport cpt = this.parseClosedTrade(line, -2, aTradingSessionID, aTradingSessionSubID, aUserKind);
            if (cpt == null) continue;
            positionList.add(cpt);
        }
        return positionList.toArray(new ClosedPositionReport[positionList.size()]);
    }

    public ClosedPositionReport parseClosedTrade(String aMsg, String aTradingSessionID, String aTradingSessionSubID, int aUserKind) {
        return this.parseClosedTrade(aMsg, 0, aTradingSessionID, aTradingSessionSubID, aUserKind);
    }

    public ClosedPositionReport parseClosedTrade(String aMsg, int aOffset, String aTradingSessionID, String aTradingSessionSubID, int aUserKind) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("parsing closed trade message = " + aMsg);
        }
        ClosedPositionReport cp = null;
        String[] tokens = Util.splitToArray(aMsg, ";");
        if (tokens.length > 1) {
            cp = new ClosedPositionReport();
            if (aOffset == 0) {
                cp.setText(tokens[1]);
            }
            cp.setPosReqType(PosReqTypeFactory.TRADES);
            cp.setFXCMPosID(this.toStringSafe(tokens, 2 + aOffset));
            cp.setPosMaintRptID(this.toStringSafe(tokens, 3 + aOffset));
            cp.getParties().setFXCMAcctID(this.toLongSafe(tokens, 6 + aOffset));
            cp.setAccount(this.toStringSafe(tokens, 7 + aOffset));
            TradingSecurityAdj ts = this.toSecuritySafe(tokens, 8 + aOffset);
            cp.setInstrument(ts);
            cp.setFXCMPosInterest(this.toDoubleSafe(tokens, 9 + aOffset));
            cp.setFXCMPosCommission(this.toDoubleSafe(tokens, 10 + aOffset));
            cp.setFXCMPosClosePNL(this.toDoubleSafe(tokens, 11 + aOffset));
            cp.setFXCMPosOpenTime(this.toTimeSafe(tokens, 12 + aOffset));
            cp.setFXCMPosCloseTime(this.toTimeSafe(tokens, 13 + aOffset));
            cp.setTransactTime(this.toTimeSafe(tokens, 13 + aOffset));
            cp.setSettlPrice(this.toDoubleSafe(tokens, 14 + aOffset));
            cp.setFXCMCloseSettlPrice(this.toDoubleSafe(tokens, 16 + aOffset));
            cp.setPositionQty(this.toPositionQtySafe(tokens, 18 + aOffset, 19 + aOffset, ts));
            cp.getParties().setFXCMTraderLoginId(this.toStringSafe(tokens, 20 + aOffset));
            cp.getParties().setFXCMAcctName(this.toStringSafe(tokens, 21 + aOffset));
            if (aUserKind == 24 && this.mUseOriginRate) {
                cp.setSettlPrice(this.toDoubleSafe(tokens, 23 + aOffset));
            }
            if (aUserKind == 24 && this.mUseOriginRate) {
                cp.setFXCMCloseSettlPrice(this.toDoubleSafe(tokens, 24 + aOffset));
            }
            cp.getParties().setFXCMAcctType(this.toIntSafe(tokens, 26 + aOffset));
            cp.setOrderID(this.toStringSafe(tokens, 27 + aOffset));
            cp.setClOrdID(this.toStringSafe(tokens, 28 + aOffset));
            cp.setSecondaryClOrdID(this.toStringSafe(tokens, 29 + aOffset));
            cp.setFXCMCloseOrderID(this.toStringSafe(tokens, 30 + aOffset));
            cp.setFXCMCloseClOrdID(this.toStringSafe(tokens, 31 + aOffset));
            cp.setFXCMCloseSecondaryClOrdID(this.toStringSafe(tokens, 32 + aOffset));
            cp.setTradingSessionID(aTradingSessionID);
            cp.setTradingSessionSubID(aTradingSessionSubID);
            cp.setFXCMUsedMargin(0.0);
            try {
                cp.setCurrency(ts.getCurrency());
            }
            catch (Exception exception) {
                // empty catch block
            }
            cp.setListID(this.toStringSafe(tokens, 33 + aOffset));
            cp.setFXCMPosIDRef(this.toStringSafe(tokens, 34 + aOffset));
        }
        return cp;
    }

    public CollateralReport[] parseInitialAccountRetrieval(String aMsg, String aTradingSessionID, String aTradingSessionSubID) {
        String[] lines;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("parsing account batch message = " + aMsg);
        }
        ArrayList<CollateralReport> accountList = new ArrayList<CollateralReport>();
        for (String line : lines = Util.splitToArray(aMsg, "\n")) {
            CollateralReport cr = this.parseAccount(line, -2, aTradingSessionID, aTradingSessionSubID);
            if (cr == null) continue;
            accountList.add(cr);
        }
        return accountList.toArray(new CollateralReport[accountList.size()]);
    }

    public TradingSecurityAdj parseInstrument(String aMsg, int aOffset) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("parsing instrument message = " + aMsg);
        }
        TradingSecurityAdj instAdj = null;
        String[] tokens = Util.splitToArray(aMsg, ";");
        if (tokens.length > 1) {
            instAdj = new TradingSecurityAdj();
            instAdj.setFXCMSymID(this.toIntSafe(tokens, 2 + aOffset));
            TradingSecurityAdj old = this.mTradingSessionStatus.getTradingSecurityAdj(instAdj.getFXCMSymID());
            if (old != null) {
                instAdj.fill(old);
            }
            if (this.toStringSafe(tokens, 6 + aOffset) != null) {
                instAdj.setFXCMSymInterestBuy(this.toDoubleSafe(tokens, 6 + aOffset));
            }
            if (this.toStringSafe(tokens, 7 + aOffset) != null) {
                instAdj.setFXCMSymInterestSell(this.toDoubleSafe(tokens, 7 + aOffset));
            }
            if (this.toStringSafe(tokens, 11 + aOffset) != null) {
                instAdj.setSymbol(this.toStringSafe(tokens, 11 + aOffset));
            }
            if (this.toStringSafe(tokens, 12 + aOffset) != null) {
                instAdj.setCurrency(this.toStringSafe(tokens, 12 + aOffset));
            }
            if (this.toStringSafe(tokens, 13 + aOffset) != null) {
                instAdj.setRoundLot(this.toDoubleSafe(tokens, 13 + aOffset));
            }
            if (this.toStringSafe(tokens, 14 + aOffset) != null) {
                instAdj.setFXCMSymPrecision(this.toIntSafe(tokens, 14 + aOffset));
            }
            if (this.toStringSafe(tokens, 15 + aOffset) != null) {
                instAdj.setFXCMSymPointSize(this.toDoubleSafe(tokens, 15 + aOffset));
            }
            if (this.toStringSafe(tokens, 16 + aOffset) != null) {
                instAdj.setFXCMSymSortOrder(this.toIntSafe(tokens, 16 + aOffset));
            }
            if (this.toStringSafe(tokens, 17 + aOffset) != null) {
                instAdj.setBidAdjustment(this.toDoubleSafe(tokens, 17 + aOffset));
            }
            if (this.toStringSafe(tokens, 18 + aOffset) != null) {
                instAdj.setAskAdjustment(this.toDoubleSafe(tokens, 18 + aOffset));
            }
            if (this.toStringSafe(tokens, 20 + aOffset) != null) {
                instAdj.setFXCMSubscriptionStatus(this.toStringSafe(tokens, 20 + aOffset));
            }
            if (this.toStringSafe(tokens, 23 + aOffset) != null) {
                int fxcmProductID = this.toIntSafe(tokens, 23 + aOffset);
                instAdj.setFXCMProductID(fxcmProductID);
                if (fxcmProductID == 1) {
                    instAdj.setProduct(4);
                } else if (fxcmProductID == 2) {
                    instAdj.setProduct(7);
                } else if (fxcmProductID == 3) {
                    instAdj.setProduct(2);
                } else if (fxcmProductID == 4) {
                    instAdj.setProduct(6);
                } else if (fxcmProductID == 5) {
                    instAdj.setProduct(2);
                } else if (fxcmProductID == 6) {
                    instAdj.setProduct(2);
                } else if (fxcmProductID == 7) {
                    instAdj.setProduct(12);
                } else {
                    instAdj.setProduct(12);
                }
            }
            instAdj.setPriceStream(new PriceStream(this.toIntSafe(tokens, 24 + aOffset), this.toStringSafe(tokens, 25 + aOffset)));
            if (this.toStringSafe(tokens, 27 + aOffset) != null) {
                instAdj.setContractMultiplier(this.toDoubleSafe(tokens, 27 + aOffset));
            }
            if (this.toStringSafe(tokens, 29 + aOffset) != null) {
                instAdj.setFXCMCondDistStop(this.toDoubleSafe(tokens, 29 + aOffset));
            }
            if (this.toStringSafe(tokens, 30 + aOffset) != null) {
                instAdj.setFXCMCondDistLimit(this.toDoubleSafe(tokens, 30 + aOffset));
            }
            if (this.toStringSafe(tokens, 31 + aOffset) != null) {
                instAdj.setFXCMCondDistEntryStop(this.toDoubleSafe(tokens, 31 + aOffset));
            }
            if (this.toStringSafe(tokens, 32 + aOffset) != null) {
                instAdj.setFXCMCondDistEntryLimit(this.toDoubleSafe(tokens, 32 + aOffset));
            }
            if (this.toStringSafe(tokens, 33 + aOffset) != null) {
                instAdj.setFXCMMaxQuantity(this.toDoubleSafe(tokens, 33 + aOffset));
            }
            if (this.toStringSafe(tokens, 34 + aOffset) != null) {
                instAdj.setFXCMMinQuantity(this.toDoubleSafe(tokens, 34 + aOffset));
            }
            if (this.toStringSafe(tokens, 35 + aOffset) != null) {
                instAdj.setFXCMTradingStatus(this.toStringSafe(tokens, 35 + aOffset));
            }
            if (this.toStringSafe(tokens, 38 + aOffset) != null) {
                instAdj.setFactor(this.toIntSafe(tokens, 38 + aOffset));
            }
        }
        return instAdj;
    }

    public EMail parseMail(String aMsg, String aTradingSessionID, String aTradingSessionSubID) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("parsing mail message = " + aMsg);
        }
        EMail mail = new EMail();
        String[] tokens = Util.splitToArray(aMsg, ";");
        String text = this.toStringSafe(tokens, 9);
        if (text != null && text.startsWith("<BASE64-DATA>")) {
            return null;
        }
        mail.setOrigTime(this.toTimeSafe(tokens, 5));
        mail.setFrom(this.toStringSafe(tokens, 6));
        mail.setText(this.cleanText(text));
        mail.setSubject(this.toStringSafe(tokens, 10));
        mail.setEmailThreadID(this.toStringSafe(tokens, 11));
        mail.setTradingSessionID(aTradingSessionID);
        mail.setTradingSessionSubID(aTradingSessionSubID);
        return mail;
    }

    private String cleanText(String aStr) {
        if (aStr == null) {
            return null;
        }
        StringBuilder text = new StringBuilder(aStr);
        try {
            int i = text.indexOf("0x");
            while (i != -1) {
                text.replace(i, i + 4, "");
                i = text.indexOf("0x");
            }
            return COMPILE.matcher(text.toString()).replaceAll("");
        }
        catch (Exception e) {
            this.mLogger.error("failed parsing: " + e.getMessage(), e);
            return "empty";
        }
    }

    public Quote parseRFQ(String aMsg, String aTradingSessionID, String aTradingSessionSubID) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("parsing rfq message = " + aMsg);
        }
        Quote quote = null;
        String[] tokens = Util.splitToArray(aMsg, ";");
        if (tokens.length > 1) {
            String oper = tokens[1];
            quote = new Quote();
            if ("D".equals(oper)) {
                return null;
            }
            quote.setQuoteType(QuoteTypeFactory.INDICATIVE);
            quote.setQuoteRespID(this.toStringSafe(tokens, 2));
            quote.setQuoteReqID(this.toStringSafe(tokens, 4));
            Parties parties = new Parties();
            quote.setParties(parties);
            quote.getParties().setFXCMAcctID(this.toLongSafe(tokens, 6));
            quote.setAccount(this.toStringSafe(tokens, 7));
            TradingSecurityAdj ts = this.toSecuritySafe(tokens, 8);
            quote.setInstrument(ts);
            try {
                quote.setCurrency(ts.getCurrency());
            }
            catch (NotDefinedException e) {
                this.mLogger.error(e.getMessage(), e);
            }
            quote.setOrderQty(this.toDoubleSafe(tokens, 9));
            long time = System.currentTimeMillis();
            int lifetime = this.toIntSafe(tokens, 12);
            if (lifetime > 0) {
                time += (long)(lifetime * 1000);
            }
            quote.setValidUntilTime(new UTCTimestamp(time));
            quote.setOfferPx(this.toDoubleSafe(tokens, 13));
            quote.setBidPx(this.toDoubleSafe(tokens, 14));
            quote.setQuoteID(this.toStringSafe(tokens, 15));
            quote.getParties().setFXCMTraderLoginId(this.toStringSafe(tokens, 16));
            quote.getParties().setFXCMAcctName(this.toStringSafe(tokens, 17));
            quote.setTransactTime(new UTCTimestamp());
            quote.setTradingSessionID(aTradingSessionID);
            quote.setTradingSessionSubID(aTradingSessionSubID);
        }
        return quote;
    }

    public com.fxcm.fix.pretrade.MarketDataSnapshot[] parseOffers(String aMsg, String aTradingSessionID, String aTradingSessionSubID, int aUserKind) {
        String[] lines;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("parsing offers message = " + aMsg);
        }
        ArrayList<com.fxcm.fix.pretrade.MarketDataSnapshot> offers = new ArrayList<com.fxcm.fix.pretrade.MarketDataSnapshot>();
        for (String line : lines = Util.splitToArray(aMsg, "\n")) {
            com.fxcm.fix.pretrade.MarketDataSnapshot mds = this.parseOffer(line, aTradingSessionID, aTradingSessionSubID, aUserKind, -2);
            if (mds == null) continue;
            offers.add(mds);
        }
        return offers.toArray(new com.fxcm.fix.pretrade.MarketDataSnapshot[offers.size()]);
    }

    public com.fxcm.fix.pretrade.MarketDataSnapshot parseOffer(String aMsg, String aTradingSessionID, String aTradingSessionSubID, int aUserKind) {
        return this.parseOffer(aMsg, aTradingSessionID, aTradingSessionSubID, aUserKind, 0);
    }

    public com.fxcm.fix.pretrade.MarketDataSnapshot parseOffer(String aMsg, String aTradingSessionID, String aTradingSessionSubID, int aUserKind, int aOffset) {
        MarketDataSnapshot mds = null;
        String[] tokens = Util.splitToArray(aMsg, ";");
        if (tokens.length > 1) {
            String asktrdbl;
            String bidtrdbl;
            String askvaluedt;
            mds = new MarketDataSnapshot();
            if (this.mTradingSessionStatus == null) {
                return null;
            }
            TradingSecurityAdj ts = this.toSecuritySafe(tokens, 2 + aOffset);
            if (ts == null) {
                return null;
            }
            mds.setInstrument(ts);
            mds.setQuoteID(this.toStringSafe(tokens, 3 + aOffset));
            mds.setOriginator(this.toStringSafe(tokens, 11 + aOffset));
            mds.setOpenTimestamp(this.toTimeSafe(tokens, 6 + aOffset));
            ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setBidClose(this.toDoubleSafe(tokens, 7 + aOffset));
            ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setAskClose(this.toDoubleSafe(tokens, 8 + aOffset));
            ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setBidId(this.toStringSafe(tokens, 9 + aOffset));
            ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setAskId(this.toStringSafe(tokens, 10 + aOffset));
            ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setBidOriginator(this.toStringSafe(tokens, 11 + aOffset));
            ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setAskOriginator(this.toStringSafe(tokens, 12 + aOffset));
            String bidvaluedt = this.toStringSafe(tokens, 13 + aOffset);
            if (bidvaluedt != null) {
                ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setBidExpireTimestamp(new UTCTimestamp(bidvaluedt));
            }
            if ((askvaluedt = this.toStringSafe(tokens, 14 + aOffset)) != null) {
                ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setAskExpireTimestamp(new UTCTimestamp(askvaluedt));
            }
            if ((bidtrdbl = this.toStringSafe(tokens, 15 + aOffset)) != null) {
                switch ("ITN".indexOf(bidtrdbl)) {
                    case 0: {
                        ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setBidQuoteCondition("A");
                        ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setBidQuoteType(0);
                        break;
                    }
                    case 1: {
                        ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setBidQuoteCondition("A");
                        ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setBidQuoteType(1);
                        break;
                    }
                    case 2: {
                        ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setBidQuoteCondition("B");
                        ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setBidQuoteType(0);
                        break;
                    }
                }
            }
            if ((asktrdbl = this.toStringSafe(tokens, 16 + aOffset)) != null) {
                switch ("ITN".indexOf(asktrdbl)) {
                    case 0: {
                        ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setAskQuoteCondition("A");
                        ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setAskQuoteType(0);
                        break;
                    }
                    case 1: {
                        ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setAskQuoteCondition("A");
                        ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setAskQuoteType(1);
                        break;
                    }
                    case 2: {
                        ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setAskQuoteCondition("B");
                        ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setAskQuoteType(0);
                        break;
                    }
                }
            }
            ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setHigh(this.toDoubleSafe(tokens, 17 + aOffset));
            ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setLow(this.toDoubleSafe(tokens, 18 + aOffset));
            if (aUserKind != 24) {
                if (ts.getBidAdjustment() != 0.0) {
                    ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setBidClose(mds.getBidClose() + ts.getBidAdjustment());
                    if (mds.getLow() != 0.0) {
                        ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setLow(mds.getLow() + ts.getBidAdjustment());
                    }
                }
                if (ts.getAskAdjustment() != 0.0) {
                    ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setAskClose(mds.getAskClose() + ts.getAskAdjustment());
                    if (mds.getHigh() != 0.0) {
                        ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setHigh(mds.getHigh() + ts.getAskAdjustment());
                    }
                }
            }
            mds.setTradingSessionID(aTradingSessionID);
            mds.setTradingSessionSubID(aTradingSessionSubID);
            mds.setPriceStream(this.toStringSafe(tokens, 22 + aOffset));
            mds.setTradeable("A".equals(((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).getAskQuoteCondition()) && ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).getAskQuoteType() == 1 && "A".equals(((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).getBidQuoteCondition()) && ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).getBidQuoteType() == 1);
        }
        return mds;
    }

    public PositionReport[] parseOpenTrades(String aMsg, String aTradingSessionID, String aTradingSessionSubID, int aUserKind) {
        String[] lines;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("parsing open positions batch message = " + aMsg);
        }
        ArrayList<PositionReport> positionList = new ArrayList<PositionReport>();
        for (String line : lines = Util.splitToArray(aMsg, "\n")) {
            PositionReport pr = this.parseTrade(line, -2, aTradingSessionID, aTradingSessionSubID, aUserKind);
            if (pr == null) continue;
            positionList.add(pr);
        }
        return positionList.toArray(new PositionReport[positionList.size()]);
    }

    public ExecutionReportEx parseOrder(String aMsg, String aTradingSessionID, String aTradingSessionSubID, int aUserKind) {
        return this.parseOrder(aMsg, 0, aTradingSessionID, aTradingSessionSubID, aUserKind);
    }

    private ExecutionReportEx parseOrder(String aMsg, int aOffset, String aTradingSessionID, String aTradingSessionSubID, int aUserKind) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("parsing order message = " + aMsg);
        }
        String[] tokens = Util.splitToArray(aMsg, ";");
        ExecutionReportEx exe = null;
        if (tokens.length > 1) {
            double execOriginRate;
            boolean executing;
            boolean partialFill;
            PegInstruction pegInstructions;
            String status = this.toStringSafe(tokens, 35 + aOffset);
            if ("G".equals(status)) {
                return null;
            }
            exe = new ExecutionReportEx();
            exe.setOrderID(this.toStringSafe(tokens, 2 + aOffset));
            exe.setExecID(this.toStringSafe(tokens, 3 + aOffset));
            exe.setClOrdID(this.toStringSafe(tokens, 4 + aOffset));
            exe.setSecondaryClOrdID(this.toStringSafe(tokens, 5 + aOffset));
            exe.setTransactTime(this.toTimeSafe(tokens, 6 + aOffset));
            exe.setLifeTime(this.toStringSafe(tokens, 8 + aOffset));
            double rate = this.toDoubleSafe(tokens, 9 + aOffset);
            exe.setPrice(rate);
            exe.setLastPx(rate);
            exe.setFXCMPosID(this.toStringSafe(tokens, 11 + aOffset));
            exe.getParties().setFXCMAcctID(this.toLongSafe(tokens, 12 + aOffset));
            exe.setAccount(this.toStringSafe(tokens, 13 + aOffset));
            TradingSecurityAdj ts = this.toSecuritySafe(tokens, 14 + aOffset);
            exe.setInstrument(ts);
            exe.setSide(this.toSideSafe(tokens, 15 + aOffset));
            double qty = this.toQtySafe(tokens, 16 + aOffset, ts);
            exe.getParties().setFXCMTraderLoginId(this.toStringSafe(tokens, 19 + aOffset));
            exe.getParties().setFXCMAcctName(this.toStringSafe(tokens, 20 + aOffset));
            double originRate = this.toDoubleSafe(tokens, 21 + aOffset);
            if (aUserKind == 24 && this.mUseOriginRate) {
                exe.setPrice(originRate);
                exe.setLastPx(originRate);
            }
            exe.getParties().setFXCMAcctType(this.toIntSafe(tokens, 28 + aOffset));
            IFXCMOrdType fxcmType = this.toFXCMOrdType(this.toStringSafe(tokens, 34 + aOffset));
            int tstep = this.toIntSafe(tokens, 29 + aOffset);
            double priceOffsetPips = this.toDoubleSafe(tokens, 48 + aOffset);
            if (tstep != 0) {
                if (fxcmType != FXCMOrdTypeFactory.LIMIT_TRAILING_ENTRY && fxcmType != FXCMOrdTypeFactory.STOP_TRAILING_ENTRY) {
                    if (fxcmType == FXCMOrdTypeFactory.STOP) {
                        fxcmType = FXCMOrdTypeFactory.TRAILING_STOP;
                    } else if (fxcmType == FXCMOrdTypeFactory.LIMIT) {
                        fxcmType = FXCMOrdTypeFactory.TRAILING_LIMIT;
                    }
                }
                pegInstructions = new PegInstruction();
                pegInstructions.setPegMoveType(0);
                if (rate == 0.0) {
                    pegInstructions.setPegOffsetType(1);
                    pegInstructions.setPegOffsetValue(priceOffsetPips);
                } else {
                    pegInstructions.setPegOffsetType(0);
                    pegInstructions.setPegOffsetValue(rate);
                }
                pegInstructions.setFXCMPegFluctuatePts(tstep);
                exe.setPegInstructions(pegInstructions);
                exe.setLastPx(this.toDoubleSafe(tokens, 30 + aOffset));
            } else if (priceOffsetPips != 0.0) {
                pegInstructions = new PegInstruction();
                String priceType = this.toStringSafe(tokens, 53 + aOffset);
                if (priceType != null) {
                    pegInstructions.setPegPriceType(this.toIntSafe(tokens, 53 + aOffset));
                }
                pegInstructions.setPegMoveType(0);
                pegInstructions.setPegOffsetType(1);
                pegInstructions.setPegOffsetValue(priceOffsetPips);
                exe.setPegInstructions(pegInstructions);
            }
            exe.setFXCMOrdType(fxcmType);
            IFXCMOrdStatus fxcmStatus = this.toFXCMOrdStatus(status);
            exe.setFXCMOrdStatus(fxcmStatus);
            String originRequestID = this.toStringSafe(tokens, 36 + aOffset);
            exe.setOrigClOrdID(originRequestID);
            exe.setExecType(FixFXMsgParser.toExecType(fxcmStatus, originRequestID));
            exe.setTradingSessionID(aTradingSessionID);
            exe.setTradingSessionSubID(aTradingSessionSubID);
            if (exe.getExecType() == ExecTypeFactory.REPLACED) {
                exe.setOrdStatus(OrdStatusFactory.REPLACED);
            } else {
                exe.setOrdStatus((IOrdStatus)cOrdStatuses.get(fxcmStatus));
            }
            double origQty = this.toQtySafe(tokens, 40 + aOffset, ts);
            double filledQty = this.toQtySafe(tokens, 41 + aOffset, ts);
            exe.setOrderQty(origQty);
            if (exe.getOrdStatus() == OrdStatusFactory.FILLED || fxcmStatus == FXCMOrdStatusFactory.EXECUTING && exe.getOrdStatus() == OrdStatusFactory.STOPPED) {
                exe.setCumQty(origQty);
                if (filledQty == 0.0) {
                    exe.setLastQty(qty);
                } else {
                    exe.setLastQty(filledQty);
                }
            } else if (origQty != 0.0) {
                exe.setCumQty(origQty - qty);
                exe.setLastQty(filledQty);
            } else {
                exe.setCumQty(0.0);
                exe.setLastQty(0.0);
            }
            boolean finalState = exe.getOrdStatus() == OrdStatusFactory.REJECTED || exe.getOrdStatus() == OrdStatusFactory.FILLED || exe.getFXCMOrdStatus() == FXCMOrdStatusFactory.EXECUTING || exe.getOrdStatus() == OrdStatusFactory.CANCELLED;
            boolean bl = partialFill = !finalState && filledQty > 0.0 && filledQty < origQty;
            if (partialFill) {
                exe.setOrdStatus(OrdStatusFactory.PARTIALLY_FILLED);
                exe.setExecType(ExecTypeFactory.TRADE);
            }
            if (finalState) {
                exe.setLeavesQty(0.0);
            } else if (origQty != 0.0) {
                exe.setLeavesQty(origQty - exe.getCumQty());
            } else {
                exe.setLeavesQty(qty);
            }
            exe.setOrdType(FixFXMsgParser.toOrdType(fxcmType));
            if (exe.getOrdType() == OrdTypeFactory.STOP) {
                exe.setStopPx(rate);
                if (aUserKind == 24 && this.mUseOriginRate) {
                    exe.setStopPx(originRate);
                }
            }
            exe.setText(this.toExecText(fxcmType, fxcmStatus));
            ITimeInForce timeinforce = TimeInForceFactory.toCodeByLabel(this.toStringSafe(tokens, 31 + aOffset));
            if (timeinforce == null) {
                timeinforce = this.toTimeInForce(fxcmType);
            }
            if ((timeinforce == TimeInForceFactory.DAY || timeinforce == TimeInForceFactory.GOOD_TILL_DATE) && exe.getFXCMOrdStatus() == FXCMOrdStatusFactory.EXPIRED) {
                exe.setOrdStatus(OrdStatusFactory.DONE_FOR_DAY);
            }
            exe.setTimeInForce(timeinforce);
            try {
                exe.setCurrency(ts.getCurrency());
            }
            catch (Exception exception) {
                // empty catch block
            }
            exe.setListID(this.toStringSafe(tokens, 42 + aOffset));
            boolean isExecutionRate = false;
            double execRate = this.toDoubleSafe(tokens, 43 + aOffset);
            boolean bl2 = executing = fxcmStatus == FXCMOrdStatusFactory.EXECUTED || fxcmStatus == FXCMOrdStatusFactory.EXECUTING;
            if (execRate != 0.0) {
                exe.setLastPx(execRate);
                if (executing) {
                    exe.setPrice(execRate);
                    if (exe.getOrdType() == OrdTypeFactory.STOP) {
                        exe.setStopPx(execRate);
                    }
                }
                isExecutionRate = true;
            }
            if ((execOriginRate = this.toDoubleSafe(tokens, 44 + aOffset)) != 0.0 && aUserKind == 24 && this.mUseOriginRate) {
                exe.setLastPx(execOriginRate);
                if (executing) {
                    exe.setPrice(execOriginRate);
                    if (exe.getOrdType() == OrdTypeFactory.STOP) {
                        exe.setStopPx(execOriginRate);
                    }
                }
                isExecutionRate = true;
            }
            if (fxcmType == FXCMOrdTypeFactory.RANGE_ENTRY || fxcmType == FXCMOrdTypeFactory.RANGE_TRAILING_ENTRY || fxcmType == FXCMOrdTypeFactory.OPEN_RANGE || fxcmType == FXCMOrdTypeFactory.CLOSE_RANGE) {
                if (isExecutionRate) {
                    exe.setStopPx(0.0);
                } else {
                    exe.setStopPx(this.toDoubleSafe(tokens, 49 + aOffset));
                    exe.setPrice(this.toDoubleSafe(tokens, 51 + aOffset));
                }
            }
            exe.setFXCMContingencyID(this.toStringSafe(tokens, 47 + aOffset));
            exe.setOrderPercent("Y".equalsIgnoreCase(this.toStringSafe(tokens, 54 + aOffset)) ? 1.0 : 0.0);
            exe.setContingencyType(ContingencyTypeFactory.toCode(this.toStringSafe(tokens, 55 + aOffset)));
            exe.setSecondaryOrderID(this.toStringSafe(tokens, 56 + aOffset));
            exe.setExpireTime(this.toTimeSafe(tokens, 57 + aOffset));
            exe.setEffectiveTime(this.toTimeSafe(tokens, 58 + aOffset));
        }
        return exe;
    }

    private static IExecType toExecType(IFXCMOrdStatus aFxcmStatus, String aOriginRequestID) {
        IExecType ret = (IExecType)cOrdStatuses.get(aFxcmStatus);
        if (ret == OrdStatusFactory.FILLED || aFxcmStatus == FXCMOrdStatusFactory.EXECUTING && ret == OrdStatusFactory.STOPPED) {
            ret = ExecTypeFactory.TRADE;
        } else {
            boolean hasOriginID;
            boolean resting = aFxcmStatus == FXCMOrdStatusFactory.INPROCESS || aFxcmStatus == FXCMOrdStatusFactory.WAITING;
            boolean bl = hasOriginID = aOriginRequestID != null && aOriginRequestID.trim().length() != 0;
            if (resting && hasOriginID) {
                ret = ExecTypeFactory.REPLACED;
            }
        }
        return ret;
    }

    public ExecutionReportEx[] parseOrders(String aMsg, String aTradingSessionID, String aTradingSessionSubID, int aUserKind) {
        String[] lines;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("parsing orders batch message = " + aMsg);
        }
        ArrayList<ExecutionReportEx> orderList = new ArrayList<ExecutionReportEx>();
        for (String line : lines = Util.splitToArray(aMsg, "\n")) {
            ExecutionReportEx er = this.parseOrder(line, -2, aTradingSessionID, aTradingSessionSubID, aUserKind);
            if (er == null) continue;
            orderList.add(er);
        }
        return orderList.toArray(new ExecutionReportEx[orderList.size()]);
    }

    public Parameter parseParam(String aMsg) {
        String[] tokens = Util.splitToArray(aMsg, ";");
        Parameter ret = null;
        if (tokens.length > 6) {
            ret = new Parameter(tokens[2], tokens[6]);
        }
        return ret;
    }

    public Parameter[] parseSystemParameters(String aMsg) {
        String[] lines;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("parsing system parameters batch message= " + aMsg);
        }
        ArrayList<Parameter> plist = new ArrayList<Parameter>();
        for (String line : lines = Util.splitToArray(aMsg, "\n")) {
            String[] tokens = Util.splitToArray(line, ";");
            if (tokens.length == 2) {
                plist.add(new Parameter(tokens[0], tokens[1]));
                continue;
            }
            if (tokens.length <= 2) continue;
            StringBuilder valueBuffer = new StringBuilder();
            for (int j = 1; j < tokens.length; ++j) {
                String token = tokens[j];
                valueBuffer.append(token);
                if (j == tokens.length - 1) continue;
                valueBuffer.append(";");
            }
            plist.add(new Parameter(tokens[0], valueBuffer.toString()));
        }
        return plist.toArray(new Parameter[plist.size()]);
    }

    public PositionReport parseTrade(String aMsg, String aTradingSessionID, String aTradingSessionSubID, int aUserKind) {
        return this.parseTrade(aMsg, 0, aTradingSessionID, aTradingSessionSubID, aUserKind);
    }

    public PositionReport parseTrade(String aMsg, int aOffset, String aTradingSessionID, String aTradingSessionSubID, int aUserKind) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("parsing trade message = " + aMsg);
        }
        String[] tokens = Util.splitToArray(aMsg, ";");
        PositionReport pr = null;
        if (tokens.length > 1) {
            pr = new PositionReport();
            if (aOffset == 0) {
                String oper = tokens[1];
                pr.setText(oper);
                String ref = this.toStringSafe(tokens, 29 + aOffset);
                if ("I".equals(oper) && ref != null) {
                    pr.setText("R");
                }
                if ("D".equals(oper)) {
                    return null;
                }
            }
            if (this.toIntSafe(tokens, 8 + aOffset) == 0) {
                this.mLogger.debug("skipping dummy trade msg");
                return null;
            }
            pr.setPosReqType(PosReqTypeFactory.POSITIONS);
            pr.setFXCMPosID(this.toStringSafe(tokens, 2 + aOffset));
            pr.setPosMaintRptID(tokens[3 + aOffset]);
            pr.getParties().setFXCMAcctID(this.toLongSafe(tokens, 6 + aOffset));
            pr.setAccount(this.toStringSafe(tokens, 7 + aOffset));
            TradingSecurityAdj ts = this.toSecuritySafe(tokens, 8 + aOffset);
            pr.setInstrument(ts);
            pr.setFXCMPosInterest(this.toDoubleSafe(tokens, 9 + aOffset));
            pr.setFXCMPosCommission(this.toDoubleSafe(tokens, 10 + aOffset));
            pr.setFXCMPosOpenTime(this.toTimeSafe(tokens, 11 + aOffset));
            pr.setTransactTime(this.toTimeSafe(tokens, 11 + aOffset));
            pr.setSettlPrice(this.toDoubleSafe(tokens, 12 + aOffset));
            pr.setPositionQty(this.toPositionQtySafe(tokens, 14 + aOffset, 15 + aOffset, ts));
            pr.getParties().setFXCMTraderLoginId(this.toStringSafe(tokens, 16 + aOffset));
            pr.getParties().setFXCMAcctName(this.toStringSafe(tokens, 17 + aOffset));
            if (aUserKind == 24 && this.mUseOriginRate) {
                pr.setSettlPrice(this.toDoubleSafe(tokens, 19 + aOffset));
            }
            pr.setFXCMUsedMargin(this.toDoubleSafe(tokens, 22 + aOffset));
            pr.getParties().setFXCMAcctType(this.toIntSafe(tokens, 23 + aOffset));
            pr.setOrderID(this.toStringSafe(tokens, 24 + aOffset));
            pr.setClOrdID(this.toStringSafe(tokens, 25 + aOffset));
            pr.setSecondaryClOrdID(this.toStringSafe(tokens, 26 + aOffset));
            try {
                pr.setCurrency(ts.getCurrency());
            }
            catch (Exception exception) {
                // empty catch block
            }
            pr.setTradingSessionID(aTradingSessionID);
            pr.setTradingSessionSubID(aTradingSessionSubID);
            pr.setListID(this.toStringSafe(tokens, 28 + aOffset));
            pr.setFXCMPosIDRef(this.toStringSafe(tokens, 29 + aOffset));
        }
        return pr;
    }

    public void setInstruments(String aQuoteMessage) {
        String[] lines;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("parsing initial currency message = " + aQuoteMessage);
        }
        this.mTradingSessionStatus.clearInstruments();
        for (String line : lines = Util.splitToArray(aQuoteMessage, "\n")) {
            TradingSecurityAdj instAdj = this.parseInstrument(line, -2);
            if (instAdj == null) continue;
            TradingSecurityAdj adj = this.mTradingSessionStatus.getTradingSecurityAdj(instAdj.getFXCMSymID());
            if (adj != null) {
                adj.fill(instAdj);
                continue;
            }
            if (instAdj.isValid()) {
                this.mTradingSessionStatus.setSecurity(instAdj);
                continue;
            }
            if (!this.mLogger.isDebugEnabled()) continue;
            this.mLogger.debug("-- skip adding invalid security " + instAdj);
        }
    }

    public void setUseOriginRate(boolean aUseOriginRate) {
        this.mUseOriginRate = aUseOriginRate;
    }

    public TradingSessionStatusAdj getTradingSessionStatus() {
        return this.mTradingSessionStatus;
    }

    static {
        cOrdTypes.put(FXCMOrdTypeFactory.OPEN, OrdTypeFactory.PREVIOUSLY_QUOTED);
        cOrdTypes.put(FXCMOrdTypeFactory.OPEN_PHONE, OrdTypeFactory.MARKET);
        cOrdTypes.put(FXCMOrdTypeFactory.OPEN_MARKET, OrdTypeFactory.MARKET);
        cOrdTypes.put(FXCMOrdTypeFactory.OPEN_LIMIT, OrdTypeFactory.LIMIT);
        cOrdTypes.put(FXCMOrdTypeFactory.OPEN_REQUOTE, OrdTypeFactory.PREVIOUSLY_QUOTED);
        cOrdTypes.put(FXCMOrdTypeFactory.OPEN_RANGE, OrdTypeFactory.STOP_LIMIT);
        cOrdTypes.put(FXCMOrdTypeFactory.CLOSE, OrdTypeFactory.PREVIOUSLY_QUOTED);
        cOrdTypes.put(FXCMOrdTypeFactory.CLOSE_PHONE, OrdTypeFactory.MARKET);
        cOrdTypes.put(FXCMOrdTypeFactory.CLOSE_MARKET, OrdTypeFactory.MARKET);
        cOrdTypes.put(FXCMOrdTypeFactory.CLOSE_LIMIT, OrdTypeFactory.LIMIT);
        cOrdTypes.put(FXCMOrdTypeFactory.CLOSE_REQUOTE, OrdTypeFactory.PREVIOUSLY_QUOTED);
        cOrdTypes.put(FXCMOrdTypeFactory.CLOSE_RANGE, OrdTypeFactory.STOP_LIMIT);
        cOrdTypes.put(FXCMOrdTypeFactory.ENTRY_LIMIT, OrdTypeFactory.LIMIT);
        cOrdTypes.put(FXCMOrdTypeFactory.ENTRY_STOP, OrdTypeFactory.STOP);
        cOrdTypes.put(FXCMOrdTypeFactory.LIMIT, OrdTypeFactory.LIMIT);
        cOrdTypes.put(FXCMOrdTypeFactory.STOP, OrdTypeFactory.STOP);
        cOrdTypes.put(FXCMOrdTypeFactory.MARGIN_CALL, OrdTypeFactory.MARKET);
        cOrdTypes.put(FXCMOrdTypeFactory.EQUITY_STOP, OrdTypeFactory.MARKET);
        cOrdTypes.put(FXCMOrdTypeFactory.TRAILING_STOP, OrdTypeFactory.PEG);
        cOrdTypes.put(FXCMOrdTypeFactory.TRAILING_LIMIT, OrdTypeFactory.PEG);
        cOrdTypes.put(FXCMOrdTypeFactory.LIMIT_TRAILING_ENTRY, OrdTypeFactory.LIMIT);
        cOrdTypes.put(FXCMOrdTypeFactory.STOP_TRAILING_ENTRY, OrdTypeFactory.STOP);
        cOrdTypes.put(FXCMOrdTypeFactory.RFQ, OrdTypeFactory.PREVIOUSLY_QUOTED);
        cOrdTypes.put(FXCMOrdTypeFactory.RANGE_ENTRY, OrdTypeFactory.STOP_LIMIT);
        cOrdTypes.put(FXCMOrdTypeFactory.RANGE_TRAILING_ENTRY, OrdTypeFactory.STOP_LIMIT);
        cOrdStatuses.put(FXCMOrdStatusFactory.WAITING, OrdStatusFactory.NEW);
        cOrdStatuses.put(FXCMOrdStatusFactory.INPROCESS, OrdStatusFactory.NEW);
        cOrdStatuses.put(FXCMOrdStatusFactory.DEALER_INTERVENTION, OrdStatusFactory.NEW);
        cOrdStatuses.put(FXCMOrdStatusFactory.REQUOTED, OrdStatusFactory.REJECTED);
        cOrdStatuses.put(FXCMOrdStatusFactory.EXECUTING, OrdStatusFactory.STOPPED);
        cOrdStatuses.put(FXCMOrdStatusFactory.PEDNING_CALCULATED, OrdStatusFactory.STOPPED);
        cOrdStatuses.put(FXCMOrdStatusFactory.PENDING_CANCEL, OrdStatusFactory.PENDING_CANCEL);
        cOrdStatuses.put(FXCMOrdStatusFactory.PENDING_CANCEL_CALCULATED, OrdStatusFactory.PENDING_CANCEL);
        cOrdStatuses.put(FXCMOrdStatusFactory.CANCELLED, OrdStatusFactory.CANCELLED);
        cOrdStatuses.put(FXCMOrdStatusFactory.REJECTED, OrdStatusFactory.REJECTED);
        cOrdStatuses.put(FXCMOrdStatusFactory.EXPIRED, OrdStatusFactory.EXPIRED);
        cOrdStatuses.put(FXCMOrdStatusFactory.EXECUTED, OrdStatusFactory.FILLED);
        cServerCalendar = new ThreadLocal();
    }
}

