/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.fix;

import com.fxcm.GenericException;
import com.fxcm.fix.BusinessRejectReasonFactory;
import com.fxcm.fix.FixObjectFactory;
import com.fxcm.fix.Parameter;
import com.fxcm.fix.custom.FXCMRequest;
import com.fxcm.fix.custom.FXCMResponse;
import com.fxcm.fix.other.BusinessMessageReject;
import com.fxcm.fix.pretrade.TradingSessionStatus;
import com.fxcm.fix.pretrade.TradingSessionStatusRequest;
import com.fxcm.messaging.ConnectionManagerEx;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ISessionStatus;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.IUserMessageListener;
import com.fxcm.messaging.IUserSession;
import com.fxcm.messaging.IUserTransportableListener;
import com.fxcm.messaging.TradingSessionDesc;
import com.fxcm.messaging.util.DBParamUtil;
import com.fxcm.messaging.util.GenericSessionStatus;
import com.fxcm.messaging.util.ITransportSession;
import com.fxcm.messaging.util.UniversalUserSession;
import com.fxcm.messaging.util.fix.FXCMCommandType;
import com.fxcm.messaging.util.fix.FixFXMsgParser;
import com.fxcm.messaging.util.fix.ISessionStrategy;
import com.fxcm.messaging.util.fix.RequestResponseController;
import com.fxcm.messaging.util.fix.TradingSessionStatusAdj;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class FIXUserSession
extends UniversalUserSession {
    protected boolean mAllReady;
    protected boolean mNativeBehavior;
    protected FixFXMsgParser mParser;
    protected TradingSessionStatusAdj mTradingSessionStatus;
    protected final TransportMutex mTransportMutexEx;
    protected final BackToUserQueue mUserQueue;
    protected RequestResponseController mReqRespController;
    protected List mBacklog = new ArrayList();

    public FIXUserSession(String aHostDescriptorURL, String aHostDescriptorXML, String aHostName, String aServiceName, String aTradingSessionID, String aTradingSessionSubID, String aLoginID, String aPassword, String aStationName, Properties aProperties) {
        this(aHostDescriptorURL, aHostDescriptorXML, aHostName, aServiceName, aTradingSessionID, aTradingSessionSubID, aLoginID, aPassword, null, aStationName, aProperties);
    }

    public FIXUserSession(String aHostDescriptorURL, String aHostDescriptorXML, String aHostName, String aServiceName, String aTradingSessionID, String aTradingSessionSubID, String aLoginID, String aPassword, String aOpenToken, String aStationName, Properties aProperties) {
        super(aHostDescriptorURL, aHostDescriptorXML, aHostName, aServiceName, aTradingSessionID, aTradingSessionSubID, aLoginID, aPassword, aOpenToken, aStationName, aProperties);
        this.mTransportMutexEx = new TransportMutex();
        this.mUserQueue = new BackToUserQueue(this);
        this.mParser = new FixFXMsgParser();
        this.mParser.setUseOriginRate("true".equals(aProperties.getProperty("com.fxcm.messaging.IConnectionManager.UseOriginRate", "true")));
        ISessionStrategy strategy = new ISessionStrategy(){

            @Override
            public IMessageFactory getMessageFactory() {
                return FIXUserSession.this.getMessageFactory();
            }

            @Override
            public long getMsgFlags() {
                return FIXUserSession.this.getMsgFlags();
            }

            @Override
            public String getSessionID() {
                return FIXUserSession.this.getSessionID();
            }

            @Override
            public String getTradingSessionID() {
                return FIXUserSession.this.getTradingSession().getID();
            }

            @Override
            public String getTradingSessionSubID() {
                return FIXUserSession.this.getTradingSession().getSubID();
            }

            @Override
            public int getUserKind() {
                return FIXUserSession.this.getUserKind();
            }

            @Override
            public FixFXMsgParser getParser() {
                return FIXUserSession.this.getParser();
            }

            @Override
            public TradingSessionStatusAdj getTradingSessionStatus() {
                return FIXUserSession.this.getTradingSessionStatus();
            }

            @Override
            public void sendBackToUser(List aList) {
                FIXUserSession.this.sendBackToUser(aList);
            }

            @Override
            public void sendBackToUser(IMessage aMessage) {
                FIXUserSession.this.sendBackToUser(aMessage);
            }

            @Override
            public void sendBackToUser(ITransportable aTransportable) {
                FIXUserSession.this.sendBackToUser(aTransportable);
            }

            @Override
            public boolean updateParam(Parameter aParameter) {
                return FIXUserSession.this.updateParam(aParameter);
            }

            @Override
            public void sendToServer(ITransportable aRequest) throws GenericException {
                FIXUserSession.this.sendToServer(aRequest);
            }

            @Override
            public int getUserID() {
                return FIXUserSession.this.getUserID();
            }

            @Override
            public String getNextRequestID() throws GenericException {
                return FIXUserSession.this.getNextRequestID();
            }

            @Override
            public boolean isClosed() {
                return FIXUserSession.this.isClosed();
            }

            @Override
            public Object getParameter(String aName) {
                return FIXUserSession.this.getParameter(aName);
            }

            @Override
            public void setParameter(String aName, String aVal) {
                FIXUserSession.this.setParameter(aName, aVal);
            }
        };
        this.mReqRespController = new RequestResponseController(strategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        TransportMutex transportMutex = this.mTransportMutexEx;
        synchronized (transportMutex) {
            this.mTransportMutexEx.notifyAll();
        }
        super.close();
        this.mUserQueue.stop();
    }

    public long getMsgFlags() {
        ITransportSession transportSession = this.getTransportSession();
        if (transportSession == null) {
            return 0L;
        }
        return transportSession.getConParams().mlMsgFlags;
    }

    public FixFXMsgParser getParser() {
        return this.mParser;
    }

    public synchronized TradingSessionStatusAdj getTradingSessionStatus() {
        return this.mTradingSessionStatus;
    }

    @Override
    public boolean open() throws GenericException {
        return this.open(null);
    }

    @Override
    public boolean open(String aExtraParams) throws GenericException {
        this.mUserQueue.start();
        boolean res = this.isValid();
        if (res) {
            ITransportSession sess = this.getValidSession();
            sess.addMessageListener(this.mListener);
            sess.addSessionStatusListener(this.mListener);
            res = sess.isValid();
        } else {
            res = super.open(aExtraParams);
        }
        if (res && (res = this.retrieveTradingSession())) {
            if (!this.isNative()) {
                this.processSynchronousFXCMRequest(FXCMCommandType.GET_SYSTEM_PARAMETERS);
            }
            switch (this.getUserKind()) {
                case 20: 
                case 22: 
                case 24: {
                    res = this.processSynchronousFXCMRequest(FXCMCommandType.GET_INSTRUMENTS);
                    break;
                }
            }
            this.mAllReady = true;
            this.updateStatus(6, 12);
            this.sendStatusUpdate();
        }
        return res;
    }

    public void setTransmitTradingSession(TradingSessionDesc tradingSession) {
        this.setTransmitTsID(tradingSession.getID());
        this.setTransmitTsSubID(tradingSession.getSubID());
    }

    @Override
    public void attach(String aSessionID, String aExtraParams) throws GenericException {
        this.mUserQueue.start();
        super.attach(aSessionID, aExtraParams);
        Enumeration en = ConnectionManagerEx.getUserSessions(aSessionID);
        IUserSession us = null;
        while (en.hasMoreElements() && (us = (IUserSession)en.nextElement()) == this) {
        }
        if (us == null || !(us instanceof FIXUserSession)) {
            throw new GenericException("Main session is not found for attached one");
        }
        FIXUserSession usFix = (FIXUserSession)us;
        this.mTradingSessionStatus = new TradingSessionStatusAdj(usFix.getTradingSessionStatus());
        this.mParser.init(this.mTradingSessionStatus);
        this.mNativeBehavior = usFix.isNative();
        this.mAllReady = true;
        this.updateStatus(6, 12);
        this.sendStatusUpdate();
    }

    private boolean processSynchronousFXCMRequest(FXCMCommandType aCmd) throws GenericException {
        FXCMRequest req = new FXCMRequest();
        String offerReqID = this.getNextRequestID();
        req.setTradingSessionID(this.getTradingSession().getID());
        req.setTradingSessionSubID(this.getTradingSession().getSubID());
        req.setTestReqID(offerReqID);
        req.setFXCMCommandID(aCmd.getType());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("SID", this.getSessionID());
        params.put("TraderID", String.valueOf(this.getUserID()));
        params.put("QID", offerReqID);
        req.setParams(params);
        return this.processSynchronousRequest(req, aCmd.getTypeCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processSynchronousRequest(ITransportable aRequest, int aCommandID) {
        boolean ret;
        block18: {
            ITransportable resp;
            block19: {
                block20: {
                    IMessage msg = aRequest.toMessage(this.getSessionID(), this.getMessageFactory());
                    resp = null;
                    long to = this.getLongProperty("com.fxcm.messaging.IConnectionManager.SyncRequestTimeout", 180000L);
                    TransportMutex transportMutex = this.mTransportMutexEx;
                    synchronized (transportMutex) {
                        try {
                            this.mTransportMutexEx.setRequestID(aRequest.getRequestID());
                            if (this.moLogger.isDebugEnabled()) {
                                this.moLogger.debug("processSynchronousRequest.request = " + msg);
                            }
                            super.send(msg);
                            this.mTransportMutexEx.wait(to);
                            resp = this.mTransportMutexEx.getResponse();
                            if (this.moLogger.isDebugEnabled()) {
                                this.moLogger.debug("processSynchronousRequest.response = " + resp);
                            }
                        }
                        catch (Exception e) {
                            this.moLogger.error("", e);
                        }
                        finally {
                            this.mTransportMutexEx.clear();
                        }
                    }
                    ret = false;
                    if (resp == null) break block18;
                    ret = true;
                    if (!TradingSessionStatus.OBJ_TYPE.equals(resp.getType())) break block19;
                    this.mTradingSessionStatus = new TradingSessionStatusAdj((TradingSessionStatus)resp);
                    if (this.mTradingSessionStatus.getTradSesStatusRejReason() != null) break block20;
                    this.mParser.init(this.mTradingSessionStatus);
                    String fixSupport = this.mTradingSessionStatus.getParameterValue("FixSupport");
                    if (fixSupport == null) {
                        fixSupport = "FIXONLY";
                    }
                    if ("FIXONLY".equals(fixSupport)) {
                        this.mNativeBehavior = true;
                    }
                    break block18;
                }
                ret = false;
                if (!this.moLogger.isErrorEnabled()) break block18;
                this.moLogger.error("Unable to obtain TradingSessionStatus." + this.mTradingSessionStatus.getText());
                break block18;
            }
            if (resp.getType().equals(FXCMResponse.OBJ_TYPE)) {
                String fxcmResponseParam = ((FXCMResponse)resp).getParam("DAS");
                if (FXCMCommandType.GET_INSTRUMENTS.getTypeCode() == aCommandID) {
                    this.mParser.setInstruments(fxcmResponseParam);
                } else if (FXCMCommandType.GET_SYSTEM_PARAMETERS.getTypeCode() == aCommandID) {
                    Parameter[] parameters = this.mParser.parseSystemParameters(fxcmResponseParam);
                    for (int i = 0; i < parameters.length; ++i) {
                        this.updateParam(parameters[i]);
                    }
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeMessageListener(IUserTransportableListener aListener) {
        super.removeMessageListener(aListener);
        BackToUserQueue backToUserQueue = this.mUserQueue;
        synchronized (backToUserQueue) {
            this.mUserQueue.fillListeners();
            this.mUserQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeMessageListener(IUserMessageListener aListener) {
        super.removeMessageListener(aListener);
        BackToUserQueue backToUserQueue = this.mUserQueue;
        synchronized (backToUserQueue) {
            this.mUserQueue.fillListeners();
            this.mUserQueue.notifyAll();
        }
    }

    public boolean retrieveTradingSession() throws GenericException {
        TradingSessionStatusRequest tr = new TradingSessionStatusRequest();
        tr.setTradSesReqID(this.getNextRequestID());
        tr.setTradingSessionID(this.getTradingSession().getID());
        tr.setTradingSessionSubID(this.getTradingSession().getSubID());
        return this.processSynchronousRequest(tr, 0);
    }

    @Override
    public String send(IMessage aMessage) throws GenericException {
        String ret = "sent out";
        if (this.mNativeBehavior) {
            ret = super.send(aMessage);
        } else if (this.mReqRespController.processRequest(aMessage) == RequestResponseController.UNKNOWN) {
            BusinessMessageReject bmr = new BusinessMessageReject();
            bmr.setFXCMErrorDetails("Unsupported message type " + aMessage.getMsgType());
            bmr.setFXCMRequestRejectReason(1);
            bmr.setBusinessRejectReason(BusinessRejectReasonFactory.UNSUPPORTED_MESSAGE_TYPE);
            bmr.setBusinessRejectRefID(FixObjectFactory.toObject(aMessage).getRequestID());
            bmr.setRefMsgType(aMessage.getMsgType());
            bmr.setText(BusinessRejectReasonFactory.UNSUPPORTED_MESSAGE_TYPE.getDesc());
            bmr.setTradingSessionID(this.getTradingSessionStatus().getTradingSessionID());
            bmr.setTradingSessionSubID(this.getTradingSessionStatus().getTradingSessionSubID());
            this.sendBackToUser(bmr);
        }
        return ret;
    }

    public void sendBackToUser(IMessage aMsg) {
        this.mUserQueue.put(aMsg);
    }

    public void sendBackToUser(ITransportable aTransportable) {
        this.mUserQueue.put(aTransportable);
    }

    public void sendBackToUser(List aMsgs) {
        this.mUserQueue.put(aMsgs);
    }

    public String sendToServer(IMessage aMsg) throws GenericException {
        return super.send(aMsg);
    }

    public String sendToServer(ITransportable aTransportable) throws GenericException {
        IMessage msg = aTransportable.toMessage(this.getSessionID(), this.getMessageFactory());
        return this.sendToServer(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean setMessageListener(IUserTransportableListener aListener) {
        boolean ret = super.setMessageListener(aListener);
        BackToUserQueue backToUserQueue = this.mUserQueue;
        synchronized (backToUserQueue) {
            this.mUserQueue.fillListeners();
            this.mUserQueue.notifyAll();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean setMessageListener(IUserMessageListener aListener) {
        boolean ret = super.setMessageListener(aListener);
        BackToUserQueue backToUserQueue = this.mUserQueue;
        synchronized (backToUserQueue) {
            this.mUserQueue.fillListeners();
            this.mUserQueue.notifyAll();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMessageHook(IMessage aMessage) {
        String req = this.mTransportMutexEx.getRequestID();
        boolean processed = false;
        ITransportable tr = null;
        if (req != null && (tr = FixObjectFactory.toObject(aMessage)) != null && req.equals(tr.getRequestID())) {
            TransportMutex transportMutex = this.mTransportMutexEx;
            synchronized (transportMutex) {
                req = this.mTransportMutexEx.getRequestID();
                if (req != null && req.equals(tr.getRequestID())) {
                    this.mTransportMutexEx.setResponse(tr);
                    processed = true;
                    this.mTransportMutexEx.notifyAll();
                }
            }
        }
        if (!processed && this.mAllReady && !this.mNativeBehavior) {
            RequestResponseController.Status status = this.mReqRespController.processResponse(aMessage);
            processed = status == RequestResponseController.SUCCESS || status == RequestResponseController.FAILURE;
        }
        IMessage ret = null;
        if (!processed && this.mAllReady) {
            long msgChannel;
            long msgFlags = this.getMsgFlags();
            if (FixObjectFactory.isMsgReceiveOn(msgFlags, msgChannel = FixObjectFactory.getMessageChannel(aMessage.getMsgType()))) {
                ret = aMessage;
            } else {
                if (tr == null) {
                    tr = FixObjectFactory.toObject(aMessage);
                }
                if (tr == null || tr.getRequestID() != null) {
                    ret = aMessage;
                }
            }
        }
        if (ret != null) {
            this.sendBackToUser(ret);
        }
        if (ret == null && !processed && !this.mAllReady) {
            this.mBacklog.add(aMessage);
        }
    }

    public boolean updateParam(Parameter aParam) {
        return DBParamUtil.fill(this.getTradingSessionStatus(), aParam.getName(), aParam.getValue());
    }

    public boolean isNative() {
        return this.mNativeBehavior;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateStatus(ISessionStatus aState) {
        GenericSessionStatus genericSessionStatus = this.mStatus;
        synchronized (genericSessionStatus) {
            super.updateStatus(aState);
            if (!this.mAllReady && aState.getStatusCode() == 6) {
                this.updateStatus(1, 9);
            }
        }
    }

    @Override
    protected void updateStatus(int aStatusCode, int aStatusMsgID) {
        int newCode = aStatusCode;
        int newMsg = aStatusMsgID;
        if (!this.mAllReady && newCode == 6) {
            newCode = 1;
            newMsg = 9;
        }
        super.updateStatus(newCode, newMsg);
    }

    protected static class TransportMutex {
        protected String mRequestID;
        protected ITransportable mResponse;

        TransportMutex() {
        }

        String getRequestID() {
            return this.mRequestID;
        }

        ITransportable getResponse() {
            return this.mResponse;
        }

        void setResponse(ITransportable aResponse) {
            this.mResponse = aResponse;
        }

        void clear() {
            this.mRequestID = null;
            this.mResponse = null;
        }

        void setRequestID(String aRequestID) {
            this.mRequestID = aRequestID;
            this.mResponse = null;
        }
    }

    protected class BackToUserQueue
    implements Runnable {
        private List mMessages;
        private final Object mMutex = new Object();
        private List mSafeListeners;
        private final FIXUserSession mSession;
        private boolean mbContinue;

        BackToUserQueue(FIXUserSession aSession) {
            this.mSession = aSession;
            this.mMessages = new ArrayList();
            this.mSafeListeners = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fillListeners() {
            if (FIXUserSession.this.mClientMessageListeners.size() != this.mSafeListeners.size()) {
                FIXUserSession fIXUserSession = this.mSession;
                synchronized (fIXUserSession) {
                    this.mSafeListeners = (Vector)FIXUserSession.this.mClientMessageListeners.clone();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(IMessage aMsg) {
            Object object = this.mMutex;
            synchronized (object) {
                this.mMessages.add(aMsg);
                this.mMutex.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(ITransportable aMsg) {
            Object object = this.mMutex;
            synchronized (object) {
                this.mMessages.add(aMsg);
                this.mMutex.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(List aMsgs) {
            Object object = this.mMutex;
            synchronized (object) {
                this.mMessages.addAll(aMsgs);
                this.mMutex.notifyAll();
            }
        }

        private void releaseBacklog() {
            if (!FIXUserSession.this.mBacklog.isEmpty()) {
                try {
                    for (int i = 0; i < FIXUserSession.this.mBacklog.size(); ++i) {
                        IMessage msg = (IMessage)FIXUserSession.this.mBacklog.get(i);
                        FIXUserSession.this.updateMessageHook(msg);
                    }
                }
                finally {
                    FIXUserSession.this.mBacklog.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList toSend = new ArrayList();
            while (this.mbContinue) {
                try {
                    Object object = this.mMutex;
                    synchronized (object) {
                        if (this.mbContinue) {
                            if (this.mMessages.isEmpty()) {
                                this.mMutex.wait(3000L);
                            } else {
                                toSend.addAll(this.mMessages);
                                this.mMessages.clear();
                            }
                        }
                    }
                    while (this.mbContinue && !toSend.isEmpty()) {
                        Object listener;
                        int i;
                        Object msg;
                        this.fillListeners();
                        Object obj = toSend.remove(0);
                        if (obj instanceof IMessage) {
                            msg = (IMessage)obj;
                            if ("W".equals(msg.getMsgType())) {
                                if (FIXUserSession.this.mTraceMarketDataLogger.isTraceEnabled()) {
                                    FIXUserSession.this.mTraceMarketDataLogger.trace("inc <<< " + FixObjectFactory.toObject((IMessage)msg));
                                }
                            } else if (FIXUserSession.this.mTraceMessageLogger.isTraceEnabled()) {
                                FIXUserSession.this.mTraceMessageLogger.trace("inc <<< " + FixObjectFactory.toObject((IMessage)msg));
                            }
                            for (i = 0; i < this.mSafeListeners.size(); ++i) {
                                listener = this.mSafeListeners.get(i);
                                if (listener instanceof IUserMessageListener) {
                                    ((IUserMessageListener)listener).update(this.mSession, (IMessage)msg);
                                    continue;
                                }
                                if (!(listener instanceof IUserTransportableListener)) continue;
                                ((IUserTransportableListener)listener).update(this.mSession, FixObjectFactory.toObject((IMessage)msg));
                            }
                            if (!"h".equalsIgnoreCase(msg.getMsgType())) continue;
                            this.releaseBacklog();
                            continue;
                        }
                        if (!(obj instanceof ITransportable)) continue;
                        msg = (ITransportable)obj;
                        if ("W".equals(msg.getType().getCode())) {
                            if (FIXUserSession.this.mTraceMarketDataLogger.isTraceEnabled()) {
                                FIXUserSession.this.mTraceMarketDataLogger.trace("inc <<< " + (ITransportable)msg);
                            }
                        } else if (FIXUserSession.this.mTraceMessageLogger.isTraceEnabled()) {
                            FIXUserSession.this.mTraceMessageLogger.trace("inc <<< " + (ITransportable)msg);
                        }
                        for (i = 0; i < this.mSafeListeners.size(); ++i) {
                            listener = this.mSafeListeners.get(i);
                            if (listener instanceof IUserMessageListener) {
                                ((IUserMessageListener)listener).update(this.mSession, msg.toMessage(FIXUserSession.this.getSessionID(), FIXUserSession.this.getMessageFactory()));
                                continue;
                            }
                            if (!(listener instanceof IUserTransportableListener)) continue;
                            ((IUserTransportableListener)listener).update(this.mSession, (ITransportable)msg);
                        }
                        if (!"h".equalsIgnoreCase(msg.getType().getCode())) continue;
                        this.releaseBacklog();
                    }
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable th) {
                    FIXUserSession.this.moLogger.error("", th);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            Object object = this.mMutex;
            synchronized (object) {
                if (!this.mbContinue) {
                    this.mbContinue = true;
                    new Thread((Runnable)this, "BackToUserQueue").start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.mMutex;
            synchronized (object) {
                this.mbContinue = false;
                this.mMutex.notifyAll();
            }
        }
    }
}

