/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util;

import com.fxcm.GenericException;
import com.fxcm.fix.FixObjectFactory;
import com.fxcm.fix.admin.Heartbeat;
import com.fxcm.fix.admin.TestRequest;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ISessionStatus;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.IUserMessageListener;
import com.fxcm.messaging.IUserSession;
import com.fxcm.messaging.IUserSessionStatusListener;
import com.fxcm.messaging.IUserTransportableListener;
import com.fxcm.messaging.TradingSessionDesc;
import com.fxcm.messaging.util.CommunicationException;
import com.fxcm.messaging.util.ConParams;
import com.fxcm.messaging.util.CryptUtils;
import com.fxcm.messaging.util.GenericSessionStatus;
import com.fxcm.messaging.util.HostDesc;
import com.fxcm.messaging.util.HostDescV3;
import com.fxcm.messaging.util.HostElement;
import com.fxcm.messaging.util.HostReader;
import com.fxcm.messaging.util.IMessageListener;
import com.fxcm.messaging.util.ISessionStatusListener;
import com.fxcm.messaging.util.ITransportProvider;
import com.fxcm.messaging.util.ITransportSession;
import com.fxcm.messaging.util.ITransportSessionEx;
import com.fxcm.messaging.util.TransportProviderFactory;
import com.fxcm.messaging.util.UniversalMessage;
import com.fxcm.messaging.util.UrlElement;
import com.fxcm.util.Base64t;
import com.fxcm.util.Util;
import com.fxcm.util.logging.Utils;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;

public class UniversalUserSession
implements IUserSession {
    protected final Log moLogger = Utils.getLog(UniversalUserSession.class);
    protected final Log mTraceMessageLogger = Utils.getLog("develop.trace.message." + UniversalUserSession.class.getName());
    protected final Log mTraceMarketDataLogger = Utils.getLog("develop.trace.marketdata." + UniversalUserSession.class.getName());
    protected final Log mTraceStatusLogger = Utils.getLog("develop.trace.status." + UniversalUserSession.class.getName());
    protected final GenericSessionStatus mStatus = new GenericSessionStatus();
    protected String mHostDescriptorURL;
    protected String mHostDescriptorXML;
    protected String mHostName;
    protected String mServiceName;
    protected TradingSessionDesc mTradingSession;
    protected HostElement mHost;
    protected String mLoginID;
    protected String mPasswordPlain;
    protected String mPasswordDigest;
    protected String mStationName;
    protected boolean mReloginAllowed;
    protected boolean mUnderRelogin;
    protected boolean mStop;
    protected boolean mEmpty = true;
    protected long mLastActivity;
    protected final Properties mProperties;
    protected final Properties mParameters;
    protected Listener mListener;
    protected final Vector mClientMessageListeners;
    protected final Vector mClientStatusListeners;
    protected ITransportSession mTransportSession;
    protected ITransportProvider mTransportProvider;
    protected ConParams mTransportParams;
    protected final Object mTransportMutex;
    protected HostReader mHostReader;
    protected HostDesc mHostDesc;
    protected String mExtraParams;
    protected long mlMsgFlags;
    protected String mSsoToken;
    protected String mSsoTokenKey;
    protected volatile boolean mLogonSucceed = false;
    protected String mChangingPassword = null;
    protected String mTransmitTsID = null;
    protected String mTransmitTsSubID = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTransportSession(ITransportSession aSession) {
        Object object = this.mTransportMutex;
        synchronized (object) {
            this.mTransportSession = aSession;
            if (this.mTransportSession != null) {
                this.mTransportProvider = this.mTransportSession.getTransportProvider();
                this.mTransportParams = new ConParams(this.mTransportSession.getConParams());
            }
        }
    }

    protected boolean isSsoTokenSupported() {
        return this.mSsoTokenKey != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTransportProvider(ITransportProvider aProvider) {
        Object object = this.mTransportMutex;
        synchronized (object) {
            this.mTransportProvider = aProvider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ITransportSession getTransportSession() {
        ITransportSession ret;
        Object object = this.mTransportMutex;
        synchronized (object) {
            ret = this.mTransportSession;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConParams getTransportParams() {
        ConParams ret;
        Object object = this.mTransportMutex;
        synchronized (object) {
            ret = this.mTransportParams;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ITransportProvider getTransportProvider() {
        ITransportProvider ret;
        Object object = this.mTransportMutex;
        synchronized (object) {
            ret = this.mTransportProvider;
        }
        return ret;
    }

    protected HostElement getHostElement(String aName) {
        HostElement ret = null;
        if (this.mTradingSession != null && this.mHostDesc != null) {
            try {
                ret = this.mHostDesc.get(aName);
            }
            catch (GenericException e) {
                this.moLogger.error(e.getMessage(), e);
            }
        }
        return ret;
    }

    protected TradingSessionDesc getPriceChannelSessionDesc() {
        TradingSessionDesc ret = null;
        if (this.mTradingSession != null && this.mHostDesc instanceof HostDescV3) {
            HostDescV3 hd = (HostDescV3)this.mHostDesc;
            if (this.moLogger.isDebugEnabled()) {
                this.moLogger.debug("getPriceChannelSessionDesc:" + this.mTradingSession.getName() + " " + this.mHostName + " " + this.mServiceName);
            }
            ret = hd.getPriceChannelSessionDesc(this.mTradingSession.getName());
        }
        return ret;
    }

    private UrlElement[] getAvailableUrls(boolean aSecurePreferable, boolean aUseProxy) {
        if (this.mHost == null) {
            return null;
        }
        Vector<UrlElement> vTcpS = new Vector<UrlElement>();
        Vector<UrlElement> vHttpS = new Vector<UrlElement>();
        Vector<UrlElement> vTcp = new Vector<UrlElement>();
        Vector<UrlElement> vHttp = new Vector<UrlElement>();
        Vector vUrls = null;
        try {
            vUrls = this.mHost.getUrls().getUrls();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (vUrls == null || vUrls.isEmpty()) {
            return null;
        }
        Enumeration e = vUrls.elements();
        while (e.hasMoreElements()) {
            UrlElement url = (UrlElement)e.nextElement();
            boolean secB = "true".equals(url.getSecure());
            boolean tcpB = "tcp".equals(url.getProtocol());
            if (secB) {
                if (tcpB) {
                    vTcpS.addElement(url);
                    continue;
                }
                vHttpS.addElement(url);
                continue;
            }
            if (tcpB) {
                vTcp.addElement(url);
                continue;
            }
            vHttp.addElement(url);
        }
        UrlElement[] arrayUrl = new UrlElement[vUrls.size()];
        int i = -1;
        if (aSecurePreferable) {
            if (aUseProxy) {
                i = UniversalUserSession.addAll(arrayUrl, vHttpS, i);
                i = UniversalUserSession.addAll(arrayUrl, vTcpS, i);
                i = UniversalUserSession.addAll(arrayUrl, vHttp, i);
                i = UniversalUserSession.addAll(arrayUrl, vTcp, i);
            } else {
                i = UniversalUserSession.addAll(arrayUrl, vTcpS, i);
                i = UniversalUserSession.addAll(arrayUrl, vHttpS, i);
                i = UniversalUserSession.addAll(arrayUrl, vTcp, i);
                i = UniversalUserSession.addAll(arrayUrl, vHttp, i);
            }
        } else if (aUseProxy) {
            i = UniversalUserSession.addAll(arrayUrl, vHttp, i);
            i = UniversalUserSession.addAll(arrayUrl, vHttpS, i);
            i = UniversalUserSession.addAll(arrayUrl, vTcp, i);
            i = UniversalUserSession.addAll(arrayUrl, vTcpS, i);
        } else {
            i = UniversalUserSession.addAll(arrayUrl, vUrls, i);
        }
        vTcpS.clear();
        vHttpS.clear();
        vTcp.clear();
        vHttp.clear();
        vUrls.clear();
        return arrayUrl;
    }

    private static int addAll(UrlElement[] aTo, Vector aFrom, int aLast) {
        int i = aLast;
        if (aTo != null && aFrom != null) {
            Enumeration e = aFrom.elements();
            while (e.hasMoreElements()) {
                aTo[++i] = (UrlElement)e.nextElement();
            }
        }
        return i;
    }

    @Override
    public IMessageFactory getMessageFactory() {
        IMessageFactory ret = null;
        ITransportSession ts = this.getTransportSession();
        if (ts != null) {
            ret = ts.getMessageFactory();
        }
        return ret;
    }

    protected long getLongProperty(String aName, long aDefault) {
        long ret = aDefault;
        String res = this.mProperties.getProperty(aName);
        if (res != null && res.length() > 0) {
            try {
                ret = Long.parseLong(res);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    protected boolean getBooleanProperty(String aName, boolean aDefault) {
        boolean ret = aDefault;
        String res = this.mProperties.getProperty(aName);
        if (res != null && res.length() > 0) {
            ret = "true".equals(res);
        }
        return ret;
    }

    public UniversalUserSession(String aHostDescriptorURL, String aHostDescriptorXML, String aHostName, String aServiceName, String aTradingSessionID, String aTradingSessionSubID, String aLoginID, String aPassword, String aToken, String aStationName, Properties aProperties) {
        String s;
        this.mProperties = new Properties(aProperties);
        this.mParameters = new Properties();
        this.mTransportMutex = new Object();
        this.mHostDescriptorURL = aHostDescriptorURL;
        this.mHostDescriptorXML = aHostDescriptorXML;
        this.mHostName = aHostName;
        this.mServiceName = aServiceName;
        this.mTradingSession = new TradingSessionDesc(aTradingSessionSubID, aTradingSessionID, null, null);
        this.mTradingSession.setName(null);
        this.mTradingSession.setDesc(null);
        this.mLoginID = aLoginID;
        this.mPasswordPlain = aPassword;
        this.mSsoToken = aToken;
        this.mStationName = aStationName;
        this.mReloginAllowed = false;
        this.mUnderRelogin = false;
        this.mEmpty = true;
        this.mStop = false;
        this.mListener = new Listener(this);
        this.mClientMessageListeners = new Vector();
        this.mClientStatusListeners = new Vector();
        this.mLastActivity = System.currentTimeMillis();
        this.mlMsgFlags = 0L;
        if (this.mProperties != null && (s = this.mProperties.getProperty("MessageFlags")) != null && s.length() > 0) {
            try {
                this.mlMsgFlags = Long.parseLong(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setTradingSession(TradingSessionDesc aTradingSession) {
        if (aTradingSession != null) {
            this.mTradingSession.setID(aTradingSession.getID());
            this.mTradingSession.setSubID(aTradingSession.getSubID());
            this.mTradingSession.setName(aTradingSession.getName());
            this.mTradingSession.setDesc(aTradingSession.getDesc());
            String saltPlain = aTradingSession.getProperty("S");
            if (this.mPasswordPlain != null && this.mPasswordDigest == null) {
                this.mPasswordDigest = this.digestPassword(this.mPasswordPlain, saltPlain);
                this.mPasswordPlain = null;
            }
            if (this.moLogger.isDebugEnabled()) {
                this.moLogger.debug("setTradingSession:" + this.mTradingSession);
            }
        }
    }

    private String digestPassword(String aPassword, String aSalt) {
        Object ret = aPassword;
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            byte[] pwdDigest = null;
            byte[] saltBase64 = null;
            if (aSalt != null) {
                saltBase64 = aSalt.getBytes();
            }
            if (saltBase64 != null && saltBase64.length % 4 == 0) {
                byte[] salt = Base64t.decode(saltBase64);
                byte[] pwdPlain = aPassword.getBytes();
                byte[] pwdSalted = new byte[pwdPlain.length + salt.length];
                System.arraycopy(pwdPlain, 0, pwdSalted, 0, pwdPlain.length);
                System.arraycopy(salt, 0, pwdSalted, pwdPlain.length, salt.length);
                pwdDigest = sha.digest(pwdSalted);
                ret = new String(Base64t.encode(pwdDigest));
            } else {
                pwdDigest = sha.digest(aPassword.getBytes());
                ret = "";
                for (int i = 0; i < pwdDigest.length; ++i) {
                    ret = (String)ret + UniversalUserSession.toHex(pwdDigest[i] >> 4 & 0xF) + UniversalUserSession.toHex(pwdDigest[i] & 0xF);
                }
            }
        }
        catch (Exception ee) {
            this.moLogger.error(ee.getMessage(), ee);
        }
        return ret;
    }

    private static String toHex(int a) {
        char[] ac = new char[]{a < 10 ? (char)(a + 48) : (char)(a + 97 - 10)};
        return new String(ac);
    }

    @Override
    public TradingSessionDesc getTradingSession() {
        return this.mTradingSession;
    }

    protected String getTransmitTsID() {
        return this.mTransmitTsID != null ? this.mTransmitTsID : this.mTradingSession.getID();
    }

    protected String getTransmitTsSubID() {
        return this.mTransmitTsSubID != null ? this.mTransmitTsSubID : this.mTradingSession.getSubID();
    }

    protected final void setTransmitTsID(String s) {
        this.mTransmitTsID = s;
    }

    protected final void setTransmitTsSubID(String s) {
        this.mTransmitTsSubID = s;
    }

    @Override
    public final void setMsgFlags(long aMsgFlags) {
        this.mlMsgFlags = aMsgFlags;
        ITransportSession ts = this.getTransportSession();
        if (ts != null) {
            ConParams conParams = ts.getConParams();
            conParams.mlMsgFlags = aMsgFlags;
        }
    }

    @Override
    public void setParameter(String aName, String aValue) {
        ITransportSession ts = this.getTransportSession();
        if (ts != null) {
            ts.setParameter(aName, aValue);
        }
        this.mParameters.put(aName, aValue);
    }

    @Override
    public int getQueueSize() {
        int ret = 0;
        ITransportSession ts = this.getTransportSession();
        if (ts != null) {
            ret = ts.getQueueSize();
        }
        return ret;
    }

    @Override
    public boolean loadStationDescriptor() throws GenericException {
        boolean ret;
        this.updateStatus(4, 1);
        this.sendStatusUpdate();
        this.mHost = null;
        this.mHostReader = new HostReader();
        this.mHostReader.setProxyParameters(this.mProperties.getProperty("com.fxcm.messaging.IConnectionManager.ProxyServer"), (int)this.getLongProperty("com.fxcm.messaging.IConnectionManager.ProxyPort", 80L), this.mProperties.getProperty("com.fxcm.messaging.IConnectionManager.ProxyUserID"), this.mProperties.getProperty("com.fxcm.messaging.IConnectionManager.ProxyPassword"), this.getBooleanProperty("com.fxcm.messaging.IConnectionManager.ProxyHTTP11", false));
        if (this.mHostDescriptorXML == null && this.mHostDesc != null) {
            this.mHostDescriptorXML = this.mHostDesc.getHostDescriptorXML();
        }
        if (this.mHostDescriptorXML == null) {
            this.mHostDesc = this.mHostReader.read(this.mHostDescriptorURL, this.mHostName, this.mStationName, this.mLoginID);
            if (this.mHostDesc != null) {
                this.mHostDescriptorXML = this.mHostDesc.getHostDescriptorXML();
            }
        } else {
            this.mHostDesc = this.mHostReader.readFromXML(this.mHostDescriptorXML, this.mHostName, this.mStationName);
        }
        if (this.mHostDesc != null) {
            this.mHost = this.mHostDesc.get(this.mHostName);
        }
        boolean bl = ret = this.mHost != null;
        if (ret) {
            this.updateStatus(7, 0);
        } else {
            this.updateStatus(-2, 4);
        }
        this.sendStatusUpdate();
        return ret;
    }

    @Override
    public String getHostParamValue(String aAttributeName) {
        String ret = null;
        if (this.mHost != null) {
            ret = this.mHost.getAttribute(aAttributeName);
        }
        return ret;
    }

    @Override
    public String getStationParamValue(String aAttributeName) {
        String ret = null;
        if (this.mHost != null && this.mStationName != null) {
            try {
                ret = this.mHost.getStations().getStation(this.mStationName).getAttribute(aAttributeName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    protected ConParams createConParams() {
        ConParams ret = new ConParams();
        ret.msName = "";
        if (this.mHost != null) {
            ret.msName = this.mHost.getName();
        }
        ret.msTransportProvider = "";
        ret.msHost = "";
        ret.miPort = -1;
        ret.mbUseHttp = false;
        ret.msScript = "";
        ret.msApp = this.mProperties.getProperty("com.fxcm.messaging.IConnectionManager.AppInfo");
        ret.msUid = "";
        ret.msUpwd = "";
        ret.mbUseProxy = false;
        ret.msProxyHost = this.mProperties.getProperty("com.fxcm.messaging.IConnectionManager.ProxyServer");
        ret.miProxyPort = (int)this.getLongProperty("com.fxcm.messaging.IConnectionManager.ProxyPort", 80L);
        ret.msProxyUid = this.mProperties.getProperty("com.fxcm.messaging.IConnectionManager.ProxyUserID");
        ret.msProxyPwd = this.mProperties.getProperty("com.fxcm.messaging.IConnectionManager.ProxyUserID");
        ret.mProxyAuthenticationRealm = this.mProperties.getProperty("com.fxcm.messaging.IConnectionManager.ProxyRealm");
        ret.mProxyType = this.mProperties.getProperty("com.fxcm.messaging.IConnectionManager.ProxyType");
        ret.mbProxyHTTP11 = this.getBooleanProperty("com.fxcm.messaging.IConnectionManager.ProxyHTTP11", false);
        ret.msHttpUid = this.mProperties.getProperty("com.fxcm.messaging.IConnectionManager.ProxyUserID");
        ret.msHttpPwd = this.mProperties.getProperty("com.fxcm.messaging.IConnectionManager.ProxyPassword");
        ret.mbUseSecure = false;
        ret.mlMsgFlags = this.mlMsgFlags;
        ret.mbUseProxy = ret.msProxyHost != null && ret.msProxyHost.trim().length() > 0 && ret.miProxyPort > 0;
        return ret;
    }

    protected ITransportSession getValidSession() throws GenericException {
        ITransportSession ret = this.getTransportSession();
        if (ret != null) {
            boolean valid = false;
            try {
                valid = ret.isValid();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!valid) {
                this.setTransportSession(null);
                try {
                    ret.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ret = null;
            }
        }
        if (ret == null) {
            ret = this.openTransportSession();
            this.setTransportSession(ret);
        }
        return ret;
    }

    protected ITransportSession openTransportSession() throws GenericException {
        ITransportSession ret = null;
        GenericException lastEx = null;
        ConParams par = this.getTransportParams();
        if (par != null) {
            if (this.moLogger.isDebugEnabled()) {
                this.moLogger.debug("Try to use previous connection");
            }
            try {
                ret = this.openTransportSession(par);
            }
            catch (GenericException e) {
                lastEx = e;
            }
        }
        if (ret == null) {
            par = this.createConParams();
            UrlElement[] urls = this.getAvailableUrls(this.getBooleanProperty("com.fxcm.messaging.IConnectionManager.SecurePreferable", par.mbUseSecure), par.mbUseProxy);
            if (urls == null || urls.length == 0) {
                throw new CommunicationException("Incorrect URL");
            }
            int cnt = urls.length;
            for (int i = 0; i < cnt; ++i) {
                try {
                    if (this.moLogger.isDebugEnabled()) {
                        this.moLogger.debug("URL no " + i + " of " + cnt + " :" + urls[i].getUrlString());
                    }
                    par.setUrl(urls[i]);
                    ret = this.openTransportSession(par);
                    if (ret == null) continue;
                    break;
                }
                catch (GenericException e) {
                    lastEx = e;
                }
            }
        }
        if (ret == null && lastEx != null) {
            throw lastEx;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ITransportSession openTransportSession(ConParams aParams) throws GenericException {
        ITransportSession ret = null;
        if (aParams != null && !aParams.isEmpty()) {
            ITransportProvider provider = TransportProviderFactory.get(aParams.msTransportProvider);
            if (provider != null) {
                ConParams par;
                if (!provider.isInitiated()) {
                    provider.init(this.mProperties);
                }
                if (provider.isInitiated() && provider.isValid(par = provider.addExtra(aParams)) && (ret = provider.createSession(par)) != null) {
                    Properties props = null;
                    Object object = this.mTransportMutex;
                    synchronized (object) {
                        props = (Properties)this.mParameters.clone();
                    }
                    Enumeration<?> en = props.propertyNames();
                    while (en.hasMoreElements()) {
                        String name = (String)en.nextElement();
                        ret.setParameter(name, props.getProperty(name));
                    }
                }
            } else if (this.moLogger.isDebugEnabled()) {
                this.moLogger.debug("Provider " + aParams.msTransportProvider + " not found");
            }
        }
        return ret;
    }

    @Override
    public TradingSessionDesc[] retrieveTradingSessions() throws GenericException {
        TradingSessionDesc[] ret;
        if (this.mHostDesc != null) {
            TradingSessionDesc[] tsds;
            if (this.moLogger.isDebugEnabled()) {
                this.moLogger.debug("HostDesc defined: retrieveSessionDescriptions...");
            }
            if ((tsds = this.mHostDesc.retrieveSessionDescriptions()) != null && tsds.length > 0) {
                if (this.moLogger.isDebugEnabled()) {
                    this.moLogger.debug("HostDesc defined: retrieveSessionDescriptions=" + tsds.length);
                }
                if (tsds[0].getProperty("S") != null) {
                    return tsds;
                }
                if (this.moLogger.isDebugEnabled()) {
                    this.moLogger.debug("No salt defined in " + tsds + " possible backdoor. need to get salt from server");
                }
            }
        }
        if (this.mHost == null) {
            throw new GenericException("Session is not ready");
        }
        ITransportSession sess = null;
        try {
            String connect;
            block23: {
                block22: {
                    connect = this.mServiceName;
                    if (!"trading".equals(this.mHost.getHostType())) break block22;
                    connect = this.mHost.getAttribute("subid");
                    if (connect == null) {
                        connect = this.mHost.getName();
                    }
                    if (!this.moLogger.isDebugEnabled()) break block23;
                    this.moLogger.debug("Use trading host:'" + connect + "'");
                    break block23;
                }
                if ("global".equals(this.mHost.getHostType())) {
                    if (this.moLogger.isDebugEnabled()) {
                        this.moLogger.debug("skip globla host:'" + this.mHost.getName() + "' look for a first trading");
                    }
                    for (HostElement hostElement : this.mHostDesc.mHostList.getActiveHosts()) {
                        if (!"trading".equals(hostElement.getHostType())) continue;
                        this.mHost = hostElement;
                        connect = this.mHost.getAttribute("subid");
                        if (connect == null) {
                            connect = this.mHost.getName();
                        }
                        if (!this.moLogger.isDebugEnabled()) break;
                        this.moLogger.debug("HostDesc has no TSS correctly defined: use first one '" + connect + "'");
                        break;
                    }
                }
            }
            sess = this.getValidSession();
            this.updateStatus(4, 1);
            this.sendStatusUpdate();
            if (this.moLogger.isDebugEnabled()) {
                this.moLogger.debug("HostDesc has no TSS correctly defined: sess.retrieveSessionDescriptions for " + connect + " " + this.mLoginID);
            }
            if ((ret = sess.retrieveTradingSessions(connect, this.mLoginID, null)) == null || ret.length == 0) {
                sess.close();
            } else if (this.moLogger.isDebugEnabled()) {
                this.moLogger.debug("sess.retrieveSessionDescriptions:" + this.mServiceName + ":" + ret.length);
            }
        }
        catch (Exception e) {
            if (sess != null) {
                try {
                    this.setTradingSession(null);
                    sess.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.updateStatus(-2, 4);
            this.sendStatusUpdate();
            this.updateStatus(7, 0);
            this.sendStatusUpdate();
            if (e instanceof GenericException) {
                throw (GenericException)e;
            }
            throw new GenericException(e.getMessage());
        }
        this.updateStatus(7, 0);
        this.sendStatusUpdate();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean open(String aExtraParams) throws GenericException {
        boolean ret;
        this.mExtraParams = aExtraParams;
        this.mParameters.putAll((Map<?, ?>)Util.parseParams(this.mExtraParams));
        if (this.mTradingSession.getSubID() == null || this.mHost == null) {
            throw new GenericException("Session is not ready to be open");
        }
        if (!this.mEmpty) {
            this.close();
        }
        try {
            HostElement host = null;
            if (this.mHostDescriptorXML == null && this.mHostDesc != null) {
                this.mHostDescriptorXML = this.mHostDesc.getHostDescriptorXML();
            }
            if (this.mHostDescriptorXML == null) {
                this.mHostDesc = this.mHostReader.read(this.mHostDescriptorURL, this.mTradingSession.getSubID(), this.mStationName, this.mLoginID);
                if (this.mHostDesc != null) {
                    this.mHostDescriptorXML = this.mHostDesc.getHostDescriptorXML();
                }
            } else {
                this.mHostDesc = this.mHostReader.readFromXML(this.mHostDescriptorXML, this.mTradingSession.getSubID(), this.mStationName);
            }
            if (this.mHostDesc != null) {
                if (this.mTransportSession != null) {
                    this.mTransportSession = null;
                }
                if ((host = this.mHostDesc.get(this.mTradingSession.getSubID())) != null) {
                    this.mHost = host;
                    if (this.moLogger.isDebugEnabled()) {
                        this.moLogger.debug("original mTransportParams = " + this.mTransportParams);
                    }
                    this.mTransportParams = this.createConParams();
                    if (this.moLogger.isDebugEnabled()) {
                        this.moLogger.debug("reset mTransportParams = " + this.mTransportParams);
                    }
                }
            }
        }
        catch (GenericException host) {
            // empty catch block
        }
        this.updateStatus(1, 9);
        this.sendStatusUpdate();
        boolean attachKind = false;
        ITransportSession sess = null;
        try {
            String sid;
            sess = this.getValidSession();
            sess.addMessageListener(this.mListener);
            sess.addSessionStatusListener(this.mListener);
            if (this.mSsoToken != null) {
                attachKind = true;
                sid = sess.logonSso(this.mServiceName, this.getTransmitTsID(), this.getTransmitTsSubID(), this.mLoginID, this.mSsoToken, this.mStationName, this.mExtraParams);
                ret = sid != null;
            } else {
                if (this.mExtraParams != null) {
                    attachKind = this.mExtraParams.indexOf("SID=") >= 0;
                }
                ret = (sid = sess.logon(this.mServiceName, this.getTransmitTsID(), this.getTransmitTsSubID(), this.mLoginID, this.mPasswordDigest, this.mStationName, this.mExtraParams)) != null;
            }
        }
        catch (Exception e) {
            if (sess != null) {
                try {
                    this.setTradingSession(null);
                    sess.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.updateStatus(-2, 11);
            this.sendStatusUpdate();
            this.updateStatus(-1, 11);
            this.sendStatusUpdate();
            if (e instanceof GenericException) {
                throw (GenericException)e;
            }
            throw new GenericException(e.getMessage(), e);
        }
        if (ret) {
            this.mEmpty = false;
            UniversalUserSession universalUserSession = this;
            synchronized (universalUserSession) {
                this.mStop = false;
            }
            this.updateStatus(sess.getCurrentStatus());
            this.updateStatus(6, 12);
            boolean bl = this.mReloginAllowed = !attachKind;
            while (!this.mLogonSucceed) {
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {}
            }
        } else {
            try {
                this.setTradingSession(null);
                sess.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updateStatus(-1, 11);
        }
        this.sendStatusUpdate();
        return ret;
    }

    @Override
    public boolean open() throws GenericException {
        return this.open(null);
    }

    @Override
    public String getSessionID() {
        String ret = null;
        ITransportSession sess = this.getTransportSession();
        if (sess != null) {
            ret = sess.getSessionID();
        }
        return ret;
    }

    @Override
    public boolean isValid() {
        boolean ret = false;
        ITransportSession sess = this.getTransportSession();
        if (sess != null) {
            ret = sess.isValid();
        }
        return ret;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.mStop;
    }

    @Override
    public int getUserKind() {
        int ret = 0;
        ITransportSession sess = this.getTransportSession();
        if (sess != null) {
            ret = sess.getUserKind();
        }
        return ret;
    }

    @Override
    public int getUserID() {
        int ret = 0;
        ITransportSession sess = this.getTransportSession();
        if (sess != null) {
            ret = sess.getUserID();
        }
        return ret;
    }

    @Override
    public synchronized boolean setMessageListener(IUserMessageListener aListener) {
        this.mClientMessageListeners.add(aListener);
        return true;
    }

    @Override
    public synchronized boolean setMessageListener(IUserTransportableListener aListener) {
        this.mClientMessageListeners.add(aListener);
        return true;
    }

    @Override
    public synchronized void removeMessageListener(IUserMessageListener aListener) {
        this.mClientMessageListeners.remove(aListener);
    }

    @Override
    public synchronized void removeMessageListener(IUserTransportableListener aListener) {
        this.mClientMessageListeners.remove(aListener);
    }

    @Override
    public synchronized boolean setSessionStatusListener(IUserSessionStatusListener aListener) {
        this.mClientStatusListeners.add(aListener);
        return true;
    }

    @Override
    public synchronized void removeSessionStatusListener(IUserSessionStatusListener aListener) {
        this.mClientStatusListeners.remove(aListener);
    }

    @Override
    public ISessionStatus getCurrentStatus() {
        return new GenericSessionStatus(this.mStatus);
    }

    @Override
    public void force() {
        ITransportSession sess = this.getTransportSession();
        if (sess != null) {
            sess.force();
        }
    }

    @Override
    public String send(IMessage aMessage) throws GenericException {
        ITransportSession sess;
        if (aMessage == null) {
            return "Error:NoMessage";
        }
        if ("U54.Batch.Req".equals(aMessage.getMsgType())) {
            IFieldGroupList fgl = aMessage.getValueList("9036");
            if (fgl != null) {
                List<IFieldGroup> fields = fgl.getFields();
                String cmd = "";
                for (int i = 0; i < fields.size(); ++i) {
                    IFieldGroup fg = fields.get(i);
                    if (i == 0) {
                        cmd = fg.getValueString("9028");
                        if (cmd != null) continue;
                        throw new GenericException("No FXCMCommandID specified in first message of BatchRequest");
                    }
                    if (cmd.equals(fg.getValueString("9028"))) continue;
                    throw new GenericException("Different FXCMCommandIDs in a single BatchRequest is unsupported");
                }
            }
        } else if (this.mSsoTokenKey != null) {
            String pwd;
            int cmd;
            if ("U54".equals(aMessage.getMsgType())) {
                String cmd2 = aMessage.getValueString("9028");
                if ("39".equals(cmd2)) {
                    String pwd2;
                    IFieldGroup pwdGroup = null;
                    IFieldGroupList fgl = aMessage.getValueList("9016");
                    if (fgl != null) {
                        for (IFieldGroup fg : fgl.values()) {
                            if (!"Psw".equalsIgnoreCase(fg.getValueString("9017"))) continue;
                            pwdGroup = fg;
                            break;
                        }
                    }
                    if (pwdGroup != null && (pwd2 = pwdGroup.getValueString("9018")) != null && pwd2.length() > 0) {
                        this.mChangingPassword = pwd2;
                        String ot = this.encrypt(pwd2);
                        if (ot != null && !ot.equals(pwd2)) {
                            pwdGroup.setValue("9017", "EncrPsw");
                            pwdGroup.setValue("9018", ot);
                        }
                    }
                }
            } else if ("BE".equals(aMessage.getMsgType()) && (cmd = aMessage.getValueInt("924")) == 3 && (pwd = aMessage.getValueString("925")) != null && pwd.length() > 0) {
                this.mChangingPassword = pwd;
                String ot = this.encrypt(pwd);
                if (ot != null && !ot.equals(pwd)) {
                    aMessage.setValue("925", "");
                    aMessage.setValue("1404", ot);
                }
            }
        }
        if (this.mTraceMessageLogger.isTraceEnabled()) {
            this.mTraceMessageLogger.trace("out >>> " + FixObjectFactory.toObject(aMessage));
        }
        String ret = (sess = this.getTransportSession()) != null ? sess.postMessage(aMessage) : "Error:NoSessionOpen";
        return ret;
    }

    @Override
    public String getNextRequestID() throws GenericException {
        ITransportSession sess = this.getTransportSession();
        if (sess == null) {
            throw new GenericException("No session open");
        }
        String ret = sess.getNextRequestID();
        return ret;
    }

    @Override
    public Object getParameter(String aName) {
        String ret = null;
        ret = "ServiceName".equalsIgnoreCase(aName) ? this.mServiceName : this.mParameters.getProperty(aName);
        if (ret == null && this.getTransportSession() != null) {
            ret = this.getTransportSession().getParameter(aName);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        boolean stopped;
        UniversalUserSession universalUserSession = this;
        synchronized (universalUserSession) {
            stopped = this.mStop;
        }
        if (!stopped) {
            universalUserSession = this;
            synchronized (universalUserSession) {
                this.mStop = true;
                this.notifyAll();
            }
            Thread.yield();
            ITransportSession sess = this.getTransportSession();
            if (sess != null) {
                this.setTransportSession(null);
                try {
                    sess.logout();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    sess.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sess.removeMessageListener(this.mListener);
                sess.removeSessionStatusListener(this.mListener);
            }
        }
        this.mTransportSession = null;
        this.mTransportProvider = null;
        this.mSsoTokenKey = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attach(String aSessionID, String aExtraParams) throws GenericException {
        if (!this.mEmpty) {
            this.close();
        }
        this.mExtraParams = aExtraParams;
        this.mParameters.putAll((Map<?, ?>)Util.parseParams(this.mExtraParams));
        ITransportSession sess = this.getValidSession();
        sess.addMessageListener(this.mListener);
        sess.addSessionStatusListener(this.mListener);
        boolean ret = true;
        try {
            if (!(sess instanceof ITransportSessionEx)) {
                throw new GenericException("attach is not supported by transport provider");
            }
            ITransportSessionEx sessEx = (ITransportSessionEx)sess;
            ret = sessEx.attach(aSessionID, this.getTransmitTsID(), this.getTransmitTsSubID(), this.mStationName, this.mExtraParams);
        }
        catch (Exception e) {
            if (sess != null) {
                try {
                    this.setTradingSession(null);
                    sess.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.updateStatus(-2, 11);
            this.sendStatusUpdate();
            this.updateStatus(-1, 11);
            this.sendStatusUpdate();
            if (e instanceof GenericException) {
                throw (GenericException)e;
            }
            throw new GenericException(e.getMessage(), e);
        }
        if (ret) {
            this.mEmpty = false;
            UniversalUserSession universalUserSession = this;
            synchronized (universalUserSession) {
                this.mStop = false;
            }
            this.updateStatus(sess.getCurrentStatus());
            this.updateStatus(6, 12);
            this.mReloginAllowed = false;
        } else {
            try {
                this.setTradingSession(null);
                sess.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updateStatus(-1, 11);
        }
        this.sendStatusUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStatus(int aStatusCode, int aStatusMsgID) {
        GenericSessionStatus genericSessionStatus = this.mStatus;
        synchronized (genericSessionStatus) {
            this.mStatus.setStatusCode(aStatusCode);
            this.mStatus.setStatusName(GenericSessionStatus.getStatusName(aStatusCode));
            this.mStatus.setStatusMessageID(aStatusMsgID);
            this.mStatus.setStatusMessage(GenericSessionStatus.getStatusMessage(aStatusMsgID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStatus(ISessionStatus aState) {
        GenericSessionStatus genericSessionStatus = this.mStatus;
        synchronized (genericSessionStatus) {
            this.mStatus.setConnectionName(aState.getConnectionName());
            this.mStatus.setProtocolName(aState.getProtocolName());
            this.mStatus.setSecureProtocolString(aState.getSecureProtocolString());
            this.mStatus.setStatusCode(aState.getStatusCode());
            this.mStatus.setStatusName(aState.getStatusName());
            this.mStatus.setStatusMessageID(aState.getStatusMessageID());
            this.mStatus.setStatusMessage(aState.getStatusMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendStatusUpdate() {
        Vector lstr;
        GenericSessionStatus toSend = new GenericSessionStatus(this.mStatus);
        UniversalUserSession universalUserSession = this;
        synchronized (universalUserSession) {
            lstr = (Vector)this.mClientStatusListeners.clone();
        }
        if (this.mTraceStatusLogger.isTraceEnabled()) {
            this.mTraceStatusLogger.trace("\n" + toSend);
        }
        Enumeration en = lstr.elements();
        while (en.hasMoreElements()) {
            ((IUserSessionStatusListener)en.nextElement()).update(this, toSend);
        }
        lstr.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendToUser(IMessage aMsg) {
        if (aMsg != null) {
            Vector lstr;
            UniversalUserSession universalUserSession = this;
            synchronized (universalUserSession) {
                lstr = (Vector)this.mClientMessageListeners.clone();
            }
            if ("W".equals(aMsg.getMsgType())) {
                if (this.mTraceMarketDataLogger.isTraceEnabled()) {
                    this.mTraceMarketDataLogger.trace("inc <<< " + FixObjectFactory.toObject(aMsg));
                }
            } else if (this.mTraceMessageLogger.isTraceEnabled()) {
                this.mTraceMessageLogger.trace("inc <<< " + FixObjectFactory.toObject(aMsg));
            }
            Enumeration en = lstr.elements();
            while (en.hasMoreElements()) {
                Object obj = en.nextElement();
                if (obj instanceof IUserMessageListener) {
                    ((IUserMessageListener)obj).update(this, aMsg);
                    continue;
                }
                if (!(obj instanceof IUserTransportableListener)) continue;
                ((IUserTransportableListener)obj).update(this, FixObjectFactory.toObject(aMsg));
            }
            lstr.clear();
        }
    }

    private String encrypt(String aToEncrypt) {
        String ret = aToEncrypt;
        if (aToEncrypt != null && this.mSsoTokenKey != null) {
            try {
                ret = CryptUtils.encrypt(ret, this.mSsoTokenKey);
            }
            catch (Exception e) {
                this.moLogger.error("", e);
                ret = aToEncrypt;
            }
        }
        return ret;
    }

    protected void finalize() {
        this.close();
        this.mClientStatusListeners.clear();
        this.mClientMessageListeners.clear();
    }

    protected void onRelogSuccess() throws GenericException {
    }

    public void updateMessageHook(IMessage aMessage) throws GenericException {
        this.sendToUser(aMessage);
    }

    protected class Listener
    implements IMessageListener,
    ISessionStatusListener {
        private final UniversalUserSession mSession;
        private int mLastMsgNo;
        private boolean mListenAdminMessages;

        Listener(UniversalUserSession aSession) {
            this.mSession = aSession;
            this.mLastMsgNo = 0;
            this.mListenAdminMessages = this.mSession.getBooleanProperty("com.fxcm.messaging.IConnectionManager.AdminMessages", false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(IMessage aMessage) {
            String msgType = aMessage.getMsgType();
            UniversalUserSession universalUserSession = this.mSession;
            synchronized (universalUserSession) {
                this.mSession.mLastActivity = new Date().getTime();
            }
            if ("U54.Batch".equals(aMessage.getMsgType()) && aMessage.getValueInt("9073") <= 0) {
                IFieldGroupList gl = aMessage.getValueList("9036");
                if (UniversalUserSession.this.moLogger.isDebugEnabled()) {
                    UniversalUserSession.this.moLogger.debug("List messages recieved " + gl);
                }
                if (gl != null) {
                    for (IFieldGroup fg : gl.values()) {
                        UniversalMessage embMsg = new UniversalMessage(fg);
                        if (UniversalUserSession.this.moLogger.isDebugEnabled()) {
                            UniversalUserSession.this.moLogger.debug("create message from batch " + embMsg);
                        }
                        this.update(embMsg);
                    }
                    return;
                }
            }
            if ("1".equals(msgType)) {
                try {
                    ITransportable fixObj = FixObjectFactory.toObject(aMessage);
                    fixObj = new Heartbeat(((TestRequest)fixObj).getTestReqID());
                    UniversalUserSession.this.send(fixObj.toMessage(UniversalUserSession.this.getSessionID(), this.mSession.getMessageFactory()));
                }
                catch (Exception fixObj) {}
            } else if ("BF".equals(msgType)) {
                int requestCode = aMessage.getValueInt("924");
                int userStatus = aMessage.getValueInt("926");
                boolean doLogonSucceed = false;
                switch (requestCode) {
                    case 0: 
                    case 1: {
                        if (userStatus != 1) break;
                        doLogonSucceed = true;
                        this.lookForSsoTokenKey(aMessage);
                        break;
                    }
                    case 9: {
                        if (userStatus != 1) break;
                        this.decryptTokenKey(aMessage);
                        break;
                    }
                    case 3: {
                        String salt;
                        if (userStatus == 5 && UniversalUserSession.this.mChangingPassword != null && (salt = aMessage.getValueString("927")) != null) {
                            UniversalUserSession.this.mPasswordDigest = UniversalUserSession.this.digestPassword(UniversalUserSession.this.mChangingPassword, salt);
                            aMessage.setValue("927", "OK");
                        }
                        UniversalUserSession.this.mChangingPassword = null;
                        break;
                    }
                }
                try {
                    UniversalUserSession.this.updateMessageHook(aMessage);
                    if (doLogonSucceed) {
                        UniversalUserSession.this.mLogonSucceed = true;
                    }
                }
                catch (Exception e) {
                    UniversalUserSession.this.moLogger.error("we got a problem in message hook, moving on.", e);
                }
            } else {
                int cmd;
                if ("0".equals(msgType) && !this.mListenAdminMessages) {
                    UniversalUserSession.this.mTraceMessageLogger.trace("inc <<< " + FixObjectFactory.toObject(aMessage));
                    return;
                }
                if ("U52".equals(msgType)) {
                    int cmd2 = aMessage.getValueInt("9028");
                    if (cmd2 == 39 && UniversalUserSession.this.mChangingPassword != null) {
                        UniversalUserSession.this.mChangingPassword = null;
                    }
                } else if ("U55".equals(msgType) && (cmd = aMessage.getValueInt("9028")) == 39 && UniversalUserSession.this.mChangingPassword != null) {
                    String das;
                    IFieldGroup dasGroup = null;
                    IFieldGroupList fgl = aMessage.getValueList("9016");
                    if (fgl != null) {
                        for (IFieldGroup fg : fgl.values()) {
                            if (!"DAS".equalsIgnoreCase(fg.getValueString("9017"))) continue;
                            dasGroup = fg;
                            break;
                        }
                    }
                    if (dasGroup != null && (das = dasGroup.getValueString("9018")) != null) {
                        String[] rows = Util.splitToArray(das, "\n");
                        if (rows.length > 0) {
                            das = rows[1];
                        }
                        UniversalUserSession.this.mPasswordDigest = UniversalUserSession.this.digestPassword(UniversalUserSession.this.mChangingPassword, das);
                        dasGroup.setValue("9018", "OK");
                    }
                    UniversalUserSession.this.mChangingPassword = null;
                }
                try {
                    UniversalUserSession.this.updateMessageHook(aMessage);
                }
                catch (Exception e) {
                    UniversalUserSession.this.moLogger.error("we got a problem in message hook, moving on.", e);
                }
                int msgNo = aMessage.getValueInt("34");
                if (msgNo != 0) {
                    int msgNoTest;
                    UniversalUserSession universalUserSession2 = this.mSession;
                    synchronized (universalUserSession2) {
                        msgNoTest = this.mLastMsgNo;
                    }
                    if (msgNoTest > 0 && ++msgNoTest != msgNo) {
                        if (UniversalUserSession.this.moLogger.isDebugEnabled()) {
                            UniversalUserSession.this.moLogger.debug("Message sequence destroyed: instead of " + this.mLastMsgNo + " we have " + msgNo);
                        }
                        this.mSession.updateStatus(-2, 18);
                        this.mSession.sendStatusUpdate();
                        this.mSession.updateStatus(6, 18);
                        this.mSession.sendStatusUpdate();
                    }
                    universalUserSession2 = this.mSession;
                    synchronized (universalUserSession2) {
                        this.mLastMsgNo = msgNo;
                    }
                }
            }
        }

        private void lookForSsoTokenKey(IMessage aMessage) {
            IFieldGroupList grList = aMessage.getValueList("9016");
            if (grList != null) {
                IFieldGroup tokenKeyGr = null;
                for (IFieldGroup gr : grList.values()) {
                    String paramName = gr.getValueString("9017");
                    String paramValue = gr.getValueString("9018");
                    if (paramName == null || paramValue == null || !"TokenKey".equalsIgnoreCase(paramName)) continue;
                    UniversalUserSession.this.mSsoTokenKey = paramValue;
                    tokenKeyGr = gr;
                    break;
                }
                if (tokenKeyGr != null) {
                    tokenKeyGr.setValue("9018", "-");
                    tokenKeyGr.setValue("9017", "-");
                }
            }
        }

        private void decryptTokenKey(IMessage aMessage) {
            String userText = aMessage.getValueString("927");
            String userText2 = null;
            int userStatus = 1;
            if (userText != null) {
                String[] rows = Util.splitToArray(userText, "\n");
                userText = rows[0];
                userText2 = rows[0];
                if (UniversalUserSession.this.mSsoTokenKey != null) {
                    try {
                        userText = CryptUtils.decrypt(userText, UniversalUserSession.this.mSsoTokenKey);
                    }
                    catch (Exception e) {
                        userStatus = 6;
                        userText = e.getMessage();
                        UniversalUserSession.this.moLogger.error("tokenKey'=" + UniversalUserSession.this.mSsoTokenKey + "';userText='" + userText2 + "'", e);
                        e.printStackTrace();
                    }
                }
            } else {
                userStatus = 6;
                userText = "no token key recieved";
            }
            aMessage.setValue("926", userStatus);
            aMessage.setValue("927", userText);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(ISessionStatus aNewStatus) {
            if (aNewStatus != null) {
                if (aNewStatus.getStatusCode() == -1) {
                    boolean needTo;
                    boolean skip;
                    UniversalUserSession universalUserSession = this.mSession;
                    synchronized (universalUserSession) {
                        this.mLastMsgNo = 0;
                        skip = this.mSession.mUnderRelogin;
                        needTo = this.mSession.mReloginAllowed && !this.mSession.mUnderRelogin && !this.mSession.mStop;
                    }
                    if (needTo) {
                        UniversalUserSession.this.moLogger.debug("UserSession.Listener.Disconnected. Run relogger");
                        new Relogger(this.mSession, aNewStatus).start();
                        return;
                    }
                    if (skip) {
                        return;
                    }
                    if (!this.mSession.mStop) {
                        this.mSession.close();
                    }
                }
                this.mSession.updateStatus(aNewStatus);
                this.mSession.sendStatusUpdate();
            }
        }
    }

    private class Relogger
    implements Runnable {
        private final UniversalUserSession mSession;
        private ISessionStatus mSessionStatus;

        Relogger(UniversalUserSession aSession, ISessionStatus aDisconnectedStatus) {
            this.mSession = aSession;
            if (aDisconnectedStatus != null) {
                this.mSessionStatus = new GenericSessionStatus((GenericSessionStatus)aDisconnectedStatus);
            }
        }

        public void start() {
            new Thread((Runnable)this, "UniversalUserSessionRelogger").start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean needToExit = false;
            UniversalUserSession universalUserSession = this.mSession;
            synchronized (universalUserSession) {
                needToExit |= !this.mSession.mReloginAllowed;
                needToExit |= this.mSession.mStop;
                if (!(needToExit |= this.mSession.mUnderRelogin)) {
                    this.mSession.mUnderRelogin = true;
                }
            }
            if (needToExit) {
                UniversalUserSession.this.moLogger.debug("UserSession.Relogger not alowed to relogin; exit");
            } else {
                ITransportSession sess = null;
                boolean success = false;
                try {
                    int numberReloginAttempts = (int)this.mSession.getLongProperty("com.fxcm.messaging.IConnectionManager.NoReloginAttempts", 3L);
                    for (int i = 0; i < numberReloginAttempts; ++i) {
                        long timeToWait;
                        if (sess != null) {
                            UniversalUserSession.this.moLogger.debug("UserSession.Relogger.Close bad session before continue");
                            try {
                                sess.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            sess = null;
                        }
                        UniversalUserSession universalUserSession2 = this.mSession;
                        synchronized (universalUserSession2) {
                            needToExit = this.mSession.mStop;
                            timeToWait = this.mSession.getLongProperty("com.fxcm.messaging.IConnectionManager.ReloginTimeout", 2000L) - (new Date().getTime() - this.mSession.mLastActivity);
                            if (timeToWait <= 0L) {
                                timeToWait = 100L;
                            }
                            sess = this.mSession.getTransportSession();
                            this.mSession.setTransportSession(null);
                        }
                        if (needToExit) {
                            UniversalUserSession.this.moLogger.debug("UserSession.Relogger got signal to stop. exit");
                            break;
                        }
                        if (sess != null) {
                            UniversalUserSession.this.moLogger.debug("UserSession.Relogger.logging out");
                            sess.removeMessageListener(this.mSession.mListener);
                            sess.removeSessionStatusListener(this.mSession.mListener);
                            try {
                                sess.logout();
                            }
                            catch (Exception e) {
                                UniversalUserSession.this.moLogger.debug("", e);
                            }
                            try {
                                sess.close();
                            }
                            catch (Exception e) {
                                UniversalUserSession.this.moLogger.debug("", e);
                            }
                            sess = null;
                        }
                        if (UniversalUserSession.this.moLogger.isDebugEnabled()) {
                            UniversalUserSession.this.moLogger.debug("UserSession.Relogger wait to relogin = " + timeToWait);
                        }
                        this.mSession.updateStatus(-1, 14);
                        this.mSession.sendStatusUpdate();
                        this.mSession.updateStatus(7, 9);
                        this.mSession.sendStatusUpdate();
                        UniversalUserSession e = this.mSession;
                        synchronized (e) {
                            try {
                                this.mSession.wait(timeToWait);
                            }
                            catch (Exception e2) {
                                UniversalUserSession.this.moLogger.debug("", e2);
                            }
                            needToExit = this.mSession.mStop;
                            if (!needToExit) {
                                this.mSession.mLastActivity = new Date().getTime();
                            }
                        }
                        if (UniversalUserSession.this.moLogger.isDebugEnabled()) {
                            UniversalUserSession.this.moLogger.debug("UserSession.Relogger getting to relogin, " + timeToWait + " needToExit = " + needToExit);
                        }
                        if (needToExit) {
                            UniversalUserSession.this.moLogger.debug("UserSession.Relogger got signal to stop. exit");
                            break;
                        }
                        try {
                            this.mSession.mSsoTokenKey = null;
                            if (UniversalUserSession.this.moLogger.isDebugEnabled()) {
                                UniversalUserSession.this.moLogger.debug("Relogger.opening session " + (i + 1) + " of " + numberReloginAttempts);
                            }
                            this.mSession.updateStatus(1, 9);
                            this.mSession.sendStatusUpdate();
                            sess = this.mSession.openTransportSession();
                            sess.addMessageListener(this.mSession.mListener);
                            sess.addSessionStatusListener(this.mSession.mListener);
                            success = this.relogin(sess);
                            if (!success) continue;
                            e = this.mSession;
                            synchronized (e) {
                                this.mSession.setTransportSession(sess);
                                this.mSession.mUnderRelogin = false;
                                this.mSession.notifyAll();
                            }
                            this.mSession.updateStatus(sess.getCurrentStatus());
                            this.mSession.updateStatus(6, 12);
                            this.mSession.sendStatusUpdate();
                            sess = null;
                            UniversalUserSession.this.onRelogSuccess();
                            break;
                        }
                        catch (Exception e2) {
                            if (!UniversalUserSession.this.moLogger.isDebugEnabled()) continue;
                            UniversalUserSession.this.moLogger.debug("UserSession.Relogger.Exception catched " + e2.getMessage() + ". continue", e2);
                        }
                    }
                }
                finally {
                    if (sess != null) {
                        UniversalUserSession.this.moLogger.debug("UserSession.Relogger.Close bad session before stop");
                        try {
                            sess.close();
                        }
                        catch (Exception numberReloginAttempts) {}
                    }
                    if (!success && this.mSessionStatus != null) {
                        try {
                            Vector lstr;
                            this.mSession.close();
                            UniversalUserSession.this.moLogger.debug("UserSession.Relogger.Notify clients about disconnect");
                            UniversalUserSession i = this.mSession;
                            synchronized (i) {
                                lstr = (Vector)UniversalUserSession.this.mClientStatusListeners.clone();
                            }
                            Enumeration en = lstr.elements();
                            while (en.hasMoreElements()) {
                                ((IUserSessionStatusListener)en.nextElement()).update(this.mSession, this.mSessionStatus);
                            }
                            lstr.clear();
                            this.mSessionStatus = null;
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            UniversalUserSession.this.moLogger.debug("UserSession.Relogger.Getting out");
        }

        private boolean relogin(ITransportSession aSess) throws GenericException {
            String sid = aSess.logon(this.mSession.mServiceName, UniversalUserSession.this.getTransmitTsID(), UniversalUserSession.this.getTransmitTsSubID(), this.mSession.mLoginID, this.mSession.mPasswordDigest, this.mSession.mStationName, this.mSession.mExtraParams);
            if (UniversalUserSession.this.moLogger.isDebugEnabled()) {
                if (sid != null) {
                    UniversalUserSession.this.moLogger.debug("UserSession.Relogger.Session opened with SID = " + sid);
                } else {
                    UniversalUserSession.this.moLogger.debug("UserSession.Relogger.Session opening returns null. Continue");
                }
            }
            return sid != null;
        }
    }
}

