/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util;

import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.util.UniversalFieldGroup;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.WeakHashMap;

public class UniversalFieldGroupList
extends ArrayList<IFieldGroup>
implements IFieldGroupList,
Externalizable {
    private static final long serialVersionUID = 8685172194447836115L;
    private WeakHashMap mIteratorMap;

    public UniversalFieldGroupList() {
    }

    public UniversalFieldGroupList(int capacity) {
        super(capacity);
    }

    public UniversalFieldGroupList(IFieldGroupList aGroupList) {
        super(aGroupList == null ? 2 : aGroupList.size());
        if (aGroupList != null) {
            for (IFieldGroup gr : aGroupList.values()) {
                this.put(new UniversalFieldGroup(gr));
            }
        }
    }

    @Override
    public void put(IFieldGroup aGroup) {
        this.add(aGroup);
    }

    public List getFields() {
        return new ArrayList<IFieldGroup>(this);
    }

    public Collection values() {
        return this;
    }

    @Override
    public IFieldGroup getFirst() {
        Object nextObject = null;
        if (this.mIteratorMap == null) {
            this.mIteratorMap = new WeakHashMap();
        }
        ListIterator iterator = this.listIterator();
        this.mIteratorMap.put(Thread.currentThread(), iterator);
        if (iterator.hasNext()) {
            nextObject = iterator.next();
        }
        if (nextObject == null) {
            this.mIteratorMap.remove(Thread.currentThread());
        }
        return nextObject;
    }

    @Override
    public IFieldGroup getNext() {
        IFieldGroup nextObject = null;
        Iterator iterator = null;
        if (this.mIteratorMap != null) {
            iterator = (Iterator)this.mIteratorMap.get(Thread.currentThread());
        }
        if (iterator != null) {
            if (iterator.hasNext()) {
                nextObject = iterator.next();
            }
            if (nextObject == null) {
                this.mIteratorMap.remove(Thread.currentThread());
            }
        } else {
            nextObject = this.getFirst();
        }
        return nextObject;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        int i = 0;
        ListIterator li = this.listIterator();
        while (li.hasNext()) {
            ret.append(++i).append(":\t").append(li.next()).append("\n");
        }
        return ret.toString();
    }

    @Override
    public void readExternal(ObjectInput aObjectInput) throws IOException, ClassNotFoundException {
        int size = aObjectInput.readInt();
        this.clear();
        for (int i = 0; i < size; ++i) {
            UniversalFieldGroup ufg = new UniversalFieldGroup();
            ufg.readExternal(aObjectInput);
            this.add(ufg);
        }
    }

    @Override
    public void writeExternal(ObjectOutput aObjectOutput) throws IOException {
        aObjectOutput.writeInt(this.size());
        for (int i = 0; i < this.size(); ++i) {
            UniversalFieldGroup fg = (UniversalFieldGroup)this.get(i);
            fg.writeExternal(aObjectOutput);
        }
    }
}

