/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util;

import com.fxcm.messaging.IField;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.util.UniversalField;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class UniversalFieldGroup
extends HashMap<String, IField>
implements IFieldGroup,
Externalizable {
    private static final long serialVersionUID = -6548334081567575950L;
    private WeakHashMap mIteratorMap;
    private static double cLoadFactor = 0.75;

    public UniversalFieldGroup() {
        super(16);
    }

    public UniversalFieldGroup(int aSize) {
        super(1 + (int)((double)aSize / cLoadFactor));
    }

    public UniversalFieldGroup(IFieldGroup aGroup) {
        this(aGroup == null ? 16 : aGroup.size());
        if (aGroup != null) {
            for (IField field : aGroup.values()) {
                this.putField(field);
            }
        }
    }

    @Override
    public void setValue(String aName, String aValue) {
        this.put(aName, new UniversalField(aName, aValue));
    }

    @Override
    public String getValueString(String aName) {
        String ret = null;
        IField fld = (IField)this.get(aName);
        if (fld != null) {
            ret = fld.getValueString();
        }
        return ret;
    }

    @Override
    public void setValue(String aName, double aValue) {
        this.put(aName, new UniversalField(aName, aValue));
    }

    @Override
    public double getValueDouble(String aName) {
        double ret = 0.0;
        IField fld = (IField)this.get(aName);
        if (fld != null) {
            ret = fld.getValueDouble();
        }
        return ret;
    }

    @Override
    public long getValueLong(String aName) {
        long ret = 0L;
        IField fld = (IField)this.get(aName);
        if (fld != null) {
            ret = fld.getValueLong();
        }
        return ret;
    }

    @Override
    public void setValue(String aName, int aValue) {
        this.put(aName, new UniversalField(aName, aValue));
    }

    @Override
    public void setValue(String aName, long aValue) {
        this.put(aName, new UniversalField(aName, aValue));
    }

    @Override
    public int getValueInt(String aName) {
        int ret = 0;
        IField fld = (IField)this.get(aName);
        if (fld != null) {
            ret = fld.getValueInt();
        }
        return ret;
    }

    @Override
    public void setValue(String aName, IFieldGroupList aValue) {
        UniversalField field = new UniversalField(aName, (IFieldGroupList)null);
        field.setValue(aValue);
        this.put(aName, field);
    }

    @Override
    public IFieldGroupList getValueList(String aName) {
        IFieldGroupList ret = null;
        IField fld = (IField)this.get(aName);
        if (fld != null) {
            ret = fld.getValueList();
        }
        return ret;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        for (String key : this.keySet()) {
            IField value = (IField)this.get(key);
            ret.append(value).append(";");
        }
        return ret.toString();
    }

    public List getFields() {
        return new ArrayList(this.values());
    }

    @Override
    public IField getFirst() {
        IField ret = null;
        Iterator iterator = this.values().iterator();
        if (this.mIteratorMap == null) {
            this.mIteratorMap = new WeakHashMap();
        }
        this.mIteratorMap.put(Thread.currentThread(), iterator);
        if (iterator.hasNext()) {
            ret = (IField)iterator.next();
        }
        if (ret == null) {
            this.mIteratorMap.remove(Thread.currentThread());
        }
        return ret;
    }

    @Override
    public IField getNext() {
        IField ret = null;
        Iterator iterator = null;
        if (this.mIteratorMap != null) {
            iterator = (Iterator)this.mIteratorMap.get(Thread.currentThread());
        }
        if (iterator != null) {
            if (iterator.hasNext()) {
                ret = (IField)iterator.next();
            }
            if (ret == null) {
                this.mIteratorMap.remove(Thread.currentThread());
            }
        } else {
            ret = this.getFirst();
        }
        return ret;
    }

    @Override
    public void putField(IField aField) {
        if (aField != null) {
            this.put(aField.getName(), new UniversalField(aField));
        }
    }

    @Override
    public IField getField(String aName) {
        return (IField)this.get(aName);
    }

    @Override
    public void setValue(String aName, byte[] aValue) {
        this.put(aName, new UniversalField(aName, aValue));
    }

    @Override
    public byte[] getValueBytes(String aName) {
        byte[] ret = null;
        UniversalField fld = (UniversalField)this.get(aName);
        if (fld != null) {
            ret = fld.getValueBytes();
        }
        return ret;
    }

    @Override
    public void readExternal(ObjectInput aObjectInput) throws IOException, ClassNotFoundException {
        int size = aObjectInput.readInt();
        for (int i = 0; i < size; ++i) {
            String key = aObjectInput.readUTF();
            UniversalField ufValue = new UniversalField();
            ufValue.readExternal(aObjectInput);
            this.put(key, ufValue);
        }
    }

    private static void writeString(ObjectOutput aObjectOutput, String aString) throws IOException {
        aObjectOutput.writeShort(aString.length());
        aObjectOutput.writeChars(aString);
    }

    @Override
    public void writeExternal(ObjectOutput aObjectOutput) throws IOException {
        aObjectOutput.writeInt(this.size());
        for (Map.Entry e : this.entrySet()) {
            aObjectOutput.writeUTF((String)e.getKey());
            UniversalField uf = (UniversalField)e.getValue();
            uf.writeExternal(aObjectOutput);
        }
    }
}

