/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util;

import com.fxcm.messaging.IField;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.util.UniversalFieldGroupList;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

public class UniversalField
implements IField,
Externalizable {
    public static final int DATATYPECODE_NONE = 0;
    public static final int DATATYPECODE_INT = 1;
    public static final int DATATYPECODE_STRING = 2;
    public static final int DATATYPECODE_LIST = 3;
    public static final int DATATYPECODE_DOUBLE = 4;
    public static final int DATATYPECODE_LONG = 5;
    IField.DataType mDataType = DATATYPE_NONE;
    Object mValue = null;
    String mName = null;
    private static final int DATATYPE_BYTES_CODE = DATATYPE_BYTES.getIntCode();
    private static final int DATATYPE_DOUBLE_CODE = DATATYPE_DOUBLE.getIntCode();
    private static final int DATATYPE_INT_CODE = DATATYPE_INT.getIntCode();
    private static final int DATATYPE_LONG_CODE = DATATYPE_LONG.getIntCode();
    private static final int DATATYPE_STRING_CODE = DATATYPE_STRING.getIntCode();
    private static final int DATATYPE_LIST_CODE = DATATYPE_LIST.getIntCode();

    public UniversalField() {
    }

    public void set(String aName, Object aValue) {
        this.mName = aName;
        this.setValue(aValue);
    }

    public UniversalField(String aName, String aValue) {
        this.mName = aName;
        this.setValue(aValue);
    }

    public UniversalField(String aName, long aValue) {
        this.mName = aName;
        this.setValue(aValue);
    }

    public UniversalField(String aName, int aValue) {
        this.mName = aName;
        this.setValue(aValue);
    }

    public UniversalField(String aName, double aValue) {
        this.mName = aName;
        this.setValue(aValue);
    }

    public UniversalField(String aName, IFieldGroupList aValue) {
        this.mName = aName;
        UniversalFieldGroupList value = null;
        if (aValue != null) {
            value = new UniversalFieldGroupList(aValue);
        }
        this.setValue(value);
    }

    public UniversalField(String aName, byte[] aValue) {
        this.mName = aName;
        this.setValue(aValue);
    }

    public UniversalField(IField aField) {
        this.set(aField);
    }

    @Override
    public IField.DataType getDatatype() {
        return this.mDataType;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean isNullValue() {
        return this.mValue == null;
    }

    @Override
    public String getValueString() {
        String ret = null;
        if (this.mValue != null) {
            switch (this.mDataType.getIntCode()) {
                case 1: 
                case 4: 
                case 5: {
                    ret = this.mValue.toString();
                    break;
                }
                case 2: {
                    ret = (String)this.mValue;
                }
            }
        }
        return ret;
    }

    @Override
    public int getValueInt() {
        int ret = 0;
        switch (this.mDataType.getIntCode()) {
            case 1: 
            case 4: 
            case 5: {
                ret = ((Number)this.mValue).intValue();
                break;
            }
            case 2: {
                try {
                    ret = Integer.parseInt((String)this.mValue);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    @Override
    public long getValueLong() {
        long ret = 0L;
        switch (this.mDataType.getIntCode()) {
            case 1: 
            case 4: 
            case 5: {
                ret = ((Number)this.mValue).longValue();
                break;
            }
            case 2: {
                try {
                    ret = Long.parseLong((String)this.mValue);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    @Override
    public double getValueDouble() {
        double ret = 0.0;
        switch (this.mDataType.getIntCode()) {
            case 1: 
            case 4: 
            case 5: {
                ret = ((Number)this.mValue).doubleValue();
                break;
            }
            case 2: {
                try {
                    ret = Double.parseDouble((String)this.mValue);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    @Override
    public IFieldGroupList getValueList() {
        IFieldGroupList ret = null;
        switch (this.mDataType.getIntCode()) {
            case 3: {
                ret = (IFieldGroupList)this.mValue;
            }
        }
        return ret;
    }

    @Override
    public void setName(String aName) {
        this.mName = aName;
    }

    @Override
    public void setValue(String aValue) {
        if (aValue == null) {
            return;
        }
        this.mDataType = DATATYPE_STRING;
        this.mValue = aValue;
    }

    @Override
    public void setValue(long aValue) {
        this.mDataType = DATATYPE_LONG;
        this.mValue = aValue;
    }

    @Override
    public void setValue(int aValue) {
        this.mDataType = DATATYPE_INT;
        this.mValue = aValue;
    }

    @Override
    public void setValue(double aValue) {
        this.mDataType = DATATYPE_DOUBLE;
        this.mValue = aValue;
    }

    @Override
    public void setValue(IFieldGroupList aValue) {
        if (aValue == null) {
            return;
        }
        this.mDataType = DATATYPE_LIST;
        this.mValue = aValue;
    }

    @Override
    public byte[] getValueBytes() {
        byte[] ret = null;
        if (this.mDataType == DATATYPE_BYTES) {
            ret = (byte[])this.mValue;
        }
        return ret;
    }

    @Override
    public void setValueBytes(byte[] aValue) {
        if (aValue == null) {
            return;
        }
        this.mDataType = DATATYPE_BYTES;
        this.mValue = aValue;
    }

    @Override
    public void set(IField aField) {
        if (aField == null) {
            return;
        }
        this.mDataType = DATATYPE_NONE;
        this.mName = null;
        this.mValue = null;
        if (aField != null) {
            this.mName = aField.getName();
            switch (aField.getDatatype().getIntCode()) {
                case 1: {
                    this.setValue(aField.getValueInt());
                    break;
                }
                case 2: {
                    this.setValue(aField.getValueString());
                    break;
                }
                case 3: {
                    this.setValue(aField.getValueList());
                    break;
                }
                case 4: {
                    this.setValue(aField.getValueDouble());
                    break;
                }
                case 5: {
                    this.setValue(aField.getValueLong());
                }
            }
        }
    }

    public String toString() {
        Object ret = "";
        if (DATATYPE_LIST.equals(this.mDataType)) {
            ret = this.mName + "=list\n--------\n";
            ret = (String)ret + this.mValue;
            ret = (String)ret + "--------";
        } else {
            ret = this.mName + "=" + this.mValue;
        }
        return ret;
    }

    public void setValue(Object aValue) {
        if (aValue == null) {
            return;
        }
        this.mDataType = DATATYPE_STRING;
        this.mValue = null;
        if (aValue != null) {
            if (aValue instanceof Integer) {
                this.setValue((Integer)aValue);
            } else if (aValue instanceof String) {
                String val = (String)aValue;
                this.setValue(val);
            } else if (aValue instanceof IFieldGroupList) {
                this.setValue((IFieldGroupList)aValue);
            } else if (aValue instanceof Double) {
                this.setValue((Double)aValue);
            } else if (aValue instanceof Long) {
                this.setValue((Long)aValue);
            } else if (aValue instanceof byte[]) {
                this.setValueBytes((byte[])aValue);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.mName = in.readUTF();
        int intCode = in.readInt();
        if (intCode == DATATYPE_BYTES.getIntCode()) {
            int length = in.readInt();
            byte[] buff = new byte[length];
            in.read(buff);
            this.setValueBytes(buff);
        } else if (intCode == DATATYPE_DOUBLE.getIntCode()) {
            this.setValue(in.readDouble());
        } else if (intCode == DATATYPE_INT.getIntCode()) {
            this.setValue(in.readInt());
        } else if (intCode == DATATYPE_LONG.getIntCode()) {
            this.setValue(in.readLong());
        } else if (intCode == DATATYPE_STRING.getIntCode()) {
            this.setValue(in.readUTF());
        } else if (intCode == DATATYPE_LIST.getIntCode()) {
            UniversalFieldGroupList gl = new UniversalFieldGroupList();
            gl.readExternal(in);
            this.setValue(gl);
        }
    }

    private static void writeString(ObjectOutput out, String s) throws IOException {
        out.writeShort(s.length());
        out.writeChars(s);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.mName);
        int intCode = this.mDataType.getIntCode();
        out.writeInt(intCode);
        if (intCode == DATATYPE_BYTES_CODE) {
            out.writeInt(((byte[])this.mValue).length);
            out.write((byte[])this.mValue);
        } else if (intCode == DATATYPE_DOUBLE_CODE) {
            out.writeDouble((Double)this.mValue);
        } else if (intCode == DATATYPE_INT_CODE) {
            out.writeInt((Integer)this.mValue);
        } else if (intCode == DATATYPE_LONG_CODE) {
            out.writeLong((Long)this.mValue);
        } else if (intCode == DATATYPE_STRING_CODE) {
            out.writeUTF((String)this.mValue);
        } else if (intCode == DATATYPE_LIST_CODE) {
            ((UniversalFieldGroupList)this.mValue).writeExternal(out);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniversalField that = (UniversalField)o;
        if (this.mDataType != null ? !this.mDataType.equals(that.mDataType) : that.mDataType != null) {
            return false;
        }
        if (this.mName != null ? !this.mName.equals(that.mName) : that.mName != null) {
            return false;
        }
        if (this.mDataType.equals(IField.DATATYPE_BYTES)) {
            return Arrays.equals((byte[])this.mValue, (byte[])that.mValue);
        }
        return !(this.mValue != null ? !this.mValue.equals(that.mValue) : that.mValue != null);
    }
}

