/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util;

import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.IUserSession;
import com.fxcm.messaging.TradingSessionDesc;
import com.fxcm.messaging.util.HostElement;
import com.fxcm.messaging.util.IConnectionManager;
import com.fxcm.messaging.util.UniversalUserSession;
import java.util.Properties;

public class UniversalConnectionManager
implements IConnectionManager {
    protected UniversalUserSession mLastUserSession;
    protected Properties mProperties;

    @Override
    public synchronized IMessageFactory getMessageFactory() {
        IMessageFactory ret = null;
        if (this.mLastUserSession != null) {
            ret = this.mLastUserSession.getMessageFactory();
        }
        return ret;
    }

    @Override
    public void setProperties(Properties aProperties) {
        this.mProperties = new Properties(aProperties);
    }

    @Override
    public synchronized IUserSession createUserSession(String aHostDescriptorURL, String aHostName, String aServiceName, String aTradingSessionID, String aTradingSessionSubID, String aLoginID, String aPassword, String aStationName) {
        String hostDescriptorXML = null;
        this.mLastUserSession = new UniversalUserSession(aHostDescriptorURL, hostDescriptorXML, aHostName, aServiceName, aTradingSessionID, aTradingSessionSubID, aLoginID, aPassword, null, aStationName, this.mProperties);
        return this.mLastUserSession;
    }

    @Override
    public IUserSession createUserSessionOpenToken(String aHostDescriptorURL, String aHostDescriptorXML, String aHostName, String aServiceName, String aTradingSessionID, String aTradingSessionSubID, String aOpenToken, String aStationName) {
        this.mLastUserSession = new UniversalUserSession(aHostDescriptorURL, aHostDescriptorXML, aHostName, aServiceName, aTradingSessionID, aTradingSessionSubID, null, null, aOpenToken, aStationName, this.mProperties);
        return this.mLastUserSession;
    }

    @Override
    public IUserSession createUserSessionSso(String aHostDescriptorURL, String aHostDescriptorXML, String aHostName, String aServiceName, String aTradingSessionID, String aTradingSessionSubID, String aLoginID, String aSsoToken, String aStationName) {
        this.mLastUserSession = new UniversalUserSession(aHostDescriptorURL, aHostDescriptorXML, aHostName, aServiceName, aTradingSessionID, aTradingSessionSubID, aLoginID, null, aSsoToken, aStationName, this.mProperties);
        return this.mLastUserSession;
    }

    @Override
    public IUserSession createPriceChannelSession(IUserSession aSession) {
        UniversalUserSession ret = null;
        UniversalUserSession universalSession = (UniversalUserSession)aSession;
        TradingSessionDesc priceSession = universalSession.getPriceChannelSessionDesc();
        if (priceSession != null) {
            HostElement hostElement = universalSession.getHostElement(priceSession.getName());
            ret = new UniversalUserSession(null, universalSession.mHostDescriptorXML, priceSession.getName(), universalSession.mServiceName, priceSession.getID(), priceSession.getSubID(), null, null, null, universalSession.mStationName, this.mProperties);
            ret.mHost = hostElement;
        }
        return ret;
    }

    @Override
    public void cleanup() {
    }
}

