/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util;

import com.fxcm.messaging.util.ITransportProvider;
import com.fxcm.util.logging.Utils;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;

public class TransportProviderFactory {
    private static final Log cLogger = Utils.getLog(TransportProviderFactory.class);
    private static final Hashtable cProviders = new Hashtable();

    public static void cleanup() {
        Enumeration en = cProviders.elements();
        while (en.hasMoreElements()) {
            ITransportProvider tp = (ITransportProvider)en.nextElement();
            tp.cleanup();
        }
        cProviders.clear();
    }

    public static ITransportProvider get(String aName) {
        ITransportProvider ret = null;
        if (aName != null) {
            String key = aName.toUpperCase();
            if (cProviders.containsKey(key)) {
                ret = (ITransportProvider)cProviders.get(key);
            } else {
                String className = "com.fxcm.messaging.util." + aName.toLowerCase() + ".TransportProvider";
                try {
                    Class<?> cm = Class.forName(className);
                    ret = (ITransportProvider)cm.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (cLogger.isDebugEnabled()) {
                        cLogger.debug("TransportProvider = " + cm.getName());
                    }
                }
                catch (Throwable th) {
                    cLogger.error(th.getMessage(), th);
                }
                if (ret != null) {
                    cProviders.put(key, ret);
                }
            }
        }
        return ret;
    }
}

