/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util;

import com.fxcm.GenericException;
import com.fxcm.messaging.util.CfxParser;
import com.fxcm.messaging.util.HostDesc;
import com.fxcm.messaging.util.HostDescV2;
import com.fxcm.messaging.util.HostDescV3;
import com.fxcm.messaging.util.HostDescV6;
import com.fxcm.messaging.util.HostList;
import com.fxcm.messaging.util.web.HttpContentGetter;
import com.fxcm.messaging.util.web.HttpParameter;
import com.fxcm.util.logging.Utils;
import java.util.Vector;
import org.apache.commons.logging.Log;

public class HostReader {
    private final Log mLogger = Utils.getLog(HostReader.class);
    private HttpContentGetter mGetter = new HttpContentGetter();
    protected String mVersion = "3.0";

    public void setProxyParameters(String aProxyServerAddress, int aProxyServerPort, String aProxyUserID, String aProxyPassword, boolean aProxyOverHTTP11) {
        this.mGetter.setProxyServer(aProxyServerAddress, aProxyServerPort);
        this.mGetter.setBasicProxyAuth(aProxyUserID, aProxyPassword);
    }

    public void setVersion(String version) {
        if (version != null) {
            this.mVersion = version;
        }
    }

    public HostDesc readFromXML(String xmlString, String aHostName, String aStationName) throws GenericException {
        if (xmlString != null && this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("HTML Data Received.");
            this.mLogger.debug("--------");
            this.mLogger.debug(xmlString);
            this.mLogger.debug("--------");
        }
        CfxParser p = new CfxParser();
        HostList hosts = (HostList)p.parseContent(xmlString);
        p.clear();
        String version = hosts.getAttribute("version");
        double dVersion = 1.0;
        if (version != null) {
            dVersion = Double.parseDouble(version);
        }
        HostDesc ret = null;
        ret = HostReader.createHostDesc(hosts, dVersion, aHostName);
        if (ret != null) {
            ret.setHostDescriptorXML(xmlString);
        }
        return ret;
    }

    private static HostDesc createHostDesc(HostList aHosts, double aVersion, String aHostName) {
        HostDesc ret = null;
        ret = aVersion >= 6.0 ? new HostDescV6(aHosts, aHostName) : (aVersion >= 3.0 ? new HostDescV3(aHosts, aHostName) : (aVersion >= 2.0 ? new HostDescV2(aHosts, aHostName) : new HostDesc(aHosts)));
        return ret;
    }

    public HostDesc read(String aHostDescriptorURL, String aHostName, String aStationName, String aLoginID) throws GenericException {
        if (aHostDescriptorURL == null) {
            return null;
        }
        String xmlString = null;
        try {
            xmlString = this.getHttpContent(aHostDescriptorURL, aHostName, aStationName, true, aLoginID);
        }
        catch (Exception e) {
            this.mLogger.error("", e);
        }
        if (xmlString != null && this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("HTML Data Received.");
            this.mLogger.debug("--------");
            this.mLogger.debug(xmlString);
            this.mLogger.debug("--------");
        }
        if (!(xmlString != null && xmlString.indexOf("Error") <= 0 && xmlString.indexOf("ERROR") <= 0 || aHostDescriptorURL.startsWith("file://"))) {
            try {
                xmlString = this.getHttpContent(aHostDescriptorURL, aHostName, aStationName, false, aLoginID);
            }
            catch (Exception e) {
                this.mLogger.error("", e);
            }
        }
        if (xmlString == null || xmlString.length() == 0) {
            throw new GenericException("Request to \"" + aHostDescriptorURL + "\" returns empty content");
        }
        return this.readFromXML(xmlString, aHostName, aStationName);
    }

    private String getHttpContent(String aHostDescriptorURL, String aHostName, String aStationName, boolean aPost, String aLoginID) throws Exception {
        Vector<HttpParameter> params = new Vector<HttpParameter>();
        params.add(new HttpParameter("ID", String.valueOf(System.currentTimeMillis())));
        params.add(new HttpParameter("PN", aHostName != null ? aHostName : ""));
        params.add(new HttpParameter("SN", aStationName != null ? aStationName : ""));
        params.add(new HttpParameter("LN", aLoginID));
        params.add(new HttpParameter("MV", this.mVersion));
        params.add(new HttpParameter("AT", "PLAIN"));
        return this.getHttpContent(aHostDescriptorURL, params, aPost);
    }

    protected String getHttpContent(String aHostDescriptorURL, Vector params, boolean aPost) {
        if (this.mLogger.isDebugEnabled()) {
            if (aPost) {
                this.mLogger.debug("Getting HTML Data by method POST from " + aHostDescriptorURL);
            } else {
                this.mLogger.debug("Getting HTML Data by method GET from " + aHostDescriptorURL);
            }
        }
        int attempts = 1;
        if (!aHostDescriptorURL.startsWith("file://")) {
            attempts = 3;
        }
        String ret = null;
        for (int i = 0; i < attempts; ++i) {
            try {
                ret = this.mGetter.getTextContent(aHostDescriptorURL, aPost, params);
            }
            catch (Exception e) {
                this.mLogger.debug(e.getMessage(), e);
            }
            if (ret != null) break;
        }
        return ret;
    }
}

