/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util;

import com.fxcm.messaging.TradingSessionDesc;
import com.fxcm.messaging.util.HostDesc;
import com.fxcm.messaging.util.HostDescV2;
import com.fxcm.messaging.util.HostElement;
import com.fxcm.messaging.util.HostList;
import java.util.ArrayList;
import java.util.Vector;

public class HostDescV3
extends HostDescV2 {
    public HostDescV3(HostList aHostList, String aMainHost) {
        super(aHostList, aMainHost);
    }

    public HostDesc getPriceChannelHostDesc(String aSessionName) {
        HostElement priceHostElement;
        String priceChannelHostName;
        HostDesc ret = null;
        HostElement hostElement = this.mHostList.getHost(aSessionName);
        if ("trading".equals(hostElement.getHostType()) && (priceChannelHostName = hostElement.getPriceChannelHostName()) != null && (priceHostElement = this.mHostList.getHost(priceChannelHostName)) != null && priceHostElement.getHostType().equals("price")) {
            HostList lst = new HostList();
            lst.addElement(priceHostElement);
            ret = new HostDesc(lst);
        }
        return ret;
    }

    public TradingSessionDesc getPriceChannelSessionDesc(String aSessionName) {
        TradingSessionDesc ret = null;
        for (HostElement hostElement : this.mHostList.getActiveHosts()) {
            HostElement priceHostElement;
            String priceChannelHostName;
            if (!"trading".equals(hostElement.getHostType()) || !aSessionName.equalsIgnoreCase(hostElement.getName()) || (priceChannelHostName = hostElement.getPriceChannelHostName()) == null || (priceHostElement = this.mHostList.getHost(priceChannelHostName)) == null || !priceHostElement.getHostType().equals("price")) continue;
            String name = priceHostElement.getName();
            String subID = priceHostElement.getAttribute("subid");
            String id = hostElement.getAttribute("id");
            String desc = hostElement.getAttribute("description");
            if (subID == null) {
                subID = name;
            }
            if (id == null) {
                id = "FXCM";
            }
            ret = new TradingSessionDesc(subID, id, name, desc);
            break;
        }
        return ret;
    }

    @Override
    public TradingSessionDesc[] retrieveSessionDescriptions() {
        ArrayList<TradingSessionDesc> ret = new ArrayList<TradingSessionDesc>();
        Vector hosts = this.mHostList.getHosts();
        if (hosts != null && hosts.size() > 0) {
            for (int i = 0; i < hosts.size(); ++i) {
                HostElement hostElement = (HostElement)hosts.get(i);
                if (!"trading".equals(hostElement.getHostType())) continue;
                String name = hostElement.getName();
                String subID = hostElement.getAttribute("subid");
                String id = hostElement.getAttribute("id");
                String desc = hostElement.getAttribute("description");
                String pinRequired = hostElement.getAttribute("pin");
                String errorCode = hostElement.getAttribute("err_code");
                String errorMessage = hostElement.getAttribute("err_message");
                String priceTerminal = hostElement.getAttribute("price_terminal");
                String s = hostElement.getAttribute("S");
                if (name == null || subID == null || id == null) continue;
                TradingSessionDesc tsd = new TradingSessionDesc(subID, id, name, desc);
                ret.add(tsd);
                if (pinRequired != null && "Y".equalsIgnoreCase(pinRequired)) {
                    tsd.setProperty("PIN_REQUIRED", pinRequired);
                }
                if (errorCode != null || errorMessage != null) {
                    int iErrorCode = -1;
                    if (errorCode != null) {
                        iErrorCode = Integer.parseInt(errorCode);
                    }
                    tsd.setErrorCode(iErrorCode);
                    tsd.setErrorMessage(errorMessage);
                }
                if (priceTerminal != null) {
                    tsd.setProperty("PRICE_TERMINAL", priceTerminal);
                }
                if (s == null) continue;
                tsd.setProperty("S", s);
            }
        }
        return ret.toArray(new TradingSessionDesc[ret.size()]);
    }
}

