/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util;

import com.fxcm.GenericException;
import com.fxcm.messaging.TradingSessionDesc;
import com.fxcm.messaging.util.HostDesc;
import com.fxcm.messaging.util.HostElement;
import com.fxcm.messaging.util.HostList;
import java.util.ArrayList;
import java.util.Vector;

public class HostDescV2
extends HostDesc {
    protected static final int AUTH_ERROR = 3000;
    private int mErrorCode;
    private String mErrorMessage;
    private String mMainHost;

    public HostDescV2(HostList aHostList, String aMainHost) {
        super(aHostList);
        this.mMainHost = aMainHost;
        this.initErrorFromHostList();
    }

    @Override
    public HostElement get(String aHost) throws GenericException {
        HostElement hostElement = super.get(aHost);
        if (hostElement != null) {
            String errorCode = hostElement.getAttribute("err_code");
            String errorMessage = hostElement.getAttribute("err_message");
            if (errorCode != null || errorMessage != null) {
                int iErrorCode = -1;
                if (errorCode != null) {
                    iErrorCode = Integer.parseInt(errorCode);
                }
                throw new GenericException("Error Code: " + iErrorCode + ": " + errorMessage);
            }
        }
        return hostElement;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public String getMainHost() {
        return this.mMainHost;
    }

    private void initErrorFromHostList() {
        String errorCode = this.mHostList.getAttribute("err_code");
        String errorMsg = this.mHostList.getAttribute("err_message");
        if (errorCode != null || errorMsg != null) {
            this.mErrorCode = -1;
            if (errorCode != null && "AUTH_ERR".equals(errorCode)) {
                this.mErrorCode = 3000;
            } else if (errorCode != null) {
                this.mErrorCode = Integer.parseInt(errorCode);
            }
            this.mErrorMessage = errorMsg != null ? errorMsg : null;
        }
    }

    @Override
    public TradingSessionDesc[] retrieveSessionDescriptions() {
        ArrayList<TradingSessionDesc> ret = new ArrayList<TradingSessionDesc>();
        Vector hosts = this.mHostList.getHosts();
        if (hosts != null && hosts.size() > 0) {
            for (int i = 0; i < hosts.size(); ++i) {
                HostElement hostElement = (HostElement)hosts.get(i);
                String name = hostElement.getName();
                String subID = hostElement.getAttribute("subid");
                String id = hostElement.getAttribute("id");
                String desc = hostElement.getAttribute("description");
                String pinRequired = hostElement.getAttribute("pin");
                String errorCode = hostElement.getAttribute("err_code");
                String errorMessage = hostElement.getAttribute("err_message");
                if (name == null || subID == null || id == null) continue;
                TradingSessionDesc tsd = new TradingSessionDesc(subID, id, name, desc);
                ret.add(tsd);
                if (pinRequired != null && "Y".equalsIgnoreCase(pinRequired)) {
                    tsd.setProperty("PIN_REQUIRED", pinRequired);
                }
                if (errorCode == null && errorMessage == null) continue;
                int iErrorCode = -1;
                if (errorCode != null) {
                    iErrorCode = Integer.parseInt(errorCode);
                }
                tsd.setErrorCode(iErrorCode);
                tsd.setErrorMessage(errorMessage);
            }
        }
        return ret.toArray(new TradingSessionDesc[ret.size()]);
    }
}

