/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util;

import com.fxcm.messaging.ISessionStatus;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;

public class GenericSessionStatus
implements ISessionStatus {
    public static final String CONNECTION_NAME = "ConnectionName";
    public static final String PROTOCOL_NAME = "ProtocolName";
    public static final String SECURE_PROTOCOL_STRING = "SecureProtocolString";
    public static final String STATUS_CODE = "StatusCode";
    public static final String STATUS_NAME = "StatusName";
    public static final String STATUS_MESSAGE = "StatusMessage";
    public static final String STATUS_MESSAGE_ID = "StatusMessageID";
    private final Hashtable mHashtable = new Hashtable();
    private int mQueueSize;
    private static final String[] STATUSNAMES = new String[]{"Error", "Disconnected", "Ready", "Connecting", "Sending", "Receiving", "Processing", "Disconnecting", "Logged in", "Waiting", "Expired", "Shutdown", "Forced relogin", "Connected", "Logging in", "Attaching", "Unknown"};
    private static final String[] MSGTEXTS = new String[]{"", "Sending request...", "Communication broken.", "Session timed out.", "Request failed.", "Request sent.", "Command failed.", "Restoring connection...", "Connection Restored.", "Connecting to the Server...", "Failed to connect to the server.", "Login failed.", "Connected to the Server.", "Disconnecting from the Server.", "Session closed.", "Connection not initiated", "Failed to create async receiver.", "Session expired.", "Gap withing message sequence"};

    public static String getStatusName(int aStatusCode) {
        return STATUSNAMES[aStatusCode - -2];
    }

    public static String getStatusMessage(int aStatusMessageCode) {
        return MSGTEXTS[aStatusMessageCode];
    }

    public GenericSessionStatus(Hashtable aHashtable) {
        if (aHashtable != null) {
            Enumeration e = aHashtable.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                this.mHashtable.put(key, aHashtable.get(key));
            }
        }
    }

    public GenericSessionStatus() {
    }

    public GenericSessionStatus(GenericSessionStatus aStatus) {
        Hashtable props = aStatus.mHashtable;
        if (props != null) {
            Enumeration e = props.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                this.mHashtable.put(key, props.get(key));
            }
        }
        this.setQueueSize(aStatus.getQueueSize());
    }

    @Override
    public String getConnectionName() {
        return (String)this.mHashtable.get(CONNECTION_NAME);
    }

    public void setConnectionName(String aName) {
        if (aName != null) {
            this.mHashtable.put(CONNECTION_NAME, aName);
        }
    }

    @Override
    public String getProtocolName() {
        return (String)this.mHashtable.get(PROTOCOL_NAME);
    }

    public void setProtocolName(String aName) {
        if (aName != null) {
            this.mHashtable.put(PROTOCOL_NAME, aName);
        }
    }

    @Override
    public String getSecureProtocolString() {
        return (String)this.mHashtable.get(SECURE_PROTOCOL_STRING);
    }

    public void setSecureProtocolString(String aString) {
        if (aString != null) {
            this.mHashtable.put(SECURE_PROTOCOL_STRING, aString);
        }
    }

    @Override
    public int getStatusCode() {
        int ret = -1;
        String s = (String)this.mHashtable.get(STATUS_CODE);
        if (s != null) {
            ret = Integer.parseInt(s);
        }
        return ret;
    }

    public void setStatusCode(int aCode) {
        this.mHashtable.put(STATUS_CODE, String.valueOf(aCode));
    }

    @Override
    public String getStatusName() {
        return (String)this.mHashtable.get(STATUS_NAME);
    }

    public void setStatusName(String aName) {
        if (aName != null) {
            this.mHashtable.put(STATUS_NAME, aName);
        }
    }

    @Override
    public String getStatusMessage() {
        return (String)this.mHashtable.get(STATUS_MESSAGE);
    }

    public void setStatusMessage(String aMessage) {
        if (aMessage != null) {
            this.mHashtable.put(STATUS_MESSAGE, aMessage);
        }
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("");
        Enumeration e = this.mHashtable.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object val = this.mHashtable.get(key);
            buff.append("{").append(key).append("}\t{").append(val).append("}\n");
        }
        return buff.toString();
    }

    @Override
    public int getStatusMessageID() {
        int ret = -1;
        String s = (String)this.mHashtable.get(STATUS_MESSAGE_ID);
        if (s != null) {
            ret = Integer.parseInt(s);
        }
        return ret;
    }

    public void setStatusMessageID(int aMessageID) {
        this.mHashtable.put(STATUS_MESSAGE_ID, String.valueOf(aMessageID));
    }

    @Override
    public int getQueueSize() {
        return this.mQueueSize;
    }

    public void setQueueSize(int aQueueSize) {
        this.mQueueSize = aQueueSize;
    }

    @Override
    public Map getFields() {
        return this.mHashtable;
    }

    @Override
    public void update(ISessionStatus aSessionStatus) {
        this.mHashtable.putAll(aSessionStatus.getFields());
    }
}

