/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util;

import com.fxcm.GenericException;
import com.fxcm.fix.FixObjectFactory;
import com.fxcm.fix.custom.FXCMResponse;
import com.fxcm.fix.other.UserRequest;
import com.fxcm.fix.other.UserResponse;
import com.fxcm.messaging.ConnectionManagerEx;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.IUserMessageListener;
import com.fxcm.messaging.IUserSession;
import com.fxcm.messaging.IUserSessionStatusListener;
import com.fxcm.messaging.IUserTransportableListener;
import com.fxcm.messaging.TradingSessionDesc;
import com.fxcm.messaging.util.UniversalConnectionManager;
import com.fxcm.messaging.util.UniversalUserSession;
import com.fxcm.util.Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class DoubleUserSession
extends UniversalUserSession {
    private static final int CMD_GET_SYSTEM_PARAMS = 3;
    protected IUserSession mPriceSession;
    protected TransportMutex mTransportMutexEx = new TransportMutex();
    protected String mExtPriceTerminal;
    protected String mSsoTokenPrice;
    protected long mPriceMsgFlags = 0L;

    public DoubleUserSession(String aHostDescriptorURL, String aHostDescriptorXML, String aHostName, String aServiceName, String aTradingSessionID, String aTradingSessionSubID, String aLoginID, String aPassword, String aOpenToken, String aStationName, Properties aProperties) {
        super(aHostDescriptorURL, aHostDescriptorXML, aHostName, aServiceName, aTradingSessionID, aTradingSessionSubID, aLoginID, aPassword, aOpenToken, aStationName, aProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        TransportMutex transportMutex = this.mTransportMutexEx;
        synchronized (transportMutex) {
            this.mTransportMutexEx.notifyAll();
        }
        super.close();
        if (this.mPriceSession != null) {
            try {
                this.mPriceSession.close();
            }
            catch (GenericException e) {
                this.moLogger.error(e.getMessage(), e);
            }
        }
    }

    @Override
    protected void onRelogSuccess() throws GenericException {
        boolean good = true;
        do {
            try {
                if (this.mPriceSession != null) {
                    this.mPriceSession.close();
                    this.mPriceSession = null;
                }
                good = this.openPriceTerminal();
            }
            catch (GenericException e) {
                this.moLogger.error(e.getMessage(), e);
                good = false;
            }
            if (!good) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!good);
    }

    @Override
    public boolean open(String aExtraParams) throws GenericException {
        this.mPriceMsgFlags = 894L;
        long userMsgFlags = 1L;
        String value = this.mProperties.getProperty("MessageFlags");
        try {
            if (value != null && !"0".equals(value)) {
                long lFlag = Long.parseLong(value);
                this.mPriceMsgFlags = lFlag | 0x37EL;
                userMsgFlags = lFlag | 1L;
            }
        }
        catch (Exception e) {
            this.moLogger.error("problem parsing msg flags:" + value, e);
        }
        this.setMsgFlags(userMsgFlags);
        boolean ret = super.open(aExtraParams);
        boolean good = false;
        if (ret) {
            TradingSessionDesc pcsd = this.getPriceChannelSessionDesc();
            if (pcsd != null) {
                this.mExtPriceTerminal = pcsd.getName();
                good = true;
            } else {
                this.moLogger.debug("Unable to find price terminal:" + this.mTradingSession.getName() + " " + this.mHostName + " " + this.mServiceName);
            }
        }
        if (ret && good) {
            if (this.moLogger.isDebugEnabled()) {
                this.moLogger.debug("opening price terminal: isSsoTokenSupported:" + this.isSsoTokenSupported() + " " + this.mExtPriceTerminal);
            }
            try {
                ret = this.openPriceTerminal();
                if (this.moLogger.isDebugEnabled()) {
                    this.moLogger.debug("open price terminal: isSsoTokenSupported: " + this.mExtPriceTerminal + " " + ret);
                }
            }
            catch (GenericException e) {
                this.moLogger.error("opening price terminal: isSsoTokenSupported:" + this.isSsoTokenSupported() + " " + this.mExtPriceTerminal, e);
                throw e;
            }
            if (ret) {
                if (this.moLogger.isDebugEnabled()) {
                    this.moLogger.debug("trading SID:" + this.getSessionID() + " mdt SID:" + this.mPriceSession.getSessionID());
                }
            } else if (this.moLogger.isDebugEnabled()) {
                this.moLogger.debug("opening price terminal: fails. " + this.mExtPriceTerminal);
            }
        }
        return ret;
    }

    private boolean openPriceTerminal() throws GenericException {
        boolean ret = true;
        if (this.mExtPriceTerminal != null) {
            boolean good = true;
            this.mSsoTokenPrice = null;
            if (good && this.isSsoTokenSupported()) {
                UserRequest ur = new UserRequest();
                ur.setUserRequestType(9);
                ur.setParam("aRemoteAppCode", this.mStationName);
                ur.setUserRequestID(this.getNextRequestID());
                good = this.processSynchronousRequest(ur);
                if (this.moLogger.isDebugEnabled()) {
                    this.moLogger.debug("got SSO token:  " + good);
                }
            }
            if (good) {
                this.mPriceSession = this.mSsoTokenPrice != null ? ConnectionManagerEx.createUserSessionSso(this.mHostDescriptorURL, this.mHostDescriptorXML, this.mExtPriceTerminal, null, this.mLoginID, this.mSsoTokenPrice, this.mStationName, new UniversalConnectionManager()) : ConnectionManagerEx.createUserSession(this.mHostDescriptorURL, null, this.mExtPriceTerminal, null, null, this.mStationName, new UniversalConnectionManager());
                this.mPriceSession.setMsgFlags(this.mPriceMsgFlags);
                if (!this.mPriceSession.loadStationDescriptor()) {
                    throw new GenericException("Problem getting station descriptor for price session");
                }
                ((UniversalUserSession)this.mPriceSession).setTransmitTsID(this.getTradingSession().getID());
                ((UniversalUserSession)this.mPriceSession).setTransmitTsSubID(this.getTradingSession().getSubID());
                if (this.mSsoTokenPrice != null) {
                    if (this.moLogger.isDebugEnabled()) {
                        this.moLogger.debug("opening new price session...");
                    }
                    ret = this.mPriceSession.open("SID=" + this.getSessionID());
                } else {
                    if (this.moLogger.isDebugEnabled()) {
                        this.moLogger.debug("attach price session...");
                    }
                    this.mPriceSession.attach(this.getSessionID(), null);
                }
                if (this.moLogger.isDebugEnabled()) {
                    this.moLogger.debug("open new price session:" + ret);
                }
                for (Object next : this.mClientMessageListeners) {
                    if (next instanceof IUserMessageListener) {
                        this.mPriceSession.setMessageListener((IUserMessageListener)next);
                        continue;
                    }
                    if (!(next instanceof IUserTransportableListener)) continue;
                    this.mPriceSession.setMessageListener((IUserTransportableListener)next);
                }
                Iterator it = this.mClientStatusListeners.iterator();
                while (it.hasNext()) {
                    this.mPriceSession.setSessionStatusListener((IUserSessionStatusListener)it.next());
                }
            }
        }
        return ret;
    }

    @Override
    public synchronized boolean setMessageListener(IUserMessageListener aListener) {
        if (aListener == null) {
            return false;
        }
        super.setMessageListener(aListener);
        if (this.mPriceSession != null) {
            this.mPriceSession.setMessageListener(aListener);
        }
        return true;
    }

    @Override
    public synchronized void removeMessageListener(IUserMessageListener aListener) {
        super.removeMessageListener(aListener);
        if (this.mPriceSession != null) {
            this.mPriceSession.removeMessageListener(aListener);
        }
    }

    @Override
    public synchronized boolean setMessageListener(IUserTransportableListener aListener) {
        if (aListener == null) {
            return false;
        }
        super.setMessageListener(aListener);
        if (this.mPriceSession != null) {
            this.mPriceSession.setMessageListener(aListener);
        }
        return true;
    }

    @Override
    public synchronized void removeMessageListener(IUserTransportableListener aListener) {
        super.removeMessageListener(aListener);
        if (this.mPriceSession != null) {
            this.mPriceSession.removeMessageListener(aListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMessageHook(IMessage aMessage) throws GenericException {
        ITransportable tr;
        String req = this.mTransportMutexEx.getRequestID();
        boolean processed = false;
        if (req != null && req.equals((tr = FixObjectFactory.toObject(aMessage)).getRequestID())) {
            TransportMutex transportMutex = this.mTransportMutexEx;
            synchronized (transportMutex) {
                req = this.mTransportMutexEx.getRequestID();
                if (req != null && req.equals(tr.getRequestID())) {
                    this.mTransportMutexEx.setResponse(tr);
                    processed = true;
                    this.mTransportMutexEx.notifyAll();
                }
            }
        }
        if (!processed) {
            super.updateMessageHook(aMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processSynchronousRequest(ITransportable aRequest) {
        IMessage msg = aRequest.toMessage(this.getSessionID(), this.getMessageFactory());
        ITransportable resp = null;
        long to = this.getLongProperty("com.fxcm.messaging.IConnectionManager.SyncRequestTimeout", 180000L);
        TransportMutex transportMutex = this.mTransportMutexEx;
        synchronized (transportMutex) {
            try {
                this.mTransportMutexEx.setRequestID(aRequest.getRequestID());
                super.send(msg);
                this.mTransportMutexEx.wait(to);
                resp = this.mTransportMutexEx.getResponse();
                this.mTransportMutexEx.clear();
            }
            catch (Exception e) {
                this.moLogger.error(e.getMessage(), e);
            }
            finally {
                this.mTransportMutexEx.clear();
            }
        }
        if (resp != null && this.moLogger.isDebugEnabled()) {
            this.moLogger.debug("processSynchronousRequest.response = " + resp);
        }
        boolean ret = false;
        if (resp != null && !resp.getType().equals(FXCMResponse.OBJ_TYPE) && resp.getType().equals(UserResponse.OBJ_TYPE) && ((UserResponse)resp).getUserStatus() == 1 && ((UserResponse)resp).getUserRequestType() == 9) {
            this.mSsoTokenPrice = ((UserResponse)resp).getUserStatusText();
            ret = true;
        }
        return ret;
    }

    protected Map parseParameters(String aMsg) {
        HashMap<String, String> plist = new HashMap<String, String>();
        String[] lines = Util.splitToArray(aMsg, "\n");
        for (int i = 0; i < lines.length; ++i) {
            String[] tokens = Util.splitToArray(lines[i], ";");
            if (tokens.length == 2) {
                plist.put(tokens[0], tokens[1]);
                continue;
            }
            if (tokens.length <= 2) continue;
            StringBuffer valueBuffer = new StringBuffer();
            for (int j = 1; j < tokens.length; ++j) {
                String token = tokens[j];
                valueBuffer.append(token);
                if (j == tokens.length - 1) continue;
                valueBuffer.append(";");
            }
            plist.put(tokens[0], valueBuffer.toString());
        }
        return plist;
    }

    protected static class TransportMutex {
        protected String mRequestID;
        protected ITransportable mResponse;

        TransportMutex() {
        }

        String getRequestID() {
            return this.mRequestID;
        }

        ITransportable getResponse() {
            return this.mResponse;
        }

        void setResponse(ITransportable aResponse) {
            this.mResponse = aResponse;
        }

        void clear() {
            this.mRequestID = null;
            this.mResponse = null;
        }

        void setRequestID(String aRequestID) {
            this.mRequestID = aRequestID;
            this.mResponse = null;
        }
    }
}

