/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ConfigElement {
    private String type;
    private Vector elements = new Vector();
    private Hashtable attributeTable = new Hashtable();
    private String data;
    protected Vector mSkip = new Vector();

    public ConfigElement(String aType) {
        this.type = aType;
    }

    public String getType() {
        return this.type;
    }

    public Hashtable getAttributes() {
        return this.attributeTable;
    }

    public void setAttributes(Hashtable aAttributeTable) {
        this.attributeTable = aAttributeTable;
    }

    public boolean addElement(ConfigElement element) {
        if (element != null) {
            this.elements.addElement(element);
            return true;
        }
        return false;
    }

    public boolean addAttribute(String attributeName, String attributeValue) {
        if (attributeName != null && attributeName.trim().length() != 0) {
            String tmp;
            AttrW aw = new AttrW();
            aw.name = attributeName.trim();
            String nm = aw.name.toLowerCase();
            aw.value = tmp = attributeValue != null ? attributeValue : "";
            this.attributeTable.put(nm, aw);
            return true;
        }
        return false;
    }

    public String getAttribute(String attributeName) {
        AttrW attr;
        String ret = null;
        if (attributeName != null && attributeName.trim().length() != 0 && (attr = (AttrW)this.attributeTable.get(attributeName.trim().toLowerCase())) != null) {
            ret = attr.value;
        }
        return ret;
    }

    public Vector getElements() {
        return this.elements;
    }

    public void setElements(Vector aElements) {
        this.elements = aElements;
    }

    public Vector getElements(String aType) {
        Vector<ConfigElement> v = new Vector<ConfigElement>();
        if (aType == null || aType.trim().length() == 0 || this.elements.size() == 0) {
            return v;
        }
        Enumeration e = this.elements.elements();
        while (e.hasMoreElements()) {
            ConfigElement element = (ConfigElement)e.nextElement();
            if (!aType.trim().equalsIgnoreCase(element.getType())) continue;
            v.addElement(element);
        }
        return v;
    }

    public Vector getElements(String aType, String attributeName, String value) {
        Vector<ConfigElement> v = new Vector<ConfigElement>();
        if (aType == null || aType.trim().length() == 0 || this.elements.size() == 0 || attributeName == null || attributeName.trim().length() == 0 || value == null) {
            return v;
        }
        Enumeration e = this.elements.elements();
        while (e.hasMoreElements()) {
            ConfigElement element = (ConfigElement)e.nextElement();
            if (!aType.trim().equalsIgnoreCase(element.getType()) || !value.equals(element.getAttribute(attributeName.trim()))) continue;
            v.addElement(element);
        }
        return v;
    }

    public String toString() {
        return this.toString("");
    }

    public String getData() {
        return this.data;
    }

    public void postParse(Object aObject) {
    }

    public void setData(String aData) {
        this.data = aData;
    }

    public String toStringExtraElement(String indent) {
        return null;
    }

    public String toString(String indent) {
        Object myIndent = indent;
        StringBuffer sb = new StringBuffer();
        sb.append(indent).append("<").append(this.getType());
        Hashtable ht = this.getAttributes();
        Enumeration e = ht.elements();
        while (e.hasMoreElements()) {
            AttrW aw = (AttrW)e.nextElement();
            sb.append(" ").append(aw.name).append("=\"").append(aw.value).append("\"");
        }
        myIndent = (String)myIndent + "    ";
        String extra = this.toStringExtraElement((String)myIndent);
        Vector el = this.getElements();
        if (el.size() > 0 || extra != null) {
            sb.append(">\n");
            Enumeration e2 = el.elements();
            while (e2.hasMoreElements()) {
                ConfigElement ce = (ConfigElement)e2.nextElement();
                if (this.mSkip.contains(ce.getType())) continue;
                sb.append(ce.toString((String)myIndent));
            }
            if (extra != null) {
                sb.append(extra);
            }
            sb.append(indent).append("</").append(this.getType()).append(">\n");
        } else if (this.getData() != null) {
            sb.append(">\n").append(indent).append("    ").append(this.getData().trim()).append("\n");
            sb.append(indent).append("</").append(this.getType()).append(">\n");
        } else {
            sb.append(" />\n");
        }
        return sb.toString();
    }

    private class AttrW {
        String name;
        String value;

        private AttrW() {
        }
    }
}

