/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util;

import com.fxcm.messaging.util.UrlElement;
import java.net.URL;
import java.util.Hashtable;

public class ConParams {
    public String msName;
    public String msTransportProvider;
    public String msHost;
    public int miPort;
    public boolean mbUseHttp;
    public String msScript;
    public String msApp;
    public String msUid;
    public String msUpwd;
    public boolean mbUseProxy;
    public String msProxyHost;
    public int miProxyPort;
    public String msProxyUid;
    public String msProxyPwd;
    public String mProxyAuthenticationRealm;
    public String mProxyType;
    public boolean mbProxyHTTP11 = true;
    public String msHttpUid;
    public String msHttpPwd;
    public boolean mbUseSecure;
    public String msFullUrl;
    public long mlMsgFlags;
    public Hashtable mOptionalParams = new Hashtable();

    public ConParams() {
        this.clear();
    }

    public ConParams(ConParams aParams) {
        this.clear();
        if (aParams != null) {
            if (aParams.msName != null) {
                this.msName = aParams.msName;
            }
            if (aParams.msTransportProvider != null) {
                this.msTransportProvider = aParams.msTransportProvider;
            }
            if (aParams.msHost != null) {
                this.msHost = aParams.msHost;
            }
            this.miPort = aParams.miPort;
            this.mbUseHttp = aParams.mbUseHttp;
            if (aParams.msScript != null) {
                this.msScript = aParams.msScript;
            }
            if (aParams.msApp != null) {
                this.msApp = aParams.msApp;
            }
            if (aParams.msUid != null) {
                this.msUid = aParams.msUid;
            }
            if (aParams.msUpwd != null) {
                this.msUpwd = aParams.msUpwd;
            }
            this.mbUseProxy = aParams.mbUseProxy;
            if (aParams.msProxyHost != null) {
                this.msProxyHost = aParams.msProxyHost;
            }
            this.miProxyPort = aParams.miProxyPort;
            if (aParams.msProxyUid != null) {
                this.msProxyUid = aParams.msProxyUid;
            }
            if (aParams.msProxyPwd != null) {
                this.msProxyPwd = aParams.msProxyPwd;
            }
            if (aParams.mProxyAuthenticationRealm != null) {
                this.mProxyAuthenticationRealm = aParams.mProxyAuthenticationRealm;
            }
            if (aParams.mProxyType != null) {
                this.mProxyType = aParams.mProxyType;
            }
            this.mbProxyHTTP11 = aParams.mbProxyHTTP11;
            if (aParams.msHttpUid != null) {
                this.msHttpUid = aParams.msHttpUid;
            }
            if (aParams.msHttpPwd != null) {
                this.msHttpPwd = aParams.msHttpPwd;
            }
            this.mbUseSecure = aParams.mbUseSecure;
            if (aParams.msFullUrl != null) {
                this.msFullUrl = aParams.msFullUrl;
            }
            this.mlMsgFlags = aParams.mlMsgFlags;
            this.mOptionalParams = (Hashtable)aParams.getOptionalParamters().clone();
        }
    }

    public void clear() {
        this.msTransportProvider = "";
        this.msHost = "";
        this.miPort = -1;
        this.mbUseHttp = false;
        this.msScript = "";
        this.msApp = "";
        this.msUid = "";
        this.msUpwd = "";
        this.mbUseProxy = false;
        this.msProxyHost = "";
        this.miProxyPort = -1;
        this.msProxyUid = null;
        this.msProxyPwd = null;
        this.mProxyAuthenticationRealm = null;
        this.mProxyType = null;
        this.mbProxyHTTP11 = true;
        this.msHttpUid = null;
        this.msHttpPwd = null;
        this.mbUseSecure = false;
        this.msFullUrl = null;
        this.mlMsgFlags = 0L;
        this.clearOptionalParamters();
    }

    public boolean isEmpty() {
        return this.msHost == null || this.msHost.length() == 0;
    }

    public void setUrl(UrlElement aUrl) {
        this.msTransportProvider = "";
        this.msHost = "";
        this.miPort = -1;
        this.mbUseHttp = false;
        this.mbUseSecure = false;
        if (aUrl == null) {
            return;
        }
        String url = aUrl.getUrlString();
        if (url == null) {
            return;
        }
        this.mbUseHttp = "http".equalsIgnoreCase(aUrl.getProtocol());
        this.mbUseSecure = "true".equalsIgnoreCase(aUrl.getSecure());
        int p = url.indexOf(58);
        if (p <= 0) {
            return;
        }
        this.msTransportProvider = url.substring(0, p);
        this.msFullUrl = url = url.substring(p + 1);
        if (url.toUpperCase().startsWith("HTTP://") || url.toUpperCase().startsWith("HTTPS://")) {
            String uFile;
            URL ul;
            this.mbUseHttp = true;
            try {
                ul = new URL(url);
            }
            catch (Exception ex) {
                return;
            }
            this.msHost = ul.getHost();
            this.miPort = ul.getPort();
            if (this.miPort <= 0) {
                this.miPort = this.mbUseSecure ? 443 : 80;
            }
            if ((uFile = ul.getFile()) != null && uFile.trim().length() != 0) {
                int idx = uFile.lastIndexOf("/");
                if (idx == -1) {
                    return;
                }
                this.msScript = uFile.substring(0, idx);
                this.msApp = uFile.substring(idx + 1);
            }
        } else {
            int idx = url.indexOf(":");
            if (idx == -1) {
                return;
            }
            this.mbUseHttp = false;
            this.msHost = url.substring(0, idx);
            try {
                String num = url.substring(idx + 1);
                this.miPort = Integer.parseInt(num);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Hashtable ht = aUrl.getParams();
        if (ht != null) {
            this.mOptionalParams = (Hashtable)ht.clone();
        } else {
            this.clearOptionalParamters();
        }
    }

    public Hashtable getOptionalParamters() {
        return this.mOptionalParams;
    }

    public void clearOptionalParamters() {
        this.mOptionalParams.clear();
    }

    public void setOptionalParameter(String aName, String aValue) {
        this.mOptionalParams.put(aName, aValue);
    }

    public String getOptionalParameter(String aName, String aDefault) {
        String ret = (String)this.mOptionalParams.get(aName);
        if (ret == null) {
            ret = aDefault;
        }
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ConParams");
        sb.append("{mbProxyHTTP11=").append(this.mbProxyHTTP11);
        sb.append(", msName='").append(this.msName).append('\'');
        sb.append(", msTransportProvider='").append(this.msTransportProvider).append('\'');
        sb.append(", msHost='").append(this.msHost).append('\'');
        sb.append(", miPort=").append(this.miPort);
        sb.append(", mbUseHttp=").append(this.mbUseHttp);
        sb.append(", msScript='").append(this.msScript).append('\'');
        sb.append(", msApp='").append(this.msApp).append('\'');
        sb.append(", msUid='").append(this.msUid).append('\'');
        sb.append(", msUpwd='").append(this.msUpwd).append('\'');
        sb.append(", mbUseProxy=").append(this.mbUseProxy);
        sb.append(", msProxyHost='").append(this.msProxyHost).append('\'');
        sb.append(", miProxyPort=").append(this.miProxyPort);
        sb.append(", msProxyUid='").append(this.msProxyUid).append('\'');
        sb.append(", msProxyPwd='").append(this.msProxyPwd).append('\'');
        sb.append(", mProxyAuthenticationRealm='").append(this.mProxyAuthenticationRealm).append('\'');
        sb.append(", mProxyType='").append(this.mProxyType).append('\'');
        sb.append(", msHttpUid='").append(this.msHttpUid).append('\'');
        sb.append(", msHttpPwd='").append(this.msHttpPwd).append('\'');
        sb.append(", mbUseSecure=").append(this.mbUseSecure);
        sb.append(", msFullUrl='").append(this.msFullUrl).append('\'');
        sb.append(", mlMsgFlags=").append(this.mlMsgFlags);
        sb.append(", mOptionalParams=").append(this.mOptionalParams);
        sb.append('}');
        return sb.toString();
    }
}

