/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util;

import com.fxcm.messaging.util.CfxParserException;
import com.fxcm.messaging.util.ConfigElement;
import com.fxcm.messaging.util.ConfigElementFactory;
import com.fxcm.messaging.util.IConfigElementFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.StringBufferInputStream;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;
import uk.co.wilson.xml.MinML;

public class CfxParser
extends MinML {
    private static final Log moLogger = LogFactory.getLog(CfxParser.class);
    private IConfigElementFactory ifactory = null;
    private ConfigElement root = null;
    private ConfigElement currentElement = null;
    private Stack elements = new Stack();

    public CfxParser() {
    }

    public CfxParser(IConfigElementFactory factory) {
        this.ifactory = factory;
    }

    public void setElementFactory(IConfigElementFactory factory) {
        this.ifactory = factory;
    }

    public ConfigElement parseFile(String file) {
        if (this.ifactory == null) {
            this.ifactory = this.getElementFactory();
            if (this.ifactory == null) {
                throw new CfxParserException("P: Unable to parse. Element factory  does not exist or has not been specified.");
            }
        }
        FileInputStream fl = null;
        try {
            fl = new FileInputStream(file);
            this.parse(new InputStreamReader(fl));
            ConfigElement configElement = this.root;
            return configElement;
        }
        catch (FileNotFoundException ex1) {
            throw new CfxParserException("P: File not found: " + ex1.getMessage());
        }
        catch (SecurityException ex2) {
            throw new CfxParserException("P: Security : " + ex2.getMessage());
        }
        catch (Exception ex3) {
            throw new CfxParserException("P: Generic : " + ex3.getMessage());
        }
        finally {
            try {
                if (fl != null) {
                    fl.close();
                }
                fl = null;
            }
            catch (Exception ex1) {
                fl = null;
            }
        }
    }

    public ConfigElement parseContent(String content) {
        StringBufferInputStream reader = new StringBufferInputStream(content);
        if (this.ifactory == null) {
            this.ifactory = this.getElementFactory();
            if (this.ifactory == null) {
                throw new CfxParserException("P: Unable to parse. Element factory  does not exist or has not been specified.");
            }
        }
        try {
            this.parse(new InputStreamReader(reader));
            return this.root;
        }
        catch (Exception ex3) {
            throw new CfxParserException("P: Generic : " + ex3.getMessage());
        }
    }

    public void reset() {
        this.root = null;
        this.currentElement = null;
        this.elements.removeAllElements();
    }

    public void clear() {
        this.reset();
        this.ifactory = null;
    }

    @Override
    public void startDocument() throws SAXException {
        moLogger.debug("Start document");
    }

    @Override
    public void startElement(String localName, AttributeList attributes) throws SAXException {
        if (this.currentElement == null) {
            this.currentElement = this.root = this.ifactory.createElement(localName);
            if (moLogger.isDebugEnabled()) {
                moLogger.debug("It's root. Root element created , using class: " + this.root.getClass().getName());
            }
        } else {
            boolean resFlag;
            ConfigElement parentElement = this.currentElement;
            ConfigElement childElement = this.ifactory.createElement(localName);
            if (moLogger.isDebugEnabled()) {
                moLogger.debug("Object for element '" + localName + "' created, using class:" + childElement.getClass().getName());
            }
            if (!(resFlag = this.currentElement.addElement(childElement))) {
                throw new SAXException("Invalid XML: unable to add element to the parent element.");
            }
            moLogger.debug("Element successfully added to parent's storage");
            this.elements.push(parentElement);
            this.currentElement = childElement;
        }
        this.processAttributes(this.currentElement, attributes);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentElement != null) {
            String data;
            String newData = new String(ch, start, length);
            if (moLogger.isDebugEnabled()) {
                moLogger.debug("Add data : " + newData + " for element " + this.currentElement.getClass().getName());
            }
            if ((data = this.currentElement.getData()) == null) {
                this.currentElement.setData(newData);
            } else {
                this.currentElement.setData(data + newData);
            }
        }
    }

    @Override
    public void endElement(String qName) throws SAXException {
        if (moLogger.isDebugEnabled()) {
            moLogger.debug("endElement: " + qName);
        }
        try {
            this.currentElement = (ConfigElement)this.elements.pop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void endDocument() throws SAXException {
        moLogger.debug("End document");
    }

    private IConfigElementFactory getElementFactory() {
        if (this.ifactory != null) {
            return this.ifactory;
        }
        return new ConfigElementFactory();
    }

    private void processAttributes(ConfigElement object, AttributeList atts) throws SAXException {
        if (moLogger.isDebugEnabled()) {
            moLogger.debug("Processing attributes for element: " + object.getType());
        }
        ConfigElement element = object;
        for (int i = 0; i < atts.getLength(); ++i) {
            boolean resFlag;
            String localName = atts.getName(i);
            String value = atts.getValue(i);
            if (moLogger.isDebugEnabled()) {
                moLogger.debug("-attribute: " + localName);
            }
            if (!(resFlag = element.addAttribute(localName, value))) {
                throw new SAXException("Invalid XML - unable to add attribute '" + localName + "' to element '" + element.getType() + "'");
            }
            if (!moLogger.isDebugEnabled()) continue;
            moLogger.debug("attribute '" + localName + "' successufully added to element's storage.");
        }
    }
}

