/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.https;

import com.fxcm.messaging.https.IContextAdapter;
import com.fxcm.messaging.https.ISSLVerifier;
import com.fxcm.messaging.https.SSLVerifierException;
import com.fxcm.messaging.https.V4ContextAdapter;
import java.io.ByteArrayInputStream;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;

class V3SSEContextAdapter
implements IContextAdapter {
    private final SSLContext context;
    private final ISSLVerifier verifier;
    private final int verifierMode;
    private PrivateKey privateKey;
    private java.security.cert.X509Certificate[] certChain;
    private KeyStore keyStore;
    private String keyStorePassword;

    V3SSEContextAdapter(ISSLVerifier verifier, int verifierMode, PrivateKey privateKey, java.security.cert.X509Certificate[] certChain) throws GeneralSecurityException {
        this.verifier = verifier;
        this.verifierMode = verifierMode;
        this.privateKey = privateKey;
        this.certChain = certChain;
        this.context = SSLContext.getInstance("TLS");
        this.context.init(this.getKeyManagers(), this.getTrustManagers(), null);
    }

    V3SSEContextAdapter(ISSLVerifier verifier, int verifierMode, KeyStore keyStore, String password) throws GeneralSecurityException {
        this.verifier = verifier;
        this.verifierMode = verifierMode;
        this.keyStore = keyStore;
        this.keyStorePassword = password;
        this.context = SSLContext.getInstance("TLS");
        this.context.init(this.getKeyManagers(), this.getTrustManagers(), null);
    }

    static java.security.cert.X509Certificate[] convertCertificates(X509Certificate[] oldJSSECerts) throws GeneralSecurityException, CertificateException {
        java.security.cert.X509Certificate[] newCerts = new java.security.cert.X509Certificate[oldJSSECerts.length];
        for (int i = 0; i < newCerts.length; ++i) {
            byte[] buffer = oldJSSECerts[i].getEncoded();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
            newCerts[i] = (java.security.cert.X509Certificate)cf.generateCertificate(stream);
        }
        return newCerts;
    }

    @Override
    public SSLSocketFactory getSocketFactory() {
        return this.context.getSocketFactory();
    }

    @Override
    public SSLServerSocketFactory getServerSocketFactory() {
        return this.context.getServerSocketFactory();
    }

    private KeyManager[] getKeyManagers() throws GeneralSecurityException {
        if (this.privateKey != null) {
            return new KeyManager[]{new MyKeyManager()};
        }
        if (this.keyStore != null) {
            KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            factory.init(this.keyStore, this.keyStorePassword.toCharArray());
            return factory.getKeyManagers();
        }
        return null;
    }

    private TrustManager[] getTrustManagers() throws GeneralSecurityException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(V4ContextAdapter.loadCaCerts());
        TrustManager[] managers = factory.getTrustManagers();
        boolean foundX509 = false;
        for (int i = 0; i < managers.length; ++i) {
            if (!(managers[i] instanceof X509TrustManager)) continue;
            managers[i] = new MyTrustManager((X509TrustManager)managers[i]);
            foundX509 = true;
            break;
        }
        if (!foundX509) {
            throw new RuntimeException("No default X509TrustManager available");
        }
        return managers;
    }

    static void disableHostnameVerification(HttpsURLConnection conn) {
        conn.setHostnameVerifier(new NullHostnameVerifier());
    }

    private class MyTrustManager
    implements X509TrustManager {
        private final X509TrustManager baseManager;

        @Override
        public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String authType) throws java.security.cert.CertificateException {
            if (V3SSEContextAdapter.this.verifier != null) {
                if (V3SSEContextAdapter.this.verifierMode == 0) {
                    if (!this.isVerified(chain)) {
                        this.baseManager.checkClientTrusted(chain, authType);
                    }
                } else if (V3SSEContextAdapter.this.verifierMode == 1) {
                    if (!this.isVerified(chain)) {
                        this.baseManager.checkClientTrusted(chain, authType);
                    }
                } else if (V3SSEContextAdapter.this.verifierMode == 2) {
                    this.isVerified(chain);
                }
                throw new IllegalArgumentException("Unknown verifierMode: " + V3SSEContextAdapter.this.verifierMode);
            }
            this.baseManager.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String authType) throws java.security.cert.CertificateException {
            if (V3SSEContextAdapter.this.verifier != null) {
                if (V3SSEContextAdapter.this.verifierMode == 0) {
                    if (!this.isVerified(chain)) {
                        this.baseManager.checkClientTrusted(chain, authType);
                    }
                } else if (V3SSEContextAdapter.this.verifierMode == 1) {
                    if (!this.isVerified(chain)) {
                        this.baseManager.checkClientTrusted(chain, authType);
                    }
                } else if (V3SSEContextAdapter.this.verifierMode == 2) {
                    this.isVerified(chain);
                }
                throw new IllegalArgumentException("Unknown verifierMode: " + V3SSEContextAdapter.this.verifierMode);
            }
            this.baseManager.checkServerTrusted(chain, authType);
        }

        @Override
        public java.security.cert.X509Certificate[] getAcceptedIssuers() {
            return this.baseManager.getAcceptedIssuers();
        }

        private boolean isVerified(java.security.cert.X509Certificate[] chain) {
            try {
                V3SSEContextAdapter.this.verifier.verifyTrust(chain);
                return true;
            }
            catch (SSLVerifierException e) {
                return false;
            }
        }

        private MyTrustManager(X509TrustManager baseManager) {
            this.baseManager = baseManager;
        }
    }

    private class MyKeyManager
    implements X509KeyManager {
        public String chooseClientAlias(String keyType, Principal[] issuers) {
            return "OneAndOnly";
        }

        public String chooseServerAlias(String keyType, Principal[] issuers) {
            return "OneAndOnly";
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return IContextAdapter.ALIASES;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return "OneAndOnly";
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return IContextAdapter.ALIASES;
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return "OneAndOnly";
        }

        @Override
        public java.security.cert.X509Certificate[] getCertificateChain(String alias) {
            if ("OneAndOnly".equals(alias)) {
                return V3SSEContextAdapter.this.certChain;
            }
            return null;
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            if ("OneAndOnly".equals(alias)) {
                return V3SSEContextAdapter.this.privateKey;
            }
            return null;
        }

        private MyKeyManager() {
        }
    }

    static class NullHostnameVerifier
    implements HostnameVerifier {
        public boolean verify(String urlHost, String certHost) {
            return true;
        }

        NullHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

