/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.https;

import com.fxcm.messaging.https.IContextAdapter;
import com.fxcm.messaging.https.ISSLVerifier;
import com.fxcm.messaging.https.SSLVerifierException;
import com.fxcm.messaging.https.V3SSEContextAdapter;
import com.fxcm.messaging.https.V4ContextAdapter;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;

public class SSLTrustAdapter {
    static final String NO_SSL_MESSAGE = "Neither JSSE nor JDK1.4 are present so SSL is not available";
    static boolean isJDK14Available = false;
    static boolean isJSSEAvailable = false;
    private static final Class[] NO_CLASSES = new Class[0];
    private IContextAdapter adapter;

    public SSLTrustAdapter(ISSLVerifier verifier, int verifierMode) throws GeneralSecurityException {
        this(verifier, verifierMode, (PrivateKey)null, (X509Certificate[])null);
    }

    public SSLTrustAdapter(ISSLVerifier verifier, int verifierMode, PrivateKey privateKey, X509Certificate[] certChain) throws GeneralSecurityException {
        if (isJDK14Available) {
            this.adapter = new V4ContextAdapter(verifier, verifierMode, privateKey, certChain);
        } else if (isJSSEAvailable) {
            this.adapter = new V3SSEContextAdapter(verifier, verifierMode, privateKey, certChain);
        } else {
            throw new RuntimeException(NO_SSL_MESSAGE);
        }
    }

    public SSLTrustAdapter(ISSLVerifier verifier, int verifierMode, KeyStore keyStore, String password) throws GeneralSecurityException {
        if (isJDK14Available) {
            this.adapter = new V4ContextAdapter(verifier, verifierMode, keyStore, password);
        } else if (isJSSEAvailable) {
            this.adapter = new V3SSEContextAdapter(verifier, verifierMode, keyStore, password);
        } else {
            throw new RuntimeException(NO_SSL_MESSAGE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void verifySession(SSLSession session, ISSLVerifier verifier) throws SSLVerifierException, SSLPeerUnverifiedException {
        X509Certificate[] chain = null;
        if (isJDK14Available) {
            chain = (X509Certificate[])session.getPeerCertificates();
        } else {
            if (!isJSSEAvailable) throw new RuntimeException(NO_SSL_MESSAGE);
            javax.security.cert.X509Certificate[] certArray = session.getPeerCertificateChain();
            try {
                if (certArray != null) {
                    chain = V3SSEContextAdapter.convertCertificates(certArray);
                }
            }
            catch (Exception e) {
                throw new SSLVerifierException(e);
            }
        }
        if (chain == null) {
            throw new SSLVerifierException();
        }
        verifier.verifyTrust(chain);
    }

    public SSLSocketFactory getSocketFactory() throws GeneralSecurityException {
        return this.adapter.getSocketFactory();
    }

    public SSLServerSocketFactory getServerSocketFactory() throws GeneralSecurityException {
        return this.adapter.getServerSocketFactory();
    }

    static {
        try {
            Class.forName("javax.net.ssl.HttpsURLConnection");
            isJDK14Available = true;
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("com.sun.net.ssl.HttpsURLConnection");
                isJSSEAvailable = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

