/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.https;

import com.fxcm.messaging.https.ISSLVerifier;
import com.fxcm.messaging.https.SSLTrustAdapter;
import com.fxcm.messaging.https.SSLVerifierException;
import com.fxcm.messaging.https.V4ContextAdapter;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.CertificateException;

public class SSLAdapter {
    public static final int VERIFIER_OR = 0;
    public static final int VERIFIER_AND = 1;
    public static final int VERIFIER_ONLY = 2;
    private ISSLVerifier verifier;
    private SSLTrustAdapter sslAdapter;

    public SSLAdapter(ISSLVerifier verifier, int verifierMode) throws GeneralSecurityException {
        this(verifier, verifierMode, (PrivateKey)null, (X509Certificate[])null);
    }

    public SSLAdapter(ISSLVerifier verifier, int verifierMode, PrivateKey privateKey, X509Certificate[] certChain) throws GeneralSecurityException {
        this.verifier = verifier;
        this.sslAdapter = new SSLTrustAdapter(verifier, verifierMode, privateKey, certChain);
    }

    public SSLAdapter(ISSLVerifier verifier, int verifierMode, KeyStore keyStore, String password) throws GeneralSecurityException {
        this.verifier = verifier;
        this.sslAdapter = new SSLTrustAdapter(verifier, verifierMode, keyStore, password);
    }

    public static void verifyConnection(URLConnection aConnection, ISSLVerifier aVerifier) throws SSLVerifierException, SSLPeerUnverifiedException {
        X509Certificate[] chain;
        if (!"https".equals(aConnection.getURL().getProtocol())) {
            aVerifier.verifyTrust();
            return;
        }
        try {
            chain = SSLAdapter.getServerCertificates(aConnection);
        }
        catch (Exception e) {
            throw new SSLVerifierException(e);
        }
        if (chain == null) {
            throw new SSLPeerUnverifiedException("No server certs available");
        }
        aVerifier.verifyTrust(chain);
    }

    public static X509Certificate[] getServerCertificates(URLConnection connection) throws GeneralSecurityException, SSLPeerUnverifiedException, CertificateException {
        HttpsURLConnection httpsConn;
        Certificate[] certs;
        if (SSLTrustAdapter.isJDK14Available && connection instanceof HttpsURLConnection && (certs = (httpsConn = (HttpsURLConnection)connection).getServerCertificates()) != null) {
            X509Certificate[] x509Certs = new X509Certificate[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                x509Certs[i] = (X509Certificate)certs[i];
            }
            return x509Certs;
        }
        return null;
    }

    public static void disableHostnameVerification(URLConnection connection) {
        if (SSLTrustAdapter.isJDK14Available && connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConn = (HttpsURLConnection)connection;
            V4ContextAdapter.disableHostnameVerification(httpsConn);
        }
    }

    public void bindToConnection(URLConnection connection) throws GeneralSecurityException, SSLVerifierException {
        if (!"https".equals(connection.getURL().getProtocol())) {
            this.verifier.verifyTrust();
            return;
        }
        if (SSLTrustAdapter.isJDK14Available && connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConn = (HttpsURLConnection)connection;
            httpsConn.setSSLSocketFactory(this.sslAdapter.getSocketFactory());
        }
    }

    public SSLTrustAdapter getSSLTrustAdapter() {
        return this.sslAdapter;
    }
}

