/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.http.standard;

import com.fxcm.messaging.http.HttpOrProxyAuthenticator;
import com.fxcm.messaging.http.IHttpRequest;
import com.fxcm.messaging.http.ITrustVerifier;
import com.fxcm.messaging.http.TrustVerifierFactory;
import com.fxcm.util.logging.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.logging.Log;

public class HttpRequest
implements IHttpRequest {
    public static final String IMPLEMENTATION = "Standard";
    private static final Log cLogger = Utils.getLog(HttpRequest.class);
    private HttpURLConnection mConnection;
    private String mMethod;
    private ITrustVerifier mVerifier;
    private int mErrorStatus;
    private int mFlags;
    private int mSuccessStatus;

    public HttpRequest(String aMethod, String aResource, String aAcceptTypes, int aFlags, HttpOrProxyAuthenticator aAuthenticator, int aTimeout) throws IOException {
        this(aMethod, aResource, aAcceptTypes, aFlags, null, aAuthenticator, aTimeout);
    }

    public HttpRequest(String aMethod, String aResource, String aAcceptTypes, int aFlags, String aSSLTrustVerifier, HttpOrProxyAuthenticator aAuthenticator, int aTimeout) throws IOException {
        this.mFlags = aFlags;
        this.mMethod = aMethod.toUpperCase();
        StringBuilder sbUrl = new StringBuilder("http");
        if ((aFlags & 0x40) != 0) {
            sbUrl.append('s');
            TrustVerifierFactory factory = TrustVerifierFactory.getInstance(aSSLTrustVerifier);
            if (factory != null) {
                this.mVerifier = factory.getVerifier();
            }
        }
        if (aAuthenticator.getProxyHost() != null) {
            System.setProperty(sbUrl + ".proxyHost", aAuthenticator.getProxyHost());
            System.setProperty(sbUrl + ".proxyPort", String.valueOf(aAuthenticator.getProxyPort()));
        }
        sbUrl.append("://");
        sbUrl.append(aAuthenticator.getHost());
        if (aAuthenticator.getPort() >= 0) {
            sbUrl.append(':');
            sbUrl.append(aAuthenticator.getPort());
        }
        if (!aResource.startsWith("/")) {
            sbUrl.append('/');
        }
        sbUrl.append(aResource);
        URL url = new URL(sbUrl.toString());
        this.mConnection = (HttpURLConnection)url.openConnection();
        this.mConnection.setRequestProperty("Cache-Control", "no-cache");
        this.mConnection.setRequestProperty("Connection", "Keep-Alive");
        this.mConnection.setConnectTimeout(aTimeout);
        this.mConnection.setReadTimeout(aTimeout);
        if (aAcceptTypes != null) {
            this.mConnection.setRequestProperty("Accept", aAcceptTypes);
        }
    }

    @Override
    public void addReqHeader(String aName, String aValue) {
        this.mConnection.setRequestProperty(aName, aValue);
    }

    @Override
    public void close() {
        this.mConnection.disconnect();
    }

    @Override
    public int getErrorStatus() {
        return this.mErrorStatus;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.mConnection.getInputStream();
    }

    @Override
    public String getRespHeader(String aName) {
        return this.mConnection.getHeaderField(aName);
    }

    @Override
    public byte[] getResponseBody() throws IOException {
        byte[] responseBody;
        block14: {
            responseBody = null;
            try (InputStream instream = this.getInputStream();){
                int len;
                if (instream == null) break block14;
                String requestProperty = this.mConnection.getRequestProperty("Content-Length");
                long contentLength = 0L;
                try {
                    contentLength = Long.parseLong(requestProperty);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (contentLength > Integer.MAX_VALUE) {
                    throw new IOException("Content too large to be buffered: " + contentLength + " bytes");
                }
                ByteArrayOutputStream outstream = new ByteArrayOutputStream(contentLength > 0L ? (int)contentLength : 32768);
                byte[] buffer = new byte[32768];
                while ((len = instream.read(buffer)) > 0) {
                    outstream.write(buffer, 0, len);
                }
                outstream.close();
                responseBody = outstream.toByteArray();
            }
            catch (IOException aException) {
                try {
                    this.mConnection.getErrorStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw aException;
            }
        }
        return responseBody;
    }

    @Override
    public int getSuccessStatus() {
        return this.mSuccessStatus;
    }

    @Override
    public String getImplementation() {
        return IMPLEMENTATION;
    }

    @Override
    public void send() throws IOException {
        this.send(null, 0, 0);
    }

    @Override
    public void send(byte[] aRequestBody, int aBegin, int aLength) throws IOException {
        int iStatus;
        int iLength;
        this.mConnection.setRequestMethod(this.mMethod);
        boolean bPost = "POST".equals(this.mMethod);
        int n = bPost && aRequestBody != null && aRequestBody.length - aBegin > 0 && aLength > 0 ? (aRequestBody.length - aBegin >= aLength ? aLength : aRequestBody.length - aBegin) : (iLength = 0);
        if (bPost) {
            this.mConnection.setRequestProperty("Content-Length", String.valueOf(iLength));
            if (iLength > 0) {
                this.mConnection.setDoOutput(true);
            }
        }
        if (this.mVerifier != null) {
            try {
                this.mVerifier.bindToConnection(this.mConnection);
                if ((this.mFlags & 0x10) != 0) {
                    this.mVerifier.disableHostnameVerification(this.mConnection);
                }
            }
            catch (Exception e) {
                cLogger.error(e.getMessage(), e);
            }
        }
        if (iLength > 0) {
            OutputStream out = this.mConnection.getOutputStream();
            out.write(aRequestBody, aBegin, iLength);
        }
        if ((iStatus = this.mConnection.getResponseCode()) < 400) {
            this.mSuccessStatus = iStatus;
        } else {
            this.mErrorStatus = iStatus;
        }
    }
}

