/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.http.apache;

import com.fxcm.messaging.http.HttpOrProxyAuthenticator;
import com.fxcm.messaging.http.IHttpRequest;
import com.fxcm.util.logging.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpRequest
implements IHttpRequest {
    public static final String IMPLEMENTATION = "Apache";
    private static final int cMaxTotal = HttpRequest.safeInt(System.getProperty("apache.pool.max-total"), 40);
    private static final int cDefaultMaxPerRoute = HttpRequest.safeInt(System.getProperty("apache.pool.max-per-route"), 4);
    private static final PoolingHttpClientConnectionManager cConnectionManager = new PoolingHttpClientConnectionManager();
    private int mErrorStatus;
    private CloseableHttpClient mHttpClient;
    private HttpRequestBase mHttpMethod;
    private CloseableHttpResponse mHttpResponse;
    private final Log mLogger = Utils.getLog(this);
    private int mSuccessStatus;

    public HttpRequest(String aMethod, String aResource, String aAcceptTypes, int aFlags, HttpOrProxyAuthenticator aAuthenticator, int aTimeout) {
        this(aMethod, aResource, aAcceptTypes, aFlags, null, aAuthenticator, aTimeout);
    }

    public HttpRequest(String aMethod, String aResource, String aAcceptTypes, int aFlags, String aSSLTrustVerifier, HttpOrProxyAuthenticator aAuthenticator, int aTimeout) {
        StringBuilder url = new StringBuilder("http");
        if ((aFlags & 0x40) != 0) {
            url.append('s');
        }
        url.append("://");
        url.append(aAuthenticator.getHost());
        if (aAuthenticator.getPort() >= 0) {
            url.append(':');
            url.append(aAuthenticator.getPort());
        }
        if (!aResource.startsWith("/")) {
            url.append('/');
        }
        url.append(aResource);
        HttpClientBuilder hcb = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cConnectionManager);
        if (aAuthenticator.getProxyHost() != null) {
            HttpHost proxy = new HttpHost(aAuthenticator.getProxyHost(), aAuthenticator.getProxyPort());
            hcb.setProxy(proxy);
        }
        int soTimeout = HttpRequest.safeInt(System.getProperty("sun.net.client.defaultReadTimeout"), aTimeout);
        hcb.setDefaultSocketConfig(SocketConfig.custom().setSoKeepAlive(true).setSoReuseAddress(true).setTcpNoDelay(true).setSoTimeout(soTimeout).build());
        int connectTimeout = HttpRequest.safeInt(System.getProperty("sun.net.client.defaultConnectTimeout"), aTimeout);
        hcb.setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(connectTimeout).build());
        this.mHttpClient = hcb.build();
        this.mHttpMethod = "POST".equals(aMethod.toUpperCase()) ? new HttpPost(url.toString()) : new HttpGet(url.toString());
        this.addReqHeader("Cache-Control", "no-cache");
        this.addReqHeader("Connection", "Keep-Alive");
        if (aAcceptTypes != null) {
            this.addReqHeader("Accept", aAcceptTypes);
        }
    }

    @Override
    public void addReqHeader(String aName, String aValue) {
        this.mHttpMethod.setHeader(aName, aValue);
    }

    @Override
    public void close() {
        this.mLogger.debug("closing expired and idle apache connections");
        cConnectionManager.closeExpiredConnections();
        cConnectionManager.closeIdleConnections(1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public int getErrorStatus() {
        return this.mErrorStatus;
    }

    @Override
    public String getImplementation() {
        return IMPLEMENTATION;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.mHttpResponse.getEntity().getContent();
    }

    @Override
    public String getRespHeader(String aName) {
        Header header = this.mHttpResponse.getFirstHeader(aName);
        return header == null ? null : header.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getResponseBody() throws IOException {
        try {
            byte[] responseBody = null;
            InputStream instream = this.getInputStream();
            if (instream != null) {
                int len;
                long contentLength = 0L;
                try {
                    contentLength = Long.parseLong(this.getRespHeader("Content-Length"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (contentLength > Integer.MAX_VALUE) {
                    throw new IOException("Content too large to be buffered: " + contentLength + " bytes");
                }
                ByteArrayOutputStream outstream = new ByteArrayOutputStream(contentLength > 0L ? (int)contentLength : 32768);
                byte[] buffer = new byte[32768];
                while ((len = instream.read(buffer)) > 0) {
                    outstream.write(buffer, 0, len);
                }
                outstream.close();
                responseBody = outstream.toByteArray();
            }
            byte[] byArray = responseBody;
            return byArray;
        }
        finally {
            this.mHttpResponse.close();
        }
    }

    @Override
    public int getSuccessStatus() {
        return this.mSuccessStatus;
    }

    @Override
    public void send() throws IOException {
        this.send(null, 0, 0);
    }

    @Override
    public void send(byte[] aRequestBody, int aBegin, int aLength) throws IOException {
        this.mHttpResponse = null;
        try {
            this.mHttpResponse = this.mHttpClient.execute((HttpUriRequest)this.mHttpMethod);
        }
        catch (IOException e) {
            this.mLogger.error(e.getMessage(), e);
            throw e;
        }
        if (this.mHttpResponse.getStatusLine().getStatusCode() < 400) {
            this.mSuccessStatus = this.mHttpResponse.getStatusLine().getStatusCode();
        } else {
            this.mErrorStatus = this.mHttpResponse.getStatusLine().getStatusCode();
        }
    }

    private static int safeInt(String aField, int aDefault) {
        if (aField == null) {
            return aDefault;
        }
        try {
            return Integer.parseInt(aField);
        }
        catch (Exception e) {
            return aDefault;
        }
    }

    static {
        cConnectionManager.setMaxTotal(cMaxTotal);
        cConnectionManager.setDefaultMaxPerRoute(cDefaultMaxPerRoute);
    }
}

