/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.http;

import com.fxcm.messaging.http.ITrustVerifier;
import com.fxcm.util.Util;
import java.util.Hashtable;
import org.apache.commons.logging.Log;

public class TrustVerifierFactory {
    private static final Log moLogger = Util.getLog(TrustVerifierFactory.class);
    private static final String TRUST_ALL = "all";
    private static final String TRUST_NONE = "none";
    private static final Boolean CANNOT_BE_INSTANCED = true;
    private static Hashtable cTrustVerifierFactories = new Hashtable();
    private Class mTrustVerifierClass;

    private TrustVerifierFactory(String asSllTrustVerifier) throws Exception {
        if (!TRUST_NONE.equals(asSllTrustVerifier)) {
            this.mTrustVerifierClass = Class.forName("com.fxcm.messaging.http." + asSllTrustVerifier.toUpperCase() + "TrustVerifier");
            if (!((Boolean)this.mTrustVerifierClass.getMethod("canBeInstanced", new Class[0]).invoke(null, new Object[0])).booleanValue()) {
                throw new Exception("Verifier " + asSllTrustVerifier + " can't be instanced");
            }
        }
    }

    public static TrustVerifierFactory getInstance(String asSllTrustVerifier) {
        String sSllTrustVerifier = asSllTrustVerifier == null ? TRUST_ALL : asSllTrustVerifier;
        Object res = cTrustVerifierFactories.get(sSllTrustVerifier);
        if (res == null) {
            res = CANNOT_BE_INSTANCED;
            try {
                res = new TrustVerifierFactory(sSllTrustVerifier);
            }
            catch (Exception e) {
                moLogger.error("", e);
            }
            cTrustVerifierFactories.put(sSllTrustVerifier, res);
        }
        if (res == CANNOT_BE_INSTANCED) {
            return null;
        }
        return (TrustVerifierFactory)res;
    }

    public ITrustVerifier getVerifier() {
        ITrustVerifier res = null;
        if (this.mTrustVerifierClass != null) {
            try {
                res = (ITrustVerifier)this.mTrustVerifierClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                moLogger.error("", e);
            }
        }
        return res;
    }
}

