/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.http;

import com.fxcm.messaging.http.HttpOrProxyAuthenticator;
import com.fxcm.messaging.http.IHttpRequest;
import com.fxcm.messaging.http.apache.HttpRequest;
import java.io.IOException;
import java.net.Authenticator;

public class HttpConnection {
    private HttpOrProxyAuthenticator mAuthenticator = new HttpOrProxyAuthenticator();

    private HttpConnection(String aHost, int aPort, String aHttpUid, String aHttpPwd) {
        Authenticator.setDefault(this.mAuthenticator);
        this.initAuthenticator(aHost, aPort, aHttpUid, aHttpPwd);
    }

    public void close() {
        if (this.mAuthenticator != null) {
            this.mAuthenticator = null;
            Authenticator.setDefault(this.mAuthenticator);
        }
    }

    public static HttpConnection httpConnect(String aHost, int aPort, String aHttpUid, String aHttpPwd) {
        return new HttpConnection(aHost, aPort, aHttpUid, aHttpPwd);
    }

    private void initAuthenticator(String aHost, int aPort, String aHttpUid, String aHttpPwd) {
        this.mAuthenticator.setHost(aHost);
        this.mAuthenticator.setPort(aPort);
        this.mAuthenticator.setHttpUid(aHttpUid);
        this.mAuthenticator.setHttpPwd(aHttpPwd);
    }

    private void initAuthenticatorProxy(String aProxyHost, int aProxyPort, String aProxyUid, String aProxyPwd) {
        this.mAuthenticator.setProxyHost(aProxyHost);
        this.mAuthenticator.setProxyPort(aProxyPort);
        this.mAuthenticator.setProxyUid(aProxyUid);
        this.mAuthenticator.setProxyPwd(aProxyPwd);
    }

    public IHttpRequest openRequest(String aMethod, String aResource, String aAcceptTypes, int aFlags, String aHttpImplementation, int aTimeout) throws IOException {
        if ("Apache".equalsIgnoreCase(aHttpImplementation)) {
            return new HttpRequest(aMethod, aResource, aAcceptTypes, aFlags, this.mAuthenticator, aTimeout);
        }
        return new com.fxcm.messaging.http.standard.HttpRequest(aMethod, aResource, aAcceptTypes, aFlags, this.mAuthenticator, aTimeout);
    }

    public IHttpRequest openRequest(String aMethod, String aResource, String aAcceptTypes, int aFlags, String aSSLTrustVerifier, String aHttpImplementation, int aTimeout) throws IOException {
        if (this.mAuthenticator != null && 0 == this.mAuthenticator.getPort()) {
            this.mAuthenticator.setPort((aFlags & 0x40) == 0 ? 80 : 443);
        }
        if ("Apache".equalsIgnoreCase(aHttpImplementation)) {
            return new HttpRequest(aMethod, aResource, aAcceptTypes, aFlags, aSSLTrustVerifier, this.mAuthenticator, aTimeout);
        }
        return new com.fxcm.messaging.http.standard.HttpRequest(aMethod, aResource, aAcceptTypes, aFlags, aSSLTrustVerifier, this.mAuthenticator, aTimeout);
    }

    public void setProxyOptions(String aProxyHost, int aProxyPort, String aProxyUid, String aProxyPwd) {
        this.initAuthenticatorProxy(aProxyHost, aProxyPort, aProxyUid, aProxyPwd);
    }
}

