/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.http;

import com.fxcm.messaging.http.ITrustVerifier;
import com.fxcm.util.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import org.apache.commons.logging.Log;

public class ALLTrustVerifier
implements ITrustVerifier {
    private static final Log moLogger = Util.getLog(ALLTrustVerifier.class);
    private static Class cAllTrustVerifierClass;
    private static Class cTrustAdapterClass;
    private static Constructor cTrustAdapterConstructor;
    private static Method cTrustAdapterBindMethod;
    private static Method cTrustAdapterDisableHVMethod;
    private static boolean cCanBeInstanced;
    private static Object cAdapter;

    public static boolean canBeInstanced() {
        return cCanBeInstanced;
    }

    @Override
    public void bindToConnection(URLConnection aConnection) throws GeneralSecurityException {
        try {
            if (cTrustAdapterBindMethod != null) {
                ALLTrustVerifier.checkAdpaterExistance();
                cTrustAdapterBindMethod.invoke(cAdapter, aConnection);
            }
        }
        catch (InvocationTargetException e) {
            Throwable thr = e.getTargetException();
            if (thr instanceof GeneralSecurityException) {
                throw (GeneralSecurityException)thr;
            }
        }
        catch (Exception e) {
            moLogger.error("", e);
        }
    }

    @Override
    public void disableHostnameVerification(URLConnection aConnection) throws GeneralSecurityException {
        try {
            if (cTrustAdapterDisableHVMethod != null) {
                ALLTrustVerifier.checkAdpaterExistance();
                cTrustAdapterDisableHVMethod.invoke(cAdapter, aConnection);
            }
        }
        catch (InvocationTargetException e) {
            Throwable thr = e.getTargetException();
            if (thr instanceof GeneralSecurityException) {
                throw (GeneralSecurityException)thr;
            }
        }
        catch (Exception e) {
            moLogger.error("", e);
        }
    }

    private static synchronized void checkAdpaterExistance() throws Exception {
        if (cAdapter == null) {
            Object verifier = cAllTrustVerifierClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            cAdapter = cTrustAdapterConstructor.newInstance(verifier, 2);
        }
    }

    static {
        try {
            cTrustAdapterClass = Class.forName("com.fxcm.messaging.https.SSLAdapter");
            cAllTrustVerifierClass = Class.forName("com.fxcm.messaging.https.AllTrustVerifier");
            Class<?> trustVerifierInterface = Class.forName("com.fxcm.messaging.https.ISSLVerifier");
            cTrustAdapterConstructor = cTrustAdapterClass.getConstructor(trustVerifierInterface, Integer.TYPE);
            cTrustAdapterBindMethod = cTrustAdapterClass.getMethod("bindToConnection", URLConnection.class);
            cTrustAdapterDisableHVMethod = cTrustAdapterClass.getMethod("disableHostnameVerification", URLConnection.class);
            cCanBeInstanced = true;
        }
        catch (Exception e) {
            moLogger.error("", e);
        }
    }
}

