/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging;

import com.fxcm.util.Util;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TradingSessionDesc {
    private int mErrorCode;
    private String mErrorMessage;
    private String mID;
    private final Log mLogger = LogFactory.getLog(TradingSessionDesc.class);
    private Map mProperties;
    private String mSubID;

    public TradingSessionDesc() {
        this.mID = "FXCM";
        this.mSubID = "n/a";
    }

    public TradingSessionDesc(String aFields) {
        this.parse(aFields);
    }

    public TradingSessionDesc(String aSubID, String aID, String aName, String aDesc) {
        this.mID = aID;
        this.mSubID = aSubID;
        if (aName != null || aDesc != null) {
            this.mProperties = new HashMap();
            this.setName((String)(aName == null ? this.mID + this.mSubID : aName));
            this.setDesc((String)(aDesc == null ? this.mID + this.mSubID : aDesc));
        }
    }

    public TradingSessionDesc(String aSubID, String aID) {
        this.mID = aID;
        this.mSubID = aSubID;
    }

    public String getDesc() {
        return this.getProperty("DESC");
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    public void setErrorCode(int aErrorCode) {
        this.mErrorCode = aErrorCode;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public void setErrorMessage(String aErrorMessage) {
        this.mErrorMessage = aErrorMessage;
    }

    public String getID() {
        return this.mID;
    }

    public void setID(String aID) {
        this.mID = aID;
    }

    public String getName() {
        return this.getProperty("NAME");
    }

    public Map getProperties() {
        return this.mProperties;
    }

    public String getProperty(String aKey) {
        String ret = null;
        if (this.mProperties != null) {
            ret = (String)this.mProperties.get(aKey);
        }
        return ret;
    }

    public String getSubID() {
        return this.mSubID;
    }

    public void setSubID(String aSubID) {
        this.mSubID = aSubID;
    }

    public void parse(String aFields) {
        String[] fields = Util.splitToArray(aFields, ";");
        if (this.mProperties != null) {
            this.mProperties.clear();
        }
        this.mSubID = null;
        this.mID = null;
        block6: for (int i = 0; i < fields.length; ++i) {
            String[] keyvalues = Util.splitToArray(fields[i], "=");
            if (keyvalues.length > 1) {
                if ("SUBID".equals(keyvalues[0])) {
                    this.mSubID = keyvalues[1];
                    continue;
                }
                if ("ID".equals(keyvalues[0])) {
                    this.mID = keyvalues[1];
                    continue;
                }
                this.setProperty(keyvalues[0], keyvalues[1]);
                continue;
            }
            if (keyvalues.length != 1) continue;
            switch (i) {
                case 0: {
                    this.setSubID(keyvalues[0]);
                    continue block6;
                }
                case 1: {
                    this.setID(keyvalues[0]);
                    continue block6;
                }
                case 2: {
                    this.setName(keyvalues[0]);
                    continue block6;
                }
                case 3: {
                    this.setDesc(keyvalues[0]);
                }
            }
        }
        if (this.mID == null) {
            this.mID = "FXCM";
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("parsing aFields = " + aFields + " => " + this.toString());
        }
    }

    public String getParamLine() {
        Object ret = "";
        if (this.mProperties != null) {
            for (String key : this.mProperties.keySet()) {
                ret = (String)ret + key + "=" + this.mProperties.get(key) + ";";
            }
        }
        return ret;
    }

    public void setDesc(String aDesc) {
        if (aDesc != null) {
            this.setProperty("DESC", aDesc);
        }
    }

    public void setName(String aName) {
        if (aName != null) {
            this.setProperty("NAME", aName);
        }
    }

    public void setProperty(String aKey, String aValue) {
        if (this.mProperties == null) {
            this.mProperties = new HashMap();
        }
        this.mProperties.put(aKey, aValue);
    }

    public String toString() {
        return this.getSubID() + ";" + this.getID() + ";" + (this.mProperties == null ? "" : this.mProperties.toString());
    }
}

