/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging;

import com.fxcm.GenericException;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.IUserSession;
import com.fxcm.messaging.util.ConnectionManagerDummy;
import com.fxcm.messaging.util.IConnectionManager;
import com.fxcm.messaging.util.TransportProviderFactory;
import com.fxcm.messaging.util.versioning.FXCMVersion;
import com.fxcm.util.Util;
import com.fxcm.util.logging.Utils;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;

public class ConnectionManagerEx {
    private static final Log moLogger = Utils.getLog(ConnectionManagerEx.class);
    private static IConnectionManager cConnectionManager = new ConnectionManagerDummy();
    private static final Vector cUserSessions = new Vector();
    private static Properties cProperties;

    private static void fillDefaultProperties(Properties aProperties) {
        ConnectionManagerEx.fillDefaultProperty(aProperties, "com.fxcm.messaging.IConnectionManager.NoReloginAttempts", "3");
        ConnectionManagerEx.fillDefaultProperty(aProperties, "com.fxcm.messaging.IConnectionManager.ReloginTimeout", "2000");
        ConnectionManagerEx.fillDefaultProperty(aProperties, "com.fxcm.messaging.IConnectionManager.NoReconnectAttempts", "3");
        ConnectionManagerEx.fillDefaultProperty(aProperties, "com.fxcm.messaging.IConnectionManager.ReconnectTimeout", "2000");
        ConnectionManagerEx.fillDefaultProperty(aProperties, "com.fxcm.messaging.IConnectionManager.PollInterval", "2000");
        ConnectionManagerEx.fillDefaultProperty(aProperties, "com.fxcm.messaging.IConnectionManager.BatchSize", "20");
        ConnectionManagerEx.fillDefaultProperty(aProperties, "com.fxcm.messaging.IConnectionManager.TcpTimeout", "180000");
        ConnectionManagerEx.fillDefaultProperty(aProperties, "com.fxcm.messaging.IConnectionManager.HttpTimeout", "180000");
        ConnectionManagerEx.fillDefaultProperty(aProperties, "com.fxcm.messaging.IConnectionManager.AdminMessages", "false");
        ConnectionManagerEx.fillDefaultProperty(aProperties, "com.fxcm.messaging.IConnectionManager.SecurePreferable", "true");
        ConnectionManagerEx.fillDefaultProperty(aProperties, "com.fxcm.messaging.IConnectionManager.AsyncPreferable", "true");
        ConnectionManagerEx.fillDefaultProperty(aProperties, "com.fxcm.messaging.IConnectionManager.ClassName", "com.fxcm.messaging.util.DoubleConnectionManager");
        ConnectionManagerEx.fillDefaultProperty(aProperties, "MessageFlags", "0");
        ConnectionManagerEx.fillDefaultProperty(aProperties, "ssl.trust", "all");
        ConnectionManagerEx.fillDefaultProperty(aProperties, "ssl.ignore.cn.invalid", "y");
    }

    private static void fillDefaultProperty(Properties aProperties, String aName, String aValue) {
        if (!aProperties.containsKey(aName)) {
            aProperties.setProperty(aName, aValue);
        }
    }

    private static void resetStatic() {
        String classname = cProperties.getProperty("com.fxcm.messaging.IConnectionManager.ClassName");
        if (!classname.equals(cConnectionManager.getClass().getName())) {
            try {
                Class<?> cm = Class.forName(classname);
                cConnectionManager = (IConnectionManager)cm.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                cConnectionManager.setProperties(cProperties);
            }
            catch (Exception e) {
                moLogger.debug("", e);
            }
        }
    }

    public static void init(String aProperitesFileName) {
        Properties p = null;
        if (aProperitesFileName != null) {
            try {
                p = Util.loadProperties(aProperitesFileName);
                if (moLogger.isDebugEnabled()) {
                    moLogger.debug("use " + aProperitesFileName);
                }
            }
            catch (Exception e) {
                moLogger.error("Unable to parse " + aProperitesFileName + ". Skip the error. use defaults taken from fxmsg.properties");
            }
        }
        ConnectionManagerEx.init(p);
    }

    public static void init(Properties aProps) {
        Object key;
        if (aProps != null && !aProps.isEmpty()) {
            ConnectionManagerEx.fillDefaultProperties(cProperties);
            Enumeration<Object> en = aProps.keys();
            while (en.hasMoreElements()) {
                key = (String)en.nextElement();
                cProperties.setProperty((String)key, (String)aProps.get(key));
            }
        }
        if (aProps != null) {
            Enumeration<Object> keys = cProperties.keys();
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                Object value = cProperties.get(key);
                if (key == null || value == null) continue;
                try {
                    aProps.put(key, value);
                }
                catch (Exception e) {
                    moLogger.error("", e);
                }
            }
        }
        ConnectionManagerEx.resetStatic();
        if (moLogger.isDebugEnabled()) {
            moLogger.debug("Connection Properties:" + cProperties);
        }
    }

    public static String getVersion() {
        return new FXCMVersion().toString();
    }

    public static void setNoReloginAttempts(int aAttempts) {
        if (aAttempts >= 0) {
            cProperties.setProperty("com.fxcm.messaging.IConnectionManager.NoReloginAttempts", String.valueOf(aAttempts));
        }
    }

    public static void setReloginTimeout(int aTimeout) {
        if (aTimeout > 3000) {
            cProperties.setProperty("com.fxcm.messaging.IConnectionManager.ReloginTimeout", String.valueOf(aTimeout));
        }
    }

    public static void setNoReconnectAttempts(int aAttempts) {
        if (aAttempts >= 0) {
            cProperties.setProperty("com.fxcm.messaging.IConnectionManager.NoReconnectAttempts", String.valueOf(aAttempts));
        }
    }

    public static void setReconnectTimeout(int aTimeout) {
        cProperties.setProperty("com.fxcm.messaging.IConnectionManager.ReconnectTimeout", String.valueOf(aTimeout));
    }

    public static void setInterval(long aMilliSec) {
        cProperties.setProperty("com.fxcm.messaging.IConnectionManager.PollInterval", String.valueOf(aMilliSec));
    }

    public static void setBatchSize(int aNumberOfMessagesInBatch) {
        cProperties.setProperty("com.fxcm.messaging.IConnectionManager.BatchSize", String.valueOf(aNumberOfMessagesInBatch));
    }

    public static void setProxyServer(String aAddress, int aPort) {
        if (aAddress == null) {
            cProperties.remove("com.fxcm.messaging.IConnectionManager.ProxyServer");
            cProperties.remove("com.fxcm.messaging.IConnectionManager.ProxyPort");
        } else {
            cProperties.setProperty("com.fxcm.messaging.IConnectionManager.ProxyServer", aAddress);
            cProperties.setProperty("com.fxcm.messaging.IConnectionManager.ProxyPort", String.valueOf(aPort));
        }
    }

    public static void setBasicProxyAuthorization(String aUserID, String aPassword) {
        if (aUserID == null) {
            cProperties.remove("com.fxcm.messaging.IConnectionManager.ProxyUserID");
            cProperties.remove("com.fxcm.messaging.IConnectionManager.ProxyPassword");
        } else {
            cProperties.setProperty("com.fxcm.messaging.IConnectionManager.ProxyUserID", aUserID);
            cProperties.setProperty("com.fxcm.messaging.IConnectionManager.ProxyPassword", aPassword);
        }
    }

    public static void setProxyAuthenticationRealm(String aProxyAuthenticationRealm) {
        if (aProxyAuthenticationRealm == null) {
            cProperties.remove("com.fxcm.messaging.IConnectionManager.ProxyRealm");
        } else {
            cProperties.setProperty("com.fxcm.messaging.IConnectionManager.ProxyRealm", aProxyAuthenticationRealm);
        }
    }

    public static void setProxyType(String aProxyType) {
        if (aProxyType == null) {
            cProperties.remove("com.fxcm.messaging.IConnectionManager.ProxyType");
        } else {
            cProperties.setProperty("com.fxcm.messaging.IConnectionManager.ProxyType", aProxyType);
        }
    }

    public static void setProxyOverHTTP11(boolean aFlag) {
        cProperties.setProperty("com.fxcm.messaging.IConnectionManager.ProxyHTTP11", String.valueOf(aFlag));
    }

    public static void setTcpTimeout(int aTimeout) {
        cProperties.setProperty("com.fxcm.messaging.IConnectionManager.TcpTimeout", String.valueOf(aTimeout));
    }

    public static void setHttpTimeout(int aTimeout) {
        cProperties.setProperty("com.fxcm.messaging.IConnectionManager.HttpTimeout", String.valueOf(aTimeout));
    }

    public static void setListenAdminMessages(boolean aFlag) {
        cProperties.setProperty("com.fxcm.messaging.IConnectionManager.AdminMessages", String.valueOf(aFlag));
    }

    public static void setSecurePreferable(boolean aFlag) {
        cProperties.setProperty("com.fxcm.messaging.IConnectionManager.SecurePreferable", String.valueOf(aFlag));
    }

    public static void setAsync(boolean aFlag) {
        cProperties.setProperty("com.fxcm.messaging.IConnectionManager.AsyncPreferable", String.valueOf(aFlag));
    }

    public static void setMsgFlags(long aMsgFlags) {
        cProperties.setProperty("MessageFlags", String.valueOf(aMsgFlags));
    }

    public static IMessageFactory getMessageFactory() {
        return cConnectionManager.getMessageFactory();
    }

    public static IUserSession createUserSession(String aHostDescriptorURL, String aHostName, String aServiceName, String aLoginID, String aPassword, String aStationName) {
        return ConnectionManagerEx.createUserSession(aHostDescriptorURL, aHostName, aServiceName, aLoginID, aPassword, aStationName, cConnectionManager);
    }

    public static IUserSession createUserSession(String aHostDescriptorURL, String aHostName, String aServiceName, String aLoginID, String aPassword, String aStationName, IConnectionManager aConnectionManager) {
        String service = aServiceName;
        String id = null;
        String subId = null;
        if (aServiceName == null) {
            service = aHostName;
        }
        if (service != null) {
            id = "FXCM";
            subId = service;
        }
        aConnectionManager.setProperties(cProperties);
        IUserSession ret = aConnectionManager.createUserSession(aHostDescriptorURL, aHostName, service, id, subId, aLoginID, aPassword, aStationName);
        ConnectionManagerEx.addSession(ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addSession(IUserSession aRet) {
        Vector vector = cUserSessions;
        synchronized (vector) {
            for (int i = cUserSessions.size(); i > 0; --i) {
                if (!((IUserSession)cUserSessions.get(i - 1)).isClosed()) continue;
                cUserSessions.remove(i - 1);
            }
            cUserSessions.add(aRet);
        }
    }

    public static IUserSession createPriceSession(IUserSession aUserSession) {
        IUserSession ret = cConnectionManager.createPriceChannelSession(aUserSession);
        if (ret == null) {
            return null;
        }
        ConnectionManagerEx.addSession(ret);
        return ret;
    }

    public static IUserSession createUserSessionOpenToken(String aHostDescriptorURL, String aHostDescriptorXML, String aHostName, String aServiceName, String aOpenToken, String aStationName) {
        return ConnectionManagerEx.createUserSessionOpenToken(aHostDescriptorURL, aHostDescriptorXML, aHostName, aServiceName, aOpenToken, aStationName, cConnectionManager);
    }

    public static IUserSession createUserSessionSso(String aHostDescriptorURL, String aHostDescriptorXML, String aHostName, String aServiceName, String aLoginId, String aSsoToken, String aStationName) {
        return ConnectionManagerEx.createUserSessionSso(aHostDescriptorURL, aHostDescriptorXML, aHostName, aServiceName, aLoginId, aSsoToken, aStationName, cConnectionManager);
    }

    public static IUserSession createUserSessionSso(String aHostDescriptorURL, String aHostName, String aServiceName, String aLoginId, String aSsoToken, String aStationName) {
        return ConnectionManagerEx.createUserSessionSso(aHostDescriptorURL, null, aHostName, aServiceName, aLoginId, aSsoToken, aStationName, cConnectionManager);
    }

    public static IUserSession createUserSessionOpenToken(String aHostDescriptorURL, String aHostDescriptorXML, String aHostName, String aServiceName, String aOpenToken, String aStationName, IConnectionManager aConnectionManager) {
        String service = aServiceName;
        String id = null;
        String subId = null;
        if (aServiceName == null) {
            service = aHostName;
        }
        if (service != null) {
            id = "FXCM";
            subId = service;
        }
        aConnectionManager.setProperties(cProperties);
        IUserSession ret = aConnectionManager.createUserSessionOpenToken(aHostDescriptorURL, aHostDescriptorXML, aHostName, service, id, subId, aOpenToken, aStationName);
        ConnectionManagerEx.addSession(ret);
        return ret;
    }

    public static IUserSession createUserSessionSso(String aHostDescriptorURL, String aHostDescriptorXML, String aHostName, String aServiceName, String aLoginId, String aSsoToken, String aStationName, IConnectionManager aConnectionManager) {
        String service = aServiceName;
        String id = null;
        String subId = null;
        if (aServiceName == null) {
            service = aHostName;
        }
        if (service != null) {
            id = "FXCM";
            subId = service;
        }
        aConnectionManager.setProperties(cProperties);
        IUserSession ret = aConnectionManager.createUserSessionSso(aHostDescriptorURL, aHostDescriptorXML, aHostName, service, id, subId, aLoginId, aSsoToken, aStationName);
        ConnectionManagerEx.addSession(ret);
        return ret;
    }

    public static IUserSession createUserSession(String aHostDescriptorURL, String aHostName, String aLoginID, String aPassword, String aStationName) {
        return ConnectionManagerEx.createUserSession(aHostDescriptorURL, aHostName, null, aLoginID, aPassword, aStationName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IUserSession getUserSession(String aSessionID) {
        IUserSession ret = null;
        if (aSessionID != null) {
            Vector vector = cUserSessions;
            synchronized (vector) {
                Enumeration en = cUserSessions.elements();
                while (en.hasMoreElements()) {
                    IUserSession us = (IUserSession)en.nextElement();
                    if (!aSessionID.equals(us.getSessionID())) continue;
                    ret = us;
                    break;
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getUserSessions(String aSessionID) {
        Enumeration ret = null;
        if (aSessionID != null) {
            Vector vector = cUserSessions;
            synchronized (vector) {
                Vector<IUserSession> sessions = new Vector<IUserSession>();
                Enumeration en = cUserSessions.elements();
                while (en.hasMoreElements()) {
                    IUserSession us = (IUserSession)en.nextElement();
                    if (!aSessionID.equals(us.getSessionID())) continue;
                    sessions.add(us);
                }
                ret = sessions.elements();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup() {
        Vector vector = cUserSessions;
        synchronized (vector) {
            Enumeration en = cUserSessions.elements();
            while (en.hasMoreElements()) {
                try {
                    IUserSession session = (IUserSession)en.nextElement();
                    session.close();
                }
                catch (Exception e) {
                    moLogger.error("", e);
                }
            }
            cUserSessions.clear();
        }
        cConnectionManager.cleanup();
        TransportProviderFactory.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup(IUserSession aUserSession) {
        try {
            aUserSession.close();
        }
        catch (GenericException e) {
            e.printStackTrace();
        }
        Vector vector = cUserSessions;
        synchronized (vector) {
            cUserSessions.remove(aUserSession);
        }
        cConnectionManager.cleanup();
    }

    public static void setDebug(boolean aFlag) {
        System.out.println("ConnectionManagerEx.setDebug: setDebug is deprecated and empty.  Use commons-logging");
    }

    static {
        try {
            cProperties = Util.loadProperties("fxmsg.properties");
        }
        catch (Exception e) {
            moLogger.error("Unable to parse fxmsg.properties. Skip the error.");
            cProperties = new Properties();
        }
        ConnectionManagerEx.fillDefaultProperties(cProperties);
        ConnectionManagerEx.resetStatic();
    }
}

