/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.logger;

import com.fxcm.logger.LoggerConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Logger
implements LoggerConstants {
    private static Log cLog = LogFactory.getLog("com.fxcm");

    private Logger() {
    }

    public static void debug(Throwable aError) {
        cLog.error("", aError);
    }

    public static void debug(String aMsg) {
        cLog.debug(aMsg);
    }

    public static void debug(Object aCaller, Throwable aError) {
        if (aCaller == null) {
            if (cLog.isDebugEnabled()) {
                cLog.error("", aError);
            }
        } else {
            Log log = LogFactory.getLog(aCaller.getClass());
            if (log.isDebugEnabled()) {
                log.error("", aError);
            }
        }
    }

    public static void debug(Object aCaller, String aMsg) {
        if (aCaller == null) {
            cLog.error(aMsg);
        } else {
            LogFactory.getLog(aCaller.getClass()).debug(aMsg);
        }
    }

    public static void error(String aError) {
        cLog.error(aError);
    }

    public static void error(Throwable aError) {
        cLog.error("", aError);
    }

    public static void error(Object aCaller, String aError) {
        if (aCaller == null) {
            cLog.error(aError);
        } else {
            LogFactory.getLog(aCaller.getClass()).error(aError);
        }
    }

    public static void error(Object aCaller, Throwable aError) {
        if (aCaller == null) {
            cLog.error("", aError);
        } else {
            LogFactory.getLog(aCaller.getClass()).error("", aError);
        }
    }

    public static void message(String aMsg) {
        cLog.info(aMsg);
    }

    public static void message(Object aCaller, String aMsg) {
        if (aCaller == null) {
            cLog.info(aMsg);
        } else {
            LogFactory.getLog(aCaller.getClass()).info(aMsg);
        }
    }

    public static void warning(String aMsg) {
        cLog.warn(aMsg);
    }

    public static void warning(Object aCaller, String aMsg) {
        if (aCaller == null) {
            cLog.warn(aMsg);
        } else {
            LogFactory.getLog(aCaller.getClass()).warn(aMsg);
        }
    }
}

