/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.trade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.ATradeTransportable;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;

public class OrderStatusRequest
extends ATradeTransportable {
    public static final ICode OBJ_TYPE = new OrderStatusRequestType();
    private String mClOrdLinkID;
    private String mOrderStatusReqID;
    private long mMakingTime = System.currentTimeMillis();

    @Override
    public boolean fill(IMessage aMsg) {
        super.fill(aMsg);
        this.setOrderStatusReqID(aMsg.getValueString("790"));
        this.setClOrdLinkID(aMsg.getValueString("583"));
        return this.isValid();
    }

    @Override
    public String getClOrdID() {
        return super.getClOrdID();
    }

    public String getClOrdLinkID() {
        return this.mClOrdLinkID;
    }

    public void setClOrdLinkID(String aClOrdLinkID) {
        this.mClOrdLinkID = aClOrdLinkID;
    }

    @Override
    public String getOrderID() {
        return super.getOrderID();
    }

    public String getOrderStatusReqID() {
        return this.mOrderStatusReqID;
    }

    public void setOrderStatusReqID(String aOrderStatusReqID) {
        this.mOrderStatusReqID = aOrderStatusReqID;
    }

    @Override
    public String getRequestID() {
        return this.getOrderStatusReqID();
    }

    @Override
    public String getSecondaryClOrdID() {
        return super.getSecondaryClOrdID();
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public boolean isValid() {
        return this.getClOrdID() != null || this.getOrderID() != null;
    }

    @Override
    protected void reset() {
        super.reset();
        this.setOrderStatusReqID(null);
    }

    @Override
    public void setClOrdID(String aClOrdID) {
        super.setClOrdID(aClOrdID);
    }

    @Override
    public void setOrderID(String aOrderID) {
        super.setOrderID(aOrderID);
    }

    @Override
    public void setSecondaryClOrdID(String aSecondaryClOrdID) {
        super.setSecondaryClOrdID(aSecondaryClOrdID);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        IMessage ret = super.toMessage(aSID, aTradingSessionID, aTradingSessionSubID, aRequestID, aOptions, aFactory);
        String req = aRequestID;
        if (req == null) {
            req = this.getOrderStatusReqID();
        }
        ret.setValue("790", req);
        ret.setValue("583", this.getClOrdLinkID());
        return ret;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("OrderStatusRequest");
        sb.append(" --- begin superclass toString ");
        sb.append(super.toString());
        sb.append(" --- end superclass toString ");
        sb.append("{mClOrdLinkID='").append(this.mClOrdLinkID).append('\'');
        sb.append(", mOrderStatusReqID='").append(this.mOrderStatusReqID).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class OrderStatusRequestType
    extends ACode {
        OrderStatusRequestType() {
            super("H", "OrderStatusRequestType", "");
        }
    }
}

