/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.trade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.ATradeTransportable;
import com.fxcm.fix.IOrdType;
import com.fxcm.fix.ISide;
import com.fxcm.fix.ITimeInForce;
import com.fxcm.fix.OrdTypeFactory;
import com.fxcm.fix.PegInstruction;
import com.fxcm.fix.SideFactory;
import com.fxcm.fix.TimeInForceFactory;
import com.fxcm.fix.UTCDate;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import java.text.ParseException;

public class OrderSingle
extends ATradeTransportable {
    public static final ICode OBJ_TYPE = new OrderSingleType();
    protected String mCurrency;
    protected String mFXCMPosID;
    protected IOrdType mOrdType;
    protected double mOrderQty;
    protected PegInstruction mPegInstructions;
    protected double mPrice;
    protected String mQuoteID;
    protected ISide mSide;
    protected double mStopPx;
    protected ITimeInForce mTimeInForce;
    protected int mListSeqNo;
    protected String mClOrdLinkID;
    protected UTCTimestamp mExpireTimestamp;
    protected boolean mExpireTimeSet;
    protected boolean mExpireDateSet;
    protected double mOrderPercent;
    protected String mExecInstruction;
    protected double mPrevClosePx;

    @Override
    public boolean fill(IMessage aMsg) {
        return this.fill((IFieldGroup)aMsg);
    }

    @Override
    public boolean fill(IFieldGroup aGrp) {
        String expireDate;
        super.fill(aGrp);
        this.setFXCMPosID(aGrp.getValueString("9041"));
        this.setOrdType(OrdTypeFactory.toCode(aGrp.getValueString("40")));
        this.setOrderQty(aGrp.getValueDouble("38"));
        this.setPegInstructions(new PegInstruction());
        this.getPegInstructions().setPegPriceType(aGrp.getValueInt("1094"));
        this.getPegInstructions().setPegOffsetValue(aGrp.getValueDouble("211"));
        this.getPegInstructions().setPegMoveType(aGrp.getValueInt("835"));
        this.getPegInstructions().setPegOffsetType(aGrp.getValueInt("836"));
        this.getPegInstructions().setFXCMPegFluctuatePts(aGrp.getValueInt("9061"));
        this.setStopPx(aGrp.getValueDouble("99"));
        this.setPrice(aGrp.getValueDouble("44"));
        this.setQuoteID(aGrp.getValueString("117"));
        this.setSide(SideFactory.toCode(aGrp.getValueString("54")));
        String timeinforce = aGrp.getValueString("59");
        if (timeinforce != null) {
            this.setTimeInForce(TimeInForceFactory.toCode(timeinforce));
        }
        this.setCurrency(aGrp.getValueString("15"));
        this.setListSeqNo(aGrp.getValueInt("67"));
        this.setClOrdLinkID(aGrp.getValueString("583"));
        String expireTime = aGrp.getValueString("126");
        if (expireTime != null) {
            this.setExpireTime(expireTime);
        }
        if ((expireDate = aGrp.getValueString("432")) != null) {
            this.setExpireDate(expireDate);
        }
        this.setOrderPercent(aGrp.getValueDouble("516"));
        this.setExecInstruction(aGrp.getValueString("18"));
        this.setPrevClosePx(aGrp.getValueDouble("140"));
        return this.isValid();
    }

    @Override
    protected void fillTradingSessionIDs(IFieldGroup aGroup) {
        IFieldGroup tsGroup;
        IFieldGroupList tsList = aGroup.getValueList("386");
        if (tsList != null && tsList.size() != 0 && (tsGroup = tsList.getFields().get(0)) != null) {
            this.setTradingSessionID(tsGroup.getValueString("336"));
            this.setTradingSessionSubID(tsGroup.getValueString("625"));
        }
    }

    public String getClOrdLinkID() {
        return this.mClOrdLinkID;
    }

    public void setClOrdLinkID(String aClOrdLinkID) {
        this.mClOrdLinkID = aClOrdLinkID;
    }

    public String getExecInstruction() {
        return this.mExecInstruction;
    }

    public void setExecInstruction(String aExecInstruction) {
        this.mExecInstruction = aExecInstruction;
    }

    public UTCTimestamp getExpireTimestamp() {
        return this.mExpireTimestamp;
    }

    public void setExpireTimestamp(UTCTimestamp aExpireTimestamp) {
        if (aExpireTimestamp != null) {
            this.mExpireTimeSet = true;
            this.mExpireDateSet = true;
        }
        this.mExpireTimestamp = aExpireTimestamp;
    }

    public UTCTimestamp getExpireTime() {
        return this.getExpireTimestamp();
    }

    public void setExpireTime(String aExpireTime) {
        if (this.mExpireTimestamp == null) {
            this.mExpireTimestamp = new UTCTimestamp();
        }
        try {
            this.mExpireTimestamp.setTime(aExpireTime);
            this.mExpireTimeSet = true;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void setExpireTime(UTCTimestamp aExpireTime) {
        if (this.mExpireTimestamp == null) {
            this.mExpireTimestamp = new UTCTimestamp();
        }
        this.mExpireTimestamp.setTimeOnly(aExpireTime.getTime());
        this.mExpireTimeSet = true;
    }

    public UTCDate getExpireDate() {
        if (this.mExpireTimestamp == null) {
            return null;
        }
        return new UTCDate(this.mExpireTimestamp);
    }

    public void setExpireDate(String aExpireDate) {
        if (this.mExpireTimestamp == null) {
            this.mExpireTimestamp = new UTCTimestamp();
        }
        try {
            this.mExpireTimestamp.setDateOnly(aExpireDate);
            this.mExpireDateSet = true;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void setExpireDate(UTCDate aExpireDate) {
        if (this.mExpireTimestamp == null) {
            this.mExpireTimestamp = new UTCTimestamp();
        }
        this.mExpireTimestamp.setDateOnly(aExpireDate);
        this.mExpireDateSet = true;
    }

    public boolean isExpireTimeSet() {
        return this.mExpireTimeSet;
    }

    public boolean isExpireDateSet() {
        return this.mExpireDateSet;
    }

    public int getListSeqNo() {
        return this.mListSeqNo;
    }

    public void setListSeqNo(int aListSeqNo) {
        this.mListSeqNo = aListSeqNo;
    }

    public String getCurrency() {
        return this.mCurrency;
    }

    public void setCurrency(String aCurrency) {
        this.mCurrency = aCurrency;
    }

    public String getFXCMPosID() {
        return this.mFXCMPosID;
    }

    public void setFXCMPosID(String aFXCMPosID) {
        this.mFXCMPosID = aFXCMPosID;
    }

    public IOrdType getOrdType() {
        return this.mOrdType;
    }

    public void setOrdType(IOrdType aOrderType) {
        this.mOrdType = aOrderType;
    }

    public double getOrderPercent() {
        return this.mOrderPercent;
    }

    public void setOrderPercent(double aOrderPercent) {
        this.mOrderPercent = aOrderPercent;
    }

    public double getOrderQty() {
        return this.mOrderQty;
    }

    public void setOrderQty(double aOrderQty) {
        this.mOrderQty = aOrderQty;
    }

    public PegInstruction getPegInstructions() {
        return this.mPegInstructions;
    }

    public void setPegInstructions(PegInstruction aPegInstructions) {
        this.mPegInstructions = aPegInstructions;
    }

    public double getPrice() {
        return this.mPrice;
    }

    public void setPrice(double aPrice) {
        this.mPrice = aPrice;
    }

    public String getQuoteID() {
        return this.mQuoteID;
    }

    public void setQuoteID(String aQuoteID) {
        this.mQuoteID = aQuoteID;
    }

    @Override
    public String getRequestID() {
        return this.getClOrdID();
    }

    public ISide getSide() {
        return this.mSide;
    }

    public void setSide(ISide aSide) {
        this.mSide = aSide;
    }

    public double getStopPx() {
        return this.mStopPx;
    }

    public void setStopPx(double aStopPx) {
        this.mStopPx = aStopPx;
    }

    public ITimeInForce getTimeInForce() {
        return this.mTimeInForce;
    }

    public void setTimeInForce(ITimeInForce aTimeInForce) {
        this.mTimeInForce = aTimeInForce;
    }

    public double getPrevClosePx() {
        return this.mPrevClosePx;
    }

    public void setPrevClosePx(double aPrevClosePx) {
        this.mPrevClosePx = aPrevClosePx;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public boolean isValid() {
        boolean ret = false;
        if (this.mInstrument != null && this.mTransactTime != null) {
            ret = this.mPrice != 0.0 && this.mSide != null;
        }
        return ret;
    }

    @Override
    protected void reset() {
        super.reset();
        this.setFXCMPosID(null);
        this.setOrdType(OrdTypeFactory.PREVIOUSLY_QUOTED);
        this.setOrderQty(0.0);
        this.setPegInstructions(null);
        this.setPrice(0.0);
        this.setQuoteID(null);
        this.setSide(null);
        this.setTimeInForce(TimeInForceFactory.GOOD_TILL_CANCEL);
        this.setCurrency(null);
        this.setStopPx(0.0);
        this.setListSeqNo(0);
        this.setClOrdLinkID(null);
        this.setExpireTimestamp(null);
        this.setOrderPercent(0.0);
        this.setExecInstruction(null);
        this.setPrevClosePx(0.0);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        IMessage ret = super.toMessage(aSID, aTradingSessionID, aTradingSessionSubID, aRequestID, aOptions, aFactory);
        ret.setValue("9041", this.getFXCMPosID());
        ret.setValue("38", this.getOrderQty());
        ret.setValue("117", this.getQuoteID());
        if (this.getOrdType() != null) {
            ret.setValue("40", this.getOrdType().getCode());
        }
        if (this.getPegInstructions() != null) {
            ret.setValue("1094", this.getPegInstructions().getPegPriceType());
            ret.setValue("211", this.getPegInstructions().getPegOffsetValue());
            ret.setValue("835", this.getPegInstructions().getPegMoveType());
            ret.setValue("836", this.getPegInstructions().getPegOffsetType());
            ret.setValue("9061", this.getPegInstructions().getFXCMPegFluctuatePts());
        }
        if (this.getPrice() != 0.0) {
            ret.setValue("44", this.mInstrument.priceToString(this.getPrice()));
        }
        if (this.getStopPx() != 0.0) {
            ret.setValue("99", this.mInstrument.priceToString(this.getStopPx()));
        }
        if (this.getSide() != null) {
            ret.setValue("54", this.getSide().getCode());
        }
        if (this.getTimeInForce() != null) {
            ret.setValue("59", this.getTimeInForce().getCode());
        }
        if (this.getCurrency() != null) {
            ret.setValue("15", this.getCurrency());
        }
        if (this.getListSeqNo() != 0) {
            ret.setValue("67", this.getListSeqNo());
        }
        if (this.isExpireTimeSet() && this.getExpireTimestamp() != null) {
            ret.setValue("126", this.getExpireTimestamp().toString());
        }
        if (this.isExpireDateSet() && this.getExpireTimestamp() != null) {
            ret.setValue("432", this.getExpireTimestamp().toStringDateOnly());
        }
        if (this.getOrderPercent() != 0.0) {
            ret.setValue("516", this.getOrderPercent());
        }
        ret.setValue("583", this.getClOrdLinkID());
        ret.setValue("18", this.getExecInstruction());
        ret.setValue("140", this.getPrevClosePx());
        return ret;
    }

    @Override
    protected void toMessageTradingSessionIDs(IMessage aMessage, String aTradingSessionID, String aTradingSessionSubID, IMessageFactory aFactory) {
        if (aTradingSessionID != null) {
            IFieldGroupList tsList = aFactory.createFieldGroupList();
            IFieldGroup tsGroup = aFactory.createFieldGroup();
            tsGroup.setValue("336", aTradingSessionID);
            tsGroup.setValue("625", aTradingSessionSubID);
            tsList.put(tsGroup);
            aMessage.setValue("386", tsList);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OrderSingle");
        sb.append(" --- begin superclass toString ");
        sb.append(super.toString());
        sb.append(" --- end superclass toString ");
        sb.append("{mClOrdLinkID='").append(this.mClOrdLinkID).append('\'');
        sb.append(", mCurrency='").append(this.mCurrency).append('\'');
        sb.append(", mExecInstruction='").append(this.mExecInstruction).append('\'');
        sb.append(", mExpireTimestamp=").append(this.mExpireTimestamp);
        sb.append(", mFXCMPosID='").append(this.mFXCMPosID).append('\'');
        sb.append(", mListSeqNo=").append(this.mListSeqNo);
        sb.append(", mOrderPercent=").append(this.mOrderPercent);
        sb.append(", mOrderQty=").append(this.mOrderQty);
        sb.append(", mOrdType=").append(this.mOrdType);
        sb.append(", mPegInstructions=").append(this.mPegInstructions);
        sb.append(", mPrice=").append(this.mPrice);
        sb.append(", mQuoteID='").append(this.mQuoteID).append('\'');
        sb.append(", mSide=").append(this.mSide);
        sb.append(", mStopPx=").append(this.mStopPx);
        sb.append(", mTimeInForce=").append(this.mTimeInForce);
        sb.append(", mPrevClosePx=").append(this.mPrevClosePx);
        sb.append('}');
        return sb.toString();
    }

    private static class OrderSingleType
    extends ACode {
        private static final long serialVersionUID = 192707702930571094L;

        OrderSingleType() {
            super("D", "OrderSingleType", "");
        }
    }
}

