/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.trade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.ContingencyTypeFactory;
import com.fxcm.fix.IContingencyType;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.fix.trade.OrderSingle;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;
import java.util.ArrayList;
import java.util.List;

public class OrderList
implements ITransportable,
IFixDefs {
    public static final ICode OBJ_TYPE = new OrderListType();
    private int mBidType;
    protected String mFXCMContingencyID;
    private IContingencyType mContingencyType;
    private String mListID;
    private long mMakingTime = System.currentTimeMillis();
    private List mOrders;
    private String mTradingSessionID;
    private String mTradingSessionSubID;
    protected UTCTimestamp mTransactTime;

    public OrderList() {
        this.reset();
    }

    public void addOrder(OrderSingle aOrderSingle) {
        this.mOrders.add(aOrderSingle);
    }

    @Override
    public boolean fill(IMessage aMsg) {
        IFieldGroupList groupList;
        this.reset();
        this.mFXCMContingencyID = aMsg.getValueString("9079");
        this.mContingencyType = ContingencyTypeFactory.toCode(aMsg.getValueString("1385"));
        this.mListID = aMsg.getValueString("66");
        this.mBidType = aMsg.getValueInt("394");
        this.mTradingSessionID = aMsg.getValueString("336");
        this.mTradingSessionSubID = aMsg.getValueString("625");
        if (aMsg.getValueString("60") != null) {
            this.setTransactTime(new UTCTimestamp(aMsg.getValueString("60")));
        }
        if ((groupList = aMsg.getValueList("73")) != null) {
            for (IFieldGroup gr : groupList.values()) {
                OrderSingle single = new OrderSingle();
                single.fill(gr);
                this.addOrder(single);
            }
        }
        return this.isValid();
    }

    public int getBidType() {
        return this.mBidType;
    }

    public void setBidType(int aBidType) {
        this.mBidType = aBidType;
    }

    public String getFXCMContingencyID() {
        return this.mFXCMContingencyID;
    }

    public void setFXCMContingencyID(String aFXCMContingencyID) {
        this.mFXCMContingencyID = aFXCMContingencyID;
    }

    public IContingencyType getContingencyType() {
        return this.mContingencyType;
    }

    public void setContingencyType(IContingencyType aContingencyType) {
        this.mContingencyType = aContingencyType;
    }

    public String getListID() {
        return this.mListID;
    }

    public void setListID(String aListID) {
        this.mListID = aListID;
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    public OrderSingle[] getOrders() {
        return this.mOrders.toArray(new OrderSingle[this.mOrders.size()]);
    }

    @Override
    public String getRequestID() {
        return this.mListID;
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID;
    }

    public UTCTimestamp getTransactTime() {
        return this.mTransactTime;
    }

    public void setTransactTime(UTCTimestamp aTransactTime) {
        this.mTransactTime = aTransactTime != null ? aTransactTime : new UTCTimestamp();
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public void removeOrder(OrderSingle aOrder) {
        this.mOrders.remove(aOrder);
    }

    public void reset() {
        this.mListID = null;
        this.mBidType = 3;
        this.mOrders = new ArrayList();
        this.mContingencyType = null;
        this.mFXCMContingencyID = null;
    }

    public int size() {
        return this.mOrders.size();
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        IMessage ret = aFactory.createMessage(aSID, "E");
        ret.setValue("66", this.mListID);
        ret.setValue("394", this.mBidType);
        ret.setValue("68", this.mOrders.size());
        ret.setValue("73", this.mOrders.size());
        ret.setValue("336", aTradingSessionID);
        ret.setValue("625", aTradingSessionSubID);
        if (this.mContingencyType != null) {
            ret.setValue("1385", this.mContingencyType.getCode());
        }
        if (this.mFXCMContingencyID != null) {
            ret.setValue("9079", this.mFXCMContingencyID);
        }
        if (this.mTransactTime != null) {
            ret.setValue("60", this.getTransactTime().toString());
        }
        IFieldGroupList list = aFactory.createFieldGroupList();
        for (int i = 0; i < this.mOrders.size(); ++i) {
            OrderSingle order = (OrderSingle)this.mOrders.get(i);
            order.setListSeqNo(i + 1);
            list.put(order.toMessage(aSID, aFactory));
        }
        ret.setValue("73", list);
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("OrderList");
        sb.append("{mBidType=").append(this.mBidType);
        sb.append(", mFXCMContingencyID='").append(this.mFXCMContingencyID).append('\'');
        sb.append(", mContingencyType=").append(this.mContingencyType);
        sb.append(", mListID='").append(this.mListID).append('\'');
        sb.append(", mMakingTime=").append(this.mMakingTime);
        sb.append(", mOrders=").append(this.mOrders.size());
        for (int i = 0; i < this.mOrders.size(); ++i) {
            sb.append("\n\t mOrder=").append(this.mOrders.get(i));
            if (i + 1 != this.mOrders.size()) continue;
            sb.append("\n");
        }
        sb.append(", mTradingSessionID='").append(this.mTradingSessionID).append('\'');
        sb.append(", mTradingSessionSubID='").append(this.mTradingSessionSubID).append('\'');
        sb.append(", mTransactTime=").append(this.mTransactTime);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    private static class OrderListType
    extends ACode {
        OrderListType() {
            super("E", "OrderListType", "");
        }
    }
}

