/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.trade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.ATradeTransportable;
import com.fxcm.fix.ISide;
import com.fxcm.fix.Instrument;
import com.fxcm.fix.SideFactory;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;

public class OrderCancelRequest
extends ATradeTransportable {
    public static final ICode OBJ_TYPE = new OrderCancelRequestType();
    protected String mOrigClOrdID;
    protected double mOrderQty;
    protected ISide mSide;

    @Override
    public boolean fill(IMessage aMsg) {
        super.fill(aMsg);
        this.setOrigClOrdID(aMsg.getValueString("41"));
        this.setOrderQty(aMsg.getValueDouble("38"));
        this.setSide(SideFactory.toCode(aMsg.getValueString("54")));
        return this.isValid();
    }

    public double getOrderQty() {
        return this.mOrderQty;
    }

    public String getOrigClOrdID() {
        return this.mOrigClOrdID;
    }

    @Override
    public String getRequestID() {
        return this.getClOrdID();
    }

    public ISide getSide() {
        return this.mSide;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public boolean isValid() {
        boolean ret = false;
        if (this.mOrderID != null) {
            ret = true;
        }
        return ret;
    }

    @Override
    public void reset() {
        super.reset();
        this.mOrigClOrdID = "NONE";
        this.mInstrument = new Instrument("[N/A]");
        this.mOrderQty = 0.0;
        this.mSide = SideFactory.UNDISCLOSED;
    }

    public void setOrderQty(double aOrderQty) {
        this.mOrderQty = aOrderQty;
    }

    public void setOrigClOrdID(String aOrigClOrdID) {
        this.mOrigClOrdID = aOrigClOrdID;
    }

    public void setSide(ISide aSide) {
        this.mSide = aSide;
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        IMessage ret = super.toMessage(aSID, aTradingSessionID, aTradingSessionSubID, aRequestID, aOptions, aFactory);
        ret.setValue("41", this.getOrigClOrdID());
        ret.setValue("38", this.getOrderQty());
        if (this.getSide() != null) {
            ret.setValue("54", this.getSide().getCode());
        }
        return ret;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OrderCancelRequest");
        sb.append(" --- begin superclass toString ");
        sb.append(super.toString());
        sb.append(" --- end superclass toString ");
        sb.append("{mOrigClOrdID='").append(this.mOrigClOrdID).append('\'');
        sb.append(", mOrderQty=").append(this.format(this.mOrderQty));
        sb.append(", mSide=").append(this.mSide);
        sb.append('}');
        return sb.toString();
    }

    private static class OrderCancelRequestType
    extends ACode {
        private static final long serialVersionUID = 9193641318763447868L;

        OrderCancelRequestType() {
            super("F", "OrderCancelRequestType", "");
        }
    }
}

