/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.trade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.ATradeTransportable;
import com.fxcm.fix.ContingencyTypeFactory;
import com.fxcm.fix.IContingencyType;
import com.fxcm.fix.IOrdType;
import com.fxcm.fix.ISide;
import com.fxcm.fix.ITimeInForce;
import com.fxcm.fix.Instrument;
import com.fxcm.fix.OrdTypeFactory;
import com.fxcm.fix.PegInstruction;
import com.fxcm.fix.SideFactory;
import com.fxcm.fix.TimeInForceFactory;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;

public class OrderCancelReplaceRequest
extends ATradeTransportable {
    public static final ICode OBJ_TYPE = new OrderCancelReplaceRequestType();
    protected String mFXCMContingencyID;
    protected IContingencyType mContingencyType;
    protected double mOrderQty;
    protected IOrdType mOrdType;
    protected String mOrigClOrdID;
    protected PegInstruction mPegInstructions;
    protected double mPrice;
    protected ISide mSide;
    protected double mStopPx;
    protected double mLeavesQty;
    protected ITimeInForce mTimeInForce;

    @Override
    public boolean fill(IMessage aMsg) {
        super.fill(aMsg);
        this.setPegInstructions(new PegInstruction());
        this.getPegInstructions().setPegPriceType(aMsg.getValueInt("1094"));
        this.getPegInstructions().setPegOffsetValue(aMsg.getValueDouble("211"));
        this.getPegInstructions().setPegMoveType(aMsg.getValueInt("835"));
        this.getPegInstructions().setPegOffsetType(aMsg.getValueInt("836"));
        this.getPegInstructions().setFXCMPegFluctuatePts(aMsg.getValueInt("9061"));
        this.setOrigClOrdID(aMsg.getValueString("41"));
        this.setOrdType(OrdTypeFactory.toCode(aMsg.getValueString("40")));
        this.setOrderQty(aMsg.getValueDouble("38"));
        this.setPrice(aMsg.getValueDouble("44"));
        this.setStopPx(aMsg.getValueDouble("99"));
        this.setSide(SideFactory.toCode(aMsg.getValueString("54")));
        String timeinforce = aMsg.getValueString("59");
        if (timeinforce != null) {
            this.setTimeInForce(TimeInForceFactory.toCode(timeinforce));
        }
        this.setContingencyType(ContingencyTypeFactory.toCode(aMsg.getValueString("1385")));
        this.setFXCMContingencyID(aMsg.getValueString("9079"));
        this.setLeavesQty(aMsg.getValueDouble("151"));
        return this.isValid();
    }

    @Override
    protected void fillTradingSessionIDs(IFieldGroup aGroup) {
        IFieldGroup tsGroup;
        IFieldGroupList tsList = aGroup.getValueList("386");
        if (tsList != null && tsList.size() != 0 && (tsGroup = tsList.getFields().get(0)) != null) {
            this.setTradingSessionID(tsGroup.getValueString("336"));
            this.setTradingSessionSubID(tsGroup.getValueString("625"));
        }
    }

    public String getFXCMContingencyID() {
        return this.mFXCMContingencyID;
    }

    public void setFXCMContingencyID(String aFXCMContingencyID) {
        this.mFXCMContingencyID = aFXCMContingencyID;
    }

    public IContingencyType getContingencyType() {
        return this.mContingencyType;
    }

    public void setContingencyType(IContingencyType aContingencyType) {
        this.mContingencyType = aContingencyType;
    }

    public double getOrderQty() {
        return this.mOrderQty;
    }

    public void setOrderQty(double aOrderQty) {
        this.mOrderQty = aOrderQty;
    }

    public IOrdType getOrdType() {
        return this.mOrdType;
    }

    public void setOrdType(IOrdType aOrdType) {
        this.mOrdType = aOrdType;
    }

    public String getOrigClOrdID() {
        return this.mOrigClOrdID;
    }

    public void setOrigClOrdID(String aOrigClOrdID) {
        this.mOrigClOrdID = aOrigClOrdID;
    }

    public PegInstruction getPegInstructions() {
        return this.mPegInstructions;
    }

    public void setPegInstructions(PegInstruction aPegInstructions) {
        this.mPegInstructions = aPegInstructions;
    }

    public double getPrice() {
        return this.mPrice;
    }

    public void setPrice(double aPrice) {
        this.mPrice = aPrice;
    }

    @Override
    public String getRequestID() {
        return this.getClOrdID();
    }

    public ISide getSide() {
        return this.mSide;
    }

    public void setSide(ISide aSide) {
        this.mSide = aSide;
    }

    public double getStopPx() {
        return this.mStopPx;
    }

    public void setStopPx(double aStopPx) {
        this.mStopPx = aStopPx;
    }

    public ITimeInForce getTimeInForce() {
        return this.mTimeInForce;
    }

    public double getLeavesQty() {
        return this.mLeavesQty;
    }

    public void setLeavesQty(double aLeavesQty) {
        this.mLeavesQty = aLeavesQty;
    }

    public void setTimeInForce(ITimeInForce aTimeInForce) {
        this.mTimeInForce = aTimeInForce;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public boolean isValid() {
        boolean ret = false;
        if (this.mOrderID != null && this.mOrdType != null) {
            ret = true;
        }
        return ret;
    }

    @Override
    protected void reset() {
        super.reset();
        this.mOrigClOrdID = "NONE";
        this.mInstrument = new Instrument("[N/A]");
        this.mOrdType = null;
        this.mOrderQty = 0.0;
        this.mPrice = 0.0;
        this.mSide = SideFactory.UNDISCLOSED;
        this.mTimeInForce = TimeInForceFactory.GOOD_TILL_CANCEL;
        this.mPegInstructions = null;
        this.mStopPx = 0.0;
        this.mContingencyType = null;
        this.mFXCMContingencyID = null;
        this.mLeavesQty = 0.0;
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        IMessage ret = super.toMessage(aSID, aTradingSessionID, aTradingSessionSubID, aRequestID, aOptions, aFactory);
        ret.setValue("41", this.getOrigClOrdID());
        if (this.getOrdType() != null) {
            ret.setValue("40", this.getOrdType().getCode());
        }
        ret.setValue("44", this.getPrice());
        ret.setValue("99", this.getStopPx());
        ret.setValue("38", this.getOrderQty());
        if (this.getSide() != null) {
            ret.setValue("54", this.getSide().getCode());
        }
        if (this.getTimeInForce() != null) {
            ret.setValue("59", this.getTimeInForce().getCode());
        }
        if (this.getPegInstructions() != null) {
            ret.setValue("1094", this.getPegInstructions().getPegPriceType());
            ret.setValue("211", this.getPegInstructions().getPegOffsetValue());
            ret.setValue("835", this.getPegInstructions().getPegMoveType());
            ret.setValue("836", this.getPegInstructions().getPegOffsetType());
            ret.setValue("9061", this.getPegInstructions().getFXCMPegFluctuatePts());
        }
        if (this.getContingencyType() != null) {
            ret.setValue("1385", this.getContingencyType().getCode());
        }
        if (this.getFXCMContingencyID() != null) {
            ret.setValue("9079", this.getFXCMContingencyID());
        }
        ret.setValue("151", this.getLeavesQty());
        return ret;
    }

    @Override
    protected void toMessageTradingSessionIDs(IMessage aMessage, String aTradingSessionID, String aTradingSessionSubID, IMessageFactory aFactory) {
        if (aTradingSessionID != null) {
            IFieldGroupList tsList = aFactory.createFieldGroupList();
            IFieldGroup tsGroup = aFactory.createFieldGroup();
            tsGroup.setValue("336", aTradingSessionID);
            tsGroup.setValue("625", aTradingSessionSubID);
            tsList.put(tsGroup);
            aMessage.setValue("386", tsList);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OrderCancelReplaceRequest");
        sb.append(" --- begin superclass toString ");
        sb.append(super.toString());
        sb.append(" --- end superclass toString ");
        sb.append("{mOrdType=").append(this.mOrdType);
        sb.append(", mOrderQty=").append(this.format(this.mOrderQty));
        sb.append(", mOrigClOrdID='").append(this.mOrigClOrdID).append('\'');
        sb.append(", mPegInstructions=").append(this.mPegInstructions);
        sb.append(", mPrice=").append(this.mPrice);
        sb.append(", mSide=").append(this.mSide);
        sb.append(", mTimeInForce=").append(this.mTimeInForce);
        sb.append(", mStopPx=").append(this.mStopPx);
        sb.append(", mLeavesQty=").append(this.mLeavesQty);
        sb.append('}');
        return sb.toString();
    }

    private static class OrderCancelReplaceRequestType
    extends ACode {
        private static final long serialVersionUID = 4649944036366341167L;

        OrderCancelReplaceRequestType() {
            super("G", "OrderCancelReplaceRequestType", "");
        }
    }
}

