/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.trade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.CxlRejReasonFactory;
import com.fxcm.fix.CxlRejResponseToFactory;
import com.fxcm.fix.ICxlRejReason;
import com.fxcm.fix.ICxlRejResponseTo;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.IOrdStatus;
import com.fxcm.fix.OrdStatusFactory;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;

public class OrderCancelReject
implements ITransportable,
IFixDefs {
    public static final ICode OBJ_TYPE = new OrderCancelRejectAckType();
    protected String mAccount;
    protected String mOrderID;
    protected String mClOrdID;
    protected String mSecondaryClOrdID;
    protected String mTradingSessionID;
    protected String mTradingSessionSubID;
    protected UTCTimestamp mTransactTime;
    private ICxlRejReason mCxlRejReason;
    private ICxlRejResponseTo mCxlRejResponseTo;
    private String mFXCMErrorDetails;
    private int mFXCMRequestRejectReason;
    private IOrdStatus mOrdStatus;
    private String mOrigClOrdID;
    private String mText;
    private long mMakingTime = System.currentTimeMillis();

    @Override
    public boolean fill(IMessage aMsg) {
        this.reset();
        if (aMsg.getValueString("60") != null) {
            this.setTransactTime(new UTCTimestamp(aMsg.getValueString("60")));
        }
        this.setTradingSessionID(aMsg.getValueString("336"));
        this.setTradingSessionSubID(aMsg.getValueString("625"));
        this.setOrderID(aMsg.getValueString("37"));
        this.setClOrdID(aMsg.getValueString("11"));
        this.setSecondaryClOrdID(aMsg.getValueString("526"));
        this.setAccount(aMsg.getValueString("1"));
        this.setCxlRejReason(CxlRejReasonFactory.toCode(aMsg.getValueInt("102")));
        this.setCxlRejResponseTo(CxlRejResponseToFactory.toCode(aMsg.getValueString("434")));
        this.setFXCMErrorDetails(aMsg.getValueString("9029"));
        this.setFXCMRequestRejectReason(aMsg.getValueInt("9025"));
        this.setOrdStatus(OrdStatusFactory.toCode(aMsg.getValueString("39")));
        this.setOrigClOrdID(aMsg.getValueString("41"));
        this.setText(aMsg.getValueString("58"));
        return this.isValid();
    }

    public String getAccount() {
        return this.mAccount;
    }

    public void setAccount(String account) {
        this.mAccount = account;
    }

    public void setOrderID(String aOrderID) {
        this.mOrderID = aOrderID;
    }

    public String getOrderID() {
        return this.mOrderID;
    }

    public String getClOrdID() {
        return this.mClOrdID;
    }

    public void setClOrdID(String clOrdID) {
        this.mClOrdID = clOrdID;
    }

    public String getSecondaryClOrdID() {
        return this.mSecondaryClOrdID;
    }

    public void setSecondaryClOrdID(String mSecondaryClOrdID) {
        this.mSecondaryClOrdID = mSecondaryClOrdID;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID != null ? aTradingSessionID : "FXCM";
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID != null ? aTradingSessionSubID : "";
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    public UTCTimestamp getTransactTime() {
        return this.mTransactTime;
    }

    public void setTransactTime(UTCTimestamp aTransactTime) {
        this.mTransactTime = aTransactTime != null ? aTransactTime : new UTCTimestamp();
    }

    public ICxlRejReason getCxlRejReason() {
        return this.mCxlRejReason;
    }

    public void setCxlRejReason(ICxlRejReason aCxlRejReason) {
        this.mCxlRejReason = aCxlRejReason;
    }

    public ICxlRejResponseTo getCxlRejResponseTo() {
        return this.mCxlRejResponseTo;
    }

    public void setCxlRejResponseTo(ICxlRejResponseTo aCxlRejResponseTo) {
        this.mCxlRejResponseTo = aCxlRejResponseTo;
    }

    public String getFXCMErrorDetails() {
        return this.mFXCMErrorDetails;
    }

    public void setFXCMErrorDetails(String aFXCMErrorDetails) {
        this.mFXCMErrorDetails = aFXCMErrorDetails;
    }

    public int getFXCMRequestRejectReason() {
        return this.mFXCMRequestRejectReason;
    }

    public void setFXCMRequestRejectReason(int aFXCMRequestRejectReason) {
        this.mFXCMRequestRejectReason = aFXCMRequestRejectReason;
    }

    public IOrdStatus getOrdStatus() {
        return this.mOrdStatus;
    }

    public void setOrdStatus(IOrdStatus aOrdStatus) {
        this.mOrdStatus = aOrdStatus;
    }

    public String getOrigClOrdID() {
        return this.mOrigClOrdID;
    }

    public void setOrigClOrdID(String aOrigClOrdID) {
        this.mOrigClOrdID = aOrigClOrdID;
    }

    @Override
    public String getRequestID() {
        return this.getClOrdID();
    }

    public String getText() {
        return this.mText;
    }

    public void setText(String aText) {
        this.mText = aText;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public boolean isValid() {
        return this.mCxlRejReason != null && this.mOrdStatus != null && this.mOrigClOrdID != null && this.mClOrdID != null && this.mOrderID != null;
    }

    protected void reset() {
        this.mAccount = null;
        this.mOrderID = null;
        this.mClOrdID = null;
        this.mSecondaryClOrdID = null;
        this.mTradingSessionID = "FXCM";
        this.mTradingSessionSubID = "";
        if (this.mTransactTime == null) {
            this.mTransactTime = new UTCTimestamp();
        } else {
            this.mTransactTime.setDate(null);
        }
        this.mCxlRejReason = null;
        this.mCxlRejResponseTo = null;
        this.mFXCMErrorDetails = null;
        this.mFXCMRequestRejectReason = -1;
        this.mOrdStatus = null;
        this.mOrigClOrdID = null;
        this.mText = null;
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        String tssubid;
        String tsid = aTradingSessionID;
        if (tsid == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage ret = aFactory.createMessage(aSID, this.getType().getCode());
        try {
            if (this.getAccount() != null) {
                ret.setValue("1", this.getAccount());
            }
            if (this.getOrderID() != null) {
                ret.setValue("37", this.getOrderID());
            }
            if (this.getClOrdID() != null) {
                ret.setValue("11", this.getClOrdID());
            }
            if (this.getSecondaryClOrdID() != null) {
                ret.setValue("526", this.getSecondaryClOrdID());
            }
            if (tsid != null) {
                ret.setValue("336", tsid);
                ret.setValue("625", tssubid);
            }
            if (this.mTransactTime != null) {
                ret.setValue("60", this.getTransactTime().toString());
            }
            if (this.getCxlRejReason() != null) {
                ret.setValue("102", this.getCxlRejReason().getCode());
            }
            if (this.getCxlRejResponseTo() != null) {
                ret.setValue("434", this.getCxlRejResponseTo().getCode());
            }
            if (this.getOrdStatus() != null) {
                ret.setValue("39", this.getOrdStatus().getCode());
            }
            if (this.getFXCMRequestRejectReason() >= 0) {
                ret.setValue("9025", this.getFXCMRequestRejectReason());
            }
            if (this.getFXCMErrorDetails() != null) {
                ret.setValue("9029", this.getFXCMErrorDetails());
            }
            ret.setValue("41", this.getOrigClOrdID());
            ret.setValue("58", this.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("OrderCancelReject");
        buf.append(" mAccount=").append(this.mAccount);
        buf.append(",mOrderID=").append(this.mOrderID);
        buf.append(",mClOrdID=").append(this.mClOrdID);
        buf.append(",mSecondaryClOrdID=").append(this.mSecondaryClOrdID);
        buf.append(",mTradingSessionID=").append(this.mTradingSessionID);
        buf.append(",mTradingSessionSubID=").append(this.mTradingSessionSubID);
        buf.append(",mTransactTime=").append(this.mTransactTime);
        buf.append(",mCxlRejReason=").append(this.mCxlRejReason);
        buf.append(",mCxlRejResponseTo=").append(this.mCxlRejResponseTo);
        buf.append(",mFXCMErrorDetails=").append(this.mFXCMErrorDetails);
        buf.append(",mFXCMRequestRejectReason=").append(this.mFXCMRequestRejectReason);
        buf.append(",mOrdStatus=").append(this.mOrdStatus);
        buf.append(",mOrigClOrdID=").append(this.mOrigClOrdID);
        buf.append(",mText=").append(this.mText);
        return buf.toString();
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class OrderCancelRejectAckType
    extends ACode {
        OrderCancelRejectAckType() {
            super("9", "OrderCancelRejectAckType", "");
        }
    }
}

