/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.trade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.ATradeTransportable;
import com.fxcm.fix.ContingencyTypeFactory;
import com.fxcm.fix.ExecTypeFactory;
import com.fxcm.fix.FXCMOrdStatusFactory;
import com.fxcm.fix.FXCMOrdTypeFactory;
import com.fxcm.fix.IContingencyType;
import com.fxcm.fix.IExecType;
import com.fxcm.fix.IFXCMOrdStatus;
import com.fxcm.fix.IFXCMOrdType;
import com.fxcm.fix.IOrdRejReason;
import com.fxcm.fix.IOrdStatus;
import com.fxcm.fix.IOrdType;
import com.fxcm.fix.ISide;
import com.fxcm.fix.ITimeInForce;
import com.fxcm.fix.OrdRejReasonFactory;
import com.fxcm.fix.OrdStatusFactory;
import com.fxcm.fix.OrdTypeFactory;
import com.fxcm.fix.PegInstruction;
import com.fxcm.fix.SideFactory;
import com.fxcm.fix.TimeInForceFactory;
import com.fxcm.fix.UTCDate;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import java.text.ParseException;

public class ExecutionReport
extends ATradeTransportable {
    public static final ICode OBJ_TYPE = new ExecutionReportType();
    protected IContingencyType mContingencyType;
    protected double mCumQty;
    protected String mCurrency;
    protected UTCTimestamp mEffectiveTime;
    protected String mExecID;
    protected IExecType mExecType;
    private UTCTimestamp mExpireTimestamp;
    protected String mFXCMContingencyID;
    protected String mFXCMErrorDetails;
    protected IFXCMOrdStatus mFXCMOrdStatus;
    protected IFXCMOrdType mFXCMOrdType;
    protected String mFXCMPosID;
    protected int mFXCMRequestRejectReason;
    protected double mLastPx;
    protected double mLastQty;
    protected boolean mLastRptRequested;
    protected double mLeavesQty;
    protected String mListID;
    protected String mMassStatusReqID;
    protected double mOrderPercent;
    protected double mOrderQty;
    protected IOrdRejReason mOrdRejReason;
    protected IOrdStatus mOrdStatus;
    protected String mOrdStatusReqID;
    protected IOrdType mOrdType;
    protected String mOrigClOrdID;
    protected PegInstruction mPegInstruction;
    protected double mPrice;
    protected String mSecondaryOrderID;
    protected ISide mSide;
    protected double mStopPx;
    protected String mText;
    protected ITimeInForce mTimeInForce;
    protected int mTotNumReports;

    @Override
    public boolean fill(IMessage aMsg) {
        String effectiveDate;
        String expireDate;
        super.fill(aMsg);
        this.setListID(aMsg.getValueString("66"));
        this.setLastQty(aMsg.getValueDouble("32"));
        this.setExecType(ExecTypeFactory.toCode(aMsg.getValueString("150")));
        this.setMassStatusReqID(aMsg.getValueString("584"));
        this.setExecID(aMsg.getValueString("17"));
        this.setOrdStatus(OrdStatusFactory.toCode(aMsg.getValueString("39")));
        this.setOrigClOrdID(aMsg.getValueString("41"));
        this.setSide(SideFactory.toCode(aMsg.getValueString("54")));
        this.setText(aMsg.getValueString("58"));
        this.setFXCMErrorDetails(aMsg.getValueString("9029"));
        this.setFXCMRequestRejectReason(aMsg.getValueInt("9025"));
        this.setFXCMOrdStatus(FXCMOrdStatusFactory.toCode(aMsg.getValueString("9051")));
        this.setFXCMOrdType(FXCMOrdTypeFactory.toCode(aMsg.getValueString("9050")));
        this.setOrdStatusReqID(aMsg.getValueString("790"));
        this.setOrderQty(aMsg.getValueDouble("38"));
        this.setLeavesQty(aMsg.getValueDouble("151"));
        this.setCumQty(aMsg.getValueDouble("14"));
        this.setCurrency(aMsg.getValueString("15"));
        this.setOrdType(OrdTypeFactory.toCode(aMsg.getValueString("40")));
        this.setLastPx(aMsg.getValueDouble("31"));
        this.setFXCMPosID(aMsg.getValueString("9041"));
        this.setStopPx(aMsg.getValueDouble("99"));
        this.setPrice(aMsg.getValueDouble("44"));
        String timeinforce = aMsg.getValueString("59");
        if (timeinforce != null) {
            this.setTimeInForce(TimeInForceFactory.toCode(timeinforce));
        }
        if (this.getMassStatusReqID() != null) {
            this.setLastRptRequested("Y".equals(aMsg.getValueString("912")));
            this.setTotNumReports(aMsg.getValueInt("911"));
        }
        if (aMsg.getValueString("103") != null) {
            this.setOrdRejReason(OrdRejReasonFactory.toCode(aMsg.getValueInt("103")));
        }
        this.setPegInstructions(new PegInstruction());
        this.getPegInstructions().setPegPriceType(aMsg.getValueInt("1094"));
        this.getPegInstructions().setPegOffsetValue(aMsg.getValueDouble("211"));
        this.getPegInstructions().setPegMoveType(aMsg.getValueInt("835"));
        this.getPegInstructions().setPegOffsetType(aMsg.getValueInt("836"));
        this.getPegInstructions().setFXCMPegFluctuatePts(aMsg.getValueInt("9061"));
        this.setFXCMContingencyID(aMsg.getValueString("9079"));
        this.setOrderPercent(aMsg.getValueDouble("516"));
        this.setContingencyType(ContingencyTypeFactory.toCode(aMsg.getValueString("1385")));
        this.setSecondaryOrderID(aMsg.getValueString(aMsg.getValueString("198")));
        String expireTime = aMsg.getValueString("126");
        if (expireTime != null) {
            this.setExpireTime(expireTime);
        }
        if ((expireDate = aMsg.getValueString("432")) != null) {
            this.setExpireDate(expireDate);
        }
        if ((effectiveDate = aMsg.getValueString("168")) != null) {
            this.setEffectiveTime(new UTCTimestamp(effectiveDate));
        }
        return this.isValid();
    }

    public IContingencyType getContingencyType() {
        return this.mContingencyType;
    }

    public void setContingencyType(IContingencyType aContingencyType) {
        this.mContingencyType = aContingencyType;
    }

    public double getCumQty() {
        return this.mCumQty;
    }

    public void setCumQty(double aCumQty) {
        this.mCumQty = aCumQty;
    }

    public String getCurrency() {
        return this.mCurrency;
    }

    public void setCurrency(String aCurrency) {
        this.mCurrency = aCurrency;
    }

    public UTCTimestamp getEffectiveTime() {
        return this.mEffectiveTime;
    }

    public void setEffectiveTime(UTCTimestamp aEffectiveTime) {
        this.mEffectiveTime = aEffectiveTime;
    }

    public String getExecID() {
        return this.mExecID;
    }

    public void setExecID(String aExecID) {
        this.mExecID = aExecID;
    }

    public IExecType getExecType() {
        return this.mExecType;
    }

    public void setExecType(IExecType aExecType) {
        this.mExecType = aExecType;
    }

    public UTCTimestamp getExpireTimestamp() {
        return this.mExpireTimestamp;
    }

    public void setExpireTimestamp(UTCTimestamp aExpireTimestamp) {
        this.mExpireTimestamp = aExpireTimestamp;
    }

    public UTCDate getExpireDate() {
        if (this.mExpireTimestamp == null) {
            return null;
        }
        return new UTCDate(this.mExpireTimestamp);
    }

    public void setExpireDate(String aExpireDate) {
        if (aExpireDate == null) {
            this.mExpireTimestamp = null;
            return;
        }
        if (this.mExpireTimestamp == null) {
            this.mExpireTimestamp = new UTCTimestamp();
        }
        try {
            this.mExpireTimestamp.setTime(aExpireDate);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void setExpireDate(UTCDate aExpireDate) {
        if (aExpireDate == null) {
            this.mExpireTimestamp = null;
            return;
        }
        if (this.mExpireTimestamp == null) {
            this.mExpireTimestamp = new UTCTimestamp();
        }
        this.mExpireTimestamp.setDateOnly(aExpireDate);
    }

    public UTCTimestamp getExpireTime() {
        return this.mExpireTimestamp;
    }

    public void setExpireTime(String aExpireTime) {
        if (aExpireTime == null) {
            this.mExpireTimestamp = null;
            return;
        }
        if (this.mExpireTimestamp == null) {
            this.mExpireTimestamp = new UTCTimestamp();
        }
        try {
            this.mExpireTimestamp.setTime(aExpireTime);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void setExpireTime(UTCTimestamp aExpireTime) {
        if (aExpireTime == null) {
            this.mExpireTimestamp = null;
            return;
        }
        if (this.mExpireTimestamp == null) {
            this.mExpireTimestamp = new UTCTimestamp();
        }
        this.mExpireTimestamp.setTime(aExpireTime.getTime());
    }

    public String getFXCMContingencyID() {
        return this.mFXCMContingencyID;
    }

    public void setFXCMContingencyID(String aFXCMContingencyID) {
        this.mFXCMContingencyID = aFXCMContingencyID;
    }

    public String getFXCMErrorDetails() {
        return this.mFXCMErrorDetails;
    }

    public void setFXCMErrorDetails(String aFXCMErrorDetails) {
        this.mFXCMErrorDetails = aFXCMErrorDetails;
    }

    public IFXCMOrdStatus getFXCMOrdStatus() {
        return this.mFXCMOrdStatus;
    }

    public void setFXCMOrdStatus(IFXCMOrdStatus aFXCMOrdStatus) {
        this.mFXCMOrdStatus = aFXCMOrdStatus;
    }

    public IFXCMOrdType getFXCMOrdType() {
        return this.mFXCMOrdType;
    }

    public void setFXCMOrdType(IFXCMOrdType aFXCMOrdType) {
        this.mFXCMOrdType = aFXCMOrdType;
    }

    public String getFXCMPosID() {
        return this.mFXCMPosID;
    }

    public void setFXCMPosID(String aFXCMPosID) {
        this.mFXCMPosID = aFXCMPosID;
    }

    public int getFXCMRequestRejectReason() {
        return this.mFXCMRequestRejectReason;
    }

    public void setFXCMRequestRejectReason(int aFXCMRequestRejectReason) {
        this.mFXCMRequestRejectReason = aFXCMRequestRejectReason;
    }

    public double getLastPx() {
        return this.mLastPx;
    }

    public void setLastPx(double aLastPx) {
        this.mLastPx = aLastPx;
    }

    public double getLastQty() {
        return this.mLastQty;
    }

    public void setLastQty(double aLastQty) {
        this.mLastQty = aLastQty;
    }

    public double getLeavesQty() {
        return this.mLeavesQty;
    }

    public void setLeavesQty(double aLeavesQty) {
        this.mLeavesQty = aLeavesQty;
    }

    public String getListID() {
        return this.mListID;
    }

    public void setListID(String aListID) {
        this.mListID = aListID;
    }

    public String getMassStatusReqID() {
        return this.mMassStatusReqID;
    }

    public void setMassStatusReqID(String aMassStatusReqID) {
        this.mMassStatusReqID = aMassStatusReqID;
    }

    public double getOrderPercent() {
        return this.mOrderPercent;
    }

    public void setOrderPercent(double aOrderPercent) {
        this.mOrderPercent = aOrderPercent;
    }

    public double getOrderQty() {
        return this.mOrderQty;
    }

    public void setOrderQty(double aOrderQty) {
        this.mOrderQty = aOrderQty;
    }

    public IOrdRejReason getOrdRejReason() {
        return this.mOrdRejReason;
    }

    public void setOrdRejReason(IOrdRejReason aOrdRejReason) {
        this.mOrdRejReason = aOrdRejReason;
    }

    public IOrdStatus getOrdStatus() {
        return this.mOrdStatus;
    }

    public void setOrdStatus(IOrdStatus aOrdStatus) {
        this.mOrdStatus = aOrdStatus;
    }

    public String getOrdStatusReqID() {
        return this.mOrdStatusReqID;
    }

    public void setOrdStatusReqID(String aOrdStatusReqID) {
        this.mOrdStatusReqID = aOrdStatusReqID;
    }

    public IOrdType getOrdType() {
        return this.mOrdType;
    }

    public void setOrdType(IOrdType aOrdType) {
        this.mOrdType = aOrdType;
    }

    public String getOrigClOrdID() {
        return this.mOrigClOrdID;
    }

    public void setOrigClOrdID(String aOrigClOrdID) {
        this.mOrigClOrdID = aOrigClOrdID;
    }

    public PegInstruction getPegInstructions() {
        return this.mPegInstruction;
    }

    public double getPrice() {
        return this.mPrice;
    }

    public void setPrice(double aPrice) {
        this.mPrice = aPrice;
    }

    @Override
    public String getRequestID() {
        String ret = this.getMassStatusReqID();
        if (ret == null) {
            ret = this.getClOrdID();
        }
        return ret;
    }

    public String getSecondaryOrderID() {
        return this.mSecondaryOrderID;
    }

    public void setSecondaryOrderID(String aSecondaryOrderID) {
        this.mSecondaryOrderID = aSecondaryOrderID;
    }

    public ISide getSide() {
        return this.mSide;
    }

    public void setSide(ISide aSide) {
        this.mSide = aSide;
    }

    public double getStopPx() {
        return this.mStopPx;
    }

    public void setStopPx(double aStopPx) {
        this.mStopPx = aStopPx;
    }

    public String getText() {
        return this.mText;
    }

    public void setText(String aText) {
        this.mText = aText;
    }

    public ITimeInForce getTimeInForce() {
        return this.mTimeInForce;
    }

    public void setTimeInForce(ITimeInForce aTimeInForce) {
        this.mTimeInForce = aTimeInForce;
    }

    public int getTotNumReports() {
        return this.mTotNumReports;
    }

    public void setTotNumReports(int aTotNumReports) {
        this.mTotNumReports = aTotNumReports;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    public boolean isLastRptRequested() {
        return this.mLastRptRequested;
    }

    public void setLastRptRequested(boolean aLastRptRequested) {
        this.mLastRptRequested = aLastRptRequested;
    }

    @Override
    public boolean isValid() {
        boolean ret = false;
        if (this.mInstrument != null && this.mTransactTime != null) {
            ret = this.mPrice != 0.0 && this.mSide != null;
        }
        return ret;
    }

    @Override
    protected void reset() {
        super.reset();
        this.mExecID = null;
        this.mExecType = null;
        this.mFXCMOrdStatus = null;
        this.mFXCMOrdType = null;
        this.mFXCMPosID = null;
        this.mLastRptRequested = false;
        this.mMassStatusReqID = null;
        this.mOrdStatus = null;
        this.mOrdType = null;
        this.mOrderQty = 0.0;
        this.mPrice = 0.0;
        this.mSide = null;
        this.mText = null;
        this.mTotNumReports = 0;
        this.mTimeInForce = TimeInForceFactory.GOOD_TILL_CANCEL;
        this.mOrdRejReason = null;
        this.mCurrency = null;
        this.mPegInstruction = new PegInstruction();
        this.mFXCMErrorDetails = null;
        this.mFXCMRequestRejectReason = -1;
        this.mOrdStatusReqID = null;
        this.mOrigClOrdID = null;
        this.mLastPx = 0.0;
        this.mStopPx = 0.0;
        this.mCumQty = 0.0;
        this.mLeavesQty = 0.0;
        this.mFXCMContingencyID = null;
        this.mOrderPercent = 0.0;
        this.mContingencyType = null;
        this.mSecondaryOrderID = null;
        this.mExpireTimestamp = null;
        this.mEffectiveTime = null;
    }

    public void setPegInstructions(PegInstruction aPegInstructions) {
        this.mPegInstruction = aPegInstructions;
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        IMessage ret = super.toMessage(aSID, aTradingSessionID, aTradingSessionSubID, aRequestID, aOptions, aFactory);
        ret.setValue("14", this.getCumQty());
        ret.setValue("151", this.getLeavesQty());
        ret.setValue("6", this.getPrice());
        ret.setValue("38", this.getOrderQty());
        ret.setValue("31", this.getLastPx());
        ret.setValue("99", this.getStopPx());
        ret.setValue("44", this.getPrice());
        ret.setValue("32", this.getLastQty());
        ret.setValue("66", this.getListID());
        if (this.getOrdRejReason() != null) {
            ret.setValue("103", this.getOrdRejReason().getCode());
        }
        if (this.getOrigClOrdID() != null) {
            ret.setValue("41", this.getOrigClOrdID());
        }
        if (this.getExecID() != null) {
            ret.setValue("17", this.getExecID());
        }
        if (this.getExecType() != null) {
            ret.setValue("150", this.getExecType().getCode());
        }
        if (this.getMassStatusReqID() != null) {
            ret.setValue("584", this.getMassStatusReqID());
        }
        if (this.getOrdStatus() != null) {
            ret.setValue("39", this.getOrdStatus().getCode());
        }
        if (this.getSide() != null) {
            ret.setValue("54", this.getSide().getCode());
        }
        if (this.getText() != null) {
            ret.setValue("58", this.getText());
        }
        if (this.getFXCMOrdStatus() != null) {
            ret.setValue("9051", this.getFXCMOrdStatus().getCode());
        }
        if (this.getFXCMOrdType() != null) {
            ret.setValue("9050", this.getFXCMOrdType().getCode());
        }
        if (this.getFXCMRequestRejectReason() >= 0) {
            ret.setValue("9025", this.getFXCMRequestRejectReason());
        }
        if (this.getFXCMErrorDetails() != null) {
            ret.setValue("9029", this.getFXCMErrorDetails());
        }
        if (this.getOrdStatusReqID() != null) {
            ret.setValue("790", this.getOrdStatusReqID());
        }
        if (this.getCurrency() != null) {
            ret.setValue("15", this.getCurrency());
        }
        if (this.getOrdType() != null) {
            ret.setValue("40", this.getOrdType().getCode());
        }
        if (this.getTimeInForce() != null) {
            ret.setValue("59", this.getTimeInForce().getCode());
        }
        if (this.getFXCMPosID() != null) {
            ret.setValue("9041", this.getFXCMPosID());
        }
        if (this.getMassStatusReqID() != null) {
            ret.setValue("912", this.isLastRptRequested() ? "Y" : "N");
            ret.setValue("911", this.getTotNumReports());
        }
        if (this.getPegInstructions() != null) {
            ret.setValue("1094", this.getPegInstructions().getPegPriceType());
            ret.setValue("211", this.getPegInstructions().getPegOffsetValue());
            ret.setValue("9061", this.getPegInstructions().getFXCMPegFluctuatePts());
            ret.setValue("835", this.getPegInstructions().getPegMoveType());
            ret.setValue("836", this.getPegInstructions().getPegOffsetType());
        }
        if (this.getFXCMContingencyID() != null) {
            ret.setValue("9079", this.getFXCMContingencyID());
        }
        if (this.getOrderPercent() != 0.0) {
            ret.setValue("516", this.getOrderPercent());
        }
        if (this.getContingencyType() != null) {
            ret.setValue("1385", this.getContingencyType().getCode());
        }
        if (this.getSecondaryOrderID() != null) {
            ret.setValue("198", this.getSecondaryOrderID());
        }
        if (this.getExpireTimestamp() != null) {
            ret.setValue("432", this.getExpireTimestamp().toStringDateOnly());
            ret.setValue("126", this.getExpireTime().toString());
        }
        if (this.getEffectiveTime() != null) {
            ret.setValue("168", this.getEffectiveTime().toString());
        }
        return ret;
    }

    @Override
    public String toString() {
        return "ExecutionReport{mContingencyType=" + this.mContingencyType + ", mCumQty=" + this.mCumQty + ", mCurrency='" + this.mCurrency + "', mEffectiveTime=" + this.mEffectiveTime + ", mExecID='" + this.mExecID + "', mExecType=" + this.mExecType + ", mExpireTimestamp=" + this.mExpireTimestamp + ", mFXCMContingencyID='" + this.mFXCMContingencyID + "', mFXCMErrorDetails='" + this.mFXCMErrorDetails + "', mFXCMOrdStatus=" + this.mFXCMOrdStatus + ", mFXCMOrdType=" + this.mFXCMOrdType + ", mFXCMPosID='" + this.mFXCMPosID + "', mFXCMRequestRejectReason=" + this.mFXCMRequestRejectReason + ", mLastPx=" + this.mLastPx + ", mLastQty=" + this.mLastQty + ", mLastRptRequested=" + this.mLastRptRequested + ", mLeavesQty=" + this.mLeavesQty + ", mListID='" + this.mListID + "', mMassStatusReqID='" + this.mMassStatusReqID + "', mOrderPercent=" + this.mOrderPercent + ", mOrderQty=" + this.mOrderQty + ", mOrdRejReason=" + this.mOrdRejReason + ", mOrdStatus=" + this.mOrdStatus + ", mOrdStatusReqID='" + this.mOrdStatusReqID + "', mOrdType=" + this.mOrdType + ", mOrigClOrdID='" + this.mOrigClOrdID + "', mPegInstruction=" + this.mPegInstruction + ", mPrice=" + this.mPrice + ", mSecondaryOrderID='" + this.mSecondaryOrderID + "', mSide=" + this.mSide + ", mStopPx=" + this.mStopPx + ", mText='" + this.mText + "', mTimeInForce=" + this.mTimeInForce + ", mTotNumReports=" + this.mTotNumReports + "} " + super.toString();
    }

    private static class ExecutionReportType
    extends ACode {
        private static final long serialVersionUID = -2412029529734059142L;

        ExecutionReportType() {
            super("8", "ExecutionReportType", "");
        }
    }
}

