/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.pretrade.inner;

import com.fxcm.fix.TradingSecurity;
import com.fxcm.messaging.IMessage;
import com.fxcm.util.Util;

public class TradingSessionStatus
extends com.fxcm.fix.pretrade.TradingSessionStatus {
    private String mNonChangedValue = "!=";

    @Override
    public boolean fill(IMessage aMsg) {
        boolean ret = super.fill(aMsg);
        if (ret) {
            ret = this.initExtra();
        }
        return ret;
    }

    public boolean initExtra() {
        this.mNonChangedValue = this.getParameterValue("NON_CHANGED_VALUE");
        if (this.mNonChangedValue == null) {
            this.mNonChangedValue = "!=";
        }
        return true;
    }

    public void setNonChangedValue(String aNonChangedValue) {
        this.mNonChangedValue = aNonChangedValue;
    }

    public String getNonChangedValue() {
        return this.mNonChangedValue;
    }

    public boolean updateTradingSecurity(String aMsg) {
        boolean ret = false;
        String[] tokens = Util.splitToArray(aMsg, ";");
        if (tokens.length > 1) {
            TradingSecurity instr = new TradingSecurity();
            if (this.toStringSafe(tokens, 2) != null) {
                instr.setFXCMSymID((int)this.toLongSafe(tokens, 2));
            }
            if (this.toStringSafe(tokens, 6) != null) {
                instr.setFXCMSymInterestBuy(this.toDoubleSafe(tokens, 6));
            }
            if (this.toStringSafe(tokens, 7) != null) {
                instr.setFXCMSymInterestSell(this.toDoubleSafe(tokens, 7));
            }
            if (this.toStringSafe(tokens, 11) != null) {
                instr.setSymbol(this.toStringSafe(tokens, 11));
            }
            if (this.toStringSafe(tokens, 12) != null) {
                instr.setCurrency(this.toStringSafe(tokens, 12));
            }
            if (this.toStringSafe(tokens, 13) != null) {
                instr.setRoundLot(this.toLongSafe(tokens, 13));
            }
            if (this.toStringSafe(tokens, 14) != null) {
                instr.setFXCMSymPrecision((int)this.toLongSafe(tokens, 14));
            }
            if (this.toStringSafe(tokens, 15) != null) {
                instr.setFXCMSymPointSize(this.toDoubleSafe(tokens, 15));
            }
            if (this.toStringSafe(tokens, 16) != null) {
                instr.setFXCMSymSortOrder((int)this.toLongSafe(tokens, 16));
            }
            try {
                TradingSecurity ts = this.getSecurity(instr.getSymbol());
                if (ts != null) {
                    ts.fill(instr);
                } else if (instr.isValid()) {
                    this.setSecurity(instr);
                }
                ret = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    protected String toStringSafe(String[] aTokens, int aIndex) {
        String ret = null;
        if (aTokens.length > aIndex && aTokens[aIndex] != null && aTokens[aIndex].length() > 0 && this.mNonChangedValue.equals(ret = aTokens[aIndex])) {
            ret = null;
        }
        return ret;
    }

    protected long toLongSafe(String[] aTokens, int aIndex) {
        long ret = 0L;
        String s = this.toStringSafe(aTokens, aIndex);
        if (s != null) {
            try {
                ret = Long.parseLong(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    protected double toDoubleSafe(String[] aTokens, int aIndex) {
        double ret = 0.0;
        String s = this.toStringSafe(aTokens, aIndex);
        if (s != null) {
            try {
                ret = Double.parseDouble(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }
}

